/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, LitElement } from '../../lit-element.js';
import { internalProperty } from '../../lib/decorators/internalProperty.js';
import { generateElementName } from '../test-helpers.js';
import { assert } from '@esm-bundle/chai';
// tslint:disable:no-any ok in tests
suite('@internalProperty', () => {
    let container;
    let el;
    const hasChanged = (value, old) => old === undefined || value > old;
    class E extends LitElement {
        constructor() {
            super(...arguments);
            this.prop = 'prop';
            this.hasChangedProp = 10;
            this.updateCount = 0;
        }
        update(changed) {
            this.updateCount++;
            super.update(changed);
        }
        render() {
            return html ``;
        }
    }
    __decorate([
        internalProperty()
    ], E.prototype, "prop", void 0);
    __decorate([
        internalProperty({ hasChanged })
    ], E.prototype, "hasChangedProp", void 0);
    customElements.define(generateElementName(), E);
    setup(async () => {
        container = document.createElement('div');
        container.id = 'test-container';
        document.body.appendChild(container);
        el = new E();
        container.appendChild(el);
        await el.updateComplete;
    });
    teardown(() => {
        if (container !== undefined) {
            container.parentElement.removeChild(container);
            container = undefined;
        }
    });
    test('triggers update', async () => {
        assert.equal(el.updateCount, 1);
        el.prop = 'change';
        await el.updateComplete;
        assert.equal(el.updateCount, 2);
    });
    test('uses hasChanged', async () => {
        assert.equal(el.updateCount, 1);
        el.hasChangedProp = 100;
        await el.updateComplete;
        assert.equal(el.updateCount, 2);
        el.hasChangedProp = 0;
        await el.updateComplete;
        assert.equal(el.updateCount, 2);
    });
    test('does not set via attribute', async () => {
        el.setAttribute('prop', 'attr');
        assert.equal(el.prop, 'prop');
        await el.updateComplete;
        assert.equal(el.updateCount, 1);
    });
});
//# sourceMappingURL=internalProperty_test.js.map