/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, LitElement } from '../../lit-element.js';
import { queryAll } from '../../lib/decorators/queryAll.js';
import { generateElementName } from '../test-helpers.js';
import { assert } from '@esm-bundle/chai';
// tslint:disable:no-any ok in tests
suite('@queryAll', () => {
    let container;
    let el;
    class C extends LitElement {
        render() {
            return html `
        <div>Not this one</div>
        <div id="blah">This one</div>
      `;
        }
    }
    __decorate([
        queryAll('div')
    ], C.prototype, "divs", void 0);
    __decorate([
        queryAll('span')
    ], C.prototype, "spans", void 0);
    customElements.define(generateElementName(), C);
    setup(async () => {
        container = document.createElement('div');
        container.id = 'test-container';
        document.body.appendChild(container);
        el = new C();
        container.appendChild(el);
        await el.updateComplete;
    });
    teardown(() => {
        if (container !== undefined) {
            container.parentElement.removeChild(container);
            container = undefined;
        }
    });
    test('returns elements when they exists', () => {
        assert.lengthOf(el.divs, 2);
        assert.deepEqual(Array.from(el.divs), Array.from(el.renderRoot.querySelectorAll('div')));
    });
    test('returns empty NodeList when no match', () => {
        assert.lengthOf(el.spans, 0);
        assert.deepEqual(Array.from(el.spans), Array.from(el.renderRoot.querySelectorAll('span')));
    });
});
//# sourceMappingURL=queryAll_test.js.map