/**
 * @license
 * Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { html, LitElement } from '../../lit-element.js';
import { query } from '../../lib/decorators/query.js';
import { generateElementName } from '../test-helpers.js';
import { assert } from '@esm-bundle/chai';
// tslint:disable:no-any ok in tests
suite('@query', () => {
    let container;
    let el;
    class C extends LitElement {
        constructor() {
            super(...arguments);
            this.condition = false;
        }
        render() {
            return html `
        <div>Not this one</div>
        <div id="blah">This one</div>
        ${this.condition ? html `<span>Cached</span>` : ``}
      `;
        }
    }
    C.properties = { condition: {} };
    __decorate([
        query('#blah')
    ], C.prototype, "div", void 0);
    __decorate([
        query('span', true)
    ], C.prototype, "span", void 0);
    customElements.define(generateElementName(), C);
    setup(async () => {
        container = document.createElement('div');
        container.id = 'test-container';
        document.body.appendChild(container);
        el = new C();
        container.appendChild(el);
        await el.updateComplete;
    });
    teardown(() => {
        if (container !== undefined) {
            container.parentElement.removeChild(container);
            container = undefined;
        }
    });
    test('returns an element when it exists', () => {
        const div = el.div;
        assert.instanceOf(div, HTMLDivElement);
        assert.equal(div.innerText, 'This one');
    });
    test('returns null when no match', () => {
        assert.isNull(el.span);
    });
    test('returns cached value', async () => {
        el.condition = true;
        await el.updateComplete;
        assert.equal(el.span, el.renderRoot.querySelector('span'));
        assert.instanceOf(el.span, HTMLSpanElement);
        el.condition = false;
        await el.updateComplete;
        assert.instanceOf(el.span, HTMLSpanElement);
        assert.notEqual(el.span, el.renderRoot.querySelector('span'));
    });
});
//# sourceMappingURL=query_test.js.map