/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
/**
 * LitElement support for hydration of content rendered using lit-ssr.
 *
 * @packageDocumentation
 */
import { ReactiveElement } from '@lit/reactive-element';
import { render } from 'lit-html';
import { hydrate } from 'lit-html/hydrate.js';
// eslint-disable-next-line @typescript-eslint/no-explicit-any
globalThis['litElementHydrateSupport'] = ({ LitElement, }) => {
    // Capture whether we need hydration or not
    const createRenderRoot = LitElement.prototype.createRenderRoot;
    LitElement.prototype.createRenderRoot = function () {
        if (this.shadowRoot) {
            this._$needsHydration = true;
            return this.shadowRoot;
        }
        else {
            return createRenderRoot.call(this);
        }
    };
    // Hydrate on first update when needed
    LitElement.prototype.update = function (changedProperties) {
        const value = this.render();
        // Since this is a patch, we can't call super.update()
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        ReactiveElement.prototype.update.call(this, changedProperties);
        if (this._$needsHydration) {
            this._$needsHydration = false;
            hydrate(value, this.renderRoot, this.renderOptions);
        }
        else {
            render(value, this.renderRoot, this.renderOptions);
        }
    };
};
//# sourceMappingURL=hydrate-support.js.map