/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
import * as ReactModule from 'react';
declare type Events<S> = {
    [P in keyof S]?: (e: Event) => unknown;
};
declare type StringValued<T> = {
    [P in keyof T]: string;
};
declare type Constructor<T> = {
    new (): T;
};
/**
 * Creates a React component for a custom element. Properties are distinguished
 * from attributes automatically, and events can be configured so they are
 * added to the custom element as event listeners.
 *
 * @param React The React module, typically imported from the `react` npm
 * package.
 * @param tagName The custom element tag name registered via
 * `customElements.define`.
 * @param elementClass The custom element class registered via
 * `customElements.define`.
 * @param events An object listing events to which the component can listen. The
 * object keys are the event property names passed in via React props and the
 * object values are the names of the corresponding events generated by the
 * custom element. For example, given `{onactivate: 'activate'}` an event
 * function may be passed via the component's `onactivate` prop and will be
 * called when the custom element fires its `activate` event.
 * @param displayName A React component display name, used in debugging
 * messages. Default value is inferred from the name of custom element class
 * registered via `customElements.define`.
 */
export declare const createComponent: <I extends HTMLElement, E>(React: typeof ReactModule, tagName: string, elementClass: Constructor<I>, events?: StringValued<E> | undefined, displayName?: string | undefined) => ReactModule.ForwardRefExoticComponent<ReactModule.PropsWithRef<Partial<Omit<I, "children">> & Events<E> & ReactModule.HTMLAttributes<HTMLElement>> & {
    children?: ReactModule.ReactNode;
} & ReactModule.RefAttributes<unknown>>;
export {};
//# sourceMappingURL=create-component.d.ts.map