/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
/// <reference types="react" />
export declare type EventName<T extends Event = Event> = string & {
    __event_type: T;
};
declare type EventNames = Record<string, EventName | string>;
declare type EventListeners<R extends EventNames> = {
    [K in keyof R]: R[K] extends EventName ? (e: R[K]['__event_type']) => void : (e: Event) => void;
};
declare type ReactProps<I, E> = Omit<React.HTMLAttributes<I>, keyof E>;
declare type ElementWithoutPropsOrEventListeners<I, E> = Omit<I, keyof E | keyof ReactProps<I, E>>;
export declare type WebComponentProps<I extends HTMLElement, E extends EventNames = {}> = Partial<ReactProps<I, E> & ElementWithoutPropsOrEventListeners<I, E> & EventListeners<E>>;
export declare type ReactWebComponent<I extends HTMLElement, E extends EventNames = {}> = React.ForwardRefExoticComponent<React.PropsWithoutRef<WebComponentProps<I, E>> & React.RefAttributes<I>>;
interface Options<I extends HTMLElement, E extends EventNames = {}> {
    tagName: string;
    elementClass: Constructor<I>;
    react: typeof window.React;
    events?: E;
    displayName?: string;
}
declare type Constructor<T> = {
    new (): T;
};
/**
 * Creates a React component for a custom element. Properties are distinguished
 * from attributes automatically, and events can be configured so they are
 * added to the custom element as event listeners.
 *
 * @param options An options bag containing the parameters needed to generate
 * a wrapped web component.
 *
 * @param options.react The React module, typically imported from the `react` npm
 * package.
 * @param options.tagName The custom element tag name registered via
 * `customElements.define`.
 * @param options.elementClass The custom element class registered via
 * `customElements.define`.
 * @param options.events An object listing events to which the component can listen. The
 * object keys are the event property names passed in via React props and the
 * object values are the names of the corresponding events generated by the
 * custom element. For example, given `{onactivate: 'activate'}` an event
 * function may be passed via the component's `onactivate` prop and will be
 * called when the custom element fires its `activate` event.
 * @param options.displayName A React component display name, used in debugging
 * messages. Default value is inferred from the name of custom element class
 * registered via `customElements.define`.
 */
export declare function createComponent<I extends HTMLElement, E extends EventNames = {}>(options: Options<I, E>): ReactWebComponent<I, E>;
/**
 * @deprecated Use `createComponent(options)` instead of individual arguments.
 *
 * Creates a React component for a custom element. Properties are distinguished
 * from attributes automatically, and events can be configured so they are
 * added to the custom element as event listeners.
 *
 * @param React The React module, typically imported from the `react` npm
 * package.
 * @param tagName The custom element tag name registered via
 * `customElements.define`.
 * @param elementClass The custom element class registered via
 * `customElements.define`.
 * @param events An object listing events to which the component can listen. The
 * object keys are the event property names passed in via React props and the
 * object values are the names of the corresponding events generated by the
 * custom element. For example, given `{onactivate: 'activate'}` an event
 * function may be passed via the component's `onactivate` prop and will be
 * called when the custom element fires its `activate` event.
 * @param displayName A React component display name, used in debugging
 * messages. Default value is inferred from the name of custom element class
 * registered via `customElements.define`.
 */
export declare function createComponent<I extends HTMLElement, E extends EventNames = {}>(ReactOrOptions: typeof window.React, tagName: string, elementClass: Constructor<I>, events?: E, displayName?: string): ReactWebComponent<I, E>;
export {};
//# sourceMappingURL=create-component.d.ts.map