/**
 * @license
 * Copyright (c) 2024, Adrien Pinet
 * Released under the MIT license
 */
import { Point } from "./timeshift.js";
export interface Serie {
    unit?: string;
    color?: string;
    points: Point[];
}
export interface SelectionEventDetail {
    time: number;
    values: (number | null)[];
}
/**
 * @element lit-line
 * A custom element that renders time series and allows user to interact with them.
 *
 * @fires lit-line:selected - Fired when a user moves cursor/finger over the graph
 *  The event's `detail` object has the following properties:
 *    * `time`: the cursor position through time
 *    * `values`: an array representing selected value for each lines
 *
 *   Note that this event is also fired (once) when user leaves selection (detail is then set to null).
 *
 * @cssprop [--lit-line--selected-time--color=black] - The selected time color
 * @cssprop [--lit-line--selected-time--opacity=.8] - The selected time opacity
 * @cssprop [--lit-line--selected-time--width=2] - The selected time width
 *
 * @attribute {Serie[]} data - An array of data points
 *
 */
export declare class LitLine extends HTMLElement {
    private series;
    private scaledSeries;
    private timeRange;
    private unitRange;
    private selectedTime;
    private selectedValues;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    static get observedAttributes(): never[];
    get data(): Serie[];
    set data(series: Serie[]);
    adjust(): void;
    private onResize;
    private onSelection;
    private onLeaveSelection;
    private dispatch;
    private render;
}
declare global {
    interface HTMLElementTagNameMap {
        "lit-line": LitLine;
    }
}
