/**
 * @license
 * Copyright (c) 2024, Adrien Pinet
 * Released under the MIT license
 */
export interface Point {
    time: number;
    value: number;
}
export interface Slot extends Point {
    range: Range;
    hits: number;
}
export interface Range {
    min: number;
    max: number;
}
export interface SelectedValue {
    value: number;
    range: Range;
}
export declare const sortPoints: (points: Point[]) => Point[];
export declare const getTimeRange: (sortedPoints: Point[]) => Range;
export declare const getValueRange: (points: Point[]) => Range;
export declare const scalePoints: (points: Point[], timeRange: Range, valueRange: Range, width: number, height: number, margin: number) => {
    time: number;
    value: number;
}[];
export declare const reducePoints: (points: Point[], minGap: number) => Slot[];
export declare const mergeRanges: (...ranges: Range[]) => {
    min: number;
    max: number;
};
export declare const pointsToSvgPath: (points: Point[]) => string;
export declare const getValueOverTime: (slots: Slot[], time: number) => {
    value: number;
    range: {
        min: number;
        max: number;
    };
} | null;
export declare const scale: (value: number, from: Range, to: Range) => number;
