'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var parse5 = require('parse5');

async function processLiterals(strings, ...exps) {
    const listTask = exps.map(async (n) => {
        const tasks = (Array.isArray(n) ? n : [n])
            .map(async (o) => 'function' === typeof (o) ? o() : o);
        return Promise.all(tasks);
    });
    const done = await Promise.all(listTask);
    const doneLen = done.length;
    return strings.reduce((p, n, i) => {
        const nTask = done[i];
        const joined = Array.isArray(nTask) ? nTask.join('') : nTask;
        return `${p}${i >= doneLen ? n : `${n}${joined}`}`;
    }, '');
}

function parseLiterals(serializeFn) {
    return async (fn, strings, ...exps) => {
        const content = await processLiterals(strings, ...exps);
        return serializeFn(fn(content));
    };
}

function processLiteralsSync(strings, ...exps) {
    const done = exps.map((n) => {
        return (Array.isArray(n) ? n : [n]).map(o => 'function' === typeof (o) ? o() : o);
    });
    const doneLen = done.length;
    return strings.reduce((p, n, i) => {
        const nTask = done[i];
        const joined = Array.isArray(nTask) ? nTask.join('') : nTask;
        return `${p}${i >= doneLen ? n : `${n}${joined}`}`;
    }, '');
}

function parseLiteralsSync(serializeFn) {
    return (fn, strings, ...exps) => {
        const content = processLiteralsSync(strings, ...exps);
        return serializeFn(fn(content));
    };
}

const parser = parseLiterals(parse5.serialize);
const parserSync = parseLiteralsSync(parse5.serialize);
const html = async (s, ...e) => parser((c) => parse5.parse(`<!doctype html>${c}`), s, ...e);
const htmlFragment = async (s, ...e) => parser(parse5.parseFragment, s, ...e);
const htmlSync = (s, ...e) => parserSync((c) => parse5.parse(`<!doctype html>${c}`), s, ...e);
const htmlFragmentSync = (s, ...e) => parserSync(parse5.parseFragment, s, ...e);
var index = {
    html,
    htmlFragment,
    htmlFragmentSync,
    htmlSync,
};

exports.default = index;
exports.html = html;
exports.htmlFragment = htmlFragment;
exports.htmlFragmentSync = htmlFragmentSync;
exports.htmlSync = htmlSync;
//# sourceMappingURL=index.js.map
