import { parse, parseFragment, serialize } from '@reallyland/esm/dist/parse5';

async function processLiterals(strings, ...exps) {
    const listTask = exps.map(async (n) => {
        const tasks = (Array.isArray(n) ? n : [n])
            .map(async (o) => 'function' === typeof (o) ? o() : o);
        return Promise.all(tasks);
    });
    const done = await Promise.all(listTask);
    const doneLen = done.length;
    return strings.reduce((p, n, i) => {
        const nTask = done[i];
        const joined = Array.isArray(nTask) ? nTask.join('') : nTask;
        return `${p}${i >= doneLen ? n : `${n}${joined}`}`;
    }, '');
}

function parseLiterals(serializeFn) {
    return async (fn, strings, ...exps) => {
        const content = await processLiterals(strings, ...exps);
        return serializeFn(fn(content));
    };
}

function processLiteralsSync(strings, ...exps) {
    const done = exps.map((n) => {
        return (Array.isArray(n) ? n : [n]).map(o => 'function' === typeof (o) ? o() : o);
    });
    const doneLen = done.length;
    return strings.reduce((p, n, i) => {
        const nTask = done[i];
        const joined = Array.isArray(nTask) ? nTask.join('') : nTask;
        return `${p}${i >= doneLen ? n : `${n}${joined}`}`;
    }, '');
}

function parseLiteralsSync(serializeFn) {
    return (fn, strings, ...exps) => {
        const content = processLiteralsSync(strings, ...exps);
        return serializeFn(fn(content));
    };
}

const parser = parseLiterals(serialize);
const parserSync = parseLiteralsSync(serialize);
const html = async (s, ...e) => parser((c) => parse(`<!doctype html>${c}`), s, ...e);
const htmlFragment = async (s, ...e) => parser(parseFragment, s, ...e);
const htmlSync = (s, ...e) => parserSync((c) => parse(`<!doctype html>${c}`), s, ...e);
const htmlFragmentSync = (s, ...e) => parserSync(parseFragment, s, ...e);
var litNtml = {
    html,
    htmlFragment,
    htmlFragmentSync,
    htmlSync,
};

export default litNtml;
export { html, htmlFragment, htmlFragmentSync, htmlSync };
//# sourceMappingURL=lit-ntml.js.map
