(() => {
  var __defProp = Object.defineProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[Object.keys(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name10 in all)
      __defProp(target, name10, { get: all[name10], enumerable: true });
  };

  // ../loader-utils/src/lib/env-utils/assert.ts
  function assert2(condition, message) {
    if (!condition) {
      throw new Error(message || "loader assertion failed.");
    }
  }
  var init_assert = __esm({
    "../loader-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../loader-utils/src/lib/env-utils/globals.ts
  var globals, self_, window_, global_, document_, isBrowser, matches, nodeVersion;
  var init_globals = __esm({
    "../loader-utils/src/lib/env-utils/globals.ts"() {
      globals = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document
      };
      self_ = globals.self || globals.window || globals.global || {};
      window_ = globals.window || globals.self || globals.global || {};
      global_ = globals.global || globals.self || globals.window || {};
      document_ = globals.document || {};
      isBrowser = Boolean(typeof process !== "object" || String(process) !== "[object process]" || process.browser);
      matches = typeof process !== "undefined" && process.version && /v([0-9]*)/.exec(process.version);
      nodeVersion = matches && parseFloat(matches[1]) || 0;
    }
  });

  // ../worker-utils/src/lib/env-utils/version.ts
  var DEFAULT_VERSION, VERSION;
  var init_version = __esm({
    "../worker-utils/src/lib/env-utils/version.ts"() {
      DEFAULT_VERSION = "latest";
      VERSION = typeof __VERSION__ !== "undefined" ? __VERSION__ : DEFAULT_VERSION;
      if (typeof __VERSION__ === "undefined") {
        console.error("loaders.gl: The __VERSION__ variable is not injected using babel plugin. Latest unstable workers would be fetched from the CDN.");
      }
    }
  });

  // ../worker-utils/src/lib/env-utils/assert.ts
  function assert3(condition, message) {
    if (!condition) {
      throw new Error(message || "loaders.gl assertion failed.");
    }
  }
  var init_assert2 = __esm({
    "../worker-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../worker-utils/src/lib/env-utils/globals.ts
  var globals2, self_2, window_2, global_2, document_2, isBrowser2, isWorker, isMobile, matches2, nodeVersion2;
  var init_globals2 = __esm({
    "../worker-utils/src/lib/env-utils/globals.ts"() {
      globals2 = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document
      };
      self_2 = globals2.self || globals2.window || globals2.global || {};
      window_2 = globals2.window || globals2.self || globals2.global || {};
      global_2 = globals2.global || globals2.self || globals2.window || {};
      document_2 = globals2.document || {};
      isBrowser2 = typeof process !== "object" || String(process) !== "[object process]" || process.browser;
      isWorker = typeof importScripts === "function";
      isMobile = typeof window !== "undefined" && typeof window.orientation !== "undefined";
      matches2 = typeof process !== "undefined" && process.version && /v([0-9]*)/.exec(process.version);
      nodeVersion2 = matches2 && parseFloat(matches2[1]) || 0;
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-job.ts
  var WorkerJob;
  var init_worker_job = __esm({
    "../worker-utils/src/lib/worker-farm/worker-job.ts"() {
      init_assert2();
      WorkerJob = class {
        constructor(jobName, workerThread) {
          this.isRunning = true;
          this._resolve = () => {
          };
          this._reject = () => {
          };
          this.name = jobName;
          this.workerThread = workerThread;
          this.result = new Promise((resolve2, reject) => {
            this._resolve = resolve2;
            this._reject = reject;
          });
        }
        postMessage(type, payload) {
          this.workerThread.postMessage({
            source: "loaders.gl",
            type,
            payload
          });
        }
        done(value) {
          assert3(this.isRunning);
          this.isRunning = false;
          this._resolve(value);
        }
        error(error) {
          assert3(this.isRunning);
          this.isRunning = false;
          this._reject(error);
        }
      };
    }
  });

  // ../worker-utils/src/lib/node/worker_threads-browser.ts
  var Worker2;
  var init_worker_threads_browser = __esm({
    "../worker-utils/src/lib/node/worker_threads-browser.ts"() {
      Worker2 = class {
        terminate() {
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-utils/get-loadable-worker-url.ts
  function getLoadableWorkerURL(props) {
    assert3(props.source && !props.url || !props.source && props.url);
    let workerURL = workerURLCache.get(props.source || props.url);
    if (!workerURL) {
      if (props.url) {
        workerURL = getLoadableWorkerURLFromURL(props.url);
        workerURLCache.set(props.url, workerURL);
      }
      if (props.source) {
        workerURL = getLoadableWorkerURLFromSource(props.source);
        workerURLCache.set(props.source, workerURL);
      }
    }
    assert3(workerURL);
    return workerURL;
  }
  function getLoadableWorkerURLFromURL(url) {
    if (!url.startsWith("http")) {
      return url;
    }
    const workerSource = buildScriptSource(url);
    return getLoadableWorkerURLFromSource(workerSource);
  }
  function getLoadableWorkerURLFromSource(workerSource) {
    const blob = new Blob([workerSource], { type: "application/javascript" });
    return URL.createObjectURL(blob);
  }
  function buildScriptSource(workerUrl) {
    return `try {
  importScripts('${workerUrl}');
} catch (error) {
  console.error(error);
  throw error;
}`;
  }
  var workerURLCache;
  var init_get_loadable_worker_url = __esm({
    "../worker-utils/src/lib/worker-utils/get-loadable-worker-url.ts"() {
      init_assert2();
      workerURLCache = new Map();
    }
  });

  // ../worker-utils/src/lib/worker-utils/get-transfer-list.ts
  function getTransferList(object, recursive = true, transfers) {
    const transfersSet = transfers || new Set();
    if (!object) {
    } else if (isTransferable(object)) {
      transfersSet.add(object);
    } else if (isTransferable(object.buffer)) {
      transfersSet.add(object.buffer);
    } else if (ArrayBuffer.isView(object)) {
    } else if (recursive && typeof object === "object") {
      for (const key in object) {
        getTransferList(object[key], recursive, transfersSet);
      }
    }
    return transfers === void 0 ? Array.from(transfersSet) : [];
  }
  function isTransferable(object) {
    if (!object) {
      return false;
    }
    if (object instanceof ArrayBuffer) {
      return true;
    }
    if (typeof MessagePort !== "undefined" && object instanceof MessagePort) {
      return true;
    }
    if (typeof ImageBitmap !== "undefined" && object instanceof ImageBitmap) {
      return true;
    }
    if (typeof OffscreenCanvas !== "undefined" && object instanceof OffscreenCanvas) {
      return true;
    }
    return false;
  }
  var init_get_transfer_list = __esm({
    "../worker-utils/src/lib/worker-utils/get-transfer-list.ts"() {
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-thread.ts
  var NOOP, WorkerThread;
  var init_worker_thread = __esm({
    "../worker-utils/src/lib/worker-farm/worker-thread.ts"() {
      init_worker_threads_browser();
      init_globals2();
      init_assert2();
      init_get_loadable_worker_url();
      init_get_transfer_list();
      NOOP = () => {
      };
      WorkerThread = class {
        constructor(props) {
          this.terminated = false;
          this._loadableURL = "";
          const { name: name10, source, url } = props;
          assert3(source || url);
          this.name = name10;
          this.source = source;
          this.url = url;
          this.onMessage = NOOP;
          this.onError = (error) => console.log(error);
          this.worker = isBrowser2 ? this._createBrowserWorker() : this._createNodeWorker();
        }
        static isSupported() {
          return typeof Worker !== "undefined" && isBrowser2 || typeof Worker2 !== "undefined" && !isBrowser2;
        }
        destroy() {
          this.onMessage = NOOP;
          this.onError = NOOP;
          this.worker.terminate();
          this.terminated = true;
        }
        get isRunning() {
          return Boolean(this.onMessage);
        }
        postMessage(data, transferList) {
          transferList = transferList || getTransferList(data);
          this.worker.postMessage(data, transferList);
        }
        _getErrorFromErrorEvent(event) {
          let message = "Failed to load ";
          message += `worker ${this.name} from ${this.url}. `;
          if (event.message) {
            message += `${event.message} in `;
          }
          if (event.lineno) {
            message += `:${event.lineno}:${event.colno}`;
          }
          return new Error(message);
        }
        _createBrowserWorker() {
          this._loadableURL = getLoadableWorkerURL({ source: this.source, url: this.url });
          const worker = new Worker(this._loadableURL, { name: this.name });
          worker.onmessage = (event) => {
            if (!event.data) {
              this.onError(new Error("No data received"));
            } else {
              this.onMessage(event.data);
            }
          };
          worker.onerror = (error) => {
            this.onError(this._getErrorFromErrorEvent(error));
            this.terminated = true;
          };
          worker.onmessageerror = (event) => console.error(event);
          return worker;
        }
        _createNodeWorker() {
          let worker;
          if (this.url) {
            const absolute = this.url.includes(":/") || this.url.startsWith("/");
            const url = absolute ? this.url : `./${this.url}`;
            worker = new Worker2(url, { eval: false });
          } else if (this.source) {
            worker = new Worker2(this.source, { eval: true });
          } else {
            throw new Error("no worker");
          }
          worker.on("message", (data) => {
            this.onMessage(data);
          });
          worker.on("error", (error) => {
            this.onError(error);
          });
          worker.on("exit", (code) => {
          });
          return worker;
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-pool.ts
  var WorkerPool;
  var init_worker_pool = __esm({
    "../worker-utils/src/lib/worker-farm/worker-pool.ts"() {
      init_globals2();
      init_worker_thread();
      init_worker_job();
      WorkerPool = class {
        constructor(props) {
          this.name = "unnamed";
          this.maxConcurrency = 1;
          this.maxMobileConcurrency = 1;
          this.onDebug = () => {
          };
          this.reuseWorkers = true;
          this.props = {};
          this.jobQueue = [];
          this.idleQueue = [];
          this.count = 0;
          this.isDestroyed = false;
          this.source = props.source;
          this.url = props.url;
          this.setProps(props);
        }
        static isSupported() {
          return WorkerThread.isSupported();
        }
        destroy() {
          this.idleQueue.forEach((worker) => worker.destroy());
          this.isDestroyed = true;
        }
        setProps(props) {
          this.props = { ...this.props, ...props };
          if (props.name !== void 0) {
            this.name = props.name;
          }
          if (props.maxConcurrency !== void 0) {
            this.maxConcurrency = props.maxConcurrency;
          }
          if (props.maxMobileConcurrency !== void 0) {
            this.maxMobileConcurrency = props.maxMobileConcurrency;
          }
          if (props.reuseWorkers !== void 0) {
            this.reuseWorkers = props.reuseWorkers;
          }
          if (props.onDebug !== void 0) {
            this.onDebug = props.onDebug;
          }
        }
        async startJob(name10, onMessage2 = (job, type, data) => job.done(data), onError = (job, error) => job.error(error)) {
          const startPromise = new Promise((onStart) => {
            this.jobQueue.push({ name: name10, onMessage: onMessage2, onError, onStart });
            return this;
          });
          this._startQueuedJob();
          return await startPromise;
        }
        async _startQueuedJob() {
          if (!this.jobQueue.length) {
            return;
          }
          const workerThread = this._getAvailableWorker();
          if (!workerThread) {
            return;
          }
          const queuedJob = this.jobQueue.shift();
          if (queuedJob) {
            this.onDebug({
              message: "Starting job",
              name: queuedJob.name,
              workerThread,
              backlog: this.jobQueue.length
            });
            const job = new WorkerJob(queuedJob.name, workerThread);
            workerThread.onMessage = (data) => queuedJob.onMessage(job, data.type, data.payload);
            workerThread.onError = (error) => queuedJob.onError(job, error);
            queuedJob.onStart(job);
            try {
              await job.result;
            } finally {
              this.returnWorkerToQueue(workerThread);
            }
          }
        }
        returnWorkerToQueue(worker) {
          const shouldDestroyWorker = this.isDestroyed || !this.reuseWorkers || this.count > this._getMaxConcurrency();
          if (shouldDestroyWorker) {
            worker.destroy();
            this.count--;
          } else {
            this.idleQueue.push(worker);
          }
          if (!this.isDestroyed) {
            this._startQueuedJob();
          }
        }
        _getAvailableWorker() {
          if (this.idleQueue.length > 0) {
            return this.idleQueue.shift() || null;
          }
          if (this.count < this._getMaxConcurrency()) {
            this.count++;
            const name10 = `${this.name.toLowerCase()} (#${this.count} of ${this.maxConcurrency})`;
            return new WorkerThread({ name: name10, source: this.source, url: this.url });
          }
          return null;
        }
        _getMaxConcurrency() {
          return isMobile ? this.maxMobileConcurrency : this.maxConcurrency;
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-farm/worker-farm.ts
  var DEFAULT_PROPS, WorkerFarm;
  var init_worker_farm = __esm({
    "../worker-utils/src/lib/worker-farm/worker-farm.ts"() {
      init_worker_pool();
      init_worker_thread();
      DEFAULT_PROPS = {
        maxConcurrency: 3,
        maxMobileConcurrency: 1,
        reuseWorkers: true,
        onDebug: () => {
        }
      };
      WorkerFarm = class {
        constructor(props) {
          this.workerPools = new Map();
          this.props = { ...DEFAULT_PROPS };
          this.setProps(props);
          this.workerPools = new Map();
        }
        static isSupported() {
          return WorkerThread.isSupported();
        }
        static getWorkerFarm(props = {}) {
          WorkerFarm._workerFarm = WorkerFarm._workerFarm || new WorkerFarm({});
          WorkerFarm._workerFarm.setProps(props);
          return WorkerFarm._workerFarm;
        }
        destroy() {
          for (const workerPool of this.workerPools.values()) {
            workerPool.destroy();
          }
          this.workerPools = new Map();
        }
        setProps(props) {
          this.props = { ...this.props, ...props };
          for (const workerPool of this.workerPools.values()) {
            workerPool.setProps(this._getWorkerPoolProps());
          }
        }
        getWorkerPool(options) {
          const { name: name10, source, url } = options;
          let workerPool = this.workerPools.get(name10);
          if (!workerPool) {
            workerPool = new WorkerPool({
              name: name10,
              source,
              url
            });
            workerPool.setProps(this._getWorkerPoolProps());
            this.workerPools.set(name10, workerPool);
          }
          return workerPool;
        }
        _getWorkerPoolProps() {
          return {
            maxConcurrency: this.props.maxConcurrency,
            maxMobileConcurrency: this.props.maxMobileConcurrency,
            reuseWorkers: this.props.reuseWorkers,
            onDebug: this.props.onDebug
          };
        }
      };
    }
  });

  // ../worker-utils/src/lib/worker-api/get-worker-url.ts
  function getWorkerURL(worker, options = {}) {
    const workerOptions = options[worker.id] || {};
    const workerFile = `${worker.id}-worker.js`;
    let url = workerOptions.workerUrl;
    if (!url && worker.id === "compression") {
      url = options.workerUrl;
    }
    if (options._workerType === "test") {
      url = `modules/${worker.module}/dist/${workerFile}`;
    }
    if (!url) {
      let version = worker.version;
      if (version === "latest") {
        version = NPM_TAG;
      }
      const versionTag = version ? `@${version}` : "";
      url = `https://unpkg.com/@loaders.gl/${worker.module}${versionTag}/dist/${workerFile}`;
    }
    assert3(url);
    return url;
  }
  var NPM_TAG;
  var init_get_worker_url = __esm({
    "../worker-utils/src/lib/worker-api/get-worker-url.ts"() {
      init_assert2();
      NPM_TAG = "latest";
    }
  });

  // ../worker-utils/src/lib/worker-api/validate-worker-version.ts
  function validateWorkerVersion(worker, coreVersion = VERSION) {
    assert3(worker, "no worker provided");
    const workerVersion = worker.version;
    if (!coreVersion || !workerVersion) {
      return false;
    }
    return true;
  }
  var init_validate_worker_version = __esm({
    "../worker-utils/src/lib/worker-api/validate-worker-version.ts"() {
      init_assert2();
      init_version();
    }
  });

  // ../worker-utils/src/lib/node/require-utils.browser.ts
  var require_utils_browser_exports = {};
  __export(require_utils_browser_exports, {
    readFileAsArrayBuffer: () => readFileAsArrayBuffer,
    readFileAsText: () => readFileAsText,
    requireFromFile: () => requireFromFile,
    requireFromString: () => requireFromString
  });
  var readFileAsArrayBuffer, readFileAsText, requireFromFile, requireFromString;
  var init_require_utils_browser = __esm({
    "../worker-utils/src/lib/node/require-utils.browser.ts"() {
      readFileAsArrayBuffer = null;
      readFileAsText = null;
      requireFromFile = null;
      requireFromString = null;
    }
  });

  // ../worker-utils/src/lib/library-utils/library-utils.ts
  async function loadLibrary(libraryUrl, moduleName = null, options = {}) {
    if (moduleName) {
      libraryUrl = getLibraryUrl(libraryUrl, moduleName, options);
    }
    loadLibraryPromises[libraryUrl] = loadLibraryPromises[libraryUrl] || loadLibraryFromFile(libraryUrl);
    return await loadLibraryPromises[libraryUrl];
  }
  function getLibraryUrl(library, moduleName, options) {
    if (library.startsWith("http")) {
      return library;
    }
    const modules = options.modules || {};
    if (modules[library]) {
      return modules[library];
    }
    if (!isBrowser2) {
      return `modules/${moduleName}/dist/libs/${library}`;
    }
    if (options.CDN) {
      assert3(options.CDN.startsWith("http"));
      return `${options.CDN}/${moduleName}@${VERSION2}/dist/libs/${library}`;
    }
    if (isWorker) {
      return `../src/libs/${library}`;
    }
    return `modules/${moduleName}/src/libs/${library}`;
  }
  async function loadLibraryFromFile(libraryUrl) {
    if (libraryUrl.endsWith("wasm")) {
      const response2 = await fetch(libraryUrl);
      return await response2.arrayBuffer();
    }
    if (!isBrowser2) {
      try {
        return require_utils_browser_exports && requireFromFile && await requireFromFile(libraryUrl);
      } catch {
        return null;
      }
    }
    if (isWorker) {
      return importScripts(libraryUrl);
    }
    const response = await fetch(libraryUrl);
    const scriptSource = await response.text();
    return loadLibraryFromString(scriptSource, libraryUrl);
  }
  function loadLibraryFromString(scriptSource, id) {
    if (!isBrowser2) {
      return requireFromString && requireFromString(scriptSource, id);
    }
    if (isWorker) {
      eval.call(global_2, scriptSource);
      return null;
    }
    const script = document.createElement("script");
    script.id = id;
    try {
      script.appendChild(document.createTextNode(scriptSource));
    } catch (e) {
      script.text = scriptSource;
    }
    document.body.appendChild(script);
    return null;
  }
  var LATEST, VERSION2, loadLibraryPromises;
  var init_library_utils = __esm({
    "../worker-utils/src/lib/library-utils/library-utils.ts"() {
      init_globals2();
      init_require_utils_browser();
      init_assert2();
      init_version();
      LATEST = "latest";
      VERSION2 = typeof VERSION !== "undefined" ? VERSION : LATEST;
      loadLibraryPromises = {};
    }
  });

  // ../worker-utils/src/index.ts
  var init_src = __esm({
    "../worker-utils/src/index.ts"() {
      init_assert2();
      init_globals2();
      init_worker_farm();
      init_get_worker_url();
      init_validate_worker_version();
      init_library_utils();
    }
  });

  // ../loader-utils/src/lib/worker-loader-utils/parse-with-worker.ts
  function canParseWithWorker(loader, options) {
    if (!WorkerFarm.isSupported()) {
      return false;
    }
    if (!isBrowser2 && !options?._nodeWorkers) {
      return false;
    }
    return loader.worker && options?.worker;
  }
  async function parseWithWorker(loader, data, options, context, parseOnMainThread) {
    const name10 = loader.id;
    const url = getWorkerURL(loader, options);
    const workerFarm = WorkerFarm.getWorkerFarm(options);
    const workerPool = workerFarm.getWorkerPool({ name: name10, url });
    options = JSON.parse(JSON.stringify(options));
    context = JSON.parse(JSON.stringify(context || {}));
    const job = await workerPool.startJob("process-on-worker", onMessage.bind(null, parseOnMainThread));
    job.postMessage("process", {
      input: data,
      options,
      context
    });
    const result = await job.result;
    return await result.result;
  }
  async function onMessage(parseOnMainThread, job, type, payload) {
    switch (type) {
      case "done":
        job.done(payload);
        break;
      case "error":
        job.error(new Error(payload.error));
        break;
      case "process":
        const { id, input, options } = payload;
        try {
          const result = await parseOnMainThread(input, options);
          job.postMessage("done", { id, result });
        } catch (error) {
          const message = error instanceof Error ? error.message : "unknown error";
          job.postMessage("error", { id, error: message });
        }
        break;
      default:
        console.warn(`parse-with-worker unknown message ${type}`);
    }
  }
  var init_parse_with_worker = __esm({
    "../loader-utils/src/lib/worker-loader-utils/parse-with-worker.ts"() {
      init_src();
      init_src();
    }
  });

  // ../loader-utils/src/lib/binary-utils/get-first-characters.ts
  function getFirstCharacters(data, length4 = 5) {
    if (typeof data === "string") {
      return data.slice(0, length4);
    } else if (ArrayBuffer.isView(data)) {
      return getMagicString(data.buffer, data.byteOffset, length4);
    } else if (data instanceof ArrayBuffer) {
      const byteOffset = 0;
      return getMagicString(data, byteOffset, length4);
    }
    return "";
  }
  function getMagicString(arrayBuffer, byteOffset, length4) {
    if (arrayBuffer.byteLength <= byteOffset + length4) {
      return "";
    }
    const dataView = new DataView(arrayBuffer);
    let magic = "";
    for (let i2 = 0; i2 < length4; i2++) {
      magic += String.fromCharCode(dataView.getUint8(byteOffset + i2));
    }
    return magic;
  }
  var init_get_first_characters = __esm({
    "../loader-utils/src/lib/binary-utils/get-first-characters.ts"() {
    }
  });

  // ../loader-utils/src/lib/parser-utils/parse-json.ts
  function parseJSON(string) {
    try {
      return JSON.parse(string);
    } catch (_) {
      throw new Error(`Failed to parse JSON from data starting with "${getFirstCharacters(string)}"`);
    }
  }
  var init_parse_json = __esm({
    "../loader-utils/src/lib/parser-utils/parse-json.ts"() {
      init_get_first_characters();
    }
  });

  // ../loader-utils/src/lib/binary-utils/array-buffer-utils.ts
  function compareArrayBuffers(arrayBuffer1, arrayBuffer2, byteLength) {
    byteLength = byteLength || arrayBuffer1.byteLength;
    if (arrayBuffer1.byteLength < byteLength || arrayBuffer2.byteLength < byteLength) {
      return false;
    }
    const array1 = new Uint8Array(arrayBuffer1);
    const array2 = new Uint8Array(arrayBuffer2);
    for (let i2 = 0; i2 < array1.length; ++i2) {
      if (array1[i2] !== array2[i2]) {
        return false;
      }
    }
    return true;
  }
  function concatenateArrayBuffers(...sources) {
    const sourceArrays = sources.map((source2) => source2 instanceof ArrayBuffer ? new Uint8Array(source2) : source2);
    const byteLength = sourceArrays.reduce((length4, typedArray) => length4 + typedArray.byteLength, 0);
    const result = new Uint8Array(byteLength);
    let offset = 0;
    for (const sourceArray of sourceArrays) {
      result.set(sourceArray, offset);
      offset += sourceArray.byteLength;
    }
    return result.buffer;
  }
  function sliceArrayBuffer(arrayBuffer, byteOffset, byteLength) {
    const subArray = byteLength !== void 0 ? new Uint8Array(arrayBuffer).subarray(byteOffset, byteOffset + byteLength) : new Uint8Array(arrayBuffer).subarray(byteOffset);
    const arrayCopy = new Uint8Array(subArray);
    return arrayCopy.buffer;
  }
  var init_array_buffer_utils = __esm({
    "../loader-utils/src/lib/binary-utils/array-buffer-utils.ts"() {
    }
  });

  // ../loader-utils/src/lib/binary-utils/memory-copy-utils.ts
  function padToNBytes(byteLength, padding) {
    assert2(byteLength >= 0);
    assert2(padding > 0);
    return byteLength + (padding - 1) & ~(padding - 1);
  }
  function copyToArray(source, target, targetOffset) {
    let sourceArray;
    if (source instanceof ArrayBuffer) {
      sourceArray = new Uint8Array(source);
    } else {
      const srcByteOffset = source.byteOffset;
      const srcByteLength = source.byteLength;
      sourceArray = new Uint8Array(source.buffer || source.arrayBuffer, srcByteOffset, srcByteLength);
    }
    target.set(sourceArray, targetOffset);
    return targetOffset + padToNBytes(sourceArray.byteLength, 4);
  }
  var init_memory_copy_utils = __esm({
    "../loader-utils/src/lib/binary-utils/memory-copy-utils.ts"() {
      init_assert();
    }
  });

  // ../loader-utils/src/lib/binary-utils/dataview-copy-utils.ts
  function padStringToByteAlignment(string, byteAlignment) {
    const length4 = string.length;
    const paddedLength = Math.ceil(length4 / byteAlignment) * byteAlignment;
    const padding = paddedLength - length4;
    let whitespace = "";
    for (let i2 = 0; i2 < padding; ++i2) {
      whitespace += " ";
    }
    return string + whitespace;
  }
  function copyStringToDataView(dataView, byteOffset, string, byteLength) {
    if (dataView) {
      for (let i2 = 0; i2 < byteLength; i2++) {
        dataView.setUint8(byteOffset + i2, string.charCodeAt(i2));
      }
    }
    return byteOffset + byteLength;
  }
  function copyBinaryToDataView(dataView, byteOffset, binary, byteLength) {
    if (dataView) {
      for (let i2 = 0; i2 < byteLength; i2++) {
        dataView.setUint8(byteOffset + i2, binary[i2]);
      }
    }
    return byteOffset + byteLength;
  }
  function copyPaddedArrayBufferToDataView(dataView, byteOffset, sourceBuffer, padding) {
    const paddedLength = padToNBytes(sourceBuffer.byteLength, padding);
    const padLength = paddedLength - sourceBuffer.byteLength;
    if (dataView) {
      const targetArray = new Uint8Array(dataView.buffer, dataView.byteOffset + byteOffset, sourceBuffer.byteLength);
      const sourceArray = new Uint8Array(sourceBuffer);
      targetArray.set(sourceArray);
      for (let i2 = 0; i2 < padLength; ++i2) {
        dataView.setUint8(byteOffset + sourceBuffer.byteLength + i2, 32);
      }
    }
    byteOffset += paddedLength;
    return byteOffset;
  }
  function copyPaddedStringToDataView(dataView, byteOffset, string, padding) {
    const textEncoder = new TextEncoder();
    const stringBuffer = textEncoder.encode(string);
    byteOffset = copyPaddedArrayBufferToDataView(dataView, byteOffset, stringBuffer, padding);
    return byteOffset;
  }
  var init_dataview_copy_utils = __esm({
    "../loader-utils/src/lib/binary-utils/dataview-copy-utils.ts"() {
      init_memory_copy_utils();
    }
  });

  // ../loader-utils/src/lib/iterators/async-iteration.ts
  async function concatenateArrayBuffersAsync(asyncIterator) {
    const arrayBuffers = [];
    for await (const chunk of asyncIterator) {
      arrayBuffers.push(chunk);
    }
    return concatenateArrayBuffers(...arrayBuffers);
  }
  var init_async_iteration = __esm({
    "../loader-utils/src/lib/iterators/async-iteration.ts"() {
      init_array_buffer_utils();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/typeof.js
  function _typeof(obj) {
    "@babel/helpers - typeof";
    return _typeof = typeof Symbol == "function" && typeof Symbol.iterator == "symbol" ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && typeof Symbol == "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof(obj);
  }
  var init_typeof = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/typeof.js"() {
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js
  function _toPrimitive(input, hint) {
    if (_typeof(input) !== "object" || input === null)
      return input;
    var prim = input[Symbol.toPrimitive];
    if (prim !== void 0) {
      var res = prim.call(input, hint || "default");
      if (_typeof(res) !== "object")
        return res;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return (hint === "string" ? String : Number)(input);
  }
  var init_toPrimitive = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js"() {
      init_typeof();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
  function _toPropertyKey(arg) {
    var key = _toPrimitive(arg, "string");
    return _typeof(key) === "symbol" ? key : String(key);
  }
  var init_toPropertyKey = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js"() {
      init_typeof();
      init_toPrimitive();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/defineProperty.js
  function _defineProperty(obj, key, value) {
    key = _toPropertyKey(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var init_defineProperty = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/defineProperty.js"() {
      init_toPropertyKey();
    }
  });

  // ../loader-utils/src/lib/path-utils/file-aliases.ts
  function resolvePath(filename2) {
    for (const alias in fileAliases) {
      if (filename2.startsWith(alias)) {
        const replacement = fileAliases[alias];
        filename2 = filename2.replace(alias, replacement);
      }
    }
    if (!filename2.startsWith("http://") && !filename2.startsWith("https://")) {
      filename2 = `${pathPrefix}${filename2}`;
    }
    return filename2;
  }
  var pathPrefix, fileAliases;
  var init_file_aliases = __esm({
    "../loader-utils/src/lib/path-utils/file-aliases.ts"() {
      pathPrefix = "";
      fileAliases = {};
    }
  });

  // ../loader-utils/src/lib/node/buffer.browser.ts
  function toArrayBuffer(buffer) {
    return buffer;
  }
  var init_buffer_browser = __esm({
    "../loader-utils/src/lib/node/buffer.browser.ts"() {
    }
  });

  // ../loader-utils/src/lib/binary-utils/memory-conversion-utils.ts
  function isBuffer(value) {
    return value && typeof value === "object" && value.isBuffer;
  }
  function toArrayBuffer2(data) {
    if (isBuffer(data)) {
      return toArrayBuffer(data);
    }
    if (data instanceof ArrayBuffer) {
      return data;
    }
    if (ArrayBuffer.isView(data)) {
      if (data.byteOffset === 0 && data.byteLength === data.buffer.byteLength) {
        return data.buffer;
      }
      return data.buffer.slice(data.byteOffset, data.byteOffset + data.byteLength);
    }
    if (typeof data === "string") {
      const text = data;
      const uint8Array = new TextEncoder().encode(text);
      return uint8Array.buffer;
    }
    if (data && typeof data === "object" && data._toArrayBuffer) {
      return data._toArrayBuffer();
    }
    throw new Error("toArrayBuffer");
  }
  var init_memory_conversion_utils = __esm({
    "../loader-utils/src/lib/binary-utils/memory-conversion-utils.ts"() {
      init_buffer_browser();
    }
  });

  // ../loader-utils/src/lib/path-utils/get-cwd.ts
  function getCWD() {
    if (typeof process !== "undefined" && typeof process.cwd !== "undefined") {
      return process.cwd();
    }
    const pathname = window.location?.pathname;
    return pathname?.slice(0, pathname.lastIndexOf("/") + 1) || "";
  }
  var init_get_cwd = __esm({
    "../loader-utils/src/lib/path-utils/get-cwd.ts"() {
    }
  });

  // ../loader-utils/src/lib/path-utils/path.ts
  var path_exports = {};
  __export(path_exports, {
    dirname: () => dirname,
    filename: () => filename,
    join: () => join,
    resolve: () => resolve
  });
  function filename(url) {
    const slashIndex = url ? url.lastIndexOf("/") : -1;
    return slashIndex >= 0 ? url.substr(slashIndex + 1) : "";
  }
  function dirname(url) {
    const slashIndex = url ? url.lastIndexOf("/") : -1;
    return slashIndex >= 0 ? url.substr(0, slashIndex) : "";
  }
  function join(...parts) {
    const separator = "/";
    parts = parts.map((part, index) => {
      if (index) {
        part = part.replace(new RegExp(`^${separator}`), "");
      }
      if (index !== parts.length - 1) {
        part = part.replace(new RegExp(`${separator}$`), "");
      }
      return part;
    });
    return parts.join(separator);
  }
  function resolve(...components) {
    const paths = [];
    for (let _i = 0; _i < components.length; _i++) {
      paths[_i] = components[_i];
    }
    let resolvedPath = "";
    let resolvedAbsolute = false;
    let cwd;
    for (let i2 = paths.length - 1; i2 >= -1 && !resolvedAbsolute; i2--) {
      let path;
      if (i2 >= 0) {
        path = paths[i2];
      } else {
        if (cwd === void 0) {
          cwd = getCWD();
        }
        path = cwd;
      }
      if (path.length === 0) {
        continue;
      }
      resolvedPath = `${path}/${resolvedPath}`;
      resolvedAbsolute = path.charCodeAt(0) === SLASH;
    }
    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
    if (resolvedAbsolute) {
      return `/${resolvedPath}`;
    } else if (resolvedPath.length > 0) {
      return resolvedPath;
    }
    return ".";
  }
  function normalizeStringPosix(path, allowAboveRoot) {
    let res = "";
    let lastSlash = -1;
    let dots = 0;
    let code;
    let isAboveRoot = false;
    for (let i2 = 0; i2 <= path.length; ++i2) {
      if (i2 < path.length) {
        code = path.charCodeAt(i2);
      } else if (code === SLASH) {
        break;
      } else {
        code = SLASH;
      }
      if (code === SLASH) {
        if (lastSlash === i2 - 1 || dots === 1) {
        } else if (lastSlash !== i2 - 1 && dots === 2) {
          if (res.length < 2 || !isAboveRoot || res.charCodeAt(res.length - 1) !== DOT || res.charCodeAt(res.length - 2) !== DOT) {
            if (res.length > 2) {
              const start = res.length - 1;
              let j = start;
              for (; j >= 0; --j) {
                if (res.charCodeAt(j) === SLASH) {
                  break;
                }
              }
              if (j !== start) {
                res = j === -1 ? "" : res.slice(0, j);
                lastSlash = i2;
                dots = 0;
                isAboveRoot = false;
                continue;
              }
            } else if (res.length === 2 || res.length === 1) {
              res = "";
              lastSlash = i2;
              dots = 0;
              isAboveRoot = false;
              continue;
            }
          }
          if (allowAboveRoot) {
            if (res.length > 0) {
              res += "/..";
            } else {
              res = "..";
            }
            isAboveRoot = true;
          }
        } else {
          const slice = path.slice(lastSlash + 1, i2);
          if (res.length > 0) {
            res += `/${slice}`;
          } else {
            res = slice;
          }
          isAboveRoot = false;
        }
        lastSlash = i2;
        dots = 0;
      } else if (code === DOT && dots !== -1) {
        ++dots;
      } else {
        dots = -1;
      }
    }
    return res;
  }
  var SLASH, DOT;
  var init_path = __esm({
    "../loader-utils/src/lib/path-utils/path.ts"() {
      init_get_cwd();
      SLASH = 47;
      DOT = 46;
    }
  });

  // ../loader-utils/src/index.ts
  var init_src2 = __esm({
    "../loader-utils/src/index.ts"() {
      init_assert();
      init_globals();
      init_parse_with_worker();
      init_parse_json();
      init_array_buffer_utils();
      init_memory_copy_utils();
      init_dataview_copy_utils();
      init_async_iteration();
      init_file_aliases();
      init_memory_conversion_utils();
      init_path();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/assert.js
  function assert4(condition, message) {
    if (!condition) {
      throw new Error("math.gl assertion ".concat(message));
    }
  }
  var init_assert3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/assert.js"() {
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/common.js
  function formatValue(value, {
    precision = config.precision
  } = {}) {
    value = round(value);
    return "".concat(parseFloat(value.toPrecision(precision)));
  }
  function isArray(value) {
    return Array.isArray(value) || ArrayBuffer.isView(value) && !(value instanceof DataView);
  }
  function toRadians(degrees2) {
    return radians(degrees2);
  }
  function toDegrees(radians2) {
    return degrees(radians2);
  }
  function radians(degrees2, result) {
    return map(degrees2, (degrees3) => degrees3 * DEGREES_TO_RADIANS, result);
  }
  function degrees(radians2, result) {
    return map(radians2, (radians3) => radians3 * RADIANS_TO_DEGREES, result);
  }
  function clamp(value, min, max) {
    return map(value, (value2) => Math.max(min, Math.min(max, value2)));
  }
  function equals(a2, b, epsilon) {
    const oldEpsilon = config.EPSILON;
    if (epsilon) {
      config.EPSILON = epsilon;
    }
    try {
      if (a2 === b) {
        return true;
      }
      if (isArray(a2) && isArray(b)) {
        if (a2.length !== b.length) {
          return false;
        }
        for (let i2 = 0; i2 < a2.length; ++i2) {
          if (!equals(a2[i2], b[i2])) {
            return false;
          }
        }
        return true;
      }
      if (a2 && a2.equals) {
        return a2.equals(b);
      }
      if (b && b.equals) {
        return b.equals(a2);
      }
      if (typeof a2 === "number" && typeof b === "number") {
        return Math.abs(a2 - b) <= config.EPSILON * Math.max(1, Math.abs(a2), Math.abs(b));
      }
      return false;
    } finally {
      config.EPSILON = oldEpsilon;
    }
  }
  function round(value) {
    return Math.round(value / config.EPSILON) * config.EPSILON;
  }
  function duplicateArray(array) {
    return array.clone ? array.clone() : new Array(array.length);
  }
  function map(value, func, result) {
    if (isArray(value)) {
      const array = value;
      result = result || duplicateArray(array);
      for (let i2 = 0; i2 < result.length && i2 < array.length; ++i2) {
        result[i2] = func(value[i2], i2, result);
      }
      return result;
    }
    return func(value);
  }
  var RADIANS_TO_DEGREES, DEGREES_TO_RADIANS, config;
  var init_common = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/common.js"() {
      RADIANS_TO_DEGREES = 1 / Math.PI * 180;
      DEGREES_TO_RADIANS = 1 / 180 * Math.PI;
      config = {
        EPSILON: 1e-12,
        debug: false,
        precision: 4,
        printTypes: false,
        printDegrees: false,
        printRowMajor: true
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/math-array.js
  function _extendableBuiltin(cls) {
    function ExtendableBuiltin() {
      var instance = Reflect.construct(cls, Array.from(arguments));
      Object.setPrototypeOf(instance, Object.getPrototypeOf(this));
      return instance;
    }
    ExtendableBuiltin.prototype = Object.create(cls.prototype, {
      constructor: {
        value: cls,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(ExtendableBuiltin, cls);
    } else {
      ExtendableBuiltin.__proto__ = cls;
    }
    return ExtendableBuiltin;
  }
  var MathArray;
  var init_math_array = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/math-array.js"() {
      init_common();
      MathArray = class extends _extendableBuiltin(Array) {
        clone() {
          return new this.constructor().copy(this);
        }
        fromArray(array, offset = 0) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = array[i2 + offset];
          }
          return this.check();
        }
        toArray(targetArray = [], offset = 0) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            targetArray[offset + i2] = this[i2];
          }
          return targetArray;
        }
        from(arrayOrObject) {
          return Array.isArray(arrayOrObject) ? this.copy(arrayOrObject) : this.fromObject(arrayOrObject);
        }
        to(arrayOrObject) {
          if (arrayOrObject === this) {
            return this;
          }
          return isArray(arrayOrObject) ? this.toArray(arrayOrObject) : this.toObject(arrayOrObject);
        }
        toTarget(target) {
          return target ? this.to(target) : this;
        }
        toFloat32Array() {
          return new Float32Array(this);
        }
        toString() {
          return this.formatString(config);
        }
        formatString(opts) {
          let string = "";
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            string += (i2 > 0 ? ", " : "") + formatValue(this[i2], opts);
          }
          return "".concat(opts.printTypes ? this.constructor.name : "", "[").concat(string, "]");
        }
        equals(array) {
          if (!array || this.length !== array.length) {
            return false;
          }
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            if (!equals(this[i2], array[i2])) {
              return false;
            }
          }
          return true;
        }
        exactEquals(array) {
          if (!array || this.length !== array.length) {
            return false;
          }
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            if (this[i2] !== array[i2]) {
              return false;
            }
          }
          return true;
        }
        negate() {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = -this[i2];
          }
          return this.check();
        }
        lerp(a2, b, t2) {
          if (t2 === void 0) {
            return this.lerp(this, a2, b);
          }
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            const ai = a2[i2];
            this[i2] = ai + t2 * (b[i2] - ai);
          }
          return this.check();
        }
        min(vector) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.min(vector[i2], this[i2]);
          }
          return this.check();
        }
        max(vector) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.max(vector[i2], this[i2]);
          }
          return this.check();
        }
        clamp(minVector, maxVector) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.min(Math.max(this[i2], minVector[i2]), maxVector[i2]);
          }
          return this.check();
        }
        add(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] += vector[i2];
            }
          }
          return this.check();
        }
        subtract(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] -= vector[i2];
            }
          }
          return this.check();
        }
        scale(scale5) {
          if (typeof scale5 === "number") {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] *= scale5;
            }
          } else {
            for (let i2 = 0; i2 < this.ELEMENTS && i2 < scale5.length; ++i2) {
              this[i2] *= scale5[i2];
            }
          }
          return this.check();
        }
        multiplyByScalar(scalar) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] *= scalar;
          }
          return this.check();
        }
        check() {
          if (config.debug && !this.validate()) {
            throw new Error("math.gl: ".concat(this.constructor.name, " some fields set to invalid numbers'"));
          }
          return this;
        }
        validate() {
          let valid = this.length === this.ELEMENTS;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            valid = valid && Number.isFinite(this[i2]);
          }
          return valid;
        }
        sub(a2) {
          return this.subtract(a2);
        }
        setScalar(a2) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = a2;
          }
          return this.check();
        }
        addScalar(a2) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] += a2;
          }
          return this.check();
        }
        subScalar(a2) {
          return this.addScalar(-a2);
        }
        multiplyScalar(scalar) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] *= scalar;
          }
          return this.check();
        }
        divideScalar(a2) {
          return this.multiplyByScalar(1 / a2);
        }
        clampScalar(min, max) {
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            this[i2] = Math.min(Math.max(this[i2], min), max);
          }
          return this.check();
        }
        get elements() {
          return this;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/validators.js
  function validateVector(v, length4) {
    if (v.length !== length4) {
      return false;
    }
    for (let i2 = 0; i2 < v.length; ++i2) {
      if (!Number.isFinite(v[i2])) {
        return false;
      }
    }
    return true;
  }
  function checkNumber(value) {
    if (!Number.isFinite(value)) {
      throw new Error("Invalid number ".concat(value));
    }
    return value;
  }
  function checkVector(v, length4, callerName = "") {
    if (config.debug && !validateVector(v, length4)) {
      throw new Error("math.gl: ".concat(callerName, " some fields set to invalid numbers'"));
    }
    return v;
  }
  var init_validators = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/validators.js"() {
      init_common();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/vector.js
  var Vector;
  var init_vector = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/vector.js"() {
      init_math_array();
      init_validators();
      init_assert3();
      Vector = class extends MathArray {
        get x() {
          return this[0];
        }
        set x(value) {
          this[0] = checkNumber(value);
        }
        get y() {
          return this[1];
        }
        set y(value) {
          this[1] = checkNumber(value);
        }
        len() {
          return Math.sqrt(this.lengthSquared());
        }
        magnitude() {
          return this.len();
        }
        lengthSquared() {
          let length4 = 0;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            length4 += this[i2] * this[i2];
          }
          return length4;
        }
        magnitudeSquared() {
          return this.lengthSquared();
        }
        distance(mathArray) {
          return Math.sqrt(this.distanceSquared(mathArray));
        }
        distanceSquared(mathArray) {
          let length4 = 0;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            const dist = this[i2] - mathArray[i2];
            length4 += dist * dist;
          }
          return checkNumber(length4);
        }
        dot(mathArray) {
          let product = 0;
          for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
            product += this[i2] * mathArray[i2];
          }
          return checkNumber(product);
        }
        normalize() {
          const length4 = this.magnitude();
          if (length4 !== 0) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] /= length4;
            }
          }
          return this.check();
        }
        multiply(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] *= vector[i2];
            }
          }
          return this.check();
        }
        divide(...vectors) {
          for (const vector of vectors) {
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              this[i2] /= vector[i2];
            }
          }
          return this.check();
        }
        lengthSq() {
          return this.lengthSquared();
        }
        distanceTo(vector) {
          return this.distance(vector);
        }
        distanceToSquared(vector) {
          return this.distanceSquared(vector);
        }
        getComponent(i2) {
          assert4(i2 >= 0 && i2 < this.ELEMENTS, "index is out of range");
          return checkNumber(this[i2]);
        }
        setComponent(i2, value) {
          assert4(i2 >= 0 && i2 < this.ELEMENTS, "index is out of range");
          this[i2] = value;
          return this.check();
        }
        addVectors(a2, b) {
          return this.copy(a2).add(b);
        }
        subVectors(a2, b) {
          return this.copy(a2).subtract(b);
        }
        multiplyVectors(a2, b) {
          return this.copy(a2).multiply(b);
        }
        addScaledVector(a2, b) {
          return this.add(new this.constructor(a2).multiplyScalar(b));
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/common.js
  var EPSILON, ARRAY_TYPE, degree;
  var init_common2 = __esm({
    "../../node_modules/gl-matrix/esm/common.js"() {
      EPSILON = 1e-6;
      ARRAY_TYPE = typeof Float32Array !== "undefined" ? Float32Array : Array;
      degree = Math.PI / 180;
      if (!Math.hypot)
        Math.hypot = function() {
          var y = 0, i2 = arguments.length;
          while (i2--) {
            y += arguments[i2] * arguments[i2];
          }
          return Math.sqrt(y);
        };
    }
  });

  // ../../node_modules/gl-matrix/esm/vec2.js
  function create() {
    var out = new ARRAY_TYPE(2);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
    }
    return out;
  }
  function transformMat2(out, a2, m) {
    var x = a2[0], y = a2[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    return out;
  }
  function transformMat2d(out, a2, m) {
    var x = a2[0], y = a2[1];
    out[0] = m[0] * x + m[2] * y + m[4];
    out[1] = m[1] * x + m[3] * y + m[5];
    return out;
  }
  function transformMat3(out, a2, m) {
    var x = a2[0], y = a2[1];
    out[0] = m[0] * x + m[3] * y + m[6];
    out[1] = m[1] * x + m[4] * y + m[7];
    return out;
  }
  function transformMat4(out, a2, m) {
    var x = a2[0];
    var y = a2[1];
    out[0] = m[0] * x + m[4] * y + m[12];
    out[1] = m[1] * x + m[5] * y + m[13];
    return out;
  }
  var forEach2;
  var init_vec2 = __esm({
    "../../node_modules/gl-matrix/esm/vec2.js"() {
      init_common2();
      forEach2 = function() {
        var vec = create();
        return function(a2, stride, offset, count, fn, arg) {
          var i2, l2;
          if (!stride) {
            stride = 2;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l2 = Math.min(count * stride + offset, a2.length);
          } else {
            l2 = a2.length;
          }
          for (i2 = offset; i2 < l2; i2 += stride) {
            vec[0] = a2[i2];
            vec[1] = a2[i2 + 1];
            fn(vec, vec, arg);
            a2[i2] = vec[0];
            a2[i2 + 1] = vec[1];
          }
          return a2;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js
  function vec2_transformMat4AsVector(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    const w = m[3] * x + m[7] * y || 1;
    out[0] = (m[0] * x + m[4] * y) / w;
    out[1] = (m[1] * x + m[5] * y) / w;
    return out;
  }
  function vec3_transformMat4AsVector(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    const z = a2[2];
    const w = m[3] * x + m[7] * y + m[11] * z || 1;
    out[0] = (m[0] * x + m[4] * y + m[8] * z) / w;
    out[1] = (m[1] * x + m[5] * y + m[9] * z) / w;
    out[2] = (m[2] * x + m[6] * y + m[10] * z) / w;
    return out;
  }
  function vec3_transformMat2(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    out[2] = a2[2];
    return out;
  }
  function vec4_transformMat2(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    out[0] = m[0] * x + m[2] * y;
    out[1] = m[1] * x + m[3] * y;
    out[2] = a2[2];
    out[3] = a2[3];
    return out;
  }
  function vec4_transformMat3(out, a2, m) {
    const x = a2[0];
    const y = a2[1];
    const z = a2[2];
    out[0] = m[0] * x + m[3] * y + m[6] * z;
    out[1] = m[1] * x + m[4] * y + m[7] * z;
    out[2] = m[2] * x + m[5] * y + m[8] * z;
    out[3] = a2[3];
    return out;
  }
  var init_gl_matrix_extras = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/gl-matrix-extras.js"() {
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector2.js
  var Vector2;
  var init_vector2 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector2.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec2();
      init_gl_matrix_extras();
      Vector2 = class extends Vector {
        constructor(x = 0, y = 0) {
          super(2);
          if (isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
            }
            this[0] = x;
            this[1] = y;
          }
        }
        set(x, y) {
          this[0] = x;
          this[1] = y;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
          }
          this[0] = object.x;
          this[1] = object.y;
          return this.check();
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          return object;
        }
        get ELEMENTS() {
          return 2;
        }
        horizontalAngle() {
          return Math.atan2(this.y, this.x);
        }
        verticalAngle() {
          return Math.atan2(this.x, this.y);
        }
        transform(matrix4) {
          return this.transformAsPoint(matrix4);
        }
        transformAsPoint(matrix4) {
          transformMat4(this, this, matrix4);
          return this.check();
        }
        transformAsVector(matrix4) {
          vec2_transformMat4AsVector(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          transformMat3(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2x3(matrix2x3) {
          transformMat2d(this, this, matrix2x3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          transformMat2(this, this, matrix2);
          return this.check();
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/vec3.js
  function create2() {
    var out = new ARRAY_TYPE(3);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    return out;
  }
  function length(a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    return Math.hypot(x, y, z);
  }
  function fromValues(x, y, z) {
    var out = new ARRAY_TYPE(3);
    out[0] = x;
    out[1] = y;
    out[2] = z;
    return out;
  }
  function normalize(out, a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var len2 = x * x + y * y + z * z;
    if (len2 > 0) {
      len2 = 1 / Math.sqrt(len2);
    }
    out[0] = a2[0] * len2;
    out[1] = a2[1] * len2;
    out[2] = a2[2] * len2;
    return out;
  }
  function dot(a2, b) {
    return a2[0] * b[0] + a2[1] * b[1] + a2[2] * b[2];
  }
  function cross(out, a2, b) {
    var ax = a2[0], ay = a2[1], az = a2[2];
    var bx = b[0], by = b[1], bz = b[2];
    out[0] = ay * bz - az * by;
    out[1] = az * bx - ax * bz;
    out[2] = ax * by - ay * bx;
    return out;
  }
  function transformMat42(out, a2, m) {
    var x = a2[0], y = a2[1], z = a2[2];
    var w = m[3] * x + m[7] * y + m[11] * z + m[15];
    w = w || 1;
    out[0] = (m[0] * x + m[4] * y + m[8] * z + m[12]) / w;
    out[1] = (m[1] * x + m[5] * y + m[9] * z + m[13]) / w;
    out[2] = (m[2] * x + m[6] * y + m[10] * z + m[14]) / w;
    return out;
  }
  function transformMat32(out, a2, m) {
    var x = a2[0], y = a2[1], z = a2[2];
    out[0] = x * m[0] + y * m[3] + z * m[6];
    out[1] = x * m[1] + y * m[4] + z * m[7];
    out[2] = x * m[2] + y * m[5] + z * m[8];
    return out;
  }
  function transformQuat(out, a2, q) {
    var qx = q[0], qy = q[1], qz = q[2], qw = q[3];
    var x = a2[0], y = a2[1], z = a2[2];
    var uvx = qy * z - qz * y, uvy = qz * x - qx * z, uvz = qx * y - qy * x;
    var uuvx = qy * uvz - qz * uvy, uuvy = qz * uvx - qx * uvz, uuvz = qx * uvy - qy * uvx;
    var w2 = qw * 2;
    uvx *= w2;
    uvy *= w2;
    uvz *= w2;
    uuvx *= 2;
    uuvy *= 2;
    uuvz *= 2;
    out[0] = x + uvx + uuvx;
    out[1] = y + uvy + uuvy;
    out[2] = z + uvz + uuvz;
    return out;
  }
  function rotateX(out, a2, b, rad) {
    var p2 = [], r2 = [];
    p2[0] = a2[0] - b[0];
    p2[1] = a2[1] - b[1];
    p2[2] = a2[2] - b[2];
    r2[0] = p2[0];
    r2[1] = p2[1] * Math.cos(rad) - p2[2] * Math.sin(rad);
    r2[2] = p2[1] * Math.sin(rad) + p2[2] * Math.cos(rad);
    out[0] = r2[0] + b[0];
    out[1] = r2[1] + b[1];
    out[2] = r2[2] + b[2];
    return out;
  }
  function rotateY(out, a2, b, rad) {
    var p2 = [], r2 = [];
    p2[0] = a2[0] - b[0];
    p2[1] = a2[1] - b[1];
    p2[2] = a2[2] - b[2];
    r2[0] = p2[2] * Math.sin(rad) + p2[0] * Math.cos(rad);
    r2[1] = p2[1];
    r2[2] = p2[2] * Math.cos(rad) - p2[0] * Math.sin(rad);
    out[0] = r2[0] + b[0];
    out[1] = r2[1] + b[1];
    out[2] = r2[2] + b[2];
    return out;
  }
  function rotateZ(out, a2, b, rad) {
    var p2 = [], r2 = [];
    p2[0] = a2[0] - b[0];
    p2[1] = a2[1] - b[1];
    p2[2] = a2[2] - b[2];
    r2[0] = p2[0] * Math.cos(rad) - p2[1] * Math.sin(rad);
    r2[1] = p2[0] * Math.sin(rad) + p2[1] * Math.cos(rad);
    r2[2] = p2[2];
    out[0] = r2[0] + b[0];
    out[1] = r2[1] + b[1];
    out[2] = r2[2] + b[2];
    return out;
  }
  function angle(a2, b) {
    var ax = a2[0], ay = a2[1], az = a2[2], bx = b[0], by = b[1], bz = b[2], mag1 = Math.sqrt(ax * ax + ay * ay + az * az), mag2 = Math.sqrt(bx * bx + by * by + bz * bz), mag = mag1 * mag2, cosine = mag && dot(a2, b) / mag;
    return Math.acos(Math.min(Math.max(cosine, -1), 1));
  }
  var len, forEach3;
  var init_vec3 = __esm({
    "../../node_modules/gl-matrix/esm/vec3.js"() {
      init_common2();
      len = length;
      forEach3 = function() {
        var vec = create2();
        return function(a2, stride, offset, count, fn, arg) {
          var i2, l2;
          if (!stride) {
            stride = 3;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l2 = Math.min(count * stride + offset, a2.length);
          } else {
            l2 = a2.length;
          }
          for (i2 = offset; i2 < l2; i2 += stride) {
            vec[0] = a2[i2];
            vec[1] = a2[i2 + 1];
            vec[2] = a2[i2 + 2];
            fn(vec, vec, arg);
            a2[i2] = vec[0];
            a2[i2 + 1] = vec[1];
            a2[i2 + 2] = vec[2];
          }
          return a2;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector3.js
  var ORIGIN, ZERO, Vector3;
  var init_vector3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector3.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec3();
      init_gl_matrix_extras();
      ORIGIN = [0, 0, 0];
      Vector3 = class extends Vector {
        static get ZERO() {
          if (!ZERO) {
            ZERO = new Vector3(0, 0, 0);
            Object.freeze(ZERO);
          }
          return ZERO;
        }
        constructor(x = 0, y = 0, z = 0) {
          super(-0, -0, -0);
          if (arguments.length === 1 && isArray(x)) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
              checkNumber(z);
            }
            this[0] = x;
            this[1] = y;
            this[2] = z;
          }
        }
        set(x, y, z) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
            checkNumber(object.z);
          }
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          return this.check();
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          object.z = this[2];
          return object;
        }
        get ELEMENTS() {
          return 3;
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        angle(vector) {
          return angle(this, vector);
        }
        cross(vector) {
          cross(this, this, vector);
          return this.check();
        }
        rotateX({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateX(this, this, origin, radians2);
          return this.check();
        }
        rotateY({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateY(this, this, origin, radians2);
          return this.check();
        }
        rotateZ({
          radians: radians2,
          origin = ORIGIN
        }) {
          rotateZ(this, this, origin, radians2);
          return this.check();
        }
        transform(matrix4) {
          return this.transformAsPoint(matrix4);
        }
        transformAsPoint(matrix4) {
          transformMat42(this, this, matrix4);
          return this.check();
        }
        transformAsVector(matrix4) {
          vec3_transformMat4AsVector(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          transformMat32(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          vec3_transformMat2(this, this, matrix2);
          return this.check();
        }
        transformByQuaternion(quaternion) {
          transformQuat(this, this, quaternion);
          return this.check();
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/vector4.js
  var ZERO2, Vector4;
  var init_vector4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/vector4.js"() {
      init_vector();
      init_common();
      init_validators();
      init_vec3();
      init_gl_matrix_extras();
      Vector4 = class extends Vector {
        static get ZERO() {
          if (!ZERO2) {
            ZERO2 = new Vector4(0, 0, 0, 0);
            Object.freeze(ZERO2);
          }
          return ZERO2;
        }
        constructor(x = 0, y = 0, z = 0, w = 0) {
          super(-0, -0, -0, -0);
          if (isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            if (config.debug) {
              checkNumber(x);
              checkNumber(y);
              checkNumber(z);
              checkNumber(w);
            }
            this[0] = x;
            this[1] = y;
            this[2] = z;
            this[3] = w;
          }
        }
        set(x, y, z, w) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          this[3] = w;
          return this.check();
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          return this.check();
        }
        fromObject(object) {
          if (config.debug) {
            checkNumber(object.x);
            checkNumber(object.y);
            checkNumber(object.z);
            checkNumber(object.w);
          }
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          this[3] = object.w;
          return this;
        }
        toObject(object) {
          object.x = this[0];
          object.y = this[1];
          object.z = this[2];
          object.w = this[3];
          return object;
        }
        get ELEMENTS() {
          return 4;
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        get w() {
          return this[3];
        }
        set w(value) {
          this[3] = checkNumber(value);
        }
        transform(matrix4) {
          transformMat42(this, this, matrix4);
          return this.check();
        }
        transformByMatrix3(matrix3) {
          vec4_transformMat3(this, this, matrix3);
          return this.check();
        }
        transformByMatrix2(matrix2) {
          vec4_transformMat2(this, this, matrix2);
          return this.check();
        }
        transformByQuaternion(quaternion) {
          transformQuat(this, this, quaternion);
          return this.check();
        }
        applyMatrix4(m) {
          m.transform(this, this);
          return this;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/base/matrix.js
  var Matrix;
  var init_matrix = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/base/matrix.js"() {
      init_math_array();
      init_validators();
      init_common();
      Matrix = class extends MathArray {
        toString() {
          let string = "[";
          if (config.printRowMajor) {
            string += "row-major:";
            for (let row = 0; row < this.RANK; ++row) {
              for (let col = 0; col < this.RANK; ++col) {
                string += " ".concat(this[col * this.RANK + row]);
              }
            }
          } else {
            string += "column-major:";
            for (let i2 = 0; i2 < this.ELEMENTS; ++i2) {
              string += " ".concat(this[i2]);
            }
          }
          string += "]";
          return string;
        }
        getElementIndex(row, col) {
          return col * this.RANK + row;
        }
        getElement(row, col) {
          return this[col * this.RANK + row];
        }
        setElement(row, col, value) {
          this[col * this.RANK + row] = checkNumber(value);
          return this;
        }
        getColumn(columnIndex, result = new Array(this.RANK).fill(-0)) {
          const firstIndex = columnIndex * this.RANK;
          for (let i2 = 0; i2 < this.RANK; ++i2) {
            result[i2] = this[firstIndex + i2];
          }
          return result;
        }
        setColumn(columnIndex, columnVector) {
          const firstIndex = columnIndex * this.RANK;
          for (let i2 = 0; i2 < this.RANK; ++i2) {
            this[firstIndex + i2] = columnVector[i2];
          }
          return this;
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/mat3.js
  function create3() {
    var out = new ARRAY_TYPE(9);
    if (ARRAY_TYPE != Float32Array) {
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
      out[5] = 0;
      out[6] = 0;
      out[7] = 0;
    }
    out[0] = 1;
    out[4] = 1;
    out[8] = 1;
    return out;
  }
  function transpose(out, a2) {
    if (out === a2) {
      var a01 = a2[1], a02 = a2[2], a12 = a2[5];
      out[1] = a2[3];
      out[2] = a2[6];
      out[3] = a01;
      out[5] = a2[7];
      out[6] = a02;
      out[7] = a12;
    } else {
      out[0] = a2[0];
      out[1] = a2[3];
      out[2] = a2[6];
      out[3] = a2[1];
      out[4] = a2[4];
      out[5] = a2[7];
      out[6] = a2[2];
      out[7] = a2[5];
      out[8] = a2[8];
    }
    return out;
  }
  function invert(out, a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2];
    var a10 = a2[3], a11 = a2[4], a12 = a2[5];
    var a20 = a2[6], a21 = a2[7], a22 = a2[8];
    var b01 = a22 * a11 - a12 * a21;
    var b11 = -a22 * a10 + a12 * a20;
    var b21 = a21 * a10 - a11 * a20;
    var det = a00 * b01 + a01 * b11 + a02 * b21;
    if (!det) {
      return null;
    }
    det = 1 / det;
    out[0] = b01 * det;
    out[1] = (-a22 * a01 + a02 * a21) * det;
    out[2] = (a12 * a01 - a02 * a11) * det;
    out[3] = b11 * det;
    out[4] = (a22 * a00 - a02 * a20) * det;
    out[5] = (-a12 * a00 + a02 * a10) * det;
    out[6] = b21 * det;
    out[7] = (-a21 * a00 + a01 * a20) * det;
    out[8] = (a11 * a00 - a01 * a10) * det;
    return out;
  }
  function determinant(a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2];
    var a10 = a2[3], a11 = a2[4], a12 = a2[5];
    var a20 = a2[6], a21 = a2[7], a22 = a2[8];
    return a00 * (a22 * a11 - a12 * a21) + a01 * (-a22 * a10 + a12 * a20) + a02 * (a21 * a10 - a11 * a20);
  }
  function multiply(out, a2, b) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2];
    var a10 = a2[3], a11 = a2[4], a12 = a2[5];
    var a20 = a2[6], a21 = a2[7], a22 = a2[8];
    var b00 = b[0], b01 = b[1], b02 = b[2];
    var b10 = b[3], b11 = b[4], b12 = b[5];
    var b20 = b[6], b21 = b[7], b22 = b[8];
    out[0] = b00 * a00 + b01 * a10 + b02 * a20;
    out[1] = b00 * a01 + b01 * a11 + b02 * a21;
    out[2] = b00 * a02 + b01 * a12 + b02 * a22;
    out[3] = b10 * a00 + b11 * a10 + b12 * a20;
    out[4] = b10 * a01 + b11 * a11 + b12 * a21;
    out[5] = b10 * a02 + b11 * a12 + b12 * a22;
    out[6] = b20 * a00 + b21 * a10 + b22 * a20;
    out[7] = b20 * a01 + b21 * a11 + b22 * a21;
    out[8] = b20 * a02 + b21 * a12 + b22 * a22;
    return out;
  }
  function translate(out, a2, v) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a10 = a2[3], a11 = a2[4], a12 = a2[5], a20 = a2[6], a21 = a2[7], a22 = a2[8], x = v[0], y = v[1];
    out[0] = a00;
    out[1] = a01;
    out[2] = a02;
    out[3] = a10;
    out[4] = a11;
    out[5] = a12;
    out[6] = x * a00 + y * a10 + a20;
    out[7] = x * a01 + y * a11 + a21;
    out[8] = x * a02 + y * a12 + a22;
    return out;
  }
  function rotate(out, a2, rad) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a10 = a2[3], a11 = a2[4], a12 = a2[5], a20 = a2[6], a21 = a2[7], a22 = a2[8], s2 = Math.sin(rad), c = Math.cos(rad);
    out[0] = c * a00 + s2 * a10;
    out[1] = c * a01 + s2 * a11;
    out[2] = c * a02 + s2 * a12;
    out[3] = c * a10 - s2 * a00;
    out[4] = c * a11 - s2 * a01;
    out[5] = c * a12 - s2 * a02;
    out[6] = a20;
    out[7] = a21;
    out[8] = a22;
    return out;
  }
  function scale(out, a2, v) {
    var x = v[0], y = v[1];
    out[0] = x * a2[0];
    out[1] = x * a2[1];
    out[2] = x * a2[2];
    out[3] = y * a2[3];
    out[4] = y * a2[4];
    out[5] = y * a2[5];
    out[6] = a2[6];
    out[7] = a2[7];
    out[8] = a2[8];
    return out;
  }
  function fromQuat(out, q) {
    var x = q[0], y = q[1], z = q[2], w = q[3];
    var x2 = x + x;
    var y2 = y + y;
    var z2 = z + z;
    var xx = x * x2;
    var yx = y * x2;
    var yy = y * y2;
    var zx = z * x2;
    var zy = z * y2;
    var zz = z * z2;
    var wx = w * x2;
    var wy = w * y2;
    var wz = w * z2;
    out[0] = 1 - yy - zz;
    out[3] = yx - wz;
    out[6] = zx + wy;
    out[1] = yx + wz;
    out[4] = 1 - xx - zz;
    out[7] = zy - wx;
    out[2] = zx - wy;
    out[5] = zy + wx;
    out[8] = 1 - xx - yy;
    return out;
  }
  var init_mat3 = __esm({
    "../../node_modules/gl-matrix/esm/mat3.js"() {
      init_common2();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/matrix3.js
  function getZeroMatrix() {
    if (!ZERO_MATRIX3) {
      ZERO_MATRIX3 = new Matrix3([0, 0, 0, 0, 0, 0, 0, 0, 0]);
      Object.freeze(ZERO_MATRIX3);
    }
    return ZERO_MATRIX3;
  }
  function getIdentityMatrix() {
    if (!IDENTITY_MATRIX3) {
      IDENTITY_MATRIX3 = new Matrix3();
      Object.freeze(IDENTITY_MATRIX3);
    }
    return IDENTITY_MATRIX3;
  }
  var INDICES, IDENTITY_MATRIX, Matrix3, ZERO_MATRIX3, IDENTITY_MATRIX3;
  var init_matrix3 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/matrix3.js"() {
      init_matrix();
      init_validators();
      init_gl_matrix_extras();
      init_mat3();
      init_vec2();
      init_vec3();
      (function(INDICES3) {
        INDICES3[INDICES3["COL0ROW0"] = 0] = "COL0ROW0";
        INDICES3[INDICES3["COL0ROW1"] = 1] = "COL0ROW1";
        INDICES3[INDICES3["COL0ROW2"] = 2] = "COL0ROW2";
        INDICES3[INDICES3["COL1ROW0"] = 3] = "COL1ROW0";
        INDICES3[INDICES3["COL1ROW1"] = 4] = "COL1ROW1";
        INDICES3[INDICES3["COL1ROW2"] = 5] = "COL1ROW2";
        INDICES3[INDICES3["COL2ROW0"] = 6] = "COL2ROW0";
        INDICES3[INDICES3["COL2ROW1"] = 7] = "COL2ROW1";
        INDICES3[INDICES3["COL2ROW2"] = 8] = "COL2ROW2";
      })(INDICES || (INDICES = {}));
      IDENTITY_MATRIX = Object.freeze([1, 0, 0, 0, 1, 0, 0, 0, 1]);
      Matrix3 = class extends Matrix {
        static get IDENTITY() {
          return getIdentityMatrix();
        }
        static get ZERO() {
          return getZeroMatrix();
        }
        get ELEMENTS() {
          return 9;
        }
        get RANK() {
          return 3;
        }
        get INDICES() {
          return INDICES;
        }
        constructor(array, ...args) {
          super(-0, -0, -0, -0, -0, -0, -0, -0, -0);
          if (arguments.length === 1 && Array.isArray(array)) {
            this.copy(array);
          } else if (args.length > 0) {
            this.copy([array, ...args]);
          } else {
            this.identity();
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          this[4] = array[4];
          this[5] = array[5];
          this[6] = array[6];
          this[7] = array[7];
          this[8] = array[8];
          return this.check();
        }
        identity() {
          return this.copy(IDENTITY_MATRIX);
        }
        fromObject(object) {
          return this.check();
        }
        fromQuaternion(q) {
          fromQuat(this, q);
          return this.check();
        }
        set(m00, m10, m20, m01, m11, m21, m02, m12, m22) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m01;
          this[4] = m11;
          this[5] = m21;
          this[6] = m02;
          this[7] = m12;
          this[8] = m22;
          return this.check();
        }
        setRowMajor(m00, m01, m02, m10, m11, m12, m20, m21, m22) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m01;
          this[4] = m11;
          this[5] = m21;
          this[6] = m02;
          this[7] = m12;
          this[8] = m22;
          return this.check();
        }
        determinant() {
          return determinant(this);
        }
        transpose() {
          transpose(this, this);
          return this.check();
        }
        invert() {
          invert(this, this);
          return this.check();
        }
        multiplyLeft(a2) {
          multiply(this, a2, this);
          return this.check();
        }
        multiplyRight(a2) {
          multiply(this, this, a2);
          return this.check();
        }
        rotate(radians2) {
          rotate(this, this, radians2);
          return this.check();
        }
        scale(factor) {
          if (Array.isArray(factor)) {
            scale(this, this, factor);
          } else {
            scale(this, this, [factor, factor]);
          }
          return this.check();
        }
        translate(vec) {
          translate(this, this, vec);
          return this.check();
        }
        transform(vector, result) {
          let out;
          switch (vector.length) {
            case 2:
              out = transformMat3(result || [-0, -0], vector, this);
              break;
            case 3:
              out = transformMat32(result || [-0, -0, -0], vector, this);
              break;
            case 4:
              out = vec4_transformMat3(result || [-0, -0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformVector(vector, result) {
          return this.transform(vector, result);
        }
        transformVector2(vector, result) {
          return this.transform(vector, result);
        }
        transformVector3(vector, result) {
          return this.transform(vector, result);
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/mat4.js
  function identity(out) {
    out[0] = 1;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = 1;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 1;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  function transpose2(out, a2) {
    if (out === a2) {
      var a01 = a2[1], a02 = a2[2], a03 = a2[3];
      var a12 = a2[6], a13 = a2[7];
      var a23 = a2[11];
      out[1] = a2[4];
      out[2] = a2[8];
      out[3] = a2[12];
      out[4] = a01;
      out[6] = a2[9];
      out[7] = a2[13];
      out[8] = a02;
      out[9] = a12;
      out[11] = a2[14];
      out[12] = a03;
      out[13] = a13;
      out[14] = a23;
    } else {
      out[0] = a2[0];
      out[1] = a2[4];
      out[2] = a2[8];
      out[3] = a2[12];
      out[4] = a2[1];
      out[5] = a2[5];
      out[6] = a2[9];
      out[7] = a2[13];
      out[8] = a2[2];
      out[9] = a2[6];
      out[10] = a2[10];
      out[11] = a2[14];
      out[12] = a2[3];
      out[13] = a2[7];
      out[14] = a2[11];
      out[15] = a2[15];
    }
    return out;
  }
  function invert2(out, a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a03 = a2[3];
    var a10 = a2[4], a11 = a2[5], a12 = a2[6], a13 = a2[7];
    var a20 = a2[8], a21 = a2[9], a22 = a2[10], a23 = a2[11];
    var a30 = a2[12], a31 = a2[13], a32 = a2[14], a33 = a2[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32;
    var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
    if (!det) {
      return null;
    }
    det = 1 / det;
    out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
    out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
    out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
    out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
    out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
    out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
    out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
    out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
    out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
    out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
    out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
    out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
    out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
    out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
    out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
    out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
    return out;
  }
  function determinant2(a2) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a03 = a2[3];
    var a10 = a2[4], a11 = a2[5], a12 = a2[6], a13 = a2[7];
    var a20 = a2[8], a21 = a2[9], a22 = a2[10], a23 = a2[11];
    var a30 = a2[12], a31 = a2[13], a32 = a2[14], a33 = a2[15];
    var b00 = a00 * a11 - a01 * a10;
    var b01 = a00 * a12 - a02 * a10;
    var b02 = a00 * a13 - a03 * a10;
    var b03 = a01 * a12 - a02 * a11;
    var b04 = a01 * a13 - a03 * a11;
    var b05 = a02 * a13 - a03 * a12;
    var b06 = a20 * a31 - a21 * a30;
    var b07 = a20 * a32 - a22 * a30;
    var b08 = a20 * a33 - a23 * a30;
    var b09 = a21 * a32 - a22 * a31;
    var b10 = a21 * a33 - a23 * a31;
    var b11 = a22 * a33 - a23 * a32;
    return b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;
  }
  function multiply2(out, a2, b) {
    var a00 = a2[0], a01 = a2[1], a02 = a2[2], a03 = a2[3];
    var a10 = a2[4], a11 = a2[5], a12 = a2[6], a13 = a2[7];
    var a20 = a2[8], a21 = a2[9], a22 = a2[10], a23 = a2[11];
    var a30 = a2[12], a31 = a2[13], a32 = a2[14], a33 = a2[15];
    var b0 = b[0], b1 = b[1], b2 = b[2], b3 = b[3];
    out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[4];
    b1 = b[5];
    b2 = b[6];
    b3 = b[7];
    out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[8];
    b1 = b[9];
    b2 = b[10];
    b3 = b[11];
    out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    b0 = b[12];
    b1 = b[13];
    b2 = b[14];
    b3 = b[15];
    out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
    out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
    out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
    out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
    return out;
  }
  function translate2(out, a2, v) {
    var x = v[0], y = v[1], z = v[2];
    var a00, a01, a02, a03;
    var a10, a11, a12, a13;
    var a20, a21, a22, a23;
    if (a2 === out) {
      out[12] = a2[0] * x + a2[4] * y + a2[8] * z + a2[12];
      out[13] = a2[1] * x + a2[5] * y + a2[9] * z + a2[13];
      out[14] = a2[2] * x + a2[6] * y + a2[10] * z + a2[14];
      out[15] = a2[3] * x + a2[7] * y + a2[11] * z + a2[15];
    } else {
      a00 = a2[0];
      a01 = a2[1];
      a02 = a2[2];
      a03 = a2[3];
      a10 = a2[4];
      a11 = a2[5];
      a12 = a2[6];
      a13 = a2[7];
      a20 = a2[8];
      a21 = a2[9];
      a22 = a2[10];
      a23 = a2[11];
      out[0] = a00;
      out[1] = a01;
      out[2] = a02;
      out[3] = a03;
      out[4] = a10;
      out[5] = a11;
      out[6] = a12;
      out[7] = a13;
      out[8] = a20;
      out[9] = a21;
      out[10] = a22;
      out[11] = a23;
      out[12] = a00 * x + a10 * y + a20 * z + a2[12];
      out[13] = a01 * x + a11 * y + a21 * z + a2[13];
      out[14] = a02 * x + a12 * y + a22 * z + a2[14];
      out[15] = a03 * x + a13 * y + a23 * z + a2[15];
    }
    return out;
  }
  function scale2(out, a2, v) {
    var x = v[0], y = v[1], z = v[2];
    out[0] = a2[0] * x;
    out[1] = a2[1] * x;
    out[2] = a2[2] * x;
    out[3] = a2[3] * x;
    out[4] = a2[4] * y;
    out[5] = a2[5] * y;
    out[6] = a2[6] * y;
    out[7] = a2[7] * y;
    out[8] = a2[8] * z;
    out[9] = a2[9] * z;
    out[10] = a2[10] * z;
    out[11] = a2[11] * z;
    out[12] = a2[12];
    out[13] = a2[13];
    out[14] = a2[14];
    out[15] = a2[15];
    return out;
  }
  function rotate2(out, a2, rad, axis) {
    var x = axis[0], y = axis[1], z = axis[2];
    var len2 = Math.hypot(x, y, z);
    var s2, c, t2;
    var a00, a01, a02, a03;
    var a10, a11, a12, a13;
    var a20, a21, a22, a23;
    var b00, b01, b02;
    var b10, b11, b12;
    var b20, b21, b22;
    if (len2 < EPSILON) {
      return null;
    }
    len2 = 1 / len2;
    x *= len2;
    y *= len2;
    z *= len2;
    s2 = Math.sin(rad);
    c = Math.cos(rad);
    t2 = 1 - c;
    a00 = a2[0];
    a01 = a2[1];
    a02 = a2[2];
    a03 = a2[3];
    a10 = a2[4];
    a11 = a2[5];
    a12 = a2[6];
    a13 = a2[7];
    a20 = a2[8];
    a21 = a2[9];
    a22 = a2[10];
    a23 = a2[11];
    b00 = x * x * t2 + c;
    b01 = y * x * t2 + z * s2;
    b02 = z * x * t2 - y * s2;
    b10 = x * y * t2 - z * s2;
    b11 = y * y * t2 + c;
    b12 = z * y * t2 + x * s2;
    b20 = x * z * t2 + y * s2;
    b21 = y * z * t2 - x * s2;
    b22 = z * z * t2 + c;
    out[0] = a00 * b00 + a10 * b01 + a20 * b02;
    out[1] = a01 * b00 + a11 * b01 + a21 * b02;
    out[2] = a02 * b00 + a12 * b01 + a22 * b02;
    out[3] = a03 * b00 + a13 * b01 + a23 * b02;
    out[4] = a00 * b10 + a10 * b11 + a20 * b12;
    out[5] = a01 * b10 + a11 * b11 + a21 * b12;
    out[6] = a02 * b10 + a12 * b11 + a22 * b12;
    out[7] = a03 * b10 + a13 * b11 + a23 * b12;
    out[8] = a00 * b20 + a10 * b21 + a20 * b22;
    out[9] = a01 * b20 + a11 * b21 + a21 * b22;
    out[10] = a02 * b20 + a12 * b21 + a22 * b22;
    out[11] = a03 * b20 + a13 * b21 + a23 * b22;
    if (a2 !== out) {
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    return out;
  }
  function rotateX2(out, a2, rad) {
    var s2 = Math.sin(rad);
    var c = Math.cos(rad);
    var a10 = a2[4];
    var a11 = a2[5];
    var a12 = a2[6];
    var a13 = a2[7];
    var a20 = a2[8];
    var a21 = a2[9];
    var a22 = a2[10];
    var a23 = a2[11];
    if (a2 !== out) {
      out[0] = a2[0];
      out[1] = a2[1];
      out[2] = a2[2];
      out[3] = a2[3];
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    out[4] = a10 * c + a20 * s2;
    out[5] = a11 * c + a21 * s2;
    out[6] = a12 * c + a22 * s2;
    out[7] = a13 * c + a23 * s2;
    out[8] = a20 * c - a10 * s2;
    out[9] = a21 * c - a11 * s2;
    out[10] = a22 * c - a12 * s2;
    out[11] = a23 * c - a13 * s2;
    return out;
  }
  function rotateY2(out, a2, rad) {
    var s2 = Math.sin(rad);
    var c = Math.cos(rad);
    var a00 = a2[0];
    var a01 = a2[1];
    var a02 = a2[2];
    var a03 = a2[3];
    var a20 = a2[8];
    var a21 = a2[9];
    var a22 = a2[10];
    var a23 = a2[11];
    if (a2 !== out) {
      out[4] = a2[4];
      out[5] = a2[5];
      out[6] = a2[6];
      out[7] = a2[7];
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    out[0] = a00 * c - a20 * s2;
    out[1] = a01 * c - a21 * s2;
    out[2] = a02 * c - a22 * s2;
    out[3] = a03 * c - a23 * s2;
    out[8] = a00 * s2 + a20 * c;
    out[9] = a01 * s2 + a21 * c;
    out[10] = a02 * s2 + a22 * c;
    out[11] = a03 * s2 + a23 * c;
    return out;
  }
  function rotateZ2(out, a2, rad) {
    var s2 = Math.sin(rad);
    var c = Math.cos(rad);
    var a00 = a2[0];
    var a01 = a2[1];
    var a02 = a2[2];
    var a03 = a2[3];
    var a10 = a2[4];
    var a11 = a2[5];
    var a12 = a2[6];
    var a13 = a2[7];
    if (a2 !== out) {
      out[8] = a2[8];
      out[9] = a2[9];
      out[10] = a2[10];
      out[11] = a2[11];
      out[12] = a2[12];
      out[13] = a2[13];
      out[14] = a2[14];
      out[15] = a2[15];
    }
    out[0] = a00 * c + a10 * s2;
    out[1] = a01 * c + a11 * s2;
    out[2] = a02 * c + a12 * s2;
    out[3] = a03 * c + a13 * s2;
    out[4] = a10 * c - a00 * s2;
    out[5] = a11 * c - a01 * s2;
    out[6] = a12 * c - a02 * s2;
    out[7] = a13 * c - a03 * s2;
    return out;
  }
  function getScaling(out, mat) {
    var m11 = mat[0];
    var m12 = mat[1];
    var m13 = mat[2];
    var m21 = mat[4];
    var m22 = mat[5];
    var m23 = mat[6];
    var m31 = mat[8];
    var m32 = mat[9];
    var m33 = mat[10];
    out[0] = Math.hypot(m11, m12, m13);
    out[1] = Math.hypot(m21, m22, m23);
    out[2] = Math.hypot(m31, m32, m33);
    return out;
  }
  function fromQuat2(out, q) {
    var x = q[0], y = q[1], z = q[2], w = q[3];
    var x2 = x + x;
    var y2 = y + y;
    var z2 = z + z;
    var xx = x * x2;
    var yx = y * x2;
    var yy = y * y2;
    var zx = z * x2;
    var zy = z * y2;
    var zz = z * z2;
    var wx = w * x2;
    var wy = w * y2;
    var wz = w * z2;
    out[0] = 1 - yy - zz;
    out[1] = yx + wz;
    out[2] = zx - wy;
    out[3] = 0;
    out[4] = yx - wz;
    out[5] = 1 - xx - zz;
    out[6] = zy + wx;
    out[7] = 0;
    out[8] = zx + wy;
    out[9] = zy - wx;
    out[10] = 1 - xx - yy;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
    out[15] = 1;
    return out;
  }
  function frustum(out, left, right, bottom, top, near, far) {
    var rl = 1 / (right - left);
    var tb = 1 / (top - bottom);
    var nf = 1 / (near - far);
    out[0] = near * 2 * rl;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = near * 2 * tb;
    out[6] = 0;
    out[7] = 0;
    out[8] = (right + left) * rl;
    out[9] = (top + bottom) * tb;
    out[10] = (far + near) * nf;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[14] = far * near * 2 * nf;
    out[15] = 0;
    return out;
  }
  function perspectiveNO(out, fovy, aspect, near, far) {
    var f2 = 1 / Math.tan(fovy / 2), nf;
    out[0] = f2 / aspect;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = f2;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[11] = -1;
    out[12] = 0;
    out[13] = 0;
    out[15] = 0;
    if (far != null && far !== Infinity) {
      nf = 1 / (near - far);
      out[10] = (far + near) * nf;
      out[14] = 2 * far * near * nf;
    } else {
      out[10] = -1;
      out[14] = -2 * near;
    }
    return out;
  }
  function orthoNO(out, left, right, bottom, top, near, far) {
    var lr = 1 / (left - right);
    var bt = 1 / (bottom - top);
    var nf = 1 / (near - far);
    out[0] = -2 * lr;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[5] = -2 * bt;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[10] = 2 * nf;
    out[11] = 0;
    out[12] = (left + right) * lr;
    out[13] = (top + bottom) * bt;
    out[14] = (far + near) * nf;
    out[15] = 1;
    return out;
  }
  function lookAt(out, eye, center, up) {
    var x0, x1, x2, y0, y1, y2, z0, z1, z2, len2;
    var eyex = eye[0];
    var eyey = eye[1];
    var eyez = eye[2];
    var upx = up[0];
    var upy = up[1];
    var upz = up[2];
    var centerx = center[0];
    var centery = center[1];
    var centerz = center[2];
    if (Math.abs(eyex - centerx) < EPSILON && Math.abs(eyey - centery) < EPSILON && Math.abs(eyez - centerz) < EPSILON) {
      return identity(out);
    }
    z0 = eyex - centerx;
    z1 = eyey - centery;
    z2 = eyez - centerz;
    len2 = 1 / Math.hypot(z0, z1, z2);
    z0 *= len2;
    z1 *= len2;
    z2 *= len2;
    x0 = upy * z2 - upz * z1;
    x1 = upz * z0 - upx * z2;
    x2 = upx * z1 - upy * z0;
    len2 = Math.hypot(x0, x1, x2);
    if (!len2) {
      x0 = 0;
      x1 = 0;
      x2 = 0;
    } else {
      len2 = 1 / len2;
      x0 *= len2;
      x1 *= len2;
      x2 *= len2;
    }
    y0 = z1 * x2 - z2 * x1;
    y1 = z2 * x0 - z0 * x2;
    y2 = z0 * x1 - z1 * x0;
    len2 = Math.hypot(y0, y1, y2);
    if (!len2) {
      y0 = 0;
      y1 = 0;
      y2 = 0;
    } else {
      len2 = 1 / len2;
      y0 *= len2;
      y1 *= len2;
      y2 *= len2;
    }
    out[0] = x0;
    out[1] = y0;
    out[2] = z0;
    out[3] = 0;
    out[4] = x1;
    out[5] = y1;
    out[6] = z1;
    out[7] = 0;
    out[8] = x2;
    out[9] = y2;
    out[10] = z2;
    out[11] = 0;
    out[12] = -(x0 * eyex + x1 * eyey + x2 * eyez);
    out[13] = -(y0 * eyex + y1 * eyey + y2 * eyez);
    out[14] = -(z0 * eyex + z1 * eyey + z2 * eyez);
    out[15] = 1;
    return out;
  }
  var perspective, ortho;
  var init_mat4 = __esm({
    "../../node_modules/gl-matrix/esm/mat4.js"() {
      init_common2();
      perspective = perspectiveNO;
      ortho = orthoNO;
    }
  });

  // ../../node_modules/gl-matrix/esm/vec4.js
  function create4() {
    var out = new ARRAY_TYPE(4);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
      out[3] = 0;
    }
    return out;
  }
  function add(out, a2, b) {
    out[0] = a2[0] + b[0];
    out[1] = a2[1] + b[1];
    out[2] = a2[2] + b[2];
    out[3] = a2[3] + b[3];
    return out;
  }
  function scale3(out, a2, b) {
    out[0] = a2[0] * b;
    out[1] = a2[1] * b;
    out[2] = a2[2] * b;
    out[3] = a2[3] * b;
    return out;
  }
  function length2(a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var w = a2[3];
    return Math.hypot(x, y, z, w);
  }
  function squaredLength(a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var w = a2[3];
    return x * x + y * y + z * z + w * w;
  }
  function normalize2(out, a2) {
    var x = a2[0];
    var y = a2[1];
    var z = a2[2];
    var w = a2[3];
    var len2 = x * x + y * y + z * z + w * w;
    if (len2 > 0) {
      len2 = 1 / Math.sqrt(len2);
    }
    out[0] = x * len2;
    out[1] = y * len2;
    out[2] = z * len2;
    out[3] = w * len2;
    return out;
  }
  function dot2(a2, b) {
    return a2[0] * b[0] + a2[1] * b[1] + a2[2] * b[2] + a2[3] * b[3];
  }
  function lerp(out, a2, b, t2) {
    var ax = a2[0];
    var ay = a2[1];
    var az = a2[2];
    var aw = a2[3];
    out[0] = ax + t2 * (b[0] - ax);
    out[1] = ay + t2 * (b[1] - ay);
    out[2] = az + t2 * (b[2] - az);
    out[3] = aw + t2 * (b[3] - aw);
    return out;
  }
  function transformMat43(out, a2, m) {
    var x = a2[0], y = a2[1], z = a2[2], w = a2[3];
    out[0] = m[0] * x + m[4] * y + m[8] * z + m[12] * w;
    out[1] = m[1] * x + m[5] * y + m[9] * z + m[13] * w;
    out[2] = m[2] * x + m[6] * y + m[10] * z + m[14] * w;
    out[3] = m[3] * x + m[7] * y + m[11] * z + m[15] * w;
    return out;
  }
  function transformQuat2(out, a2, q) {
    var x = a2[0], y = a2[1], z = a2[2];
    var qx = q[0], qy = q[1], qz = q[2], qw = q[3];
    var ix = qw * x + qy * z - qz * y;
    var iy = qw * y + qz * x - qx * z;
    var iz = qw * z + qx * y - qy * x;
    var iw = -qx * x - qy * y - qz * z;
    out[0] = ix * qw + iw * -qx + iy * -qz - iz * -qy;
    out[1] = iy * qw + iw * -qy + iz * -qx - ix * -qz;
    out[2] = iz * qw + iw * -qz + ix * -qy - iy * -qx;
    out[3] = a2[3];
    return out;
  }
  var forEach4;
  var init_vec4 = __esm({
    "../../node_modules/gl-matrix/esm/vec4.js"() {
      init_common2();
      forEach4 = function() {
        var vec = create4();
        return function(a2, stride, offset, count, fn, arg) {
          var i2, l2;
          if (!stride) {
            stride = 4;
          }
          if (!offset) {
            offset = 0;
          }
          if (count) {
            l2 = Math.min(count * stride + offset, a2.length);
          } else {
            l2 = a2.length;
          }
          for (i2 = offset; i2 < l2; i2 += stride) {
            vec[0] = a2[i2];
            vec[1] = a2[i2 + 1];
            vec[2] = a2[i2 + 2];
            vec[3] = a2[i2 + 3];
            fn(vec, vec, arg);
            a2[i2] = vec[0];
            a2[i2 + 1] = vec[1];
            a2[i2 + 2] = vec[2];
            a2[i2 + 3] = vec[3];
          }
          return a2;
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/matrix4.js
  function getZeroMatrix2() {
    if (!ZERO3) {
      ZERO3 = new Matrix4([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]);
      Object.freeze(ZERO3);
    }
    return ZERO3;
  }
  function getIdentityMatrix2() {
    if (!IDENTITY) {
      IDENTITY = new Matrix4();
      Object.freeze(IDENTITY);
    }
    return IDENTITY;
  }
  function checkRadians(possiblyDegrees) {
    if (possiblyDegrees > Math.PI * 2) {
      throw Error("expected radians");
    }
  }
  function computeInfinitePerspectiveOffCenter(result, left, right, bottom, top, near) {
    const column0Row0 = 2 * near / (right - left);
    const column1Row1 = 2 * near / (top - bottom);
    const column2Row0 = (right + left) / (right - left);
    const column2Row1 = (top + bottom) / (top - bottom);
    const column2Row2 = -1;
    const column2Row3 = -1;
    const column3Row2 = -2 * near;
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = 0;
    result[13] = 0;
    result[14] = column3Row2;
    result[15] = 0;
    return result;
  }
  var INDICES2, DEFAULT_FOVY, DEFAULT_ASPECT, DEFAULT_NEAR, DEFAULT_FAR, IDENTITY_MATRIX2, Matrix4, ZERO3, IDENTITY;
  var init_matrix4 = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/matrix4.js"() {
      init_matrix();
      init_validators();
      init_gl_matrix_extras();
      init_mat4();
      init_vec2();
      init_vec3();
      init_vec4();
      (function(INDICES3) {
        INDICES3[INDICES3["COL0ROW0"] = 0] = "COL0ROW0";
        INDICES3[INDICES3["COL0ROW1"] = 1] = "COL0ROW1";
        INDICES3[INDICES3["COL0ROW2"] = 2] = "COL0ROW2";
        INDICES3[INDICES3["COL0ROW3"] = 3] = "COL0ROW3";
        INDICES3[INDICES3["COL1ROW0"] = 4] = "COL1ROW0";
        INDICES3[INDICES3["COL1ROW1"] = 5] = "COL1ROW1";
        INDICES3[INDICES3["COL1ROW2"] = 6] = "COL1ROW2";
        INDICES3[INDICES3["COL1ROW3"] = 7] = "COL1ROW3";
        INDICES3[INDICES3["COL2ROW0"] = 8] = "COL2ROW0";
        INDICES3[INDICES3["COL2ROW1"] = 9] = "COL2ROW1";
        INDICES3[INDICES3["COL2ROW2"] = 10] = "COL2ROW2";
        INDICES3[INDICES3["COL2ROW3"] = 11] = "COL2ROW3";
        INDICES3[INDICES3["COL3ROW0"] = 12] = "COL3ROW0";
        INDICES3[INDICES3["COL3ROW1"] = 13] = "COL3ROW1";
        INDICES3[INDICES3["COL3ROW2"] = 14] = "COL3ROW2";
        INDICES3[INDICES3["COL3ROW3"] = 15] = "COL3ROW3";
      })(INDICES2 || (INDICES2 = {}));
      DEFAULT_FOVY = 45 * Math.PI / 180;
      DEFAULT_ASPECT = 1;
      DEFAULT_NEAR = 0.1;
      DEFAULT_FAR = 500;
      IDENTITY_MATRIX2 = Object.freeze([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
      Matrix4 = class extends Matrix {
        static get IDENTITY() {
          return getIdentityMatrix2();
        }
        static get ZERO() {
          return getZeroMatrix2();
        }
        get ELEMENTS() {
          return 16;
        }
        get RANK() {
          return 4;
        }
        get INDICES() {
          return INDICES2;
        }
        constructor(array) {
          super(-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0);
          if (arguments.length === 1 && Array.isArray(array)) {
            this.copy(array);
          } else {
            this.identity();
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          this[4] = array[4];
          this[5] = array[5];
          this[6] = array[6];
          this[7] = array[7];
          this[8] = array[8];
          this[9] = array[9];
          this[10] = array[10];
          this[11] = array[11];
          this[12] = array[12];
          this[13] = array[13];
          this[14] = array[14];
          this[15] = array[15];
          return this.check();
        }
        set(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m30;
          this[4] = m01;
          this[5] = m11;
          this[6] = m21;
          this[7] = m31;
          this[8] = m02;
          this[9] = m12;
          this[10] = m22;
          this[11] = m32;
          this[12] = m03;
          this[13] = m13;
          this[14] = m23;
          this[15] = m33;
          return this.check();
        }
        setRowMajor(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33) {
          this[0] = m00;
          this[1] = m10;
          this[2] = m20;
          this[3] = m30;
          this[4] = m01;
          this[5] = m11;
          this[6] = m21;
          this[7] = m31;
          this[8] = m02;
          this[9] = m12;
          this[10] = m22;
          this[11] = m32;
          this[12] = m03;
          this[13] = m13;
          this[14] = m23;
          this[15] = m33;
          return this.check();
        }
        toRowMajor(result) {
          result[0] = this[0];
          result[1] = this[4];
          result[2] = this[8];
          result[3] = this[12];
          result[4] = this[1];
          result[5] = this[5];
          result[6] = this[9];
          result[7] = this[13];
          result[8] = this[2];
          result[9] = this[6];
          result[10] = this[10];
          result[11] = this[14];
          result[12] = this[3];
          result[13] = this[7];
          result[14] = this[11];
          result[15] = this[15];
          return result;
        }
        identity() {
          return this.copy(IDENTITY_MATRIX2);
        }
        fromObject(object) {
          return this.check();
        }
        fromQuaternion(quaternion) {
          fromQuat2(this, quaternion);
          return this.check();
        }
        frustum(view) {
          const {
            left,
            right,
            bottom,
            top,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          if (far === Infinity) {
            computeInfinitePerspectiveOffCenter(this, left, right, bottom, top, near);
          } else {
            frustum(this, left, right, bottom, top, near, far);
          }
          return this.check();
        }
        lookAt(view) {
          const {
            eye,
            center = [0, 0, 0],
            up = [0, 1, 0]
          } = view;
          lookAt(this, eye, center, up);
          return this.check();
        }
        ortho(view) {
          const {
            left,
            right,
            bottom,
            top,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          ortho(this, left, right, bottom, top, near, far);
          return this.check();
        }
        orthographic(view) {
          const {
            fovy = DEFAULT_FOVY,
            aspect = DEFAULT_ASPECT,
            focalDistance = 1,
            near = DEFAULT_NEAR,
            far = DEFAULT_FAR
          } = view;
          checkRadians(fovy);
          const halfY = fovy / 2;
          const top = focalDistance * Math.tan(halfY);
          const right = top * aspect;
          return this.ortho({
            left: -right,
            right,
            bottom: -top,
            top,
            near,
            far
          });
        }
        perspective(view) {
          const {
            fovy = 45 * Math.PI / 180,
            aspect = 1,
            near = 0.1,
            far = 500
          } = view;
          checkRadians(fovy);
          perspective(this, fovy, aspect, near, far);
          return this.check();
        }
        determinant() {
          return determinant2(this);
        }
        getScale(result = [-0, -0, -0]) {
          result[0] = Math.sqrt(this[0] * this[0] + this[1] * this[1] + this[2] * this[2]);
          result[1] = Math.sqrt(this[4] * this[4] + this[5] * this[5] + this[6] * this[6]);
          result[2] = Math.sqrt(this[8] * this[8] + this[9] * this[9] + this[10] * this[10]);
          return result;
        }
        getTranslation(result = [-0, -0, -0]) {
          result[0] = this[12];
          result[1] = this[13];
          result[2] = this[14];
          return result;
        }
        getRotation(result, scaleResult) {
          result = result || [-0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0, -0];
          scaleResult = scaleResult || [-0, -0, -0];
          const scale5 = this.getScale(scaleResult);
          const inverseScale0 = 1 / scale5[0];
          const inverseScale1 = 1 / scale5[1];
          const inverseScale2 = 1 / scale5[2];
          result[0] = this[0] * inverseScale0;
          result[1] = this[1] * inverseScale1;
          result[2] = this[2] * inverseScale2;
          result[3] = 0;
          result[4] = this[4] * inverseScale0;
          result[5] = this[5] * inverseScale1;
          result[6] = this[6] * inverseScale2;
          result[7] = 0;
          result[8] = this[8] * inverseScale0;
          result[9] = this[9] * inverseScale1;
          result[10] = this[10] * inverseScale2;
          result[11] = 0;
          result[12] = 0;
          result[13] = 0;
          result[14] = 0;
          result[15] = 1;
          return result;
        }
        getRotationMatrix3(result, scaleResult) {
          result = result || [-0, -0, -0, -0, -0, -0, -0, -0, -0];
          scaleResult = scaleResult || [-0, -0, -0];
          const scale5 = this.getScale(scaleResult);
          const inverseScale0 = 1 / scale5[0];
          const inverseScale1 = 1 / scale5[1];
          const inverseScale2 = 1 / scale5[2];
          result[0] = this[0] * inverseScale0;
          result[1] = this[1] * inverseScale1;
          result[2] = this[2] * inverseScale2;
          result[3] = this[4] * inverseScale0;
          result[4] = this[5] * inverseScale1;
          result[5] = this[6] * inverseScale2;
          result[6] = this[8] * inverseScale0;
          result[7] = this[9] * inverseScale1;
          result[8] = this[10] * inverseScale2;
          return result;
        }
        transpose() {
          transpose2(this, this);
          return this.check();
        }
        invert() {
          invert2(this, this);
          return this.check();
        }
        multiplyLeft(a2) {
          multiply2(this, a2, this);
          return this.check();
        }
        multiplyRight(a2) {
          multiply2(this, this, a2);
          return this.check();
        }
        rotateX(radians2) {
          rotateX2(this, this, radians2);
          return this.check();
        }
        rotateY(radians2) {
          rotateY2(this, this, radians2);
          return this.check();
        }
        rotateZ(radians2) {
          rotateZ2(this, this, radians2);
          return this.check();
        }
        rotateXYZ(angleXYZ) {
          return this.rotateX(angleXYZ[0]).rotateY(angleXYZ[1]).rotateZ(angleXYZ[2]);
        }
        rotateAxis(radians2, axis) {
          rotate2(this, this, radians2, axis);
          return this.check();
        }
        scale(factor) {
          scale2(this, this, Array.isArray(factor) ? factor : [factor, factor, factor]);
          return this.check();
        }
        translate(vector) {
          translate2(this, this, vector);
          return this.check();
        }
        transform(vector, result) {
          if (vector.length === 4) {
            result = transformMat43(result || [-0, -0, -0, -0], vector, this);
            checkVector(result, 4);
            return result;
          }
          return this.transformAsPoint(vector, result);
        }
        transformAsPoint(vector, result) {
          const {
            length: length4
          } = vector;
          let out;
          switch (length4) {
            case 2:
              out = transformMat4(result || [-0, -0], vector, this);
              break;
            case 3:
              out = transformMat42(result || [-0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformAsVector(vector, result) {
          let out;
          switch (vector.length) {
            case 2:
              out = vec2_transformMat4AsVector(result || [-0, -0], vector, this);
              break;
            case 3:
              out = vec3_transformMat4AsVector(result || [-0, -0, -0], vector, this);
              break;
            default:
              throw new Error("Illegal vector");
          }
          checkVector(out, vector.length);
          return out;
        }
        transformPoint(vector, result) {
          return this.transformAsPoint(vector, result);
        }
        transformVector(vector, result) {
          return this.transformAsPoint(vector, result);
        }
        transformDirection(vector, result) {
          return this.transformAsVector(vector, result);
        }
        makeRotationX(radians2) {
          return this.identity().rotateX(radians2);
        }
        makeTranslation(x, y, z) {
          return this.identity().translate([x, y, z]);
        }
      };
    }
  });

  // ../../node_modules/gl-matrix/esm/quat.js
  function create5() {
    var out = new ARRAY_TYPE(4);
    if (ARRAY_TYPE != Float32Array) {
      out[0] = 0;
      out[1] = 0;
      out[2] = 0;
    }
    out[3] = 1;
    return out;
  }
  function identity2(out) {
    out[0] = 0;
    out[1] = 0;
    out[2] = 0;
    out[3] = 1;
    return out;
  }
  function setAxisAngle(out, axis, rad) {
    rad = rad * 0.5;
    var s2 = Math.sin(rad);
    out[0] = s2 * axis[0];
    out[1] = s2 * axis[1];
    out[2] = s2 * axis[2];
    out[3] = Math.cos(rad);
    return out;
  }
  function multiply3(out, a2, b) {
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bx = b[0], by = b[1], bz = b[2], bw = b[3];
    out[0] = ax * bw + aw * bx + ay * bz - az * by;
    out[1] = ay * bw + aw * by + az * bx - ax * bz;
    out[2] = az * bw + aw * bz + ax * by - ay * bx;
    out[3] = aw * bw - ax * bx - ay * by - az * bz;
    return out;
  }
  function rotateX3(out, a2, rad) {
    rad *= 0.5;
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bx = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw + aw * bx;
    out[1] = ay * bw + az * bx;
    out[2] = az * bw - ay * bx;
    out[3] = aw * bw - ax * bx;
    return out;
  }
  function rotateY3(out, a2, rad) {
    rad *= 0.5;
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var by = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw - az * by;
    out[1] = ay * bw + aw * by;
    out[2] = az * bw + ax * by;
    out[3] = aw * bw - ay * by;
    return out;
  }
  function rotateZ3(out, a2, rad) {
    rad *= 0.5;
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bz = Math.sin(rad), bw = Math.cos(rad);
    out[0] = ax * bw + ay * bz;
    out[1] = ay * bw - ax * bz;
    out[2] = az * bw + aw * bz;
    out[3] = aw * bw - az * bz;
    return out;
  }
  function calculateW(out, a2) {
    var x = a2[0], y = a2[1], z = a2[2];
    out[0] = x;
    out[1] = y;
    out[2] = z;
    out[3] = Math.sqrt(Math.abs(1 - x * x - y * y - z * z));
    return out;
  }
  function slerp(out, a2, b, t2) {
    var ax = a2[0], ay = a2[1], az = a2[2], aw = a2[3];
    var bx = b[0], by = b[1], bz = b[2], bw = b[3];
    var omega, cosom, sinom, scale0, scale1;
    cosom = ax * bx + ay * by + az * bz + aw * bw;
    if (cosom < 0) {
      cosom = -cosom;
      bx = -bx;
      by = -by;
      bz = -bz;
      bw = -bw;
    }
    if (1 - cosom > EPSILON) {
      omega = Math.acos(cosom);
      sinom = Math.sin(omega);
      scale0 = Math.sin((1 - t2) * omega) / sinom;
      scale1 = Math.sin(t2 * omega) / sinom;
    } else {
      scale0 = 1 - t2;
      scale1 = t2;
    }
    out[0] = scale0 * ax + scale1 * bx;
    out[1] = scale0 * ay + scale1 * by;
    out[2] = scale0 * az + scale1 * bz;
    out[3] = scale0 * aw + scale1 * bw;
    return out;
  }
  function invert3(out, a2) {
    var a0 = a2[0], a1 = a2[1], a22 = a2[2], a3 = a2[3];
    var dot4 = a0 * a0 + a1 * a1 + a22 * a22 + a3 * a3;
    var invDot = dot4 ? 1 / dot4 : 0;
    out[0] = -a0 * invDot;
    out[1] = -a1 * invDot;
    out[2] = -a22 * invDot;
    out[3] = a3 * invDot;
    return out;
  }
  function conjugate(out, a2) {
    out[0] = -a2[0];
    out[1] = -a2[1];
    out[2] = -a2[2];
    out[3] = a2[3];
    return out;
  }
  function fromMat3(out, m) {
    var fTrace = m[0] + m[4] + m[8];
    var fRoot;
    if (fTrace > 0) {
      fRoot = Math.sqrt(fTrace + 1);
      out[3] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[0] = (m[5] - m[7]) * fRoot;
      out[1] = (m[6] - m[2]) * fRoot;
      out[2] = (m[1] - m[3]) * fRoot;
    } else {
      var i2 = 0;
      if (m[4] > m[0])
        i2 = 1;
      if (m[8] > m[i2 * 3 + i2])
        i2 = 2;
      var j = (i2 + 1) % 3;
      var k = (i2 + 2) % 3;
      fRoot = Math.sqrt(m[i2 * 3 + i2] - m[j * 3 + j] - m[k * 3 + k] + 1);
      out[i2] = 0.5 * fRoot;
      fRoot = 0.5 / fRoot;
      out[3] = (m[j * 3 + k] - m[k * 3 + j]) * fRoot;
      out[j] = (m[j * 3 + i2] + m[i2 * 3 + j]) * fRoot;
      out[k] = (m[k * 3 + i2] + m[i2 * 3 + k]) * fRoot;
    }
    return out;
  }
  var add2, scale4, dot3, lerp2, length3, squaredLength2, normalize3, rotationTo, sqlerp, setAxes;
  var init_quat = __esm({
    "../../node_modules/gl-matrix/esm/quat.js"() {
      init_common2();
      init_mat3();
      init_vec3();
      init_vec4();
      add2 = add;
      scale4 = scale3;
      dot3 = dot2;
      lerp2 = lerp;
      length3 = length2;
      squaredLength2 = squaredLength;
      normalize3 = normalize2;
      rotationTo = function() {
        var tmpvec3 = create2();
        var xUnitVec3 = fromValues(1, 0, 0);
        var yUnitVec3 = fromValues(0, 1, 0);
        return function(out, a2, b) {
          var dot4 = dot(a2, b);
          if (dot4 < -0.999999) {
            cross(tmpvec3, xUnitVec3, a2);
            if (len(tmpvec3) < 1e-6)
              cross(tmpvec3, yUnitVec3, a2);
            normalize(tmpvec3, tmpvec3);
            setAxisAngle(out, tmpvec3, Math.PI);
            return out;
          } else if (dot4 > 0.999999) {
            out[0] = 0;
            out[1] = 0;
            out[2] = 0;
            out[3] = 1;
            return out;
          } else {
            cross(tmpvec3, a2, b);
            out[0] = tmpvec3[0];
            out[1] = tmpvec3[1];
            out[2] = tmpvec3[2];
            out[3] = 1 + dot4;
            return normalize3(out, out);
          }
        };
      }();
      sqlerp = function() {
        var temp1 = create5();
        var temp2 = create5();
        return function(out, a2, b, c, d, t2) {
          slerp(temp1, a2, d, t2);
          slerp(temp2, b, c, t2);
          slerp(out, temp1, temp2, 2 * t2 * (1 - t2));
          return out;
        };
      }();
      setAxes = function() {
        var matr = create3();
        return function(out, view, right, up) {
          matr[0] = right[0];
          matr[3] = right[1];
          matr[6] = right[2];
          matr[1] = up[0];
          matr[4] = up[1];
          matr[7] = up[2];
          matr[2] = -view[0];
          matr[5] = -view[1];
          matr[8] = -view[2];
          return normalize3(out, fromMat3(out, matr));
        };
      }();
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/classes/quaternion.js
  var IDENTITY_QUATERNION, Quaternion;
  var init_quaternion = __esm({
    "../../node_modules/@math.gl/core/dist/esm/classes/quaternion.js"() {
      init_math_array();
      init_validators();
      init_vector4();
      init_quat();
      init_vec4();
      IDENTITY_QUATERNION = [0, 0, 0, 1];
      Quaternion = class extends MathArray {
        constructor(x = 0, y = 0, z = 0, w = 1) {
          super(-0, -0, -0, -0);
          if (Array.isArray(x) && arguments.length === 1) {
            this.copy(x);
          } else {
            this.set(x, y, z, w);
          }
        }
        copy(array) {
          this[0] = array[0];
          this[1] = array[1];
          this[2] = array[2];
          this[3] = array[3];
          return this.check();
        }
        set(x, y, z, w) {
          this[0] = x;
          this[1] = y;
          this[2] = z;
          this[3] = w;
          return this.check();
        }
        fromObject(object) {
          this[0] = object.x;
          this[1] = object.y;
          this[2] = object.z;
          this[3] = object.w;
          return this.check();
        }
        fromMatrix3(m) {
          fromMat3(this, m);
          return this.check();
        }
        fromAxisRotation(axis, rad) {
          setAxisAngle(this, axis, rad);
          return this.check();
        }
        identity() {
          identity2(this);
          return this.check();
        }
        setAxisAngle(axis, rad) {
          return this.fromAxisRotation(axis, rad);
        }
        get ELEMENTS() {
          return 4;
        }
        get x() {
          return this[0];
        }
        set x(value) {
          this[0] = checkNumber(value);
        }
        get y() {
          return this[1];
        }
        set y(value) {
          this[1] = checkNumber(value);
        }
        get z() {
          return this[2];
        }
        set z(value) {
          this[2] = checkNumber(value);
        }
        get w() {
          return this[3];
        }
        set w(value) {
          this[3] = checkNumber(value);
        }
        len() {
          return length3(this);
        }
        lengthSquared() {
          return squaredLength2(this);
        }
        dot(a2) {
          return dot3(this, a2);
        }
        rotationTo(vectorA, vectorB) {
          rotationTo(this, vectorA, vectorB);
          return this.check();
        }
        add(a2) {
          add2(this, this, a2);
          return this.check();
        }
        calculateW() {
          calculateW(this, this);
          return this.check();
        }
        conjugate() {
          conjugate(this, this);
          return this.check();
        }
        invert() {
          invert3(this, this);
          return this.check();
        }
        lerp(a2, b, t2) {
          if (t2 === void 0) {
            return this.lerp(this, a2, b);
          }
          lerp2(this, a2, b, t2);
          return this.check();
        }
        multiplyRight(a2) {
          multiply3(this, this, a2);
          return this.check();
        }
        multiplyLeft(a2) {
          multiply3(this, a2, this);
          return this.check();
        }
        normalize() {
          const length4 = this.len();
          const l2 = length4 > 0 ? 1 / length4 : 0;
          this[0] = this[0] * l2;
          this[1] = this[1] * l2;
          this[2] = this[2] * l2;
          this[3] = this[3] * l2;
          if (length4 === 0) {
            this[3] = 1;
          }
          return this.check();
        }
        rotateX(rad) {
          rotateX3(this, this, rad);
          return this.check();
        }
        rotateY(rad) {
          rotateY3(this, this, rad);
          return this.check();
        }
        rotateZ(rad) {
          rotateZ3(this, this, rad);
          return this.check();
        }
        scale(b) {
          scale4(this, this, b);
          return this.check();
        }
        slerp(arg0, arg1, arg2) {
          let start;
          let target;
          let ratio;
          switch (arguments.length) {
            case 1:
              ({
                start = IDENTITY_QUATERNION,
                target,
                ratio
              } = arg0);
              break;
            case 2:
              start = this;
              target = arg0;
              ratio = arg1;
              break;
            default:
              start = arg0;
              target = arg1;
              ratio = arg2;
          }
          slerp(this, start, target, ratio);
          return this.check();
        }
        transformVector4(vector, result = new Vector4()) {
          transformQuat2(result, vector, this);
          return checkVector(result, 4);
        }
        lengthSq() {
          return this.lengthSquared();
        }
        setFromAxisAngle(axis, rad) {
          return this.setAxisAngle(axis, rad);
        }
        premultiply(a2) {
          return this.multiplyLeft(a2);
        }
        multiply(a2) {
          return this.multiplyRight(a2);
        }
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/lib/math-utils.js
  var math_utils_default;
  var init_math_utils = __esm({
    "../../node_modules/@math.gl/core/dist/esm/lib/math-utils.js"() {
      math_utils_default = {
        EPSILON1: 0.1,
        EPSILON2: 0.01,
        EPSILON3: 1e-3,
        EPSILON4: 1e-4,
        EPSILON5: 1e-5,
        EPSILON6: 1e-6,
        EPSILON7: 1e-7,
        EPSILON8: 1e-8,
        EPSILON9: 1e-9,
        EPSILON10: 1e-10,
        EPSILON11: 1e-11,
        EPSILON12: 1e-12,
        EPSILON13: 1e-13,
        EPSILON14: 1e-14,
        EPSILON15: 1e-15,
        EPSILON16: 1e-16,
        EPSILON17: 1e-17,
        EPSILON18: 1e-18,
        EPSILON19: 1e-19,
        EPSILON20: 1e-20,
        PI_OVER_TWO: Math.PI / 2,
        PI_OVER_FOUR: Math.PI / 4,
        PI_OVER_SIX: Math.PI / 6,
        TWO_PI: Math.PI * 2
      };
    }
  });

  // ../../node_modules/@math.gl/core/dist/esm/index.js
  var init_esm = __esm({
    "../../node_modules/@math.gl/core/dist/esm/index.js"() {
      init_vector2();
      init_vector3();
      init_matrix3();
      init_matrix4();
      init_quaternion();
      init_math_utils();
      init_assert3();
      init_common();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/constants.js
  var WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z, WGS84_CONSTANTS;
  var init_constants = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/constants.js"() {
      WGS84_RADIUS_X = 6378137;
      WGS84_RADIUS_Y = 6378137;
      WGS84_RADIUS_Z = 6356752314245179e-9;
      WGS84_CONSTANTS = {
        radii: [WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z],
        radiiSquared: [WGS84_RADIUS_X * WGS84_RADIUS_X, WGS84_RADIUS_Y * WGS84_RADIUS_Y, WGS84_RADIUS_Z * WGS84_RADIUS_Z],
        oneOverRadii: [1 / WGS84_RADIUS_X, 1 / WGS84_RADIUS_Y, 1 / WGS84_RADIUS_Z],
        oneOverRadiiSquared: [1 / (WGS84_RADIUS_X * WGS84_RADIUS_X), 1 / (WGS84_RADIUS_Y * WGS84_RADIUS_Y), 1 / (WGS84_RADIUS_Z * WGS84_RADIUS_Z)],
        maximumRadius: Math.max(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z),
        centerToleranceSquared: 0.1
      };
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/type-utils.js
  function identity3(x) {
    return x;
  }
  function fromCartographic(cartographic, result = [], map2 = identity3) {
    if ("longitude" in cartographic) {
      result[0] = map2(cartographic.longitude);
      result[1] = map2(cartographic.latitude);
      result[2] = cartographic.height;
    } else if ("x" in cartographic) {
      result[0] = map2(cartographic.x);
      result[1] = map2(cartographic.y);
      result[2] = cartographic.z;
    } else {
      result[0] = map2(cartographic[0]);
      result[1] = map2(cartographic[1]);
      result[2] = cartographic[2];
    }
    return result;
  }
  function fromCartographicToRadians(cartographic, vector = []) {
    return fromCartographic(cartographic, vector, config._cartographicRadians ? identity3 : toRadians);
  }
  function toCartographic(vector, cartographic, map2 = identity3) {
    if ("longitude" in cartographic) {
      cartographic.longitude = map2(vector[0]);
      cartographic.latitude = map2(vector[1]);
      cartographic.height = vector[2];
    } else if ("x" in cartographic) {
      cartographic.x = map2(vector[0]);
      cartographic.y = map2(vector[1]);
      cartographic.z = vector[2];
    } else {
      cartographic[0] = map2(vector[0]);
      cartographic[1] = map2(vector[1]);
      cartographic[2] = vector[2];
    }
    return cartographic;
  }
  function toCartographicFromRadians(vector, cartographic) {
    return toCartographic(vector, cartographic, config._cartographicRadians ? identity3 : toDegrees);
  }
  var scratchVector;
  var init_type_utils = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/type-utils.js"() {
      init_esm();
      init_constants();
      scratchVector = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/scale-to-geodetic-surface.js
  function scaleToGeodeticSurface(cartesian, ellipsoid, result = []) {
    const {
      oneOverRadii,
      oneOverRadiiSquared,
      centerToleranceSquared
    } = ellipsoid;
    scratchVector2.from(cartesian);
    const positionX = scratchVector2.x;
    const positionY = scratchVector2.y;
    const positionZ = scratchVector2.z;
    const oneOverRadiiX = oneOverRadii.x;
    const oneOverRadiiY = oneOverRadii.y;
    const oneOverRadiiZ = oneOverRadii.z;
    const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
    const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
    const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
    const squaredNorm = x2 + y2 + z2;
    const ratio = Math.sqrt(1 / squaredNorm);
    if (!Number.isFinite(ratio)) {
      return void 0;
    }
    const intersection = scaleToGeodeticSurfaceIntersection;
    intersection.copy(cartesian).scale(ratio);
    if (squaredNorm < centerToleranceSquared) {
      return intersection.to(result);
    }
    const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
    const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
    const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
    const gradient = scaleToGeodeticSurfaceGradient;
    gradient.set(intersection.x * oneOverRadiiSquaredX * 2, intersection.y * oneOverRadiiSquaredY * 2, intersection.z * oneOverRadiiSquaredZ * 2);
    let lambda = (1 - ratio) * scratchVector2.len() / (0.5 * gradient.len());
    let correction = 0;
    let xMultiplier;
    let yMultiplier;
    let zMultiplier;
    let func;
    do {
      lambda -= correction;
      xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
      yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
      zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
      const xMultiplier2 = xMultiplier * xMultiplier;
      const yMultiplier2 = yMultiplier * yMultiplier;
      const zMultiplier2 = zMultiplier * zMultiplier;
      const xMultiplier3 = xMultiplier2 * xMultiplier;
      const yMultiplier3 = yMultiplier2 * yMultiplier;
      const zMultiplier3 = zMultiplier2 * zMultiplier;
      func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
      const denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
      const derivative = -2 * denominator;
      correction = func / derivative;
    } while (Math.abs(func) > math_utils_default.EPSILON12);
    return scratchVector2.scale([xMultiplier, yMultiplier, zMultiplier]).to(result);
  }
  var scratchVector2, scaleToGeodeticSurfaceIntersection, scaleToGeodeticSurfaceGradient;
  var init_scale_to_geodetic_surface = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/scale-to-geodetic-surface.js"() {
      init_esm();
      scratchVector2 = new Vector3();
      scaleToGeodeticSurfaceIntersection = new Vector3();
      scaleToGeodeticSurfaceGradient = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/ellipsoid-transform.js
  function localFrameToFixedFrame(ellipsoid, firstAxis, secondAxis, thirdAxis, cartesianOrigin, result) {
    const thirdAxisInferred = VECTOR_PRODUCT_LOCAL_FRAME[firstAxis] && VECTOR_PRODUCT_LOCAL_FRAME[firstAxis][secondAxis];
    assert4(thirdAxisInferred && (!thirdAxis || thirdAxis === thirdAxisInferred));
    let firstAxisVector;
    let secondAxisVector;
    let thirdAxisVector;
    const origin = scratchOrigin.copy(cartesianOrigin);
    const atPole = equals(origin.x, 0, EPSILON14) && equals(origin.y, 0, EPSILON14);
    if (atPole) {
      const sign = Math.sign(origin.z);
      firstAxisVector = scratchVector1.fromArray(degeneratePositionLocalFrame[firstAxis]);
      if (firstAxis !== "east" && firstAxis !== "west") {
        firstAxisVector.scale(sign);
      }
      secondAxisVector = scratchVector22.fromArray(degeneratePositionLocalFrame[secondAxis]);
      if (secondAxis !== "east" && secondAxis !== "west") {
        secondAxisVector.scale(sign);
      }
      thirdAxisVector = scratchVector3.fromArray(degeneratePositionLocalFrame[thirdAxis]);
      if (thirdAxis !== "east" && thirdAxis !== "west") {
        thirdAxisVector.scale(sign);
      }
    } else {
      const {
        up,
        east,
        north
      } = scratchAxisVectors;
      east.set(-origin.y, origin.x, 0).normalize();
      ellipsoid.geodeticSurfaceNormal(origin, up);
      north.copy(up).cross(east);
      const {
        down,
        west,
        south
      } = scratchAxisVectors;
      down.copy(up).scale(-1);
      west.copy(east).scale(-1);
      south.copy(north).scale(-1);
      firstAxisVector = scratchAxisVectors[firstAxis];
      secondAxisVector = scratchAxisVectors[secondAxis];
      thirdAxisVector = scratchAxisVectors[thirdAxis];
    }
    result[0] = firstAxisVector.x;
    result[1] = firstAxisVector.y;
    result[2] = firstAxisVector.z;
    result[3] = 0;
    result[4] = secondAxisVector.x;
    result[5] = secondAxisVector.y;
    result[6] = secondAxisVector.z;
    result[7] = 0;
    result[8] = thirdAxisVector.x;
    result[9] = thirdAxisVector.y;
    result[10] = thirdAxisVector.z;
    result[11] = 0;
    result[12] = origin.x;
    result[13] = origin.y;
    result[14] = origin.z;
    result[15] = 1;
    return result;
  }
  var EPSILON14, scratchOrigin, VECTOR_PRODUCT_LOCAL_FRAME, degeneratePositionLocalFrame, scratchAxisVectors, scratchVector1, scratchVector22, scratchVector3;
  var init_ellipsoid_transform = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/helpers/ellipsoid-transform.js"() {
      init_esm();
      EPSILON14 = 1e-14;
      scratchOrigin = new Vector3();
      VECTOR_PRODUCT_LOCAL_FRAME = {
        up: {
          south: "east",
          north: "west",
          west: "south",
          east: "north"
        },
        down: {
          south: "west",
          north: "east",
          west: "north",
          east: "south"
        },
        south: {
          up: "west",
          down: "east",
          west: "down",
          east: "up"
        },
        north: {
          up: "east",
          down: "west",
          west: "up",
          east: "down"
        },
        west: {
          up: "north",
          down: "south",
          north: "down",
          south: "up"
        },
        east: {
          up: "south",
          down: "north",
          north: "up",
          south: "down"
        }
      };
      degeneratePositionLocalFrame = {
        north: [-1, 0, 0],
        east: [0, 1, 0],
        up: [0, 0, 1],
        south: [1, 0, 0],
        west: [0, -1, 0],
        down: [0, 0, -1]
      };
      scratchAxisVectors = {
        east: new Vector3(),
        north: new Vector3(),
        up: new Vector3(),
        west: new Vector3(),
        south: new Vector3(),
        down: new Vector3()
      };
      scratchVector1 = new Vector3();
      scratchVector22 = new Vector3();
      scratchVector3 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/ellipsoid.js
  var scratchVector4, scratchNormal, scratchK, scratchPosition, scratchHeight, scratchCartesian, Ellipsoid;
  var init_ellipsoid = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/ellipsoid/ellipsoid.js"() {
      init_defineProperty();
      init_esm();
      init_vec3();
      init_constants();
      init_type_utils();
      init_scale_to_geodetic_surface();
      init_ellipsoid_transform();
      scratchVector4 = new Vector3();
      scratchNormal = new Vector3();
      scratchK = new Vector3();
      scratchPosition = new Vector3();
      scratchHeight = new Vector3();
      scratchCartesian = new Vector3();
      Ellipsoid = class {
        constructor(x = 0, y = 0, z = 0) {
          _defineProperty(this, "radii", void 0);
          _defineProperty(this, "radiiSquared", void 0);
          _defineProperty(this, "radiiToTheFourth", void 0);
          _defineProperty(this, "oneOverRadii", void 0);
          _defineProperty(this, "oneOverRadiiSquared", void 0);
          _defineProperty(this, "minimumRadius", void 0);
          _defineProperty(this, "maximumRadius", void 0);
          _defineProperty(this, "centerToleranceSquared", math_utils_default.EPSILON1);
          _defineProperty(this, "squaredXOverSquaredZ", void 0);
          assert4(x >= 0);
          assert4(y >= 0);
          assert4(z >= 0);
          this.radii = new Vector3(x, y, z);
          this.radiiSquared = new Vector3(x * x, y * y, z * z);
          this.radiiToTheFourth = new Vector3(x * x * x * x, y * y * y * y, z * z * z * z);
          this.oneOverRadii = new Vector3(x === 0 ? 0 : 1 / x, y === 0 ? 0 : 1 / y, z === 0 ? 0 : 1 / z);
          this.oneOverRadiiSquared = new Vector3(x === 0 ? 0 : 1 / (x * x), y === 0 ? 0 : 1 / (y * y), z === 0 ? 0 : 1 / (z * z));
          this.minimumRadius = Math.min(x, y, z);
          this.maximumRadius = Math.max(x, y, z);
          if (this.radiiSquared.z !== 0) {
            this.squaredXOverSquaredZ = this.radiiSquared.x / this.radiiSquared.z;
          }
          Object.freeze(this);
        }
        equals(right) {
          return this === right || Boolean(right && this.radii.equals(right.radii));
        }
        toString() {
          return this.radii.toString();
        }
        cartographicToCartesian(cartographic, result = [0, 0, 0]) {
          const normal = scratchNormal;
          const k = scratchK;
          const [, , height] = cartographic;
          this.geodeticSurfaceNormalCartographic(cartographic, normal);
          k.copy(this.radiiSquared).scale(normal);
          const gamma = Math.sqrt(normal.dot(k));
          k.scale(1 / gamma);
          normal.scale(height);
          k.add(normal);
          return k.to(result);
        }
        cartesianToCartographic(cartesian, result = [0, 0, 0]) {
          scratchCartesian.from(cartesian);
          const point = this.scaleToGeodeticSurface(scratchCartesian, scratchPosition);
          if (!point) {
            return void 0;
          }
          const normal = this.geodeticSurfaceNormal(point, scratchNormal);
          const h = scratchHeight;
          h.copy(scratchCartesian).subtract(point);
          const longitude = Math.atan2(normal.y, normal.x);
          const latitude = Math.asin(normal.z);
          const height = Math.sign(dot(h, scratchCartesian)) * length(h);
          return toCartographicFromRadians([longitude, latitude, height], result);
        }
        eastNorthUpToFixedFrame(origin, result = new Matrix4()) {
          return localFrameToFixedFrame(this, "east", "north", "up", origin, result);
        }
        localFrameToFixedFrame(firstAxis, secondAxis, thirdAxis, origin, result = new Matrix4()) {
          return localFrameToFixedFrame(this, firstAxis, secondAxis, thirdAxis, origin, result);
        }
        geocentricSurfaceNormal(cartesian, result = [0, 0, 0]) {
          return scratchVector4.from(cartesian).normalize().to(result);
        }
        geodeticSurfaceNormalCartographic(cartographic, result = [0, 0, 0]) {
          const cartographicVectorRadians = fromCartographicToRadians(cartographic);
          const longitude = cartographicVectorRadians[0];
          const latitude = cartographicVectorRadians[1];
          const cosLatitude = Math.cos(latitude);
          scratchVector4.set(cosLatitude * Math.cos(longitude), cosLatitude * Math.sin(longitude), Math.sin(latitude)).normalize();
          return scratchVector4.to(result);
        }
        geodeticSurfaceNormal(cartesian, result = [0, 0, 0]) {
          return scratchVector4.from(cartesian).scale(this.oneOverRadiiSquared).normalize().to(result);
        }
        scaleToGeodeticSurface(cartesian, result) {
          return scaleToGeodeticSurface(cartesian, this, result);
        }
        scaleToGeocentricSurface(cartesian, result = [0, 0, 0]) {
          scratchPosition.from(cartesian);
          const positionX = scratchPosition.x;
          const positionY = scratchPosition.y;
          const positionZ = scratchPosition.z;
          const oneOverRadiiSquared = this.oneOverRadiiSquared;
          const beta = 1 / Math.sqrt(positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z);
          return scratchPosition.multiplyScalar(beta).to(result);
        }
        transformPositionToScaledSpace(position, result = [0, 0, 0]) {
          return scratchPosition.from(position).scale(this.oneOverRadii).to(result);
        }
        transformPositionFromScaledSpace(position, result = [0, 0, 0]) {
          return scratchPosition.from(position).scale(this.radii).to(result);
        }
        getSurfaceNormalIntersectionWithZAxis(position, buffer = 0, result = [0, 0, 0]) {
          assert4(equals(this.radii.x, this.radii.y, math_utils_default.EPSILON15));
          assert4(this.radii.z > 0);
          scratchPosition.from(position);
          const z = scratchPosition.z * (1 - this.squaredXOverSquaredZ);
          if (Math.abs(z) >= this.radii.z - buffer) {
            return void 0;
          }
          return scratchPosition.set(0, 0, z).to(result);
        }
      };
      _defineProperty(Ellipsoid, "WGS84", new Ellipsoid(WGS84_RADIUS_X, WGS84_RADIUS_Y, WGS84_RADIUS_Z));
    }
  });

  // ../../node_modules/@math.gl/geospatial/dist/esm/index.js
  var init_esm2 = __esm({
    "../../node_modules/@math.gl/geospatial/dist/esm/index.js"() {
      init_ellipsoid();
      init_type_utils();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/constants.js
  var INTERSECTION;
  var init_constants2 = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/constants.js"() {
      INTERSECTION = {
        OUTSIDE: -1,
        INTERSECTING: 0,
        INSIDE: 1
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/axis-aligned-bounding-box.js
  var scratchVector5, scratchNormal2;
  var init_axis_aligned_bounding_box = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/axis-aligned-bounding-box.js"() {
      init_defineProperty();
      init_esm();
      init_constants2();
      scratchVector5 = new Vector3();
      scratchNormal2 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/bounding-sphere.js
  var scratchVector6, scratchVector23, BoundingSphere;
  var init_bounding_sphere = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/bounding-sphere.js"() {
      init_defineProperty();
      init_esm();
      init_mat4();
      init_constants2();
      scratchVector6 = new Vector3();
      scratchVector23 = new Vector3();
      BoundingSphere = class {
        constructor(center = [0, 0, 0], radius = 0) {
          _defineProperty(this, "center", void 0);
          _defineProperty(this, "radius", void 0);
          this.radius = -0;
          this.center = new Vector3();
          this.fromCenterRadius(center, radius);
        }
        fromCenterRadius(center, radius) {
          this.center.from(center);
          this.radius = radius;
          return this;
        }
        fromCornerPoints(corner, oppositeCorner) {
          oppositeCorner = scratchVector6.from(oppositeCorner);
          this.center = new Vector3().from(corner).add(oppositeCorner).scale(0.5);
          this.radius = this.center.distance(oppositeCorner);
          return this;
        }
        equals(right) {
          return this === right || Boolean(right) && this.center.equals(right.center) && this.radius === right.radius;
        }
        clone() {
          return new BoundingSphere(this.center, this.radius);
        }
        union(boundingSphere) {
          const leftCenter = this.center;
          const leftRadius = this.radius;
          const rightCenter = boundingSphere.center;
          const rightRadius = boundingSphere.radius;
          const toRightCenter = scratchVector6.copy(rightCenter).subtract(leftCenter);
          const centerSeparation = toRightCenter.magnitude();
          if (leftRadius >= centerSeparation + rightRadius) {
            return this.clone();
          }
          if (rightRadius >= centerSeparation + leftRadius) {
            return boundingSphere.clone();
          }
          const halfDistanceBetweenTangentPoints = (leftRadius + centerSeparation + rightRadius) * 0.5;
          scratchVector23.copy(toRightCenter).scale((-leftRadius + halfDistanceBetweenTangentPoints) / centerSeparation).add(leftCenter);
          this.center.copy(scratchVector23);
          this.radius = halfDistanceBetweenTangentPoints;
          return this;
        }
        expand(point) {
          const scratchPoint = scratchVector6.from(point);
          const radius = scratchPoint.subtract(this.center).magnitude();
          if (radius > this.radius) {
            this.radius = radius;
          }
          return this;
        }
        transform(transform) {
          this.center.transform(transform);
          const scale5 = getScaling(scratchVector6, transform);
          this.radius = Math.max(scale5[0], Math.max(scale5[1], scale5[2])) * this.radius;
          return this;
        }
        distanceSquaredTo(point) {
          const d = this.distanceTo(point);
          return d * d;
        }
        distanceTo(point) {
          const scratchPoint = scratchVector6.from(point);
          const delta = scratchPoint.subtract(this.center);
          return Math.max(0, delta.len() - this.radius);
        }
        intersectPlane(plane) {
          const center = this.center;
          const radius = this.radius;
          const normal = plane.normal;
          const distanceToPlane = normal.dot(center) + plane.distance;
          if (distanceToPlane < -radius) {
            return INTERSECTION.OUTSIDE;
          }
          if (distanceToPlane < radius) {
            return INTERSECTION.INTERSECTING;
          }
          return INTERSECTION.INSIDE;
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/oriented-bounding-box.js
  var scratchVector32, scratchOffset, scratchVectorU, scratchVectorV, scratchVectorW, scratchCorner, scratchToCenter, MATRIX3, OrientedBoundingBox;
  var init_oriented_bounding_box = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/bounding-volumes/oriented-bounding-box.js"() {
      init_defineProperty();
      init_esm();
      init_bounding_sphere();
      init_constants2();
      scratchVector32 = new Vector3();
      scratchOffset = new Vector3();
      scratchVectorU = new Vector3();
      scratchVectorV = new Vector3();
      scratchVectorW = new Vector3();
      scratchCorner = new Vector3();
      scratchToCenter = new Vector3();
      MATRIX3 = {
        COLUMN0ROW0: 0,
        COLUMN0ROW1: 1,
        COLUMN0ROW2: 2,
        COLUMN1ROW0: 3,
        COLUMN1ROW1: 4,
        COLUMN1ROW2: 5,
        COLUMN2ROW0: 6,
        COLUMN2ROW1: 7,
        COLUMN2ROW2: 8
      };
      OrientedBoundingBox = class {
        constructor(center = [0, 0, 0], halfAxes = [0, 0, 0, 0, 0, 0, 0, 0, 0]) {
          _defineProperty(this, "center", void 0);
          _defineProperty(this, "halfAxes", void 0);
          this.center = new Vector3().from(center);
          this.halfAxes = new Matrix3(halfAxes);
        }
        get halfSize() {
          const xAxis = this.halfAxes.getColumn(0);
          const yAxis = this.halfAxes.getColumn(1);
          const zAxis = this.halfAxes.getColumn(2);
          return [new Vector3(xAxis).len(), new Vector3(yAxis).len(), new Vector3(zAxis).len()];
        }
        get quaternion() {
          const xAxis = this.halfAxes.getColumn(0);
          const yAxis = this.halfAxes.getColumn(1);
          const zAxis = this.halfAxes.getColumn(2);
          const normXAxis = new Vector3(xAxis).normalize();
          const normYAxis = new Vector3(yAxis).normalize();
          const normZAxis = new Vector3(zAxis).normalize();
          return new Quaternion().fromMatrix3(new Matrix3([...normXAxis, ...normYAxis, ...normZAxis]));
        }
        fromCenterHalfSizeQuaternion(center, halfSize, quaternion) {
          const quaternionObject = new Quaternion(quaternion);
          const directionsMatrix = new Matrix3().fromQuaternion(quaternionObject);
          directionsMatrix[0] = directionsMatrix[0] * halfSize[0];
          directionsMatrix[1] = directionsMatrix[1] * halfSize[0];
          directionsMatrix[2] = directionsMatrix[2] * halfSize[0];
          directionsMatrix[3] = directionsMatrix[3] * halfSize[1];
          directionsMatrix[4] = directionsMatrix[4] * halfSize[1];
          directionsMatrix[5] = directionsMatrix[5] * halfSize[1];
          directionsMatrix[6] = directionsMatrix[6] * halfSize[2];
          directionsMatrix[7] = directionsMatrix[7] * halfSize[2];
          directionsMatrix[8] = directionsMatrix[8] * halfSize[2];
          this.center = new Vector3().from(center);
          this.halfAxes = directionsMatrix;
          return this;
        }
        clone() {
          return new OrientedBoundingBox(this.center, this.halfAxes);
        }
        equals(right) {
          return this === right || Boolean(right) && this.center.equals(right.center) && this.halfAxes.equals(right.halfAxes);
        }
        getBoundingSphere(result = new BoundingSphere()) {
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const cornerVector = scratchVector32.copy(u).add(v).add(w);
          result.center.copy(this.center);
          result.radius = cornerVector.magnitude();
          return result;
        }
        intersectPlane(plane) {
          const center = this.center;
          const normal = plane.normal;
          const halfAxes = this.halfAxes;
          const normalX = normal.x;
          const normalY = normal.y;
          const normalZ = normal.z;
          const radEffective = Math.abs(normalX * halfAxes[MATRIX3.COLUMN0ROW0] + normalY * halfAxes[MATRIX3.COLUMN0ROW1] + normalZ * halfAxes[MATRIX3.COLUMN0ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN1ROW0] + normalY * halfAxes[MATRIX3.COLUMN1ROW1] + normalZ * halfAxes[MATRIX3.COLUMN1ROW2]) + Math.abs(normalX * halfAxes[MATRIX3.COLUMN2ROW0] + normalY * halfAxes[MATRIX3.COLUMN2ROW1] + normalZ * halfAxes[MATRIX3.COLUMN2ROW2]);
          const distanceToPlane = normal.dot(center) + plane.distance;
          if (distanceToPlane <= -radEffective) {
            return INTERSECTION.OUTSIDE;
          } else if (distanceToPlane >= radEffective) {
            return INTERSECTION.INSIDE;
          }
          return INTERSECTION.INTERSECTING;
        }
        distanceTo(point) {
          return Math.sqrt(this.distanceSquaredTo(point));
        }
        distanceSquaredTo(point) {
          const offset = scratchOffset.from(point).subtract(this.center);
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const uHalf = u.magnitude();
          const vHalf = v.magnitude();
          const wHalf = w.magnitude();
          u.normalize();
          v.normalize();
          w.normalize();
          let distanceSquared = 0;
          let d;
          d = Math.abs(offset.dot(u)) - uHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          d = Math.abs(offset.dot(v)) - vHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          d = Math.abs(offset.dot(w)) - wHalf;
          if (d > 0) {
            distanceSquared += d * d;
          }
          return distanceSquared;
        }
        computePlaneDistances(position, direction, result = [-0, -0]) {
          let minDist = Number.POSITIVE_INFINITY;
          let maxDist = Number.NEGATIVE_INFINITY;
          const center = this.center;
          const halfAxes = this.halfAxes;
          const u = halfAxes.getColumn(0, scratchVectorU);
          const v = halfAxes.getColumn(1, scratchVectorV);
          const w = halfAxes.getColumn(2, scratchVectorW);
          const corner = scratchCorner.copy(u).add(v).add(w).add(center);
          const toCenter = scratchToCenter.copy(corner).subtract(position);
          let mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).add(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).subtract(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          corner.copy(center).add(u).subtract(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).add(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).add(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).subtract(v).add(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          center.copy(corner).subtract(u).subtract(v).subtract(w);
          toCenter.copy(corner).subtract(position);
          mag = direction.dot(toCenter);
          minDist = Math.min(mag, minDist);
          maxDist = Math.max(mag, maxDist);
          result[0] = minDist;
          result[1] = maxDist;
          return result;
        }
        transform(transformation) {
          this.center.transformAsPoint(transformation);
          const xAxis = this.halfAxes.getColumn(0, scratchVectorU);
          xAxis.transformAsPoint(transformation);
          const yAxis = this.halfAxes.getColumn(1, scratchVectorV);
          yAxis.transformAsPoint(transformation);
          const zAxis = this.halfAxes.getColumn(2, scratchVectorW);
          zAxis.transformAsPoint(transformation);
          this.halfAxes = new Matrix3([...xAxis, ...yAxis, ...zAxis]);
          return this;
        }
        getTransform() {
          throw new Error("not implemented");
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/plane.js
  var scratchPosition2, scratchNormal3, Plane;
  var init_plane = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/plane.js"() {
      init_defineProperty();
      init_esm();
      scratchPosition2 = new Vector3();
      scratchNormal3 = new Vector3();
      Plane = class {
        constructor(normal = [0, 0, 1], distance = 0) {
          _defineProperty(this, "normal", void 0);
          _defineProperty(this, "distance", void 0);
          this.normal = new Vector3();
          this.distance = -0;
          this.fromNormalDistance(normal, distance);
        }
        fromNormalDistance(normal, distance) {
          assert4(Number.isFinite(distance));
          this.normal.from(normal).normalize();
          this.distance = distance;
          return this;
        }
        fromPointNormal(point, normal) {
          point = scratchPosition2.from(point);
          this.normal.from(normal).normalize();
          const distance = -this.normal.dot(point);
          this.distance = distance;
          return this;
        }
        fromCoefficients(a2, b, c, d) {
          this.normal.set(a2, b, c);
          assert4(equals(this.normal.len(), 1));
          this.distance = d;
          return this;
        }
        clone() {
          return new Plane(this.normal, this.distance);
        }
        equals(right) {
          return equals(this.distance, right.distance) && equals(this.normal, right.normal);
        }
        getPointDistance(point) {
          return this.normal.dot(point) + this.distance;
        }
        transform(matrix4) {
          const normal = scratchNormal3.copy(this.normal).transformAsVector(matrix4).normalize();
          const point = this.normal.scale(-this.distance).transform(matrix4);
          return this.fromPointNormal(point, normal);
        }
        projectPointOntoPlane(point, result = [0, 0, 0]) {
          point = scratchPosition2.from(point);
          const pointDistance = this.getPointDistance(point);
          const scaledNormal = scratchNormal3.copy(this.normal).scale(pointDistance);
          return point.subtract(scaledNormal).to(result);
        }
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/culling-volume.js
  var faces, scratchPlaneCenter, scratchPlaneNormal, scratchPlane, CullingVolume;
  var init_culling_volume = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/culling-volume.js"() {
      init_defineProperty();
      init_esm();
      init_constants2();
      init_plane();
      faces = [new Vector3([1, 0, 0]), new Vector3([0, 1, 0]), new Vector3([0, 0, 1])];
      scratchPlaneCenter = new Vector3();
      scratchPlaneNormal = new Vector3();
      scratchPlane = new Plane(new Vector3(1, 0, 0), 0);
      CullingVolume = class {
        constructor(planes = []) {
          _defineProperty(this, "planes", void 0);
          this.planes = planes;
        }
        fromBoundingSphere(boundingSphere) {
          this.planes.length = 2 * faces.length;
          const center = boundingSphere.center;
          const radius = boundingSphere.radius;
          let planeIndex = 0;
          for (const faceNormal of faces) {
            let plane0 = this.planes[planeIndex];
            let plane1 = this.planes[planeIndex + 1];
            if (!plane0) {
              plane0 = this.planes[planeIndex] = new Plane();
            }
            if (!plane1) {
              plane1 = this.planes[planeIndex + 1] = new Plane();
            }
            const plane0Center = scratchPlaneCenter.copy(faceNormal).scale(-radius).add(center);
            const plane0Distance = -faceNormal.dot(plane0Center);
            plane0.fromPointNormal(plane0Center, faceNormal);
            const plane1Center = scratchPlaneCenter.copy(faceNormal).scale(radius).add(center);
            const negatedFaceNormal = scratchPlaneNormal.copy(faceNormal).negate();
            const plane1Distance = -negatedFaceNormal.dot(plane1Center);
            plane1.fromPointNormal(plane1Center, negatedFaceNormal);
            planeIndex += 2;
          }
          return this;
        }
        computeVisibility(boundingVolume) {
          let intersect = INTERSECTION.INSIDE;
          for (const plane of this.planes) {
            const result = boundingVolume.intersectPlane(plane);
            switch (result) {
              case INTERSECTION.OUTSIDE:
                return INTERSECTION.OUTSIDE;
              case INTERSECTION.INTERSECTING:
                intersect = INTERSECTION.INTERSECTING;
                break;
              default:
            }
          }
          return intersect;
        }
        computeVisibilityWithPlaneMask(boundingVolume, parentPlaneMask) {
          assert4(Number.isFinite(parentPlaneMask), "parentPlaneMask is required.");
          if (parentPlaneMask === CullingVolume.MASK_OUTSIDE || parentPlaneMask === CullingVolume.MASK_INSIDE) {
            return parentPlaneMask;
          }
          let mask = CullingVolume.MASK_INSIDE;
          const planes = this.planes;
          for (let k = 0; k < this.planes.length; ++k) {
            const flag = k < 31 ? 1 << k : 0;
            if (k < 31 && (parentPlaneMask & flag) === 0) {
              continue;
            }
            const plane = planes[k];
            const result = boundingVolume.intersectPlane(plane);
            if (result === INTERSECTION.OUTSIDE) {
              return CullingVolume.MASK_OUTSIDE;
            } else if (result === INTERSECTION.INTERSECTING) {
              mask |= flag;
            }
          }
          return mask;
        }
      };
      _defineProperty(CullingVolume, "MASK_OUTSIDE", 4294967295);
      _defineProperty(CullingVolume, "MASK_INSIDE", 0);
      _defineProperty(CullingVolume, "MASK_INDETERMINATE", 2147483647);
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/perspective-off-center-frustum.js
  var scratchPlaneUpVector, scratchPlaneRightVector, scratchPlaneNearCenter, scratchPlaneFarCenter, scratchPlaneNormal2;
  var init_perspective_off_center_frustum = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/perspective-off-center-frustum.js"() {
      init_defineProperty();
      init_esm();
      init_culling_volume();
      init_plane();
      scratchPlaneUpVector = new Vector3();
      scratchPlaneRightVector = new Vector3();
      scratchPlaneNearCenter = new Vector3();
      scratchPlaneFarCenter = new Vector3();
      scratchPlaneNormal2 = new Vector3();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/perspective-frustum.js
  var init_perspective_frustum = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/perspective-frustum.js"() {
      init_defineProperty();
      init_perspective_off_center_frustum();
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-sphere-from-points.js
  var fromPointsXMin, fromPointsYMin, fromPointsZMin, fromPointsXMax, fromPointsYMax, fromPointsZMax, fromPointsCurrentPos, fromPointsScratch, fromPointsRitterCenter, fromPointsMinBoxPt, fromPointsMaxBoxPt, fromPointsNaiveCenterScratch, volumeConstant;
  var init_bounding_sphere_from_points = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-sphere-from-points.js"() {
      init_esm();
      init_bounding_sphere();
      fromPointsXMin = new Vector3();
      fromPointsYMin = new Vector3();
      fromPointsZMin = new Vector3();
      fromPointsXMax = new Vector3();
      fromPointsYMax = new Vector3();
      fromPointsZMax = new Vector3();
      fromPointsCurrentPos = new Vector3();
      fromPointsScratch = new Vector3();
      fromPointsRitterCenter = new Vector3();
      fromPointsMinBoxPt = new Vector3();
      fromPointsMaxBoxPt = new Vector3();
      fromPointsNaiveCenterScratch = new Vector3();
      volumeConstant = 4 / 3 * Math.PI;
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/compute-eigen-decomposition.js
  function computeEigenDecomposition(matrix, result = {}) {
    const EIGEN_TOLERANCE = math_utils_default.EPSILON20;
    const EIGEN_MAX_SWEEPS = 10;
    let count = 0;
    let sweep = 0;
    const unitaryMatrix = scratchUnitary;
    const diagonalMatrix = scratchDiagonal;
    unitaryMatrix.identity();
    diagonalMatrix.copy(matrix);
    const epsilon = EIGEN_TOLERANCE * computeFrobeniusNorm(diagonalMatrix);
    while (sweep < EIGEN_MAX_SWEEPS && offDiagonalFrobeniusNorm(diagonalMatrix) > epsilon) {
      shurDecomposition(diagonalMatrix, jMatrix);
      jMatrixTranspose.copy(jMatrix).transpose();
      diagonalMatrix.multiplyRight(jMatrix);
      diagonalMatrix.multiplyLeft(jMatrixTranspose);
      unitaryMatrix.multiplyRight(jMatrix);
      if (++count > 2) {
        ++sweep;
        count = 0;
      }
    }
    result.unitary = unitaryMatrix.toTarget(result.unitary);
    result.diagonal = diagonalMatrix.toTarget(result.diagonal);
    return result;
  }
  function computeFrobeniusNorm(matrix) {
    let norm = 0;
    for (let i2 = 0; i2 < 9; ++i2) {
      const temp = matrix[i2];
      norm += temp * temp;
    }
    return Math.sqrt(norm);
  }
  function offDiagonalFrobeniusNorm(matrix) {
    let norm = 0;
    for (let i2 = 0; i2 < 3; ++i2) {
      const temp = matrix[scratchMatrix.getElementIndex(colVal[i2], rowVal[i2])];
      norm += 2 * temp * temp;
    }
    return Math.sqrt(norm);
  }
  function shurDecomposition(matrix, result) {
    const tolerance = math_utils_default.EPSILON15;
    let maxDiagonal = 0;
    let rotAxis = 1;
    for (let i2 = 0; i2 < 3; ++i2) {
      const temp = Math.abs(matrix[scratchMatrix.getElementIndex(colVal[i2], rowVal[i2])]);
      if (temp > maxDiagonal) {
        rotAxis = i2;
        maxDiagonal = temp;
      }
    }
    const p2 = rowVal[rotAxis];
    const q = colVal[rotAxis];
    let c = 1;
    let s2 = 0;
    if (Math.abs(matrix[scratchMatrix.getElementIndex(q, p2)]) > tolerance) {
      const qq = matrix[scratchMatrix.getElementIndex(q, q)];
      const pp = matrix[scratchMatrix.getElementIndex(p2, p2)];
      const qp = matrix[scratchMatrix.getElementIndex(q, p2)];
      const tau = (qq - pp) / 2 / qp;
      let t2;
      if (tau < 0) {
        t2 = -1 / (-tau + Math.sqrt(1 + tau * tau));
      } else {
        t2 = 1 / (tau + Math.sqrt(1 + tau * tau));
      }
      c = 1 / Math.sqrt(1 + t2 * t2);
      s2 = t2 * c;
    }
    Matrix3.IDENTITY.to(result);
    result[scratchMatrix.getElementIndex(p2, p2)] = result[scratchMatrix.getElementIndex(q, q)] = c;
    result[scratchMatrix.getElementIndex(q, p2)] = s2;
    result[scratchMatrix.getElementIndex(p2, q)] = -s2;
    return result;
  }
  var scratchMatrix, scratchUnitary, scratchDiagonal, jMatrix, jMatrixTranspose, rowVal, colVal;
  var init_compute_eigen_decomposition = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/compute-eigen-decomposition.js"() {
      init_esm();
      scratchMatrix = new Matrix3();
      scratchUnitary = new Matrix3();
      scratchDiagonal = new Matrix3();
      jMatrix = new Matrix3();
      jMatrixTranspose = new Matrix3();
      rowVal = [1, 0, 0];
      colVal = [2, 2, 1];
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-box-from-points.js
  function makeOrientedBoundingBoxFromPoints(positions, result = new OrientedBoundingBox()) {
    if (!positions || positions.length === 0) {
      result.halfAxes = new Matrix3([0, 0, 0, 0, 0, 0, 0, 0, 0]);
      result.center = new Vector3();
      return result;
    }
    const length4 = positions.length;
    const meanPoint = new Vector3(0, 0, 0);
    for (const position of positions) {
      meanPoint.add(position);
    }
    const invLength = 1 / length4;
    meanPoint.multiplyByScalar(invLength);
    let exx = 0;
    let exy = 0;
    let exz = 0;
    let eyy = 0;
    let eyz = 0;
    let ezz = 0;
    for (const position of positions) {
      const p2 = scratchVector24.copy(position).subtract(meanPoint);
      exx += p2.x * p2.x;
      exy += p2.x * p2.y;
      exz += p2.x * p2.z;
      eyy += p2.y * p2.y;
      eyz += p2.y * p2.z;
      ezz += p2.z * p2.z;
    }
    exx *= invLength;
    exy *= invLength;
    exz *= invLength;
    eyy *= invLength;
    eyz *= invLength;
    ezz *= invLength;
    const covarianceMatrix = scratchCovarianceResult;
    covarianceMatrix[0] = exx;
    covarianceMatrix[1] = exy;
    covarianceMatrix[2] = exz;
    covarianceMatrix[3] = exy;
    covarianceMatrix[4] = eyy;
    covarianceMatrix[5] = eyz;
    covarianceMatrix[6] = exz;
    covarianceMatrix[7] = eyz;
    covarianceMatrix[8] = ezz;
    const {
      unitary
    } = computeEigenDecomposition(covarianceMatrix, scratchEigenResult);
    const rotation = result.halfAxes.copy(unitary);
    let v1 = rotation.getColumn(0, scratchVector42);
    let v2 = rotation.getColumn(1, scratchVector52);
    let v3 = rotation.getColumn(2, scratchVector62);
    let u1 = -Number.MAX_VALUE;
    let u2 = -Number.MAX_VALUE;
    let u3 = -Number.MAX_VALUE;
    let l1 = Number.MAX_VALUE;
    let l2 = Number.MAX_VALUE;
    let l3 = Number.MAX_VALUE;
    for (const position of positions) {
      scratchVector24.copy(position);
      u1 = Math.max(scratchVector24.dot(v1), u1);
      u2 = Math.max(scratchVector24.dot(v2), u2);
      u3 = Math.max(scratchVector24.dot(v3), u3);
      l1 = Math.min(scratchVector24.dot(v1), l1);
      l2 = Math.min(scratchVector24.dot(v2), l2);
      l3 = Math.min(scratchVector24.dot(v3), l3);
    }
    v1 = v1.multiplyByScalar(0.5 * (l1 + u1));
    v2 = v2.multiplyByScalar(0.5 * (l2 + u2));
    v3 = v3.multiplyByScalar(0.5 * (l3 + u3));
    result.center.copy(v1).add(v2).add(v3);
    const scale5 = scratchVector33.set(u1 - l1, u2 - l2, u3 - l3).multiplyByScalar(0.5);
    const scaleMatrix = new Matrix3([scale5[0], 0, 0, 0, scale5[1], 0, 0, 0, scale5[2]]);
    result.halfAxes.multiplyRight(scaleMatrix);
    return result;
  }
  var scratchVector24, scratchVector33, scratchVector42, scratchVector52, scratchVector62, scratchCovarianceResult, scratchEigenResult;
  var init_bounding_box_from_points = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/lib/algorithms/bounding-box-from-points.js"() {
      init_esm();
      init_compute_eigen_decomposition();
      init_oriented_bounding_box();
      init_axis_aligned_bounding_box();
      scratchVector24 = new Vector3();
      scratchVector33 = new Vector3();
      scratchVector42 = new Vector3();
      scratchVector52 = new Vector3();
      scratchVector62 = new Vector3();
      scratchCovarianceResult = new Matrix3();
      scratchEigenResult = {
        diagonal: new Matrix3(),
        unitary: new Matrix3()
      };
    }
  });

  // ../../node_modules/@math.gl/culling/dist/esm/index.js
  var init_esm3 = __esm({
    "../../node_modules/@math.gl/culling/dist/esm/index.js"() {
      init_constants2();
      init_axis_aligned_bounding_box();
      init_bounding_sphere();
      init_oriented_bounding_box();
      init_culling_volume();
      init_plane();
      init_perspective_off_center_frustum();
      init_perspective_frustum();
      init_bounding_sphere_from_points();
      init_bounding_box_from_points();
      init_compute_eigen_decomposition();
    }
  });

  // ../core/src/javascript-utils/is-type.ts
  var isBoolean, isFunction, isObject, isPureObject, isIterable, isAsyncIterable, isResponse, isBlob, isBuffer2, isReadableDOMStream, isReadableNodeStream, isReadableStream;
  var init_is_type = __esm({
    "../core/src/javascript-utils/is-type.ts"() {
      isBoolean = (x) => typeof x === "boolean";
      isFunction = (x) => typeof x === "function";
      isObject = (x) => x !== null && typeof x === "object";
      isPureObject = (x) => isObject(x) && x.constructor === {}.constructor;
      isIterable = (x) => x && typeof x[Symbol.iterator] === "function";
      isAsyncIterable = (x) => x && typeof x[Symbol.asyncIterator] === "function";
      isResponse = (x) => typeof Response !== "undefined" && x instanceof Response || x && x.arrayBuffer && x.text && x.json;
      isBlob = (x) => typeof Blob !== "undefined" && x instanceof Blob;
      isBuffer2 = (x) => x && typeof x === "object" && x.isBuffer;
      isReadableDOMStream = (x) => typeof ReadableStream !== "undefined" && x instanceof ReadableStream || isObject(x) && isFunction(x.tee) && isFunction(x.cancel) && isFunction(x.getReader);
      isReadableNodeStream = (x) => isObject(x) && isFunction(x.read) && isFunction(x.pipe) && isBoolean(x.readable);
      isReadableStream = (x) => isReadableDOMStream(x) || isReadableNodeStream(x);
    }
  });

  // ../core/src/lib/utils/mime-type-utils.ts
  function parseMIMEType(mimeString) {
    const matches3 = MIME_TYPE_PATTERN.exec(mimeString);
    if (matches3) {
      return matches3[1];
    }
    return mimeString;
  }
  function parseMIMETypeFromURL(url) {
    const matches3 = DATA_URL_PATTERN.exec(url);
    if (matches3) {
      return matches3[1];
    }
    return "";
  }
  var DATA_URL_PATTERN, MIME_TYPE_PATTERN;
  var init_mime_type_utils = __esm({
    "../core/src/lib/utils/mime-type-utils.ts"() {
      DATA_URL_PATTERN = /^data:([-\w.]+\/[-\w.+]+)(;|,)/;
      MIME_TYPE_PATTERN = /^([-\w.]+\/[-\w.+]+)/;
    }
  });

  // ../core/src/lib/utils/url-utils.ts
  function extractQueryString(url) {
    const matches3 = url.match(QUERY_STRING_PATTERN);
    return matches3 && matches3[0];
  }
  function stripQueryString(url) {
    return url.replace(QUERY_STRING_PATTERN, "");
  }
  var QUERY_STRING_PATTERN;
  var init_url_utils = __esm({
    "../core/src/lib/utils/url-utils.ts"() {
      QUERY_STRING_PATTERN = /\?.*/;
    }
  });

  // ../core/src/lib/utils/resource-utils.ts
  function getResourceUrl(resource) {
    if (isResponse(resource)) {
      const response = resource;
      return response.url;
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.name || "";
    }
    if (typeof resource === "string") {
      return resource;
    }
    return "";
  }
  function getResourceMIMEType(resource) {
    if (isResponse(resource)) {
      const response = resource;
      const contentTypeHeader = response.headers.get("content-type") || "";
      const noQueryUrl = stripQueryString(response.url);
      return parseMIMEType(contentTypeHeader) || parseMIMETypeFromURL(noQueryUrl);
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.type || "";
    }
    if (typeof resource === "string") {
      return parseMIMETypeFromURL(resource);
    }
    return "";
  }
  function getResourceContentLength(resource) {
    if (isResponse(resource)) {
      const response = resource;
      return response.headers["content-length"] || -1;
    }
    if (isBlob(resource)) {
      const blob = resource;
      return blob.size;
    }
    if (typeof resource === "string") {
      return resource.length;
    }
    if (resource instanceof ArrayBuffer) {
      return resource.byteLength;
    }
    if (ArrayBuffer.isView(resource)) {
      return resource.byteLength;
    }
    return -1;
  }
  var init_resource_utils = __esm({
    "../core/src/lib/utils/resource-utils.ts"() {
      init_is_type();
      init_mime_type_utils();
      init_url_utils();
    }
  });

  // ../core/src/lib/utils/response-utils.ts
  async function makeResponse(resource) {
    if (isResponse(resource)) {
      return resource;
    }
    const headers = {};
    const contentLength = getResourceContentLength(resource);
    if (contentLength >= 0) {
      headers["content-length"] = String(contentLength);
    }
    const url = getResourceUrl(resource);
    const type = getResourceMIMEType(resource);
    if (type) {
      headers["content-type"] = type;
    }
    const initialDataUrl = await getInitialDataUrl(resource);
    if (initialDataUrl) {
      headers["x-first-bytes"] = initialDataUrl;
    }
    if (typeof resource === "string") {
      resource = new TextEncoder().encode(resource);
    }
    const response = new Response(resource, { headers });
    Object.defineProperty(response, "url", { value: url });
    return response;
  }
  async function checkResponse(response) {
    if (!response.ok) {
      const message = await getResponseError(response);
      throw new Error(message);
    }
  }
  async function getResponseError(response) {
    let message = `Failed to fetch resource ${response.url} (${response.status}): `;
    try {
      const contentType = response.headers.get("Content-Type");
      let text = response.statusText;
      if (contentType.includes("application/json")) {
        text += ` ${await response.text()}`;
      }
      message += text;
      message = message.length > 60 ? `${message.slice(0, 60)}...` : message;
    } catch (error) {
    }
    return message;
  }
  async function getInitialDataUrl(resource) {
    const INITIAL_DATA_LENGTH = 5;
    if (typeof resource === "string") {
      return `data:,${resource.slice(0, INITIAL_DATA_LENGTH)}`;
    }
    if (resource instanceof Blob) {
      const blobSlice = resource.slice(0, 5);
      return await new Promise((resolve2) => {
        const reader = new FileReader();
        reader.onload = (event) => resolve2(event?.target?.result);
        reader.readAsDataURL(blobSlice);
      });
    }
    if (resource instanceof ArrayBuffer) {
      const slice = resource.slice(0, INITIAL_DATA_LENGTH);
      const base64 = arrayBufferToBase64(slice);
      return `data:base64,${base64}`;
    }
    return null;
  }
  function arrayBufferToBase64(buffer) {
    let binary = "";
    const bytes = new Uint8Array(buffer);
    for (let i2 = 0; i2 < bytes.byteLength; i2++) {
      binary += String.fromCharCode(bytes[i2]);
    }
    return btoa(binary);
  }
  var init_response_utils = __esm({
    "../core/src/lib/utils/response-utils.ts"() {
      init_is_type();
      init_resource_utils();
    }
  });

  // ../core/src/lib/fetch/fetch-file.ts
  async function fetchFile(url, options) {
    if (typeof url === "string") {
      url = resolvePath(url);
      let fetchOptions = options;
      if (options?.fetch && typeof options?.fetch !== "function") {
        fetchOptions = options.fetch;
      }
      return await fetch(url, fetchOptions);
    }
    return await makeResponse(url);
  }
  var init_fetch_file = __esm({
    "../core/src/lib/fetch/fetch-file.ts"() {
      init_src2();
      init_response_utils();
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/lib/is-electron.js
  function isElectron(mockUserAgent) {
    if (typeof window !== "undefined" && typeof window.process === "object" && window.process.type === "renderer") {
      return true;
    }
    if (typeof process !== "undefined" && typeof process.versions === "object" && Boolean(process.versions["electron"])) {
      return true;
    }
    const realUserAgent = typeof navigator === "object" && typeof navigator.userAgent === "string" && navigator.userAgent;
    const userAgent = mockUserAgent || realUserAgent;
    if (userAgent && userAgent.indexOf("Electron") >= 0) {
      return true;
    }
    return false;
  }
  var init_is_electron = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/lib/is-electron.js"() {
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/lib/is-browser.js
  function isBrowser3() {
    const isNode = typeof process === "object" && String(process) === "[object process]" && !process.browser;
    return !isNode || isElectron();
  }
  var init_is_browser = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/lib/is-browser.js"() {
      init_is_electron();
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/lib/globals.js
  var globals3, self_3, window_3, document_3, process_;
  var init_globals3 = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/lib/globals.js"() {
      globals3 = {
        self: typeof self !== "undefined" && self,
        window: typeof window !== "undefined" && window,
        global: typeof global !== "undefined" && global,
        document: typeof document !== "undefined" && document,
        process: typeof process === "object" && process
      };
      self_3 = globals3.self || globals3.window || globals3.global;
      window_3 = globals3.window || globals3.self || globals3.global;
      document_3 = globals3.document || {};
      process_ = globals3.process || {};
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/utils/globals.js
  var VERSION3, isBrowser4;
  var init_globals4 = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/utils/globals.js"() {
      init_is_browser();
      VERSION3 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "untranspiled source";
      isBrowser4 = isBrowser3();
    }
  });

  // ../../node_modules/@probe.gl/env/dist/esm/index.js
  var init_esm4 = __esm({
    "../../node_modules/@probe.gl/env/dist/esm/index.js"() {
      init_globals4();
      init_globals3();
      init_is_browser();
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/local-storage.js
  function getStorage(type) {
    try {
      const storage = window[type];
      const x = "__storage_test__";
      storage.setItem(x, x);
      storage.removeItem(x);
      return storage;
    } catch (e) {
      return null;
    }
  }
  var LocalStorage;
  var init_local_storage = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/local-storage.js"() {
      init_defineProperty();
      LocalStorage = class {
        constructor(id, defaultConfig) {
          let type = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : "sessionStorage";
          _defineProperty(this, "storage", void 0);
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "config", void 0);
          this.storage = getStorage(type);
          this.id = id;
          this.config = defaultConfig;
          this._loadConfiguration();
        }
        getConfiguration() {
          return this.config;
        }
        setConfiguration(configuration) {
          Object.assign(this.config, configuration);
          if (this.storage) {
            const serialized = JSON.stringify(this.config);
            this.storage.setItem(this.id, serialized);
          }
        }
        _loadConfiguration() {
          let configuration = {};
          if (this.storage) {
            const serializedConfiguration = this.storage.getItem(this.id);
            configuration = serializedConfiguration ? JSON.parse(serializedConfiguration) : {};
          }
          Object.assign(this.config, configuration);
          return this;
        }
      };
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/formatters.js
  function formatTime(ms) {
    let formatted;
    if (ms < 10) {
      formatted = "".concat(ms.toFixed(2), "ms");
    } else if (ms < 100) {
      formatted = "".concat(ms.toFixed(1), "ms");
    } else if (ms < 1e3) {
      formatted = "".concat(ms.toFixed(0), "ms");
    } else {
      formatted = "".concat((ms / 1e3).toFixed(2), "s");
    }
    return formatted;
  }
  function leftPad(string) {
    let length4 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 8;
    const padLength = Math.max(length4 - string.length, 0);
    return "".concat(" ".repeat(padLength)).concat(string);
  }
  function formatImage(image, message, scale5) {
    let maxWidth = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 600;
    const imageUrl = image.src.replace(/\(/g, "%28").replace(/\)/g, "%29");
    if (image.width > maxWidth) {
      scale5 = Math.min(scale5, maxWidth / image.width);
    }
    const width = image.width * scale5;
    const height = image.height * scale5;
    const style = ["font-size:1px;", "padding:".concat(Math.floor(height / 2), "px ").concat(Math.floor(width / 2), "px;"), "line-height:".concat(height, "px;"), "background:url(".concat(imageUrl, ");"), "background-size:".concat(width, "px ").concat(height, "px;"), "color:transparent;"].join("");
    return ["".concat(message, " %c+"), style];
  }
  var init_formatters = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/formatters.js"() {
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/color.js
  function getColor(color) {
    return typeof color === "string" ? COLOR[color.toUpperCase()] || COLOR.WHITE : color;
  }
  function addColor(string, color, background) {
    if (!isBrowser3 && typeof string === "string") {
      if (color) {
        color = getColor(color);
        string = "[".concat(color, "m").concat(string, "[39m");
      }
      if (background) {
        color = getColor(background);
        string = "[".concat(background + 10, "m").concat(string, "[49m");
      }
    }
    return string;
  }
  var COLOR;
  var init_color = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/color.js"() {
      init_esm4();
      (function(COLOR2) {
        COLOR2[COLOR2["BLACK"] = 30] = "BLACK";
        COLOR2[COLOR2["RED"] = 31] = "RED";
        COLOR2[COLOR2["GREEN"] = 32] = "GREEN";
        COLOR2[COLOR2["YELLOW"] = 33] = "YELLOW";
        COLOR2[COLOR2["BLUE"] = 34] = "BLUE";
        COLOR2[COLOR2["MAGENTA"] = 35] = "MAGENTA";
        COLOR2[COLOR2["CYAN"] = 36] = "CYAN";
        COLOR2[COLOR2["WHITE"] = 37] = "WHITE";
        COLOR2[COLOR2["BRIGHT_BLACK"] = 90] = "BRIGHT_BLACK";
        COLOR2[COLOR2["BRIGHT_RED"] = 91] = "BRIGHT_RED";
        COLOR2[COLOR2["BRIGHT_GREEN"] = 92] = "BRIGHT_GREEN";
        COLOR2[COLOR2["BRIGHT_YELLOW"] = 93] = "BRIGHT_YELLOW";
        COLOR2[COLOR2["BRIGHT_BLUE"] = 94] = "BRIGHT_BLUE";
        COLOR2[COLOR2["BRIGHT_MAGENTA"] = 95] = "BRIGHT_MAGENTA";
        COLOR2[COLOR2["BRIGHT_CYAN"] = 96] = "BRIGHT_CYAN";
        COLOR2[COLOR2["BRIGHT_WHITE"] = 97] = "BRIGHT_WHITE";
      })(COLOR || (COLOR = {}));
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/autobind.js
  function autobind(obj) {
    let predefined = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : ["constructor"];
    const proto = Object.getPrototypeOf(obj);
    const propNames = Object.getOwnPropertyNames(proto);
    for (const key of propNames) {
      if (typeof obj[key] === "function") {
        if (!predefined.find((name10) => key === name10)) {
          obj[key] = obj[key].bind(obj);
        }
      }
    }
  }
  var init_autobind = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/autobind.js"() {
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/assert.js
  function assert5(condition, message) {
    if (!condition) {
      throw new Error(message || "Assertion failed");
    }
  }
  var init_assert4 = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/assert.js"() {
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/utils/hi-res-timestamp.js
  function getHiResTimestamp() {
    let timestamp;
    if (isBrowser3 && "performance" in window_3) {
      var _window$performance, _window$performance$n;
      timestamp = window_3 === null || window_3 === void 0 ? void 0 : (_window$performance = window_3.performance) === null || _window$performance === void 0 ? void 0 : (_window$performance$n = _window$performance.now) === null || _window$performance$n === void 0 ? void 0 : _window$performance$n.call(_window$performance);
    } else if ("hrtime" in process_) {
      var _process$hrtime;
      const timeParts = process_ === null || process_ === void 0 ? void 0 : (_process$hrtime = process_.hrtime) === null || _process$hrtime === void 0 ? void 0 : _process$hrtime.call(process_);
      timestamp = timeParts[0] * 1e3 + timeParts[1] / 1e6;
    } else {
      timestamp = Date.now();
    }
    return timestamp;
  }
  var init_hi_res_timestamp = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/utils/hi-res-timestamp.js"() {
      init_esm4();
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/log.js
  function noop() {
  }
  function normalizeLogLevel(logLevel) {
    if (!logLevel) {
      return 0;
    }
    let resolvedLevel;
    switch (typeof logLevel) {
      case "number":
        resolvedLevel = logLevel;
        break;
      case "object":
        resolvedLevel = logLevel.logLevel || logLevel.priority || 0;
        break;
      default:
        return 0;
    }
    assert5(Number.isFinite(resolvedLevel) && resolvedLevel >= 0);
    return resolvedLevel;
  }
  function normalizeArguments(opts) {
    const {
      logLevel,
      message
    } = opts;
    opts.logLevel = normalizeLogLevel(logLevel);
    const args = opts.args ? Array.from(opts.args) : [];
    while (args.length && args.shift() !== message) {
    }
    switch (typeof logLevel) {
      case "string":
      case "function":
        if (message !== void 0) {
          args.unshift(message);
        }
        opts.message = logLevel;
        break;
      case "object":
        Object.assign(opts, logLevel);
        break;
      default:
    }
    if (typeof opts.message === "function") {
      opts.message = opts.message();
    }
    const messageType = typeof opts.message;
    assert5(messageType === "string" || messageType === "object");
    return Object.assign(opts, {
      args
    }, opts.opts);
  }
  function decorateMessage(id, message, opts) {
    if (typeof message === "string") {
      const time = opts.time ? leftPad(formatTime(opts.total)) : "";
      message = opts.time ? "".concat(id, ": ").concat(time, "  ").concat(message) : "".concat(id, ": ").concat(message);
      message = addColor(message, opts.color, opts.background);
    }
    return message;
  }
  function logImageInNode(_ref2) {
    let {
      image,
      message = "",
      scale: scale5 = 1
    } = _ref2;
    console.warn("removed");
    return noop;
  }
  function logImageInBrowser(_ref3) {
    let {
      image,
      message = "",
      scale: scale5 = 1
    } = _ref3;
    if (typeof image === "string") {
      const img = new Image();
      img.onload = () => {
        const args = formatImage(img, message, scale5);
        console.log(...args);
      };
      img.src = image;
      return noop;
    }
    const element = image.nodeName || "";
    if (element.toLowerCase() === "img") {
      console.log(...formatImage(image, message, scale5));
      return noop;
    }
    if (element.toLowerCase() === "canvas") {
      const img = new Image();
      img.onload = () => console.log(...formatImage(img, message, scale5));
      img.src = image.toDataURL();
      return noop;
    }
    return noop;
  }
  function getTableHeader(table) {
    for (const key in table) {
      for (const title in table[key]) {
        return title || "untitled";
      }
    }
    return "empty";
  }
  var originalConsole, DEFAULT_SETTINGS, cache, ONCE, Log;
  var init_log = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/log.js"() {
      init_defineProperty();
      init_esm4();
      init_local_storage();
      init_formatters();
      init_color();
      init_autobind();
      init_assert4();
      init_hi_res_timestamp();
      originalConsole = {
        debug: isBrowser3 ? console.debug || console.log : console.log,
        log: console.log,
        info: console.info,
        warn: console.warn,
        error: console.error
      };
      DEFAULT_SETTINGS = {
        enabled: true,
        level: 0
      };
      cache = {};
      ONCE = {
        once: true
      };
      Log = class {
        constructor() {
          let {
            id
          } = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {
            id: ""
          };
          _defineProperty(this, "id", void 0);
          _defineProperty(this, "VERSION", VERSION3);
          _defineProperty(this, "_startTs", getHiResTimestamp());
          _defineProperty(this, "_deltaTs", getHiResTimestamp());
          _defineProperty(this, "_storage", void 0);
          _defineProperty(this, "userData", {});
          _defineProperty(this, "LOG_THROTTLE_TIMEOUT", 0);
          this.id = id;
          this.userData = {};
          this._storage = new LocalStorage("__probe-".concat(this.id, "__"), DEFAULT_SETTINGS);
          this.timeStamp("".concat(this.id, " started"));
          autobind(this);
          Object.seal(this);
        }
        set level(newLevel) {
          this.setLevel(newLevel);
        }
        get level() {
          return this.getLevel();
        }
        isEnabled() {
          return this._storage.config.enabled;
        }
        getLevel() {
          return this._storage.config.level;
        }
        getTotal() {
          return Number((getHiResTimestamp() - this._startTs).toPrecision(10));
        }
        getDelta() {
          return Number((getHiResTimestamp() - this._deltaTs).toPrecision(10));
        }
        set priority(newPriority) {
          this.level = newPriority;
        }
        get priority() {
          return this.level;
        }
        getPriority() {
          return this.level;
        }
        enable() {
          let enabled = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true;
          this._storage.setConfiguration({
            enabled
          });
          return this;
        }
        setLevel(level) {
          this._storage.setConfiguration({
            level
          });
          return this;
        }
        get(setting) {
          return this._storage.config[setting];
        }
        set(setting, value) {
          this._storage.setConfiguration({
            [setting]: value
          });
        }
        settings() {
          if (console.table) {
            console.table(this._storage.config);
          } else {
            console.log(this._storage.config);
          }
        }
        assert(condition, message) {
          assert5(condition, message);
        }
        warn(message) {
          return this._getLogFunction(0, message, originalConsole.warn, arguments, ONCE);
        }
        error(message) {
          return this._getLogFunction(0, message, originalConsole.error, arguments);
        }
        deprecated(oldUsage, newUsage) {
          return this.warn("`".concat(oldUsage, "` is deprecated and will be removed in a later version. Use `").concat(newUsage, "` instead"));
        }
        removed(oldUsage, newUsage) {
          return this.error("`".concat(oldUsage, "` has been removed. Use `").concat(newUsage, "` instead"));
        }
        probe(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.log, arguments, {
            time: true,
            once: true
          });
        }
        log(logLevel, message) {
          return this._getLogFunction(logLevel, message, originalConsole.debug, arguments);
        }
        info(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.info, arguments);
        }
        once(logLevel, message) {
          for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
            args[_key - 2] = arguments[_key];
          }
          return this._getLogFunction(logLevel, message, originalConsole.debug || originalConsole.info, arguments, ONCE);
        }
        table(logLevel, table, columns) {
          if (table) {
            return this._getLogFunction(logLevel, table, console.table || noop, columns && [columns], {
              tag: getTableHeader(table)
            });
          }
          return noop;
        }
        image(_ref) {
          let {
            logLevel,
            priority,
            image,
            message = "",
            scale: scale5 = 1
          } = _ref;
          if (!this._shouldLog(logLevel || priority)) {
            return noop;
          }
          return isBrowser3 ? logImageInBrowser({
            image,
            message,
            scale: scale5
          }) : logImageInNode({
            image,
            message,
            scale: scale5
          });
        }
        time(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.time ? console.time : console.info);
        }
        timeEnd(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.timeEnd ? console.timeEnd : console.info);
        }
        timeStamp(logLevel, message) {
          return this._getLogFunction(logLevel, message, console.timeStamp || noop);
        }
        group(logLevel, message) {
          let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {
            collapsed: false
          };
          const options = normalizeArguments({
            logLevel,
            message,
            opts
          });
          const {
            collapsed
          } = opts;
          options.method = (collapsed ? console.groupCollapsed : console.group) || console.info;
          return this._getLogFunction(options);
        }
        groupCollapsed(logLevel, message) {
          let opts = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
          return this.group(logLevel, message, Object.assign({}, opts, {
            collapsed: true
          }));
        }
        groupEnd(logLevel) {
          return this._getLogFunction(logLevel, "", console.groupEnd || noop);
        }
        withGroup(logLevel, message, func) {
          this.group(logLevel, message)();
          try {
            func();
          } finally {
            this.groupEnd(logLevel)();
          }
        }
        trace() {
          if (console.trace) {
            console.trace();
          }
        }
        _shouldLog(logLevel) {
          return this.isEnabled() && this.getLevel() >= normalizeLogLevel(logLevel);
        }
        _getLogFunction(logLevel, message, method, args, opts) {
          if (this._shouldLog(logLevel)) {
            opts = normalizeArguments({
              logLevel,
              message,
              args,
              opts
            });
            method = method || opts.method;
            assert5(method);
            opts.total = this.getTotal();
            opts.delta = this.getDelta();
            this._deltaTs = getHiResTimestamp();
            const tag = opts.tag || opts.message;
            if (opts.once) {
              if (!cache[tag]) {
                cache[tag] = getHiResTimestamp();
              } else {
                return noop;
              }
            }
            message = decorateMessage(this.id, opts.message, opts);
            return method.bind(console, message, ...opts.args);
          }
          return noop;
        }
      };
      _defineProperty(Log, "VERSION", VERSION3);
    }
  });

  // ../../node_modules/@probe.gl/log/dist/esm/index.js
  var esm_default;
  var init_esm5 = __esm({
    "../../node_modules/@probe.gl/log/dist/esm/index.js"() {
      init_log();
      init_log();
      esm_default = new Log({
        id: "@probe.gl/log"
      });
    }
  });

  // ../core/src/lib/loader-utils/loggers.ts
  var probeLog, NullLog, ConsoleLog;
  var init_loggers = __esm({
    "../core/src/lib/loader-utils/loggers.ts"() {
      init_esm5();
      probeLog = new Log({ id: "loaders.gl" });
      NullLog = class {
        log() {
          return () => {
          };
        }
        info() {
          return () => {
          };
        }
        warn() {
          return () => {
          };
        }
        error() {
          return () => {
          };
        }
      };
      ConsoleLog = class {
        constructor() {
          this.console = console;
        }
        log(...args) {
          return this.console.log.bind(this.console, ...args);
        }
        info(...args) {
          return this.console.info.bind(this.console, ...args);
        }
        warn(...args) {
          return this.console.warn.bind(this.console, ...args);
        }
        error(...args) {
          return this.console.error.bind(this.console, ...args);
        }
      };
    }
  });

  // ../core/src/lib/loader-utils/option-defaults.ts
  var DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS;
  var init_option_defaults = __esm({
    "../core/src/lib/loader-utils/option-defaults.ts"() {
      init_src2();
      init_loggers();
      DEFAULT_LOADER_OPTIONS = {
        fetch: null,
        mimeType: void 0,
        nothrow: false,
        log: new ConsoleLog(),
        CDN: "https://unpkg.com/@loaders.gl",
        worker: true,
        maxConcurrency: 3,
        maxMobileConcurrency: 1,
        reuseWorkers: isBrowser,
        _nodeWorkers: false,
        _workerType: "",
        limit: 0,
        _limitMB: 0,
        batchSize: "auto",
        batchDebounceMs: 0,
        metadata: false,
        transforms: []
      };
      REMOVED_LOADER_OPTIONS = {
        throws: "nothrow",
        dataType: "(no longer used)",
        uri: "baseUri",
        method: "fetch.method",
        headers: "fetch.headers",
        body: "fetch.body",
        mode: "fetch.mode",
        credentials: "fetch.credentials",
        cache: "fetch.cache",
        redirect: "fetch.redirect",
        referrer: "fetch.referrer",
        referrerPolicy: "fetch.referrerPolicy",
        integrity: "fetch.integrity",
        keepalive: "fetch.keepalive",
        signal: "fetch.signal"
      };
    }
  });

  // ../core/src/lib/loader-utils/option-utils.ts
  function getGlobalLoaderState() {
    globalThis.loaders = globalThis.loaders || {};
    const { loaders } = globalThis;
    loaders._state = loaders._state || {};
    return loaders._state;
  }
  function normalizeOptions(options, loader, loaders, url) {
    loaders = loaders || [];
    loaders = Array.isArray(loaders) ? loaders : [loaders];
    validateOptions(options, loaders);
    return normalizeOptionsInternal(loader, options, url);
  }
  function validateOptions(options, loaders) {
    validateOptionsObject(options, null, DEFAULT_LOADER_OPTIONS, REMOVED_LOADER_OPTIONS, loaders);
    for (const loader of loaders) {
      const idOptions = options && options[loader.id] || {};
      const loaderOptions = loader.options && loader.options[loader.id] || {};
      const deprecatedOptions = loader.deprecatedOptions && loader.deprecatedOptions[loader.id] || {};
      validateOptionsObject(idOptions, loader.id, loaderOptions, deprecatedOptions, loaders);
    }
  }
  function validateOptionsObject(options, id, defaultOptions, deprecatedOptions, loaders) {
    const loaderName = id || "Top level";
    const prefix = id ? `${id}.` : "";
    for (const key in options) {
      const isSubOptions = !id && isObject(options[key]);
      const isBaseUriOption = key === "baseUri" && !id;
      const isWorkerUrlOption = key === "workerUrl" && id;
      if (!(key in defaultOptions) && !isBaseUriOption && !isWorkerUrlOption) {
        if (key in deprecatedOptions) {
          probeLog.warn(`${loaderName} loader option '${prefix}${key}' no longer supported, use '${deprecatedOptions[key]}'`)();
        } else if (!isSubOptions) {
          const suggestion = findSimilarOption(key, loaders);
          probeLog.warn(`${loaderName} loader option '${prefix}${key}' not recognized. ${suggestion}`)();
        }
      }
    }
  }
  function findSimilarOption(optionKey, loaders) {
    const lowerCaseOptionKey = optionKey.toLowerCase();
    let bestSuggestion = "";
    for (const loader of loaders) {
      for (const key in loader.options) {
        if (optionKey === key) {
          return `Did you mean '${loader.id}.${key}'?`;
        }
        const lowerCaseKey = key.toLowerCase();
        const isPartialMatch = lowerCaseOptionKey.startsWith(lowerCaseKey) || lowerCaseKey.startsWith(lowerCaseOptionKey);
        if (isPartialMatch) {
          bestSuggestion = bestSuggestion || `Did you mean '${loader.id}.${key}'?`;
        }
      }
    }
    return bestSuggestion;
  }
  function normalizeOptionsInternal(loader, options, url) {
    const loaderDefaultOptions = loader.options || {};
    const mergedOptions = { ...loaderDefaultOptions };
    addUrlOptions(mergedOptions, url);
    if (mergedOptions.log === null) {
      mergedOptions.log = new NullLog();
    }
    mergeNestedFields(mergedOptions, getGlobalLoaderOptions());
    mergeNestedFields(mergedOptions, options);
    return mergedOptions;
  }
  function mergeNestedFields(mergedOptions, options) {
    for (const key in options) {
      if (key in options) {
        const value = options[key];
        if (isPureObject(value) && isPureObject(mergedOptions[key])) {
          mergedOptions[key] = {
            ...mergedOptions[key],
            ...options[key]
          };
        } else {
          mergedOptions[key] = options[key];
        }
      }
    }
  }
  function addUrlOptions(options, url) {
    if (url && !("baseUri" in options)) {
      options.baseUri = url;
    }
  }
  var getGlobalLoaderOptions;
  var init_option_utils = __esm({
    "../core/src/lib/loader-utils/option-utils.ts"() {
      init_is_type();
      init_loggers();
      init_option_defaults();
      getGlobalLoaderOptions = () => {
        const state = getGlobalLoaderState();
        state.globalOptions = state.globalOptions || { ...DEFAULT_LOADER_OPTIONS };
        return state.globalOptions;
      };
    }
  });

  // ../core/src/lib/loader-utils/normalize-loader.ts
  function isLoaderObject(loader) {
    if (!loader) {
      return false;
    }
    if (Array.isArray(loader)) {
      loader = loader[0];
    }
    const hasExtensions = Array.isArray(loader?.extensions);
    return hasExtensions;
  }
  function normalizeLoader(loader) {
    assert2(loader, "null loader");
    assert2(isLoaderObject(loader), "invalid loader");
    let options;
    if (Array.isArray(loader)) {
      options = loader[1];
      loader = loader[0];
      loader = {
        ...loader,
        options: { ...loader.options, ...options }
      };
    }
    if (loader?.parseTextSync || loader?.parseText) {
      loader.text = true;
    }
    if (!loader.text) {
      loader.binary = true;
    }
    return loader;
  }
  var init_normalize_loader = __esm({
    "../core/src/lib/loader-utils/normalize-loader.ts"() {
      init_src2();
    }
  });

  // ../core/src/lib/api/register-loaders.ts
  function getRegisteredLoaders() {
    return getGlobalLoaderRegistry();
  }
  var getGlobalLoaderRegistry;
  var init_register_loaders = __esm({
    "../core/src/lib/api/register-loaders.ts"() {
      init_option_utils();
      getGlobalLoaderRegistry = () => {
        const state = getGlobalLoaderState();
        state.loaderRegistry = state.loaderRegistry || [];
        return state.loaderRegistry;
      };
    }
  });

  // ../core/src/lib/utils/log.ts
  var log;
  var init_log2 = __esm({
    "../core/src/lib/utils/log.ts"() {
      init_esm5();
      log = new Log({ id: "loaders.gl" });
    }
  });

  // ../core/src/lib/api/select-loader.ts
  async function selectLoader(data, loaders = [], options, context) {
    if (!validHTTPResponse(data)) {
      return null;
    }
    let loader = selectLoaderSync(data, loaders, { ...options, nothrow: true }, context);
    if (loader) {
      return loader;
    }
    if (isBlob(data)) {
      data = await data.slice(0, 10).arrayBuffer();
      loader = selectLoaderSync(data, loaders, options, context);
    }
    if (!loader && !options?.nothrow) {
      throw new Error(getNoValidLoaderMessage(data));
    }
    return loader;
  }
  function selectLoaderSync(data, loaders = [], options, context) {
    if (!validHTTPResponse(data)) {
      return null;
    }
    if (loaders && !Array.isArray(loaders)) {
      return normalizeLoader(loaders);
    }
    let candidateLoaders = [];
    if (loaders) {
      candidateLoaders = candidateLoaders.concat(loaders);
    }
    if (!options?.ignoreRegisteredLoaders) {
      candidateLoaders.push(...getRegisteredLoaders());
    }
    normalizeLoaders(candidateLoaders);
    const loader = selectLoaderInternal(data, candidateLoaders, options, context);
    if (!loader && !options?.nothrow) {
      throw new Error(getNoValidLoaderMessage(data));
    }
    return loader;
  }
  function selectLoaderInternal(data, loaders, options, context) {
    const url = getResourceUrl(data);
    const type = getResourceMIMEType(data);
    const testUrl = stripQueryString(url) || context?.url;
    let loader = null;
    let reason = "";
    if (options?.mimeType) {
      loader = findLoaderByMIMEType(loaders, options?.mimeType);
      reason = `match forced by supplied MIME type ${options?.mimeType}`;
    }
    loader = loader || findLoaderByUrl(loaders, testUrl);
    reason = reason || (loader ? `matched url ${testUrl}` : "");
    loader = loader || findLoaderByMIMEType(loaders, type);
    reason = reason || (loader ? `matched MIME type ${type}` : "");
    loader = loader || findLoaderByInitialBytes(loaders, data);
    reason = reason || (loader ? `matched initial data ${getFirstCharacters2(data)}` : "");
    loader = loader || findLoaderByMIMEType(loaders, options?.fallbackMimeType);
    reason = reason || (loader ? `matched fallback MIME type ${type}` : "");
    if (reason) {
      log.log(1, `selectLoader selected ${loader?.name}: ${reason}.`);
    }
    return loader;
  }
  function validHTTPResponse(data) {
    if (data instanceof Response) {
      if (data.status === 204) {
        return false;
      }
    }
    return true;
  }
  function getNoValidLoaderMessage(data) {
    const url = getResourceUrl(data);
    const type = getResourceMIMEType(data);
    let message = "No valid loader found (";
    message += url ? `${path_exports.filename(url)}, ` : "no url provided, ";
    message += `MIME type: ${type ? `"${type}"` : "not provided"}, `;
    const firstCharacters = data ? getFirstCharacters2(data) : "";
    message += firstCharacters ? ` first bytes: "${firstCharacters}"` : "first bytes: not available";
    message += ")";
    return message;
  }
  function normalizeLoaders(loaders) {
    for (const loader of loaders) {
      normalizeLoader(loader);
    }
  }
  function findLoaderByUrl(loaders, url) {
    const match = url && EXT_PATTERN.exec(url);
    const extension = match && match[1];
    return extension ? findLoaderByExtension(loaders, extension) : null;
  }
  function findLoaderByExtension(loaders, extension) {
    extension = extension.toLowerCase();
    for (const loader of loaders) {
      for (const loaderExtension of loader.extensions) {
        if (loaderExtension.toLowerCase() === extension) {
          return loader;
        }
      }
    }
    return null;
  }
  function findLoaderByMIMEType(loaders, mimeType) {
    for (const loader of loaders) {
      if (loader.mimeTypes && loader.mimeTypes.includes(mimeType)) {
        return loader;
      }
      if (mimeType === `application/x.${loader.id}`) {
        return loader;
      }
    }
    return null;
  }
  function findLoaderByInitialBytes(loaders, data) {
    if (!data) {
      return null;
    }
    for (const loader of loaders) {
      if (typeof data === "string") {
        if (testDataAgainstText(data, loader)) {
          return loader;
        }
      } else if (ArrayBuffer.isView(data)) {
        if (testDataAgainstBinary(data.buffer, data.byteOffset, loader)) {
          return loader;
        }
      } else if (data instanceof ArrayBuffer) {
        const byteOffset = 0;
        if (testDataAgainstBinary(data, byteOffset, loader)) {
          return loader;
        }
      }
    }
    return null;
  }
  function testDataAgainstText(data, loader) {
    if (loader.testText) {
      return loader.testText(data);
    }
    const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
    return tests.some((test) => data.startsWith(test));
  }
  function testDataAgainstBinary(data, byteOffset, loader) {
    const tests = Array.isArray(loader.tests) ? loader.tests : [loader.tests];
    return tests.some((test) => testBinary(data, byteOffset, loader, test));
  }
  function testBinary(data, byteOffset, loader, test) {
    if (test instanceof ArrayBuffer) {
      return compareArrayBuffers(test, data, test.byteLength);
    }
    switch (typeof test) {
      case "function":
        return test(data, loader);
      case "string":
        const magic = getMagicString2(data, byteOffset, test.length);
        return test === magic;
      default:
        return false;
    }
  }
  function getFirstCharacters2(data, length4 = 5) {
    if (typeof data === "string") {
      return data.slice(0, length4);
    } else if (ArrayBuffer.isView(data)) {
      return getMagicString2(data.buffer, data.byteOffset, length4);
    } else if (data instanceof ArrayBuffer) {
      const byteOffset = 0;
      return getMagicString2(data, byteOffset, length4);
    }
    return "";
  }
  function getMagicString2(arrayBuffer, byteOffset, length4) {
    if (arrayBuffer.byteLength < byteOffset + length4) {
      return "";
    }
    const dataView = new DataView(arrayBuffer);
    let magic = "";
    for (let i2 = 0; i2 < length4; i2++) {
      magic += String.fromCharCode(dataView.getUint8(byteOffset + i2));
    }
    return magic;
  }
  var EXT_PATTERN;
  var init_select_loader = __esm({
    "../core/src/lib/api/select-loader.ts"() {
      init_src2();
      init_normalize_loader();
      init_log2();
      init_resource_utils();
      init_register_loaders();
      init_is_type();
      init_url_utils();
      EXT_PATTERN = /\.([^.]+)$/;
    }
  });

  // ../core/src/iterators/make-iterator/make-string-iterator.ts
  function* makeStringIterator(string, options) {
    const chunkSize = options?.chunkSize || DEFAULT_CHUNK_SIZE;
    let offset = 0;
    const textEncoder = new TextEncoder();
    while (offset < string.length) {
      const chunkLength = Math.min(string.length - offset, chunkSize);
      const chunk = string.slice(offset, offset + chunkLength);
      offset += chunkLength;
      yield textEncoder.encode(chunk);
    }
  }
  var DEFAULT_CHUNK_SIZE;
  var init_make_string_iterator = __esm({
    "../core/src/iterators/make-iterator/make-string-iterator.ts"() {
      DEFAULT_CHUNK_SIZE = 256 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-array-buffer-iterator.ts
  function* makeArrayBufferIterator(arrayBuffer, options = {}) {
    const { chunkSize = DEFAULT_CHUNK_SIZE2 } = options;
    let byteOffset = 0;
    while (byteOffset < arrayBuffer.byteLength) {
      const chunkByteLength = Math.min(arrayBuffer.byteLength - byteOffset, chunkSize);
      const chunk = new ArrayBuffer(chunkByteLength);
      const sourceArray = new Uint8Array(arrayBuffer, byteOffset, chunkByteLength);
      const chunkArray = new Uint8Array(chunk);
      chunkArray.set(sourceArray);
      byteOffset += chunkByteLength;
      yield chunk;
    }
  }
  var DEFAULT_CHUNK_SIZE2;
  var init_make_array_buffer_iterator = __esm({
    "../core/src/iterators/make-iterator/make-array-buffer-iterator.ts"() {
      DEFAULT_CHUNK_SIZE2 = 256 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-blob-iterator.ts
  async function* makeBlobIterator(blob, options) {
    const chunkSize = options?.chunkSize || DEFAULT_CHUNK_SIZE3;
    let offset = 0;
    while (offset < blob.size) {
      const end = offset + chunkSize;
      const chunk = await blob.slice(offset, end).arrayBuffer();
      offset = end;
      yield chunk;
    }
  }
  var DEFAULT_CHUNK_SIZE3;
  var init_make_blob_iterator = __esm({
    "../core/src/iterators/make-iterator/make-blob-iterator.ts"() {
      DEFAULT_CHUNK_SIZE3 = 1024 * 1024;
    }
  });

  // ../core/src/iterators/make-iterator/make-stream-iterator.ts
  function makeStreamIterator(stream, options) {
    return isBrowser ? makeBrowserStreamIterator(stream, options) : makeNodeStreamIterator(stream, options);
  }
  async function* makeBrowserStreamIterator(stream, options) {
    const reader = stream.getReader();
    let nextBatchPromise;
    try {
      while (true) {
        const currentBatchPromise = nextBatchPromise || reader.read();
        if (options?._streamReadAhead) {
          nextBatchPromise = reader.read();
        }
        const { done, value } = await currentBatchPromise;
        if (done) {
          return;
        }
        yield toArrayBuffer2(value);
      }
    } catch (error) {
      reader.releaseLock();
    }
  }
  async function* makeNodeStreamIterator(stream, options) {
    for await (const chunk of stream) {
      yield toArrayBuffer2(chunk);
    }
  }
  var init_make_stream_iterator = __esm({
    "../core/src/iterators/make-iterator/make-stream-iterator.ts"() {
      init_src2();
    }
  });

  // ../core/src/iterators/make-iterator/make-iterator.ts
  function makeIterator(data, options) {
    if (typeof data === "string") {
      return makeStringIterator(data, options);
    }
    if (data instanceof ArrayBuffer) {
      return makeArrayBufferIterator(data, options);
    }
    if (isBlob(data)) {
      return makeBlobIterator(data, options);
    }
    if (isReadableStream(data)) {
      return makeStreamIterator(data, options);
    }
    if (isResponse(data)) {
      const response = data;
      return makeStreamIterator(response.body, options);
    }
    throw new Error("makeIterator");
  }
  var init_make_iterator = __esm({
    "../core/src/iterators/make-iterator/make-iterator.ts"() {
      init_make_string_iterator();
      init_make_array_buffer_iterator();
      init_make_blob_iterator();
      init_make_stream_iterator();
      init_is_type();
    }
  });

  // ../core/src/lib/loader-utils/get-data.ts
  function getArrayBufferOrStringFromDataSync(data, loader, options) {
    if (loader.text && typeof data === "string") {
      return data;
    }
    if (isBuffer2(data)) {
      data = data.buffer;
    }
    if (data instanceof ArrayBuffer) {
      const arrayBuffer = data;
      if (loader.text && !loader.binary) {
        const textDecoder = new TextDecoder("utf8");
        return textDecoder.decode(arrayBuffer);
      }
      return arrayBuffer;
    }
    if (ArrayBuffer.isView(data)) {
      if (loader.text && !loader.binary) {
        const textDecoder = new TextDecoder("utf8");
        return textDecoder.decode(data);
      }
      let arrayBuffer = data.buffer;
      const byteLength = data.byteLength || data.length;
      if (data.byteOffset !== 0 || byteLength !== arrayBuffer.byteLength) {
        arrayBuffer = arrayBuffer.slice(data.byteOffset, data.byteOffset + byteLength);
      }
      return arrayBuffer;
    }
    throw new Error(ERR_DATA);
  }
  async function getArrayBufferOrStringFromData(data, loader, options) {
    const isArrayBuffer = data instanceof ArrayBuffer || ArrayBuffer.isView(data);
    if (typeof data === "string" || isArrayBuffer) {
      return getArrayBufferOrStringFromDataSync(data, loader, options);
    }
    if (isBlob(data)) {
      data = await makeResponse(data);
    }
    if (isResponse(data)) {
      const response = data;
      await checkResponse(response);
      return loader.binary ? await response.arrayBuffer() : await response.text();
    }
    if (isReadableStream(data)) {
      data = makeIterator(data, options);
    }
    if (isIterable(data) || isAsyncIterable(data)) {
      return concatenateArrayBuffersAsync(data);
    }
    throw new Error(ERR_DATA);
  }
  var ERR_DATA;
  var init_get_data = __esm({
    "../core/src/lib/loader-utils/get-data.ts"() {
      init_src2();
      init_is_type();
      init_make_iterator();
      init_response_utils();
      ERR_DATA = "Cannot convert supplied data type";
    }
  });

  // ../core/src/lib/loader-utils/get-fetch-function.ts
  function getFetchFunction(options, context) {
    const globalOptions = getGlobalLoaderOptions();
    const fetchOptions = options || globalOptions;
    if (typeof fetchOptions.fetch === "function") {
      return fetchOptions.fetch;
    }
    if (isObject(fetchOptions.fetch)) {
      return (url) => fetchFile(url, fetchOptions);
    }
    if (context?.fetch) {
      return context?.fetch;
    }
    return fetchFile;
  }
  var init_get_fetch_function = __esm({
    "../core/src/lib/loader-utils/get-fetch-function.ts"() {
      init_is_type();
      init_fetch_file();
      init_option_utils();
    }
  });

  // ../core/src/lib/loader-utils/loader-context.ts
  function getLoaderContext(context, options, parentContext) {
    if (parentContext) {
      return parentContext;
    }
    const newContext = {
      fetch: getFetchFunction(options, context),
      ...context
    };
    if (newContext.url) {
      const baseUrl = stripQueryString(newContext.url);
      newContext.baseUrl = baseUrl;
      newContext.queryString = extractQueryString(newContext.url);
      newContext.filename = path_exports.filename(baseUrl);
      newContext.baseUrl = path_exports.dirname(baseUrl);
    }
    if (!Array.isArray(newContext.loaders)) {
      newContext.loaders = null;
    }
    return newContext;
  }
  function getLoadersFromContext(loaders, context) {
    if (!context && loaders && !Array.isArray(loaders)) {
      return loaders;
    }
    let candidateLoaders;
    if (loaders) {
      candidateLoaders = Array.isArray(loaders) ? loaders : [loaders];
    }
    if (context && context.loaders) {
      const contextLoaders = Array.isArray(context.loaders) ? context.loaders : [context.loaders];
      candidateLoaders = candidateLoaders ? [...candidateLoaders, ...contextLoaders] : contextLoaders;
    }
    return candidateLoaders && candidateLoaders.length ? candidateLoaders : null;
  }
  var init_loader_context = __esm({
    "../core/src/lib/loader-utils/loader-context.ts"() {
      init_get_fetch_function();
      init_url_utils();
      init_src2();
    }
  });

  // ../core/src/lib/api/parse.ts
  async function parse(data, loaders, options, context) {
    assert3(!context || typeof context === "object");
    if (loaders && !Array.isArray(loaders) && !isLoaderObject(loaders)) {
      context = void 0;
      options = loaders;
      loaders = void 0;
    }
    data = await data;
    options = options || {};
    const url = getResourceUrl(data);
    const typedLoaders = loaders;
    const candidateLoaders = getLoadersFromContext(typedLoaders, context);
    const loader = await selectLoader(data, candidateLoaders, options);
    if (!loader) {
      return null;
    }
    options = normalizeOptions(options, loader, candidateLoaders, url);
    context = getLoaderContext({ url, parse, loaders: candidateLoaders }, options, context || null);
    return await parseWithLoader(loader, data, options, context);
  }
  async function parseWithLoader(loader, data, options, context) {
    validateWorkerVersion(loader);
    if (isResponse(data)) {
      const response = data;
      const { ok, redirected, status, statusText, type, url } = response;
      const headers = Object.fromEntries(response.headers.entries());
      context.response = { headers, ok, redirected, status, statusText, type, url };
    }
    data = await getArrayBufferOrStringFromData(data, loader, options);
    if (loader.parseTextSync && typeof data === "string") {
      options.dataType = "text";
      return loader.parseTextSync(data, options, context, loader);
    }
    if (canParseWithWorker(loader, options)) {
      return await parseWithWorker(loader, data, options, context, parse);
    }
    if (loader.parseText && typeof data === "string") {
      return await loader.parseText(data, options, context, loader);
    }
    if (loader.parse) {
      return await loader.parse(data, options, context, loader);
    }
    assert3(!loader.parseSync);
    throw new Error(`${loader.id} loader - no parser found and worker is disabled`);
  }
  var init_parse = __esm({
    "../core/src/lib/api/parse.ts"() {
      init_src();
      init_src2();
      init_normalize_loader();
      init_is_type();
      init_option_utils();
      init_get_data();
      init_loader_context();
      init_resource_utils();
      init_select_loader();
    }
  });

  // ../core/src/lib/api/load.ts
  async function load(url, loaders, options, context) {
    if (!Array.isArray(loaders) && !isLoaderObject(loaders)) {
      context = void 0;
      options = loaders;
      loaders = void 0;
    }
    const fetch2 = getFetchFunction(options);
    let data = url;
    if (typeof url === "string") {
      data = await fetch2(url);
    }
    if (isBlob(url)) {
      data = await fetch2(url);
    }
    return await parse(data, loaders, options);
  }
  var init_load = __esm({
    "../core/src/lib/api/load.ts"() {
      init_is_type();
      init_normalize_loader();
      init_get_fetch_function();
      init_parse();
    }
  });

  // ../core/src/index.ts
  var init_src3 = __esm({
    "../core/src/index.ts"() {
      init_fetch_file();
      init_load();
    }
  });

  // ../tiles/src/constants.ts
  var TILE_REFINEMENT, TILE_TYPE, TILESET_TYPE, LOD_METRIC_TYPE;
  var init_constants3 = __esm({
    "../tiles/src/constants.ts"() {
      TILE_REFINEMENT = {
        ADD: 1,
        REPLACE: 2
      };
      TILE_TYPE = {
        EMPTY: "empty",
        SCENEGRAPH: "scenegraph",
        POINTCLOUD: "pointcloud",
        MESH: "mesh"
      };
      TILESET_TYPE = {
        I3S: "I3S",
        TILES3D: "TILES3D"
      };
      LOD_METRIC_TYPE = {
        GEOMETRIC_ERROR: "geometricError",
        MAX_SCREEN_THRESHOLD: "maxScreenThreshold"
      };
    }
  });

  // ../tiles/src/index.ts
  var init_src4 = __esm({
    "../tiles/src/index.ts"() {
      init_constants3();
    }
  });

  // src/lib/utils/version.ts
  var VERSION4;
  var init_version2 = __esm({
    "src/lib/utils/version.ts"() {
      VERSION4 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // src/lib/constants.ts
  var TILE3D_TYPE, TILE3D_TYPES, MAGIC_ARRAY;
  var init_constants4 = __esm({
    "src/lib/constants.ts"() {
      TILE3D_TYPE = {
        COMPOSITE: "cmpt",
        POINT_CLOUD: "pnts",
        BATCHED_3D_MODEL: "b3dm",
        INSTANCED_3D_MODEL: "i3dm",
        GEOMETRY: "geom",
        VECTOR: "vect",
        GLTF: "glTF"
      };
      TILE3D_TYPES = Object.keys(TILE3D_TYPE);
      MAGIC_ARRAY = {
        BATCHED_MODEL: [98, 51, 100, 109],
        INSTANCED_MODEL: [105, 51, 100, 109],
        POINT_CLOUD: [112, 110, 116, 115],
        COMPOSITE: [99, 109, 112, 116]
      };
    }
  });

  // src/lib/parsers/helpers/parse-utils.ts
  function getStringFromArrayBuffer(arrayBuffer, byteOffset, byteLength) {
    assert2(arrayBuffer instanceof ArrayBuffer);
    const textDecoder = new TextDecoder("utf8");
    const typedArray = new Uint8Array(arrayBuffer, byteOffset, byteLength);
    const string = textDecoder.decode(typedArray);
    return string;
  }
  function getMagicString3(arrayBuffer, byteOffset = 0) {
    const dataView = new DataView(arrayBuffer);
    return `${String.fromCharCode(dataView.getUint8(byteOffset + 0))}${String.fromCharCode(dataView.getUint8(byteOffset + 1))}${String.fromCharCode(dataView.getUint8(byteOffset + 2))}${String.fromCharCode(dataView.getUint8(byteOffset + 3))}`;
  }
  var init_parse_utils = __esm({
    "src/lib/parsers/helpers/parse-utils.ts"() {
      init_src2();
    }
  });

  // ../draco/src/lib/utils/version.ts
  var VERSION5;
  var init_version3 = __esm({
    "../draco/src/lib/utils/version.ts"() {
      VERSION5 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../draco/src/draco-loader.ts
  var DEFAULT_DRACO_OPTIONS, DracoLoader;
  var init_draco_loader = __esm({
    "../draco/src/draco-loader.ts"() {
      init_src();
      init_version3();
      DEFAULT_DRACO_OPTIONS = {
        draco: {
          decoderType: typeof WebAssembly === "object" ? "wasm" : "js",
          libraryPath: "libs/",
          extraAttributes: {},
          attributeNameEntry: void 0
        }
      };
      DracoLoader = {
        name: "Draco",
        id: isBrowser2 ? "draco" : "draco-nodejs",
        module: "draco",
        shapes: ["mesh"],
        version: VERSION5,
        worker: true,
        extensions: ["drc"],
        mimeTypes: ["application/octet-stream"],
        binary: true,
        tests: ["DRACO"],
        options: DEFAULT_DRACO_OPTIONS
      };
    }
  });

  // ../schema/src/category/mesh/mesh-utils.ts
  function getMeshBoundingBox(attributes) {
    let minX = Infinity;
    let minY = Infinity;
    let minZ = Infinity;
    let maxX = -Infinity;
    let maxY = -Infinity;
    let maxZ = -Infinity;
    const positions = attributes.POSITION ? attributes.POSITION.value : [];
    const len2 = positions && positions.length;
    for (let i2 = 0; i2 < len2; i2 += 3) {
      const x = positions[i2];
      const y = positions[i2 + 1];
      const z = positions[i2 + 2];
      minX = x < minX ? x : minX;
      minY = y < minY ? y : minY;
      minZ = z < minZ ? z : minZ;
      maxX = x > maxX ? x : maxX;
      maxY = y > maxY ? y : maxY;
      maxZ = z > maxZ ? z : maxZ;
    }
    return [
      [minX, minY, minZ],
      [maxX, maxY, maxZ]
    ];
  }
  var init_mesh_utils = __esm({
    "../schema/src/category/mesh/mesh-utils.ts"() {
    }
  });

  // ../schema/src/lib/utils/assert.ts
  function assert6(condition, message) {
    if (!condition) {
      throw new Error(message || "loader assertion failed.");
    }
  }
  var init_assert5 = __esm({
    "../schema/src/lib/utils/assert.ts"() {
    }
  });

  // ../schema/src/lib/schema/impl/schema.ts
  function checkNames(fields) {
    const usedNames = {};
    for (const field of fields) {
      if (usedNames[field.name]) {
        console.warn("Schema: duplicated field name", field.name, field);
      }
      usedNames[field.name] = true;
    }
  }
  function mergeMaps(m1, m2) {
    return new Map([...m1 || new Map(), ...m2 || new Map()]);
  }
  var Schema;
  var init_schema = __esm({
    "../schema/src/lib/schema/impl/schema.ts"() {
      init_assert5();
      Schema = class {
        constructor(fields, metadata) {
          assert6(Array.isArray(fields));
          checkNames(fields);
          this.fields = fields;
          this.metadata = metadata || new Map();
        }
        compareTo(other) {
          if (this.metadata !== other.metadata) {
            return false;
          }
          if (this.fields.length !== other.fields.length) {
            return false;
          }
          for (let i2 = 0; i2 < this.fields.length; ++i2) {
            if (!this.fields[i2].compareTo(other.fields[i2])) {
              return false;
            }
          }
          return true;
        }
        select(...columnNames) {
          const nameMap = Object.create(null);
          for (const name10 of columnNames) {
            nameMap[name10] = true;
          }
          const selectedFields = this.fields.filter((field) => nameMap[field.name]);
          return new Schema(selectedFields, this.metadata);
        }
        selectAt(...columnIndices) {
          const selectedFields = columnIndices.map((index) => this.fields[index]).filter(Boolean);
          return new Schema(selectedFields, this.metadata);
        }
        assign(schemaOrFields) {
          let fields;
          let metadata = this.metadata;
          if (schemaOrFields instanceof Schema) {
            const otherSchema = schemaOrFields;
            fields = otherSchema.fields;
            metadata = mergeMaps(mergeMaps(new Map(), this.metadata), otherSchema.metadata);
          } else {
            fields = schemaOrFields;
          }
          const fieldMap = Object.create(null);
          for (const field of this.fields) {
            fieldMap[field.name] = field;
          }
          for (const field of fields) {
            fieldMap[field.name] = field;
          }
          const mergedFields = Object.values(fieldMap);
          return new Schema(mergedFields, metadata);
        }
      };
    }
  });

  // ../schema/src/lib/schema/impl/field.ts
  var Field;
  var init_field = __esm({
    "../schema/src/lib/schema/impl/field.ts"() {
      Field = class {
        constructor(name10, type, nullable = false, metadata = new Map()) {
          this.name = name10;
          this.type = type;
          this.nullable = nullable;
          this.metadata = metadata;
        }
        get typeId() {
          return this.type && this.type.typeId;
        }
        clone() {
          return new Field(this.name, this.type, this.nullable, this.metadata);
        }
        compareTo(other) {
          return this.name === other.name && this.type === other.type && this.nullable === other.nullable && this.metadata === other.metadata;
        }
        toString() {
          return `${this.type}${this.nullable ? ", nullable" : ""}${this.metadata ? `, metadata: ${this.metadata}` : ""}`;
        }
      };
    }
  });

  // ../schema/src/lib/schema/impl/enum.ts
  var Type;
  var init_enum = __esm({
    "../schema/src/lib/schema/impl/enum.ts"() {
      (function(Type2) {
        Type2[Type2["NONE"] = 0] = "NONE";
        Type2[Type2["Null"] = 1] = "Null";
        Type2[Type2["Int"] = 2] = "Int";
        Type2[Type2["Float"] = 3] = "Float";
        Type2[Type2["Binary"] = 4] = "Binary";
        Type2[Type2["Utf8"] = 5] = "Utf8";
        Type2[Type2["Bool"] = 6] = "Bool";
        Type2[Type2["Decimal"] = 7] = "Decimal";
        Type2[Type2["Date"] = 8] = "Date";
        Type2[Type2["Time"] = 9] = "Time";
        Type2[Type2["Timestamp"] = 10] = "Timestamp";
        Type2[Type2["Interval"] = 11] = "Interval";
        Type2[Type2["List"] = 12] = "List";
        Type2[Type2["Struct"] = 13] = "Struct";
        Type2[Type2["Union"] = 14] = "Union";
        Type2[Type2["FixedSizeBinary"] = 15] = "FixedSizeBinary";
        Type2[Type2["FixedSizeList"] = 16] = "FixedSizeList";
        Type2[Type2["Map"] = 17] = "Map";
        Type2[Type2["Dictionary"] = -1] = "Dictionary";
        Type2[Type2["Int8"] = -2] = "Int8";
        Type2[Type2["Int16"] = -3] = "Int16";
        Type2[Type2["Int32"] = -4] = "Int32";
        Type2[Type2["Int64"] = -5] = "Int64";
        Type2[Type2["Uint8"] = -6] = "Uint8";
        Type2[Type2["Uint16"] = -7] = "Uint16";
        Type2[Type2["Uint32"] = -8] = "Uint32";
        Type2[Type2["Uint64"] = -9] = "Uint64";
        Type2[Type2["Float16"] = -10] = "Float16";
        Type2[Type2["Float32"] = -11] = "Float32";
        Type2[Type2["Float64"] = -12] = "Float64";
        Type2[Type2["DateDay"] = -13] = "DateDay";
        Type2[Type2["DateMillisecond"] = -14] = "DateMillisecond";
        Type2[Type2["TimestampSecond"] = -15] = "TimestampSecond";
        Type2[Type2["TimestampMillisecond"] = -16] = "TimestampMillisecond";
        Type2[Type2["TimestampMicrosecond"] = -17] = "TimestampMicrosecond";
        Type2[Type2["TimestampNanosecond"] = -18] = "TimestampNanosecond";
        Type2[Type2["TimeSecond"] = -19] = "TimeSecond";
        Type2[Type2["TimeMillisecond"] = -20] = "TimeMillisecond";
        Type2[Type2["TimeMicrosecond"] = -21] = "TimeMicrosecond";
        Type2[Type2["TimeNanosecond"] = -22] = "TimeNanosecond";
        Type2[Type2["DenseUnion"] = -23] = "DenseUnion";
        Type2[Type2["SparseUnion"] = -24] = "SparseUnion";
        Type2[Type2["IntervalDayTime"] = -25] = "IntervalDayTime";
        Type2[Type2["IntervalYearMonth"] = -26] = "IntervalYearMonth";
      })(Type || (Type = {}));
    }
  });

  // ../schema/src/lib/schema/impl/type.ts
  var DataType, Null, Bool, Int, Int8, Int16, Int32, Uint8, Uint16, Uint32, Precision, Float, Float32, Float64, Binary, Utf8, DateUnit, Date2, TimeUnit, Time, Timestamp, IntervalUnit, Interval, FixedSizeList, Struct;
  var init_type = __esm({
    "../schema/src/lib/schema/impl/type.ts"() {
      init_enum();
      DataType = class {
        static isNull(x) {
          return x && x.typeId === Type.Null;
        }
        static isInt(x) {
          return x && x.typeId === Type.Int;
        }
        static isFloat(x) {
          return x && x.typeId === Type.Float;
        }
        static isBinary(x) {
          return x && x.typeId === Type.Binary;
        }
        static isUtf8(x) {
          return x && x.typeId === Type.Utf8;
        }
        static isBool(x) {
          return x && x.typeId === Type.Bool;
        }
        static isDecimal(x) {
          return x && x.typeId === Type.Decimal;
        }
        static isDate(x) {
          return x && x.typeId === Type.Date;
        }
        static isTime(x) {
          return x && x.typeId === Type.Time;
        }
        static isTimestamp(x) {
          return x && x.typeId === Type.Timestamp;
        }
        static isInterval(x) {
          return x && x.typeId === Type.Interval;
        }
        static isList(x) {
          return x && x.typeId === Type.List;
        }
        static isStruct(x) {
          return x && x.typeId === Type.Struct;
        }
        static isUnion(x) {
          return x && x.typeId === Type.Union;
        }
        static isFixedSizeBinary(x) {
          return x && x.typeId === Type.FixedSizeBinary;
        }
        static isFixedSizeList(x) {
          return x && x.typeId === Type.FixedSizeList;
        }
        static isMap(x) {
          return x && x.typeId === Type.Map;
        }
        static isDictionary(x) {
          return x && x.typeId === Type.Dictionary;
        }
        get typeId() {
          return Type.NONE;
        }
        compareTo(other) {
          return this === other;
        }
      };
      Null = class extends DataType {
        get typeId() {
          return Type.Null;
        }
        get [Symbol.toStringTag]() {
          return "Null";
        }
        toString() {
          return "Null";
        }
      };
      Bool = class extends DataType {
        get typeId() {
          return Type.Bool;
        }
        get [Symbol.toStringTag]() {
          return "Bool";
        }
        toString() {
          return "Bool";
        }
      };
      Int = class extends DataType {
        constructor(isSigned, bitWidth) {
          super();
          this.isSigned = isSigned;
          this.bitWidth = bitWidth;
        }
        get typeId() {
          return Type.Int;
        }
        get [Symbol.toStringTag]() {
          return "Int";
        }
        toString() {
          return `${this.isSigned ? "I" : "Ui"}nt${this.bitWidth}`;
        }
      };
      Int8 = class extends Int {
        constructor() {
          super(true, 8);
        }
      };
      Int16 = class extends Int {
        constructor() {
          super(true, 16);
        }
      };
      Int32 = class extends Int {
        constructor() {
          super(true, 32);
        }
      };
      Uint8 = class extends Int {
        constructor() {
          super(false, 8);
        }
      };
      Uint16 = class extends Int {
        constructor() {
          super(false, 16);
        }
      };
      Uint32 = class extends Int {
        constructor() {
          super(false, 32);
        }
      };
      Precision = {
        HALF: 16,
        SINGLE: 32,
        DOUBLE: 64
      };
      Float = class extends DataType {
        constructor(precision) {
          super();
          this.precision = precision;
        }
        get typeId() {
          return Type.Float;
        }
        get [Symbol.toStringTag]() {
          return "Float";
        }
        toString() {
          return `Float${this.precision}`;
        }
      };
      Float32 = class extends Float {
        constructor() {
          super(Precision.SINGLE);
        }
      };
      Float64 = class extends Float {
        constructor() {
          super(Precision.DOUBLE);
        }
      };
      Binary = class extends DataType {
        constructor() {
          super();
        }
        get typeId() {
          return Type.Binary;
        }
        toString() {
          return "Binary";
        }
        get [Symbol.toStringTag]() {
          return "Binary";
        }
      };
      Utf8 = class extends DataType {
        get typeId() {
          return Type.Utf8;
        }
        get [Symbol.toStringTag]() {
          return "Utf8";
        }
        toString() {
          return "Utf8";
        }
      };
      DateUnit = {
        DAY: 0,
        MILLISECOND: 1
      };
      Date2 = class extends DataType {
        constructor(unit) {
          super();
          this.unit = unit;
        }
        get typeId() {
          return Type.Date;
        }
        get [Symbol.toStringTag]() {
          return "Date";
        }
        toString() {
          return `Date${(this.unit + 1) * 32}<${DateUnit[this.unit]}>`;
        }
      };
      TimeUnit = {
        SECOND: 1,
        MILLISECOND: 1e3,
        MICROSECOND: 1e6,
        NANOSECOND: 1e9
      };
      Time = class extends DataType {
        constructor(unit, bitWidth) {
          super();
          this.unit = unit;
          this.bitWidth = bitWidth;
        }
        get typeId() {
          return Type.Time;
        }
        toString() {
          return `Time${this.bitWidth}<${TimeUnit[this.unit]}>`;
        }
        get [Symbol.toStringTag]() {
          return "Time";
        }
      };
      Timestamp = class extends DataType {
        constructor(unit, timezone = null) {
          super();
          this.unit = unit;
          this.timezone = timezone;
        }
        get typeId() {
          return Type.Timestamp;
        }
        get [Symbol.toStringTag]() {
          return "Timestamp";
        }
        toString() {
          return `Timestamp<${TimeUnit[this.unit]}${this.timezone ? `, ${this.timezone}` : ""}>`;
        }
      };
      IntervalUnit = {
        DAY_TIME: 0,
        YEAR_MONTH: 1
      };
      Interval = class extends DataType {
        constructor(unit) {
          super();
          this.unit = unit;
        }
        get typeId() {
          return Type.Interval;
        }
        get [Symbol.toStringTag]() {
          return "Interval";
        }
        toString() {
          return `Interval<${IntervalUnit[this.unit]}>`;
        }
      };
      FixedSizeList = class extends DataType {
        constructor(listSize, child) {
          super();
          this.listSize = listSize;
          this.children = [child];
        }
        get typeId() {
          return Type.FixedSizeList;
        }
        get valueType() {
          return this.children[0].type;
        }
        get valueField() {
          return this.children[0];
        }
        get [Symbol.toStringTag]() {
          return "FixedSizeList";
        }
        toString() {
          return `FixedSizeList[${this.listSize}]<${this.valueType}>`;
        }
      };
      Struct = class extends DataType {
        constructor(children) {
          super();
          this.children = children;
        }
        get typeId() {
          return Type.Struct;
        }
        toString() {
          return `Struct<{${this.children.map((f2) => `${f2.name}:${f2.type}`).join(", ")}}>`;
        }
        get [Symbol.toStringTag]() {
          return "Struct";
        }
      };
    }
  });

  // ../schema/src/lib/schema/schema.ts
  var init_schema2 = __esm({
    "../schema/src/lib/schema/schema.ts"() {
      init_schema();
      init_field();
      init_type();
    }
  });

  // ../schema/src/lib/arrow/arrow-like-type-utils.ts
  function getArrowTypeFromTypedArray(array) {
    switch (array.constructor) {
      case Int8Array:
        return new Int8();
      case Uint8Array:
        return new Uint8();
      case Int16Array:
        return new Int16();
      case Uint16Array:
        return new Uint16();
      case Int32Array:
        return new Int32();
      case Uint32Array:
        return new Uint32();
      case Float32Array:
        return new Float32();
      case Float64Array:
        return new Float64();
      default:
        throw new Error("array type not supported");
    }
  }
  var init_arrow_like_type_utils = __esm({
    "../schema/src/lib/arrow/arrow-like-type-utils.ts"() {
      init_schema2();
    }
  });

  // ../schema/src/category/mesh/deduce-mesh-schema.ts
  function deduceMeshField(attributeName, attribute, optionalMetadata) {
    const type = getArrowTypeFromTypedArray(attribute.value);
    const metadata = optionalMetadata ? optionalMetadata : makeMeshAttributeMetadata(attribute);
    const field = new Field(attributeName, new FixedSizeList(attribute.size, new Field("value", type)), false, metadata);
    return field;
  }
  function makeMeshAttributeMetadata(attribute) {
    const result = new Map();
    if ("byteOffset" in attribute) {
      result.set("byteOffset", attribute.byteOffset.toString(10));
    }
    if ("byteStride" in attribute) {
      result.set("byteStride", attribute.byteStride.toString(10));
    }
    if ("normalized" in attribute) {
      result.set("normalized", attribute.normalized.toString());
    }
    return result;
  }
  var init_deduce_mesh_schema = __esm({
    "../schema/src/category/mesh/deduce-mesh-schema.ts"() {
      init_schema2();
      init_arrow_like_type_utils();
    }
  });

  // ../schema/src/index.ts
  var init_src5 = __esm({
    "../schema/src/index.ts"() {
      init_mesh_utils();
      init_deduce_mesh_schema();
      init_schema2();
    }
  });

  // ../draco/src/lib/utils/get-draco-schema.ts
  function getDracoSchema(attributes, loaderData, indices) {
    const metadataMap = makeMetadata(loaderData.metadata);
    const fields = [];
    const namedLoaderDataAttributes = transformAttributesLoaderData(loaderData.attributes);
    for (const attributeName in attributes) {
      const attribute = attributes[attributeName];
      const field = getArrowFieldFromAttribute(attributeName, attribute, namedLoaderDataAttributes[attributeName]);
      fields.push(field);
    }
    if (indices) {
      const indicesField = getArrowFieldFromAttribute("indices", indices);
      fields.push(indicesField);
    }
    return new Schema(fields, metadataMap);
  }
  function transformAttributesLoaderData(loaderData) {
    const result = {};
    for (const key in loaderData) {
      const dracoAttribute = loaderData[key];
      result[dracoAttribute.name || "undefined"] = dracoAttribute;
    }
    return result;
  }
  function getArrowFieldFromAttribute(attributeName, attribute, loaderData) {
    const metadataMap = loaderData ? makeMetadata(loaderData.metadata) : void 0;
    const field = deduceMeshField(attributeName, attribute, metadataMap);
    return field;
  }
  function makeMetadata(metadata) {
    const metadataMap = new Map();
    for (const key in metadata) {
      metadataMap.set(`${key}.string`, JSON.stringify(metadata[key]));
    }
    return metadataMap;
  }
  var init_get_draco_schema = __esm({
    "../draco/src/lib/utils/get-draco-schema.ts"() {
      init_src5();
      init_src5();
    }
  });

  // ../draco/src/lib/draco-parser.ts
  function getDracoDataType(draco, attributeType) {
    switch (attributeType) {
      case Float32Array:
        return draco.DT_FLOAT32;
      case Int8Array:
        return draco.DT_INT8;
      case Int16Array:
        return draco.DT_INT16;
      case Int32Array:
        return draco.DT_INT32;
      case Uint8Array:
        return draco.DT_UINT8;
      case Uint16Array:
        return draco.DT_UINT16;
      case Uint32Array:
        return draco.DT_UINT32;
      default:
        return draco.DT_INVALID;
    }
  }
  function getInt32Array(dracoArray) {
    const numValues = dracoArray.size();
    const intArray = new Int32Array(numValues);
    for (let i2 = 0; i2 < numValues; i2++) {
      intArray[i2] = dracoArray.GetValue(i2);
    }
    return intArray;
  }
  function getUint32Array(dracoArray) {
    const numValues = dracoArray.size();
    const intArray = new Int32Array(numValues);
    for (let i2 = 0; i2 < numValues; i2++) {
      intArray[i2] = dracoArray.GetValue(i2);
    }
    return intArray;
  }
  var DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP, DRACO_DATA_TYPE_TO_TYPED_ARRAY_MAP, INDEX_ITEM_SIZE, DracoParser;
  var init_draco_parser = __esm({
    "../draco/src/lib/draco-parser.ts"() {
      init_src5();
      init_get_draco_schema();
      DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP = {
        POSITION: "POSITION",
        NORMAL: "NORMAL",
        COLOR: "COLOR_0",
        TEX_COORD: "TEXCOORD_0"
      };
      DRACO_DATA_TYPE_TO_TYPED_ARRAY_MAP = {
        1: Int8Array,
        2: Uint8Array,
        3: Int16Array,
        4: Uint16Array,
        5: Int32Array,
        6: Uint32Array,
        9: Float32Array
      };
      INDEX_ITEM_SIZE = 4;
      DracoParser = class {
        constructor(draco) {
          this.draco = draco;
          this.decoder = new this.draco.Decoder();
          this.metadataQuerier = new this.draco.MetadataQuerier();
        }
        destroy() {
          this.draco.destroy(this.decoder);
          this.draco.destroy(this.metadataQuerier);
        }
        parseSync(arrayBuffer, options = {}) {
          const buffer = new this.draco.DecoderBuffer();
          buffer.Init(new Int8Array(arrayBuffer), arrayBuffer.byteLength);
          this._disableAttributeTransforms(options);
          const geometry_type = this.decoder.GetEncodedGeometryType(buffer);
          const dracoGeometry = geometry_type === this.draco.TRIANGULAR_MESH ? new this.draco.Mesh() : new this.draco.PointCloud();
          try {
            let dracoStatus;
            switch (geometry_type) {
              case this.draco.TRIANGULAR_MESH:
                dracoStatus = this.decoder.DecodeBufferToMesh(buffer, dracoGeometry);
                break;
              case this.draco.POINT_CLOUD:
                dracoStatus = this.decoder.DecodeBufferToPointCloud(buffer, dracoGeometry);
                break;
              default:
                throw new Error("DRACO: Unknown geometry type.");
            }
            if (!dracoStatus.ok() || !dracoGeometry.ptr) {
              const message = `DRACO decompression failed: ${dracoStatus.error_msg()}`;
              throw new Error(message);
            }
            const loaderData = this._getDracoLoaderData(dracoGeometry, geometry_type, options);
            const geometry = this._getMeshData(dracoGeometry, loaderData, options);
            const boundingBox = getMeshBoundingBox(geometry.attributes);
            const schema = getDracoSchema(geometry.attributes, loaderData, geometry.indices);
            const data = {
              loader: "draco",
              loaderData,
              header: {
                vertexCount: dracoGeometry.num_points(),
                boundingBox
              },
              ...geometry,
              schema
            };
            return data;
          } finally {
            this.draco.destroy(buffer);
            if (dracoGeometry) {
              this.draco.destroy(dracoGeometry);
            }
          }
        }
        _getDracoLoaderData(dracoGeometry, geometry_type, options) {
          const metadata = this._getTopLevelMetadata(dracoGeometry);
          const attributes = this._getDracoAttributes(dracoGeometry, options);
          return {
            geometry_type,
            num_attributes: dracoGeometry.num_attributes(),
            num_points: dracoGeometry.num_points(),
            num_faces: dracoGeometry instanceof this.draco.Mesh ? dracoGeometry.num_faces() : 0,
            metadata,
            attributes
          };
        }
        _getDracoAttributes(dracoGeometry, options) {
          const dracoAttributes = {};
          for (let attributeId = 0; attributeId < dracoGeometry.num_attributes(); attributeId++) {
            const dracoAttribute = this.decoder.GetAttribute(dracoGeometry, attributeId);
            const metadata = this._getAttributeMetadata(dracoGeometry, attributeId);
            dracoAttributes[dracoAttribute.unique_id()] = {
              unique_id: dracoAttribute.unique_id(),
              attribute_type: dracoAttribute.attribute_type(),
              data_type: dracoAttribute.data_type(),
              num_components: dracoAttribute.num_components(),
              byte_offset: dracoAttribute.byte_offset(),
              byte_stride: dracoAttribute.byte_stride(),
              normalized: dracoAttribute.normalized(),
              attribute_index: attributeId,
              metadata
            };
            const quantization = this._getQuantizationTransform(dracoAttribute, options);
            if (quantization) {
              dracoAttributes[dracoAttribute.unique_id()].quantization_transform = quantization;
            }
            const octahedron = this._getOctahedronTransform(dracoAttribute, options);
            if (octahedron) {
              dracoAttributes[dracoAttribute.unique_id()].octahedron_transform = octahedron;
            }
          }
          return dracoAttributes;
        }
        _getMeshData(dracoGeometry, loaderData, options) {
          const attributes = this._getMeshAttributes(loaderData, dracoGeometry, options);
          const positionAttribute = attributes.POSITION;
          if (!positionAttribute) {
            throw new Error("DRACO: No position attribute found.");
          }
          if (dracoGeometry instanceof this.draco.Mesh) {
            switch (options.topology) {
              case "triangle-strip":
                return {
                  topology: "triangle-strip",
                  mode: 4,
                  attributes,
                  indices: {
                    value: this._getTriangleStripIndices(dracoGeometry),
                    size: 1
                  }
                };
              case "triangle-list":
              default:
                return {
                  topology: "triangle-list",
                  mode: 5,
                  attributes,
                  indices: {
                    value: this._getTriangleListIndices(dracoGeometry),
                    size: 1
                  }
                };
            }
          }
          return {
            topology: "point-list",
            mode: 0,
            attributes
          };
        }
        _getMeshAttributes(loaderData, dracoGeometry, options) {
          const attributes = {};
          for (const loaderAttribute of Object.values(loaderData.attributes)) {
            const attributeName = this._deduceAttributeName(loaderAttribute, options);
            loaderAttribute.name = attributeName;
            const { value, size } = this._getAttributeValues(dracoGeometry, loaderAttribute);
            attributes[attributeName] = {
              value,
              size,
              byteOffset: loaderAttribute.byte_offset,
              byteStride: loaderAttribute.byte_stride,
              normalized: loaderAttribute.normalized
            };
          }
          return attributes;
        }
        _getTriangleListIndices(dracoGeometry) {
          const numFaces = dracoGeometry.num_faces();
          const numIndices = numFaces * 3;
          const byteLength = numIndices * INDEX_ITEM_SIZE;
          const ptr = this.draco._malloc(byteLength);
          try {
            this.decoder.GetTrianglesUInt32Array(dracoGeometry, byteLength, ptr);
            return new Uint32Array(this.draco.HEAPF32.buffer, ptr, numIndices).slice();
          } finally {
            this.draco._free(ptr);
          }
        }
        _getTriangleStripIndices(dracoGeometry) {
          const dracoArray = new this.draco.DracoInt32Array();
          try {
            this.decoder.GetTriangleStripsFromMesh(dracoGeometry, dracoArray);
            return getUint32Array(dracoArray);
          } finally {
            this.draco.destroy(dracoArray);
          }
        }
        _getAttributeValues(dracoGeometry, attribute) {
          const TypedArrayCtor = DRACO_DATA_TYPE_TO_TYPED_ARRAY_MAP[attribute.data_type];
          const numComponents = attribute.num_components;
          const numPoints = dracoGeometry.num_points();
          const numValues = numPoints * numComponents;
          const byteLength = numValues * TypedArrayCtor.BYTES_PER_ELEMENT;
          const dataType = getDracoDataType(this.draco, TypedArrayCtor);
          let value;
          const ptr = this.draco._malloc(byteLength);
          try {
            const dracoAttribute = this.decoder.GetAttribute(dracoGeometry, attribute.attribute_index);
            this.decoder.GetAttributeDataArrayForAllPoints(dracoGeometry, dracoAttribute, dataType, byteLength, ptr);
            value = new TypedArrayCtor(this.draco.HEAPF32.buffer, ptr, numValues).slice();
          } finally {
            this.draco._free(ptr);
          }
          return { value, size: numComponents };
        }
        _deduceAttributeName(attribute, options) {
          const uniqueId = attribute.unique_id;
          for (const [attributeName, attributeUniqueId] of Object.entries(options.extraAttributes || {})) {
            if (attributeUniqueId === uniqueId) {
              return attributeName;
            }
          }
          const thisAttributeType = attribute.attribute_type;
          for (const dracoAttributeConstant in DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP) {
            const attributeType = this.draco[dracoAttributeConstant];
            if (attributeType === thisAttributeType) {
              return DRACO_TO_GLTF_ATTRIBUTE_NAME_MAP[dracoAttributeConstant];
            }
          }
          const entryName = options.attributeNameEntry || "name";
          if (attribute.metadata[entryName]) {
            return attribute.metadata[entryName].string;
          }
          return `CUSTOM_ATTRIBUTE_${uniqueId}`;
        }
        _getTopLevelMetadata(dracoGeometry) {
          const dracoMetadata = this.decoder.GetMetadata(dracoGeometry);
          return this._getDracoMetadata(dracoMetadata);
        }
        _getAttributeMetadata(dracoGeometry, attributeId) {
          const dracoMetadata = this.decoder.GetAttributeMetadata(dracoGeometry, attributeId);
          return this._getDracoMetadata(dracoMetadata);
        }
        _getDracoMetadata(dracoMetadata) {
          if (!dracoMetadata || !dracoMetadata.ptr) {
            return {};
          }
          const result = {};
          const numEntries = this.metadataQuerier.NumEntries(dracoMetadata);
          for (let entryIndex = 0; entryIndex < numEntries; entryIndex++) {
            const entryName = this.metadataQuerier.GetEntryName(dracoMetadata, entryIndex);
            result[entryName] = this._getDracoMetadataField(dracoMetadata, entryName);
          }
          return result;
        }
        _getDracoMetadataField(dracoMetadata, entryName) {
          const dracoArray = new this.draco.DracoInt32Array();
          try {
            this.metadataQuerier.GetIntEntryArray(dracoMetadata, entryName, dracoArray);
            const intArray = getInt32Array(dracoArray);
            return {
              int: this.metadataQuerier.GetIntEntry(dracoMetadata, entryName),
              string: this.metadataQuerier.GetStringEntry(dracoMetadata, entryName),
              double: this.metadataQuerier.GetDoubleEntry(dracoMetadata, entryName),
              intArray
            };
          } finally {
            this.draco.destroy(dracoArray);
          }
        }
        _disableAttributeTransforms(options) {
          const { quantizedAttributes = [], octahedronAttributes = [] } = options;
          const skipAttributes = [...quantizedAttributes, ...octahedronAttributes];
          for (const dracoAttributeName of skipAttributes) {
            this.decoder.SkipAttributeTransform(this.draco[dracoAttributeName]);
          }
        }
        _getQuantizationTransform(dracoAttribute, options) {
          const { quantizedAttributes = [] } = options;
          const attribute_type = dracoAttribute.attribute_type();
          const skip = quantizedAttributes.map((type) => this.decoder[type]).includes(attribute_type);
          if (skip) {
            const transform = new this.draco.AttributeQuantizationTransform();
            try {
              if (transform.InitFromAttribute(dracoAttribute)) {
                return {
                  quantization_bits: transform.quantization_bits(),
                  range: transform.range(),
                  min_values: new Float32Array([1, 2, 3]).map((i2) => transform.min_value(i2))
                };
              }
            } finally {
              this.draco.destroy(transform);
            }
          }
          return null;
        }
        _getOctahedronTransform(dracoAttribute, options) {
          const { octahedronAttributes = [] } = options;
          const attribute_type = dracoAttribute.attribute_type();
          const octahedron = octahedronAttributes.map((type) => this.decoder[type]).includes(attribute_type);
          if (octahedron) {
            const transform = new this.draco.AttributeQuantizationTransform();
            try {
              if (transform.InitFromAttribute(dracoAttribute)) {
                return {
                  quantization_bits: transform.quantization_bits()
                };
              }
            } finally {
              this.draco.destroy(transform);
            }
          }
          return null;
        }
      };
    }
  });

  // ../draco/src/lib/draco-module-loader.ts
  async function loadDracoDecoderModule(options) {
    const modules = options.modules || {};
    if (modules.draco3d) {
      loadDecoderPromise = loadDecoderPromise || modules.draco3d.createDecoderModule({}).then((draco) => {
        return { draco };
      });
    } else {
      loadDecoderPromise = loadDecoderPromise || loadDracoDecoder(options);
    }
    return await loadDecoderPromise;
  }
  async function loadDracoDecoder(options) {
    let DracoDecoderModule;
    let wasmBinary;
    switch (options.draco && options.draco.decoderType) {
      case "js":
        DracoDecoderModule = await loadLibrary(DRACO_JS_DECODER_URL, "draco", options);
        break;
      case "wasm":
      default:
        [DracoDecoderModule, wasmBinary] = await Promise.all([
          await loadLibrary(DRACO_WASM_WRAPPER_URL, "draco", options),
          await loadLibrary(DRACO_WASM_DECODER_URL, "draco", options)
        ]);
    }
    DracoDecoderModule = DracoDecoderModule || globalThis.DracoDecoderModule;
    return await initializeDracoDecoder(DracoDecoderModule, wasmBinary);
  }
  function initializeDracoDecoder(DracoDecoderModule, wasmBinary) {
    const options = {};
    if (wasmBinary) {
      options.wasmBinary = wasmBinary;
    }
    return new Promise((resolve2) => {
      DracoDecoderModule({
        ...options,
        onModuleLoaded: (draco) => resolve2({ draco })
      });
    });
  }
  var DRACO_DECODER_VERSION, DRACO_ENCODER_VERSION, STATIC_DECODER_URL, DRACO_JS_DECODER_URL, DRACO_WASM_WRAPPER_URL, DRACO_WASM_DECODER_URL, DRACO_ENCODER_URL, loadDecoderPromise;
  var init_draco_module_loader = __esm({
    "../draco/src/lib/draco-module-loader.ts"() {
      init_src();
      DRACO_DECODER_VERSION = "1.5.5";
      DRACO_ENCODER_VERSION = "1.4.1";
      STATIC_DECODER_URL = `https://www.gstatic.com/draco/versioned/decoders/${DRACO_DECODER_VERSION}`;
      DRACO_JS_DECODER_URL = `${STATIC_DECODER_URL}/draco_decoder.js`;
      DRACO_WASM_WRAPPER_URL = `${STATIC_DECODER_URL}/draco_wasm_wrapper.js`;
      DRACO_WASM_DECODER_URL = `${STATIC_DECODER_URL}/draco_decoder.wasm`;
      DRACO_ENCODER_URL = `https://raw.githubusercontent.com/google/draco/${DRACO_ENCODER_VERSION}/javascript/draco_encoder.js`;
    }
  });

  // ../draco/src/index.ts
  async function parse2(arrayBuffer, options) {
    const { draco } = await loadDracoDecoderModule(options);
    const dracoParser = new DracoParser(draco);
    try {
      return dracoParser.parseSync(arrayBuffer, options?.draco);
    } finally {
      dracoParser.destroy();
    }
  }
  var DracoLoader2;
  var init_src6 = __esm({
    "../draco/src/index.ts"() {
      init_draco_loader();
      init_draco_parser();
      init_draco_module_loader();
      DracoLoader2 = {
        ...DracoLoader,
        parse: parse2
      };
    }
  });

  // ../math/src/geometry/constants.ts
  var GL_PRIMITIVE_MODE, GL_TYPE, GL2;
  var init_constants5 = __esm({
    "../math/src/geometry/constants.ts"() {
      GL_PRIMITIVE_MODE = {
        POINTS: 0,
        LINES: 1,
        LINE_LOOP: 2,
        LINE_STRIP: 3,
        TRIANGLES: 4,
        TRIANGLE_STRIP: 5,
        TRIANGLE_FAN: 6
      };
      GL_TYPE = {
        BYTE: 5120,
        UNSIGNED_BYTE: 5121,
        SHORT: 5122,
        UNSIGNED_SHORT: 5123,
        INT: 5124,
        UNSIGNED_INT: 5125,
        FLOAT: 5126,
        DOUBLE: 5130
      };
      GL2 = {
        ...GL_PRIMITIVE_MODE,
        ...GL_TYPE
      };
    }
  });

  // ../math/src/geometry/gl/gl-type.ts
  var GL_TYPE_TO_ARRAY_TYPE, NAME_TO_GL_TYPE, ERR_TYPE_CONVERSION, GLType;
  var init_gl_type = __esm({
    "../math/src/geometry/gl/gl-type.ts"() {
      init_constants5();
      GL_TYPE_TO_ARRAY_TYPE = {
        [GL_TYPE.DOUBLE]: Float64Array,
        [GL_TYPE.FLOAT]: Float32Array,
        [GL_TYPE.UNSIGNED_SHORT]: Uint16Array,
        [GL_TYPE.UNSIGNED_INT]: Uint32Array,
        [GL_TYPE.UNSIGNED_BYTE]: Uint8Array,
        [GL_TYPE.BYTE]: Int8Array,
        [GL_TYPE.SHORT]: Int16Array,
        [GL_TYPE.INT]: Int32Array
      };
      NAME_TO_GL_TYPE = {
        DOUBLE: GL_TYPE.DOUBLE,
        FLOAT: GL_TYPE.FLOAT,
        UNSIGNED_SHORT: GL_TYPE.UNSIGNED_SHORT,
        UNSIGNED_INT: GL_TYPE.UNSIGNED_INT,
        UNSIGNED_BYTE: GL_TYPE.UNSIGNED_BYTE,
        BYTE: GL_TYPE.BYTE,
        SHORT: GL_TYPE.SHORT,
        INT: GL_TYPE.INT
      };
      ERR_TYPE_CONVERSION = "Failed to convert GL type";
      GLType = class {
        static fromTypedArray(arrayOrType) {
          arrayOrType = ArrayBuffer.isView(arrayOrType) ? arrayOrType.constructor : arrayOrType;
          for (const glType in GL_TYPE_TO_ARRAY_TYPE) {
            const ArrayType = GL_TYPE_TO_ARRAY_TYPE[glType];
            if (ArrayType === arrayOrType) {
              return glType;
            }
          }
          throw new Error(ERR_TYPE_CONVERSION);
        }
        static fromName(name10) {
          const glType = NAME_TO_GL_TYPE[name10];
          if (!glType) {
            throw new Error(ERR_TYPE_CONVERSION);
          }
          return glType;
        }
        static getArrayType(glType) {
          switch (glType) {
            case GL_TYPE.UNSIGNED_SHORT_5_6_5:
            case GL_TYPE.UNSIGNED_SHORT_4_4_4_4:
            case GL_TYPE.UNSIGNED_SHORT_5_5_5_1:
              return Uint16Array;
            default:
              const ArrayType = GL_TYPE_TO_ARRAY_TYPE[glType];
              if (!ArrayType) {
                throw new Error(ERR_TYPE_CONVERSION);
              }
              return ArrayType;
          }
        }
        static getByteSize(glType) {
          const ArrayType = GLType.getArrayType(glType);
          return ArrayType.BYTES_PER_ELEMENT;
        }
        static validate(glType) {
          return Boolean(GLType.getArrayType(glType));
        }
        static createTypedArray(glType, buffer, byteOffset = 0, length4) {
          if (length4 === void 0) {
            length4 = (buffer.byteLength - byteOffset) / GLType.getByteSize(glType);
          }
          const ArrayType = GLType.getArrayType(glType);
          return new ArrayType(buffer, byteOffset, length4);
        }
      };
    }
  });

  // ../math/src/geometry/utils/assert.ts
  function assert7(condition, message) {
    if (!condition) {
      throw new Error(`math.gl assertion failed. ${message}`);
    }
  }
  var init_assert6 = __esm({
    "../math/src/geometry/utils/assert.ts"() {
    }
  });

  // ../math/src/geometry/colors/rgb565.ts
  function decodeRGB565(rgb565, target = [0, 0, 0]) {
    const r5 = rgb565 >> 11 & 31;
    const g6 = rgb565 >> 5 & 63;
    const b5 = rgb565 & 31;
    target[0] = r5 << 3;
    target[1] = g6 << 2;
    target[2] = b5 << 3;
    return target;
  }
  var init_rgb565 = __esm({
    "../math/src/geometry/colors/rgb565.ts"() {
    }
  });

  // ../math/src/geometry/compression/attribute-compression.ts
  function fromSNorm(value, rangeMaximum = 255) {
    return clamp(value, 0, rangeMaximum) / rangeMaximum * 2 - 1;
  }
  function signNotZero(value) {
    return value < 0 ? -1 : 1;
  }
  function octDecodeInRange(x, y, rangeMax, result) {
    assert7(result);
    if (x < 0 || x > rangeMax || y < 0 || y > rangeMax) {
      throw new Error(`x and y must be unsigned normalized integers between 0 and ${rangeMax}`);
    }
    result.x = fromSNorm(x, rangeMax);
    result.y = fromSNorm(y, rangeMax);
    result.z = 1 - (Math.abs(result.x) + Math.abs(result.y));
    if (result.z < 0) {
      const oldVX = result.x;
      result.x = (1 - Math.abs(result.y)) * signNotZero(oldVX);
      result.y = (1 - Math.abs(oldVX)) * signNotZero(result.y);
    }
    return result.normalize();
  }
  function octDecode(x, y, result) {
    return octDecodeInRange(x, y, 255, result);
  }
  var RIGHT_SHIFT, scratchVector25, scratchVector34, scratchEncodeVector2, octEncodeScratch, uint8ForceArray;
  var init_attribute_compression = __esm({
    "../math/src/geometry/compression/attribute-compression.ts"() {
      init_esm();
      init_assert6();
      RIGHT_SHIFT = 1 / 256;
      scratchVector25 = new Vector2();
      scratchVector34 = new Vector3();
      scratchEncodeVector2 = new Vector2();
      octEncodeScratch = new Vector2();
      uint8ForceArray = new Uint8Array(1);
    }
  });

  // ../math/src/index.ts
  var init_src7 = __esm({
    "../math/src/index.ts"() {
      init_constants5();
      init_gl_type();
      init_rgb565();
      init_attribute_compression();
    }
  });

  // src/lib/classes/tile-3d-feature-table.ts
  var Tile3DFeatureTable;
  var init_tile_3d_feature_table = __esm({
    "src/lib/classes/tile-3d-feature-table.ts"() {
      init_src7();
      Tile3DFeatureTable = class {
        constructor(featureTableJson, featureTableBinary) {
          this.featuresLength = 0;
          this._cachedTypedArrays = {};
          this.json = featureTableJson;
          this.buffer = featureTableBinary;
        }
        getExtension(extensionName) {
          return this.json.extensions && this.json.extensions[extensionName];
        }
        hasProperty(propertyName) {
          return Boolean(this.json[propertyName]);
        }
        getGlobalProperty(propertyName, componentType = GL2.UNSIGNED_INT, componentLength = 1) {
          const jsonValue = this.json[propertyName];
          if (jsonValue && Number.isFinite(jsonValue.byteOffset)) {
            return this._getTypedArrayFromBinary(propertyName, componentType, componentLength, 1, jsonValue.byteOffset);
          }
          return jsonValue;
        }
        getPropertyArray(propertyName, componentType, componentLength) {
          const jsonValue = this.json[propertyName];
          if (jsonValue && Number.isFinite(jsonValue.byteOffset)) {
            if ("componentType" in jsonValue) {
              componentType = GLType.fromName(jsonValue.componentType);
            }
            return this._getTypedArrayFromBinary(propertyName, componentType, componentLength, this.featuresLength, jsonValue.byteOffset);
          }
          return this._getTypedArrayFromArray(propertyName, componentType, jsonValue);
        }
        getProperty(propertyName, componentType, componentLength, featureId, result) {
          const jsonValue = this.json[propertyName];
          if (!jsonValue) {
            return jsonValue;
          }
          const typedArray = this.getPropertyArray(propertyName, componentType, componentLength);
          if (componentLength === 1) {
            return typedArray[featureId];
          }
          for (let i2 = 0; i2 < componentLength; ++i2) {
            result[i2] = typedArray[componentLength * featureId + i2];
          }
          return result;
        }
        _getTypedArrayFromBinary(propertyName, componentType, componentLength, count, byteOffset) {
          const cachedTypedArrays = this._cachedTypedArrays;
          let typedArray = cachedTypedArrays[propertyName];
          if (!typedArray) {
            typedArray = GLType.createTypedArray(componentType, this.buffer.buffer, this.buffer.byteOffset + byteOffset, count * componentLength);
            cachedTypedArrays[propertyName] = typedArray;
          }
          return typedArray;
        }
        _getTypedArrayFromArray(propertyName, componentType, array) {
          const cachedTypedArrays = this._cachedTypedArrays;
          let typedArray = cachedTypedArrays[propertyName];
          if (!typedArray) {
            typedArray = GLType.createTypedArray(componentType, array);
            cachedTypedArrays[propertyName] = typedArray;
          }
          return typedArray;
        }
      };
    }
  });

  // src/lib/classes/helpers/tile-3d-accessor-utils.ts
  function createTypedArrayFromAccessor(tile3DAccessor, buffer, byteOffset, length4) {
    const { componentType } = tile3DAccessor;
    assert2(tile3DAccessor.componentType);
    const type = typeof componentType === "string" ? GLType.fromName(componentType) : componentType;
    const size = COMPONENTS_PER_ATTRIBUTE[tile3DAccessor.type];
    const unpacker = UNPACKER[tile3DAccessor.type];
    const packer = PACKER[tile3DAccessor.type];
    byteOffset += tile3DAccessor.byteOffset;
    const values = GLType.createTypedArray(type, buffer, byteOffset, size * length4);
    return {
      values,
      type,
      size,
      unpacker,
      packer
    };
  }
  var COMPONENTS_PER_ATTRIBUTE, UNPACKER, PACKER;
  var init_tile_3d_accessor_utils = __esm({
    "src/lib/classes/helpers/tile-3d-accessor-utils.ts"() {
      init_src7();
      init_src2();
      COMPONENTS_PER_ATTRIBUTE = {
        SCALAR: 1,
        VEC2: 2,
        VEC3: 3,
        VEC4: 4,
        MAT2: 4,
        MAT3: 9,
        MAT4: 16
      };
      UNPACKER = {
        SCALAR: (values, i2) => values[i2],
        VEC2: (values, i2) => [values[2 * i2 + 0], values[2 * i2 + 1]],
        VEC3: (values, i2) => [values[3 * i2 + 0], values[3 * i2 + 1], values[3 * i2 + 2]],
        VEC4: (values, i2) => [values[4 * i2 + 0], values[4 * i2 + 1], values[4 * i2 + 2], values[4 * i2 + 3]],
        MAT2: (values, i2) => [
          values[4 * i2 + 0],
          values[4 * i2 + 1],
          values[4 * i2 + 2],
          values[4 * i2 + 3]
        ],
        MAT3: (values, i2) => [
          values[9 * i2 + 0],
          values[9 * i2 + 1],
          values[9 * i2 + 2],
          values[9 * i2 + 3],
          values[9 * i2 + 4],
          values[9 * i2 + 5],
          values[9 * i2 + 6],
          values[9 * i2 + 7],
          values[9 * i2 + 8]
        ],
        MAT4: (values, i2) => [
          values[16 * i2 + 0],
          values[16 * i2 + 1],
          values[16 * i2 + 2],
          values[16 * i2 + 3],
          values[16 * i2 + 4],
          values[16 * i2 + 5],
          values[16 * i2 + 6],
          values[16 * i2 + 7],
          values[16 * i2 + 8],
          values[16 * i2 + 9],
          values[16 * i2 + 10],
          values[16 * i2 + 11],
          values[16 * i2 + 12],
          values[16 * i2 + 13],
          values[16 * i2 + 14],
          values[16 * i2 + 15]
        ]
      };
      PACKER = {
        SCALAR: (x, values, i2) => {
          values[i2] = x;
        },
        VEC2: (x, values, i2) => {
          values[2 * i2 + 0] = x[0];
          values[2 * i2 + 1] = x[1];
        },
        VEC3: (x, values, i2) => {
          values[3 * i2 + 0] = x[0];
          values[3 * i2 + 1] = x[1];
          values[3 * i2 + 2] = x[2];
        },
        VEC4: (x, values, i2) => {
          values[4 * i2 + 0] = x[0];
          values[4 * i2 + 1] = x[1];
          values[4 * i2 + 2] = x[2];
          values[4 * i2 + 3] = x[3];
        },
        MAT2: (x, values, i2) => {
          values[4 * i2 + 0] = x[0];
          values[4 * i2 + 1] = x[1];
          values[4 * i2 + 2] = x[2];
          values[4 * i2 + 3] = x[3];
        },
        MAT3: (x, values, i2) => {
          values[9 * i2 + 0] = x[0];
          values[9 * i2 + 1] = x[1];
          values[9 * i2 + 2] = x[2];
          values[9 * i2 + 3] = x[3];
          values[9 * i2 + 4] = x[4];
          values[9 * i2 + 5] = x[5];
          values[9 * i2 + 6] = x[6];
          values[9 * i2 + 7] = x[7];
          values[9 * i2 + 8] = x[8];
          values[9 * i2 + 9] = x[9];
        },
        MAT4: (x, values, i2) => {
          values[16 * i2 + 0] = x[0];
          values[16 * i2 + 1] = x[1];
          values[16 * i2 + 2] = x[2];
          values[16 * i2 + 3] = x[3];
          values[16 * i2 + 4] = x[4];
          values[16 * i2 + 5] = x[5];
          values[16 * i2 + 6] = x[6];
          values[16 * i2 + 7] = x[7];
          values[16 * i2 + 8] = x[8];
          values[16 * i2 + 9] = x[9];
          values[16 * i2 + 10] = x[10];
          values[16 * i2 + 11] = x[11];
          values[16 * i2 + 12] = x[12];
          values[16 * i2 + 13] = x[13];
          values[16 * i2 + 14] = x[14];
          values[16 * i2 + 15] = x[15];
        }
      };
    }
  });

  // src/lib/classes/tile-3d-batch-table-hierarchy.ts
  function initializeHierarchy(batchTable, jsonHeader, binaryBody) {
    if (!jsonHeader) {
      return null;
    }
    let hierarchy = batchTable.getExtension("3DTILES_batch_table_hierarchy");
    const legacyHierarchy = jsonHeader.HIERARCHY;
    if (legacyHierarchy) {
      console.warn("3D Tile Parser: HIERARCHY is deprecated. Use 3DTILES_batch_table_hierarchy.");
      jsonHeader.extensions = jsonHeader.extensions || {};
      jsonHeader.extensions["3DTILES_batch_table_hierarchy"] = legacyHierarchy;
      hierarchy = legacyHierarchy;
    }
    if (!hierarchy) {
      return null;
    }
    return initializeHierarchyValues(hierarchy, binaryBody);
  }
  function initializeHierarchyValues(hierarchyJson, binaryBody) {
    let i2;
    let classId;
    let binaryAccessor;
    const instancesLength = hierarchyJson.instancesLength;
    const classes = hierarchyJson.classes;
    let classIds = hierarchyJson.classIds;
    let parentCounts = hierarchyJson.parentCounts;
    let parentIds = hierarchyJson.parentIds;
    let parentIdsLength = instancesLength;
    if (defined(classIds.byteOffset)) {
      classIds.componentType = defaultValue(classIds.componentType, GL.UNSIGNED_SHORT);
      classIds.type = AttributeType.SCALAR;
      binaryAccessor = getBinaryAccessor(classIds);
      classIds = binaryAccessor.createArrayBufferView(binaryBody.buffer, binaryBody.byteOffset + classIds.byteOffset, instancesLength);
    }
    let parentIndexes;
    if (defined(parentCounts)) {
      if (defined(parentCounts.byteOffset)) {
        parentCounts.componentType = defaultValue(parentCounts.componentType, GL.UNSIGNED_SHORT);
        parentCounts.type = AttributeType.SCALAR;
        binaryAccessor = getBinaryAccessor(parentCounts);
        parentCounts = binaryAccessor.createArrayBufferView(binaryBody.buffer, binaryBody.byteOffset + parentCounts.byteOffset, instancesLength);
      }
      parentIndexes = new Uint16Array(instancesLength);
      parentIdsLength = 0;
      for (i2 = 0; i2 < instancesLength; ++i2) {
        parentIndexes[i2] = parentIdsLength;
        parentIdsLength += parentCounts[i2];
      }
    }
    if (defined(parentIds) && defined(parentIds.byteOffset)) {
      parentIds.componentType = defaultValue(parentIds.componentType, GL.UNSIGNED_SHORT);
      parentIds.type = AttributeType.SCALAR;
      binaryAccessor = getBinaryAccessor(parentIds);
      parentIds = binaryAccessor.createArrayBufferView(binaryBody.buffer, binaryBody.byteOffset + parentIds.byteOffset, parentIdsLength);
    }
    const classesLength = classes.length;
    for (i2 = 0; i2 < classesLength; ++i2) {
      const classInstancesLength = classes[i2].length;
      const properties = classes[i2].instances;
      const binaryProperties = getBinaryProperties(classInstancesLength, properties, binaryBody);
      classes[i2].instances = combine(binaryProperties, properties);
    }
    const classCounts = new Array(classesLength).fill(0);
    const classIndexes = new Uint16Array(instancesLength);
    for (i2 = 0; i2 < instancesLength; ++i2) {
      classId = classIds[i2];
      classIndexes[i2] = classCounts[classId];
      ++classCounts[classId];
    }
    const hierarchy = {
      classes,
      classIds,
      classIndexes,
      parentCounts,
      parentIndexes,
      parentIds
    };
    validateHierarchy(hierarchy);
    return hierarchy;
  }
  function traverseHierarchy(hierarchy, instanceIndex, endConditionCallback) {
    if (!hierarchy) {
      return;
    }
    const parentCounts = hierarchy.parentCounts;
    const parentIds = hierarchy.parentIds;
    if (parentIds) {
      return endConditionCallback(hierarchy, instanceIndex);
    }
    if (parentCounts > 0) {
      return traverseHierarchyMultipleParents(hierarchy, instanceIndex, endConditionCallback);
    }
    return traverseHierarchySingleParent(hierarchy, instanceIndex, endConditionCallback);
  }
  function traverseHierarchyMultipleParents(hierarchy, instanceIndex, endConditionCallback) {
    const classIds = hierarchy.classIds;
    const parentCounts = hierarchy.parentCounts;
    const parentIds = hierarchy.parentIds;
    const parentIndexes = hierarchy.parentIndexes;
    const instancesLength = classIds.length;
    const visited = scratchVisited;
    visited.length = Math.max(visited.length, instancesLength);
    const visitedMarker = ++marker;
    const stack2 = scratchStack;
    stack2.length = 0;
    stack2.push(instanceIndex);
    while (stack2.length > 0) {
      instanceIndex = stack2.pop();
      if (visited[instanceIndex] === visitedMarker) {
        continue;
      }
      visited[instanceIndex] = visitedMarker;
      const result = endConditionCallback(hierarchy, instanceIndex);
      if (defined(result)) {
        return result;
      }
      const parentCount = parentCounts[instanceIndex];
      const parentIndex = parentIndexes[instanceIndex];
      for (let i2 = 0; i2 < parentCount; ++i2) {
        const parentId = parentIds[parentIndex + i2];
        if (parentId !== instanceIndex) {
          stack2.push(parentId);
        }
      }
    }
    return null;
  }
  function traverseHierarchySingleParent(hierarchy, instanceIndex, endConditionCallback) {
    let hasParent = true;
    while (hasParent) {
      const result = endConditionCallback(hierarchy, instanceIndex);
      if (defined(result)) {
        return result;
      }
      const parentId = hierarchy.parentIds[instanceIndex];
      hasParent = parentId !== instanceIndex;
      instanceIndex = parentId;
    }
    throw new Error("traverseHierarchySingleParent");
  }
  function validateHierarchy(hierarchy) {
    const scratchValidateStack = [];
    const classIds = hierarchy.classIds;
    const instancesLength = classIds.length;
    for (let i2 = 0; i2 < instancesLength; ++i2) {
      validateInstance(hierarchy, i2, stack);
    }
  }
  function validateInstance(hierarchy, instanceIndex, stack2) {
    const parentCounts = hierarchy.parentCounts;
    const parentIds = hierarchy.parentIds;
    const parentIndexes = hierarchy.parentIndexes;
    const classIds = hierarchy.classIds;
    const instancesLength = classIds.length;
    if (!defined(parentIds)) {
      return;
    }
    assert(instanceIndex < instancesLength, `Parent index ${instanceIndex} exceeds the total number of instances: ${instancesLength}`);
    assert(stack2.indexOf(instanceIndex) === -1, "Circular dependency detected in the batch table hierarchy.");
    stack2.push(instanceIndex);
    const parentCount = defined(parentCounts) ? parentCounts[instanceIndex] : 1;
    const parentIndex = defined(parentCounts) ? parentIndexes[instanceIndex] : instanceIndex;
    for (let i2 = 0; i2 < parentCount; ++i2) {
      const parentId = parentIds[parentIndex + i2];
      if (parentId !== instanceIndex) {
        validateInstance(hierarchy, parentId, stack2);
      }
    }
    stack2.pop(instanceIndex);
  }
  var defined;
  var init_tile_3d_batch_table_hierarchy = __esm({
    "src/lib/classes/tile-3d-batch-table-hierarchy.ts"() {
      defined = (x) => x !== void 0;
    }
  });

  // src/lib/classes/tile-3d-batch-table.ts
  function defined2(x) {
    return x !== void 0 && x !== null;
  }
  var clone3, IGNORED_PROPERTY_FIELDS, Tile3DBatchTableParser;
  var init_tile_3d_batch_table = __esm({
    "src/lib/classes/tile-3d-batch-table.ts"() {
      init_src2();
      init_tile_3d_accessor_utils();
      init_tile_3d_batch_table_hierarchy();
      clone3 = (x, y) => x;
      IGNORED_PROPERTY_FIELDS = {
        HIERARCHY: true,
        extensions: true,
        extras: true
      };
      Tile3DBatchTableParser = class {
        constructor(json, binary, featureCount, options = {}) {
          assert2(featureCount >= 0);
          this.json = json || {};
          this.binary = binary;
          this.featureCount = featureCount;
          this._extensions = this.json?.extensions || {};
          this._properties = {};
          for (const propertyName in this.json) {
            if (!IGNORED_PROPERTY_FIELDS[propertyName]) {
              this._properties[propertyName] = this.json[propertyName];
            }
          }
          this._binaryProperties = this._initializeBinaryProperties();
          if (options["3DTILES_batch_table_hierarchy"]) {
            this._hierarchy = initializeHierarchy(this, this.json, this.binary);
          }
        }
        getExtension(extensionName) {
          return this.json && this.json.extensions && this.json.extensions[extensionName];
        }
        memorySizeInBytes() {
          return 0;
        }
        isClass(batchId, className) {
          this._checkBatchId(batchId);
          assert2(typeof className === "string", className);
          if (this._hierarchy) {
            const result = traverseHierarchy(this._hierarchy, batchId, (hierarchy, instanceIndex) => {
              const classId = hierarchy.classIds[instanceIndex];
              const instanceClass = hierarchy.classes[classId];
              return instanceClass.name === className;
            });
            return defined2(result);
          }
          return false;
        }
        isExactClass(batchId, className) {
          assert2(typeof className === "string", className);
          return this.getExactClassName(batchId) === className;
        }
        getExactClassName(batchId) {
          this._checkBatchId(batchId);
          if (this._hierarchy) {
            const classId = this._hierarchy.classIds[batchId];
            const instanceClass = this._hierarchy.classes[classId];
            return instanceClass.name;
          }
          return void 0;
        }
        hasProperty(batchId, name10) {
          this._checkBatchId(batchId);
          assert2(typeof name10 === "string", name10);
          return defined2(this._properties[name10]) || this._hasPropertyInHierarchy(batchId, name10);
        }
        getPropertyNames(batchId, results) {
          this._checkBatchId(batchId);
          results = defined2(results) ? results : [];
          results.length = 0;
          const propertyNames = Object.keys(this._properties);
          results.push(...propertyNames);
          if (this._hierarchy) {
            this._getPropertyNamesInHierarchy(batchId, results);
          }
          return results;
        }
        getProperty(batchId, name10) {
          this._checkBatchId(batchId);
          assert2(typeof name10 === "string", name10);
          if (this._binaryProperties) {
            const binaryProperty = this._binaryProperties[name10];
            if (defined2(binaryProperty)) {
              return this._getBinaryProperty(binaryProperty, batchId);
            }
          }
          const propertyValues = this._properties[name10];
          if (defined2(propertyValues)) {
            return clone3(propertyValues[batchId], true);
          }
          if (this._hierarchy) {
            const hierarchyProperty = this._getHierarchyProperty(batchId, name10);
            if (defined2(hierarchyProperty)) {
              return hierarchyProperty;
            }
          }
          return void 0;
        }
        setProperty(batchId, name10, value) {
          const featureCount = this.featureCount;
          this._checkBatchId(batchId);
          assert2(typeof name10 === "string", name10);
          if (this._binaryProperties) {
            const binaryProperty = this._binaryProperties[name10];
            if (binaryProperty) {
              this._setBinaryProperty(binaryProperty, batchId, value);
              return;
            }
          }
          if (this._hierarchy) {
            if (this._setHierarchyProperty(this, batchId, name10, value)) {
              return;
            }
          }
          let propertyValues = this._properties[name10];
          if (!defined2(propertyValues)) {
            this._properties[name10] = new Array(featureCount);
            propertyValues = this._properties[name10];
          }
          propertyValues[batchId] = clone3(value, true);
        }
        _checkBatchId(batchId) {
          const valid = batchId >= 0 && batchId < this.featureCount;
          if (!valid) {
            throw new Error("batchId not in range [0, featureCount - 1].");
          }
        }
        _getBinaryProperty(binaryProperty, index) {
          return binaryProperty.unpack(binaryProperty.typedArray, index);
        }
        _setBinaryProperty(binaryProperty, index, value) {
          binaryProperty.pack(value, binaryProperty.typedArray, index);
        }
        _initializeBinaryProperties() {
          let binaryProperties = null;
          for (const name10 in this._properties) {
            const property = this._properties[name10];
            const binaryProperty = this._initializeBinaryProperty(name10, property);
            if (binaryProperty) {
              binaryProperties = binaryProperties || {};
              binaryProperties[name10] = binaryProperty;
            }
          }
          return binaryProperties;
        }
        _initializeBinaryProperty(name10, property) {
          if ("byteOffset" in property) {
            const tile3DAccessor = property;
            assert2(this.binary, `Property ${name10} requires a batch table binary.`);
            assert2(tile3DAccessor.type, `Property ${name10} requires a type.`);
            const accessor = createTypedArrayFromAccessor(tile3DAccessor, this.binary.buffer, this.binary.byteOffset | 0, this.featureCount);
            return {
              typedArray: accessor.values,
              componentCount: accessor.size,
              unpack: accessor.unpacker,
              pack: accessor.packer
            };
          }
          return null;
        }
        _hasPropertyInHierarchy(batchId, name10) {
          if (!this._hierarchy) {
            return false;
          }
          const result = traverseHierarchy(this._hierarchy, batchId, (hierarchy, instanceIndex) => {
            const classId = hierarchy.classIds[instanceIndex];
            const instances = hierarchy.classes[classId].instances;
            return defined2(instances[name10]);
          });
          return defined2(result);
        }
        _getPropertyNamesInHierarchy(batchId, results) {
          traverseHierarchy(this._hierarchy, batchId, (hierarchy, instanceIndex) => {
            const classId = hierarchy.classIds[instanceIndex];
            const instances = hierarchy.classes[classId].instances;
            for (const name10 in instances) {
              if (instances.hasOwnProperty(name10)) {
                if (results.indexOf(name10) === -1) {
                  results.push(name10);
                }
              }
            }
          });
        }
        _getHierarchyProperty(batchId, name10) {
          return traverseHierarchy(this._hierarchy, batchId, (hierarchy, instanceIndex) => {
            const classId = hierarchy.classIds[instanceIndex];
            const instanceClass = hierarchy.classes[classId];
            const indexInClass = hierarchy.classIndexes[instanceIndex];
            const propertyValues = instanceClass.instances[name10];
            if (defined2(propertyValues)) {
              if (defined2(propertyValues.typedArray)) {
                return this._getBinaryProperty(propertyValues, indexInClass);
              }
              return clone3(propertyValues[indexInClass], true);
            }
            return null;
          });
        }
        _setHierarchyProperty(batchTable, batchId, name10, value) {
          const result = traverseHierarchy(this._hierarchy, batchId, (hierarchy, instanceIndex) => {
            const classId = hierarchy.classIds[instanceIndex];
            const instanceClass = hierarchy.classes[classId];
            const indexInClass = hierarchy.classIndexes[instanceIndex];
            const propertyValues = instanceClass.instances[name10];
            if (defined2(propertyValues)) {
              assert2(instanceIndex === batchId, `Inherited property "${name10}" is read-only.`);
              if (defined2(propertyValues.typedArray)) {
                this._setBinaryProperty(propertyValues, indexInClass, value);
              } else {
                propertyValues[indexInClass] = clone3(value, true);
              }
              return true;
            }
            return false;
          });
          return defined2(result);
        }
      };
    }
  });

  // src/lib/parsers/helpers/parse-3d-tile-header.ts
  function parse3DTileHeaderSync(tile, arrayBuffer, byteOffset = 0) {
    const view = new DataView(arrayBuffer);
    tile.magic = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT32;
    tile.version = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT32;
    tile.byteLength = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT32;
    if (tile.version !== 1) {
      throw new Error(`3D Tile Version ${tile.version} not supported`);
    }
    return byteOffset;
  }
  var SIZEOF_UINT32;
  var init_parse_3d_tile_header = __esm({
    "src/lib/parsers/helpers/parse-3d-tile-header.ts"() {
      SIZEOF_UINT32 = 4;
    }
  });

  // src/lib/parsers/helpers/parse-3d-tile-tables.ts
  function parse3DTileTablesHeaderSync(tile, arrayBuffer, byteOffset) {
    const view = new DataView(arrayBuffer);
    let batchLength;
    tile.header = tile.header || {};
    let featureTableJsonByteLength = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT322;
    let featureTableBinaryByteLength = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT322;
    let batchTableJsonByteLength = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT322;
    let batchTableBinaryByteLength = view.getUint32(byteOffset, true);
    byteOffset += SIZEOF_UINT322;
    if (batchTableJsonByteLength >= 570425344) {
      byteOffset -= SIZEOF_UINT322 * 2;
      batchLength = featureTableJsonByteLength;
      batchTableJsonByteLength = featureTableBinaryByteLength;
      batchTableBinaryByteLength = 0;
      featureTableJsonByteLength = 0;
      featureTableBinaryByteLength = 0;
      console.warn(DEPRECATION_WARNING);
    } else if (batchTableBinaryByteLength >= 570425344) {
      byteOffset -= SIZEOF_UINT322;
      batchLength = batchTableJsonByteLength;
      batchTableJsonByteLength = featureTableJsonByteLength;
      batchTableBinaryByteLength = featureTableBinaryByteLength;
      featureTableJsonByteLength = 0;
      featureTableBinaryByteLength = 0;
      console.warn(DEPRECATION_WARNING);
    }
    tile.header.featureTableJsonByteLength = featureTableJsonByteLength;
    tile.header.featureTableBinaryByteLength = featureTableBinaryByteLength;
    tile.header.batchTableJsonByteLength = batchTableJsonByteLength;
    tile.header.batchTableBinaryByteLength = batchTableBinaryByteLength;
    tile.header.batchLength = batchLength;
    return byteOffset;
  }
  function parse3DTileTablesSync(tile, arrayBuffer, byteOffset, options) {
    byteOffset = parse3DTileFeatureTable(tile, arrayBuffer, byteOffset, options);
    byteOffset = parse3DTileBatchTable(tile, arrayBuffer, byteOffset, options);
    return byteOffset;
  }
  function parse3DTileFeatureTable(tile, arrayBuffer, byteOffset, options) {
    const { featureTableJsonByteLength, featureTableBinaryByteLength, batchLength } = tile.header;
    tile.featureTableJson = {
      BATCH_LENGTH: batchLength || 0
    };
    if (featureTableJsonByteLength > 0) {
      const featureTableString = getStringFromArrayBuffer(arrayBuffer, byteOffset, featureTableJsonByteLength);
      tile.featureTableJson = JSON.parse(featureTableString);
    }
    byteOffset += featureTableJsonByteLength;
    tile.featureTableBinary = new Uint8Array(arrayBuffer, byteOffset, featureTableBinaryByteLength);
    byteOffset += featureTableBinaryByteLength;
    return byteOffset;
  }
  function parse3DTileBatchTable(tile, arrayBuffer, byteOffset, options) {
    const { batchTableJsonByteLength, batchTableBinaryByteLength } = tile.header;
    if (batchTableJsonByteLength > 0) {
      const batchTableString = getStringFromArrayBuffer(arrayBuffer, byteOffset, batchTableJsonByteLength);
      tile.batchTableJson = JSON.parse(batchTableString);
      byteOffset += batchTableJsonByteLength;
      if (batchTableBinaryByteLength > 0) {
        tile.batchTableBinary = new Uint8Array(arrayBuffer, byteOffset, batchTableBinaryByteLength);
        tile.batchTableBinary = new Uint8Array(tile.batchTableBinary);
        byteOffset += batchTableBinaryByteLength;
      }
    }
    return byteOffset;
  }
  var SIZEOF_UINT322, DEPRECATION_WARNING;
  var init_parse_3d_tile_tables = __esm({
    "src/lib/parsers/helpers/parse-3d-tile-tables.ts"() {
      init_parse_utils();
      SIZEOF_UINT322 = 4;
      DEPRECATION_WARNING = "b3dm tile in legacy format.";
    }
  });

  // src/lib/parsers/helpers/normalize-3d-tile-colors.ts
  function normalize3DTileColorAttribute(tile, colors, batchTable) {
    if (!colors && (!tile || !tile.batchIds || !batchTable)) {
      return null;
    }
    const { batchIds, isRGB565, pointCount } = tile;
    if (batchIds && batchTable) {
      const colorArray = new Uint8ClampedArray(pointCount * 3);
      for (let i2 = 0; i2 < pointCount; i2++) {
        const batchId = batchIds[i2];
        const dimensions = batchTable.getProperty(batchId, "dimensions");
        const color = dimensions.map((d) => d * 255);
        colorArray[i2 * 3] = color[0];
        colorArray[i2 * 3 + 1] = color[1];
        colorArray[i2 * 3 + 2] = color[2];
      }
      return {
        type: GL2.UNSIGNED_BYTE,
        value: colorArray,
        size: 3,
        normalized: true
      };
    }
    if (isRGB565) {
      const colorArray = new Uint8ClampedArray(pointCount * 3);
      for (let i2 = 0; i2 < pointCount; i2++) {
        const color = decodeRGB565(colors[i2]);
        colorArray[i2 * 3] = color[0];
        colorArray[i2 * 3 + 1] = color[1];
        colorArray[i2 * 3 + 2] = color[2];
      }
      return {
        type: GL2.UNSIGNED_BYTE,
        value: colorArray,
        size: 3,
        normalized: true
      };
    }
    if (colors && colors.length === pointCount * 3) {
      return {
        type: GL2.UNSIGNED_BYTE,
        value: colors,
        size: 3,
        normalized: true
      };
    }
    return {
      type: GL2.UNSIGNED_BYTE,
      value: colors,
      size: 4,
      normalized: true
    };
  }
  var init_normalize_3d_tile_colors = __esm({
    "src/lib/parsers/helpers/normalize-3d-tile-colors.ts"() {
      init_src7();
    }
  });

  // src/lib/parsers/helpers/normalize-3d-tile-normals.ts
  function normalize3DTileNormalAttribute(tile, normals) {
    if (!normals) {
      return null;
    }
    if (tile.isOctEncoded16P) {
      const decodedArray = new Float32Array(tile.pointsLength * 3);
      for (let i2 = 0; i2 < tile.pointsLength; i2++) {
        octDecode(normals[i2 * 2], normals[i2 * 2 + 1], scratchNormal4);
        scratchNormal4.toArray(decodedArray, i2 * 3);
      }
      return {
        type: GL2.FLOAT,
        size: 2,
        value: decodedArray
      };
    }
    return {
      type: GL2.FLOAT,
      size: 2,
      value: normals
    };
  }
  var scratchNormal4;
  var init_normalize_3d_tile_normals = __esm({
    "src/lib/parsers/helpers/normalize-3d-tile-normals.ts"() {
      init_esm();
      init_src7();
      scratchNormal4 = new Vector3();
    }
  });

  // src/lib/parsers/helpers/normalize-3d-tile-positions.ts
  function normalize3DTilePositionAttribute(tile, positions, options) {
    if (!tile.isQuantized) {
      return positions;
    }
    if (options["3d-tiles"] && options["3d-tiles"].decodeQuantizedPositions) {
      tile.isQuantized = false;
      return decodeQuantizedPositions(tile, positions);
    }
    return {
      type: GL2.UNSIGNED_SHORT,
      value: positions,
      size: 3,
      normalized: true
    };
  }
  function decodeQuantizedPositions(tile, positions) {
    const scratchPosition3 = new Vector3();
    const decodedArray = new Float32Array(tile.pointCount * 3);
    for (let i2 = 0; i2 < tile.pointCount; i2++) {
      scratchPosition3.set(positions[i2 * 3], positions[i2 * 3 + 1], positions[i2 * 3 + 2]).scale(1 / tile.quantizedRange).multiply(tile.quantizedVolumeScale).add(tile.quantizedVolumeOffset).toArray(decodedArray, i2 * 3);
    }
    return decodedArray;
  }
  var init_normalize_3d_tile_positions = __esm({
    "src/lib/parsers/helpers/normalize-3d-tile-positions.ts"() {
      init_esm();
      init_src7();
    }
  });

  // src/lib/parsers/parse-3d-tile-point-cloud.ts
  async function parsePointCloud3DTile(tile, arrayBuffer, byteOffset, options, context) {
    byteOffset = parse3DTileHeaderSync(tile, arrayBuffer, byteOffset);
    byteOffset = parse3DTileTablesHeaderSync(tile, arrayBuffer, byteOffset);
    byteOffset = parse3DTileTablesSync(tile, arrayBuffer, byteOffset, options);
    initializeTile(tile);
    const { featureTable, batchTable } = parsePointCloudTables(tile);
    await parseDraco(tile, featureTable, batchTable, options, context);
    parsePositions(tile, featureTable, options);
    parseColors(tile, featureTable, batchTable);
    parseNormals(tile, featureTable);
    return byteOffset;
  }
  function initializeTile(tile) {
    tile.attributes = {
      positions: null,
      colors: null,
      normals: null,
      batchIds: null
    };
    tile.isQuantized = false;
    tile.isTranslucent = false;
    tile.isRGB565 = false;
    tile.isOctEncoded16P = false;
  }
  function parsePointCloudTables(tile) {
    const featureTable = new Tile3DFeatureTable(tile.featureTableJson, tile.featureTableBinary);
    const pointsLength = featureTable.getGlobalProperty("POINTS_LENGTH");
    if (!Number.isFinite(pointsLength)) {
      throw new Error("POINTS_LENGTH must be defined");
    }
    featureTable.featuresLength = pointsLength;
    tile.featuresLength = pointsLength;
    tile.pointsLength = pointsLength;
    tile.pointCount = pointsLength;
    tile.rtcCenter = featureTable.getGlobalProperty("RTC_CENTER", GL2.FLOAT, 3);
    const batchTable = parseBatchIds(tile, featureTable);
    return { featureTable, batchTable };
  }
  function parsePositions(tile, featureTable, options) {
    if (!tile.attributes.positions) {
      if (featureTable.hasProperty("POSITION")) {
        tile.attributes.positions = featureTable.getPropertyArray("POSITION", GL2.FLOAT, 3);
      } else if (featureTable.hasProperty("POSITION_QUANTIZED")) {
        const positions = featureTable.getPropertyArray("POSITION_QUANTIZED", GL2.UNSIGNED_SHORT, 3);
        tile.isQuantized = true;
        tile.quantizedRange = (1 << 16) - 1;
        tile.quantizedVolumeScale = featureTable.getGlobalProperty("QUANTIZED_VOLUME_SCALE", GL2.FLOAT, 3);
        if (!tile.quantizedVolumeScale) {
          throw new Error("QUANTIZED_VOLUME_SCALE must be defined for quantized positions.");
        }
        tile.quantizedVolumeOffset = featureTable.getGlobalProperty("QUANTIZED_VOLUME_OFFSET", GL2.FLOAT, 3);
        if (!tile.quantizedVolumeOffset) {
          throw new Error("QUANTIZED_VOLUME_OFFSET must be defined for quantized positions.");
        }
        tile.attributes.positions = normalize3DTilePositionAttribute(tile, positions, options);
      }
    }
    if (!tile.attributes.positions) {
      throw new Error("Either POSITION or POSITION_QUANTIZED must be defined.");
    }
  }
  function parseColors(tile, featureTable, batchTable) {
    if (!tile.attributes.colors) {
      let colors = null;
      if (featureTable.hasProperty("RGBA")) {
        colors = featureTable.getPropertyArray("RGBA", GL2.UNSIGNED_BYTE, 4);
        tile.isTranslucent = true;
      } else if (featureTable.hasProperty("RGB")) {
        colors = featureTable.getPropertyArray("RGB", GL2.UNSIGNED_BYTE, 3);
      } else if (featureTable.hasProperty("RGB565")) {
        colors = featureTable.getPropertyArray("RGB565", GL2.UNSIGNED_SHORT, 1);
        tile.isRGB565 = true;
      }
      tile.attributes.colors = normalize3DTileColorAttribute(tile, colors, batchTable);
    }
    if (featureTable.hasProperty("CONSTANT_RGBA")) {
      tile.constantRGBA = featureTable.getGlobalProperty("CONSTANT_RGBA", GL2.UNSIGNED_BYTE, 4);
    }
  }
  function parseNormals(tile, featureTable) {
    if (!tile.attributes.normals) {
      let normals = null;
      if (featureTable.hasProperty("NORMAL")) {
        normals = featureTable.getPropertyArray("NORMAL", GL2.FLOAT, 3);
      } else if (featureTable.hasProperty("NORMAL_OCT16P")) {
        normals = featureTable.getPropertyArray("NORMAL_OCT16P", GL2.UNSIGNED_BYTE, 2);
        tile.isOctEncoded16P = true;
      }
      tile.attributes.normals = normalize3DTileNormalAttribute(tile, normals);
    }
  }
  function parseBatchIds(tile, featureTable) {
    let batchTable = null;
    if (!tile.batchIds && featureTable.hasProperty("BATCH_ID")) {
      tile.batchIds = featureTable.getPropertyArray("BATCH_ID", GL2.UNSIGNED_SHORT, 1);
      if (tile.batchIds) {
        const batchFeatureLength = featureTable.getGlobalProperty("BATCH_LENGTH");
        if (!batchFeatureLength) {
          throw new Error("Global property: BATCH_LENGTH must be defined when BATCH_ID is defined.");
        }
        const { batchTableJson, batchTableBinary } = tile;
        batchTable = new Tile3DBatchTableParser(batchTableJson, batchTableBinary, batchFeatureLength);
      }
    }
    return batchTable;
  }
  async function parseDraco(tile, featureTable, batchTable, options, context) {
    let dracoBuffer;
    let dracoFeatureTableProperties;
    let dracoBatchTableProperties;
    const batchTableDraco = tile.batchTableJson && tile.batchTableJson.extensions && tile.batchTableJson.extensions["3DTILES_draco_point_compression"];
    if (batchTableDraco) {
      dracoBatchTableProperties = batchTableDraco.properties;
    }
    const featureTableDraco = featureTable.getExtension("3DTILES_draco_point_compression");
    if (featureTableDraco) {
      dracoFeatureTableProperties = featureTableDraco.properties;
      const dracoByteOffset = featureTableDraco.byteOffset;
      const dracoByteLength = featureTableDraco.byteLength;
      if (!dracoFeatureTableProperties || !Number.isFinite(dracoByteOffset) || !dracoByteLength) {
        throw new Error("Draco properties, byteOffset, and byteLength must be defined");
      }
      dracoBuffer = tile.featureTableBinary.slice(dracoByteOffset, dracoByteOffset + dracoByteLength);
      tile.hasPositions = Number.isFinite(dracoFeatureTableProperties.POSITION);
      tile.hasColors = Number.isFinite(dracoFeatureTableProperties.RGB) || Number.isFinite(dracoFeatureTableProperties.RGBA);
      tile.hasNormals = Number.isFinite(dracoFeatureTableProperties.NORMAL);
      tile.hasBatchIds = Number.isFinite(dracoFeatureTableProperties.BATCH_ID);
      tile.isTranslucent = Number.isFinite(dracoFeatureTableProperties.RGBA);
    }
    if (!dracoBuffer) {
      return true;
    }
    const dracoData = {
      buffer: dracoBuffer,
      properties: { ...dracoFeatureTableProperties, ...dracoBatchTableProperties },
      featureTableProperties: dracoFeatureTableProperties,
      batchTableProperties: dracoBatchTableProperties,
      dequantizeInShader: false
    };
    return await loadDraco(tile, dracoData, options, context);
  }
  async function loadDraco(tile, dracoData, options, context) {
    const { parse: parse5 } = context;
    const dracoOptions = {
      ...options,
      draco: {
        ...options.draco,
        extraAttributes: dracoData.batchTableProperties || {}
      }
    };
    delete dracoOptions["3d-tiles"];
    const data = await parse5(dracoData.buffer, DracoLoader2, dracoOptions);
    const decodedPositions = data.attributes.POSITION && data.attributes.POSITION.value;
    const decodedColors = data.attributes.COLOR_0 && data.attributes.COLOR_0.value;
    const decodedNormals = data.attributes.NORMAL && data.attributes.NORMAL.value;
    const decodedBatchIds = data.attributes.BATCH_ID && data.attributes.BATCH_ID.value;
    const isQuantizedDraco = decodedPositions && data.attributes.POSITION.value.quantization;
    const isOctEncodedDraco = decodedNormals && data.attributes.NORMAL.value.quantization;
    if (isQuantizedDraco) {
      const quantization = data.POSITION.data.quantization;
      const range = quantization.range;
      tile.quantizedVolumeScale = new Vector3(range, range, range);
      tile.quantizedVolumeOffset = new Vector3(quantization.minValues);
      tile.quantizedRange = (1 << quantization.quantizationBits) - 1;
      tile.isQuantizedDraco = true;
    }
    if (isOctEncodedDraco) {
      tile.octEncodedRange = (1 << data.NORMAL.data.quantization.quantizationBits) - 1;
      tile.isOctEncodedDraco = true;
    }
    const batchTableAttributes = {};
    if (dracoData.batchTableProperties) {
      for (const attributeName of Object.keys(dracoData.batchTableProperties)) {
        if (data.attributes[attributeName] && data.attributes[attributeName].value) {
          batchTableAttributes[attributeName.toLowerCase()] = data.attributes[attributeName].value;
        }
      }
    }
    tile.attributes = {
      positions: decodedPositions,
      colors: normalize3DTileColorAttribute(tile, decodedColors, void 0),
      normals: decodedNormals,
      batchIds: decodedBatchIds,
      ...batchTableAttributes
    };
  }
  var init_parse_3d_tile_point_cloud = __esm({
    "src/lib/parsers/parse-3d-tile-point-cloud.ts"() {
      init_src6();
      init_src7();
      init_esm();
      init_tile_3d_feature_table();
      init_tile_3d_batch_table();
      init_parse_3d_tile_header();
      init_parse_3d_tile_tables();
      init_normalize_3d_tile_colors();
      init_normalize_3d_tile_normals();
      init_normalize_3d_tile_positions();
    }
  });

  // ../gltf/src/lib/utils/version.ts
  var VERSION6;
  var init_version4 = __esm({
    "../gltf/src/lib/utils/version.ts"() {
      VERSION6 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../textures/src/lib/utils/version.ts
  var VERSION7;
  var init_version5 = __esm({
    "../textures/src/lib/utils/version.ts"() {
      VERSION7 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../textures/src/lib/parsers/basis-module-loader.ts
  async function loadBasisTrascoderModule(options) {
    const modules = options.modules || {};
    if (modules.basis) {
      return modules.basis;
    }
    loadBasisTranscoderPromise = loadBasisTranscoderPromise || loadBasisTrascoder(options);
    return await loadBasisTranscoderPromise;
  }
  async function loadBasisTrascoder(options) {
    let BASIS = null;
    let wasmBinary = null;
    [BASIS, wasmBinary] = await Promise.all([
      await loadLibrary("basis_transcoder.js", "textures", options),
      await loadLibrary("basis_transcoder.wasm", "textures", options)
    ]);
    BASIS = BASIS || globalThis.BASIS;
    return await initializeBasisTrascoderModule(BASIS, wasmBinary);
  }
  function initializeBasisTrascoderModule(BasisModule, wasmBinary) {
    const options = {};
    if (wasmBinary) {
      options.wasmBinary = wasmBinary;
    }
    return new Promise((resolve2) => {
      BasisModule(options).then((module) => {
        const { BasisFile, initializeBasis } = module;
        initializeBasis();
        resolve2({ BasisFile });
      });
    });
  }
  async function loadBasisEncoderModule(options) {
    const modules = options.modules || {};
    if (modules.basisEncoder) {
      return modules.basisEncoder;
    }
    loadBasisEncoderPromise = loadBasisEncoderPromise || loadBasisEncoder(options);
    return await loadBasisEncoderPromise;
  }
  async function loadBasisEncoder(options) {
    let BASIS_ENCODER = null;
    let wasmBinary = null;
    [BASIS_ENCODER, wasmBinary] = await Promise.all([
      await loadLibrary(BASIS_CDN_ENCODER_JS, "textures", options),
      await loadLibrary(BASIS_CDN_ENCODER_WASM, "textures", options)
    ]);
    BASIS_ENCODER = BASIS_ENCODER || globalThis.BASIS;
    return await initializeBasisEncoderModule(BASIS_ENCODER, wasmBinary);
  }
  function initializeBasisEncoderModule(BasisEncoderModule, wasmBinary) {
    const options = {};
    if (wasmBinary) {
      options.wasmBinary = wasmBinary;
    }
    return new Promise((resolve2) => {
      BasisEncoderModule(options).then((module) => {
        const { BasisFile, KTX2File, initializeBasis, BasisEncoder } = module;
        initializeBasis();
        resolve2({ BasisFile, KTX2File, BasisEncoder });
      });
    });
  }
  var VERSION8, BASIS_CDN_ENCODER_WASM, BASIS_CDN_ENCODER_JS, loadBasisTranscoderPromise, loadBasisEncoderPromise;
  var init_basis_module_loader = __esm({
    "../textures/src/lib/parsers/basis-module-loader.ts"() {
      init_src();
      VERSION8 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      BASIS_CDN_ENCODER_WASM = `https://unpkg.com/@loaders.gl/textures@${VERSION8}/dist/libs/basis_encoder.wasm`;
      BASIS_CDN_ENCODER_JS = `https://unpkg.com/@loaders.gl/textures@${VERSION8}/dist/libs/basis_encoder.js`;
    }
  });

  // ../textures/src/lib/gl-extensions.ts
  var GL_EXTENSIONS_CONSTANTS;
  var init_gl_extensions = __esm({
    "../textures/src/lib/gl-extensions.ts"() {
      GL_EXTENSIONS_CONSTANTS = {
        COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
        COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
        COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
        COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
        COMPRESSED_R11_EAC: 37488,
        COMPRESSED_SIGNED_R11_EAC: 37489,
        COMPRESSED_RG11_EAC: 37490,
        COMPRESSED_SIGNED_RG11_EAC: 37491,
        COMPRESSED_RGB8_ETC2: 37492,
        COMPRESSED_RGBA8_ETC2_EAC: 37493,
        COMPRESSED_SRGB8_ETC2: 37494,
        COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37495,
        COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37496,
        COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37497,
        COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
        COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
        COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
        COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
        COMPRESSED_RGB_ETC1_WEBGL: 36196,
        COMPRESSED_RGB_ATC_WEBGL: 35986,
        COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL: 35987,
        COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL: 34798,
        COMPRESSED_RGBA_ASTC_4X4_KHR: 37808,
        COMPRESSED_RGBA_ASTC_5X4_KHR: 37809,
        COMPRESSED_RGBA_ASTC_5X5_KHR: 37810,
        COMPRESSED_RGBA_ASTC_6X5_KHR: 37811,
        COMPRESSED_RGBA_ASTC_6X6_KHR: 37812,
        COMPRESSED_RGBA_ASTC_8X5_KHR: 37813,
        COMPRESSED_RGBA_ASTC_8X6_KHR: 37814,
        COMPRESSED_RGBA_ASTC_8X8_KHR: 37815,
        COMPRESSED_RGBA_ASTC_10X5_KHR: 37816,
        COMPRESSED_RGBA_ASTC_10X6_KHR: 37817,
        COMPRESSED_RGBA_ASTC_10X8_KHR: 37818,
        COMPRESSED_RGBA_ASTC_10X10_KHR: 37819,
        COMPRESSED_RGBA_ASTC_12X10_KHR: 37820,
        COMPRESSED_RGBA_ASTC_12X12_KHR: 37821,
        COMPRESSED_SRGB8_ALPHA8_ASTC_4X4_KHR: 37840,
        COMPRESSED_SRGB8_ALPHA8_ASTC_5X4_KHR: 37841,
        COMPRESSED_SRGB8_ALPHA8_ASTC_5X5_KHR: 37842,
        COMPRESSED_SRGB8_ALPHA8_ASTC_6X5_KHR: 37843,
        COMPRESSED_SRGB8_ALPHA8_ASTC_6X6_KHR: 37844,
        COMPRESSED_SRGB8_ALPHA8_ASTC_8X5_KHR: 37845,
        COMPRESSED_SRGB8_ALPHA8_ASTC_8X6_KHR: 37846,
        COMPRESSED_SRGB8_ALPHA8_ASTC_8X8_KHR: 37847,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X5_KHR: 37848,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X6_KHR: 37849,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X8_KHR: 37850,
        COMPRESSED_SRGB8_ALPHA8_ASTC_10X10_KHR: 37851,
        COMPRESSED_SRGB8_ALPHA8_ASTC_12X10_KHR: 37852,
        COMPRESSED_SRGB8_ALPHA8_ASTC_12X12_KHR: 37853,
        COMPRESSED_RED_RGTC1_EXT: 36283,
        COMPRESSED_SIGNED_RED_RGTC1_EXT: 36284,
        COMPRESSED_RED_GREEN_RGTC2_EXT: 36285,
        COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT: 36286,
        COMPRESSED_SRGB_S3TC_DXT1_EXT: 35916,
        COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT: 35917,
        COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT: 35918,
        COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT: 35919
      };
    }
  });

  // ../textures/src/lib/utils/texture-formats.ts
  function getSupportedGPUTextureFormats(gl) {
    if (!formats) {
      gl = gl || getWebGLContext() || void 0;
      formats = new Set();
      for (const prefix of BROWSER_PREFIXES) {
        for (const extension in WEBGL_EXTENSIONS) {
          if (gl && gl.getExtension(`${prefix}${extension}`)) {
            const gpuTextureFormat = WEBGL_EXTENSIONS[extension];
            formats.add(gpuTextureFormat);
          }
        }
      }
    }
    return formats;
  }
  function getWebGLContext() {
    try {
      const canvas = document.createElement("canvas");
      return canvas.getContext("webgl");
    } catch (error) {
      return null;
    }
  }
  var BROWSER_PREFIXES, WEBGL_EXTENSIONS, formats;
  var init_texture_formats = __esm({
    "../textures/src/lib/utils/texture-formats.ts"() {
      BROWSER_PREFIXES = ["", "WEBKIT_", "MOZ_"];
      WEBGL_EXTENSIONS = {
        WEBGL_compressed_texture_s3tc: "dxt",
        WEBGL_compressed_texture_s3tc_srgb: "dxt-srgb",
        WEBGL_compressed_texture_etc1: "etc1",
        WEBGL_compressed_texture_etc: "etc2",
        WEBGL_compressed_texture_pvrtc: "pvrtc",
        WEBGL_compressed_texture_atc: "atc",
        WEBGL_compressed_texture_astc: "astc",
        EXT_texture_compression_rgtc: "rgtc"
      };
      formats = null;
    }
  });

  // ../../node_modules/ktx-parse/dist/ktx-parse.modern.js
  var t, n, i, s, a, r, o, l, f;
  var init_ktx_parse_modern = __esm({
    "../../node_modules/ktx-parse/dist/ktx-parse.modern.js"() {
      t = new Uint8Array([0]);
      !function(t2) {
        t2[t2.NONE = 0] = "NONE", t2[t2.BASISLZ = 1] = "BASISLZ", t2[t2.ZSTD = 2] = "ZSTD", t2[t2.ZLIB = 3] = "ZLIB";
      }(n || (n = {})), function(t2) {
        t2[t2.BASICFORMAT = 0] = "BASICFORMAT";
      }(i || (i = {})), function(t2) {
        t2[t2.UNSPECIFIED = 0] = "UNSPECIFIED", t2[t2.ETC1S = 163] = "ETC1S", t2[t2.UASTC = 166] = "UASTC";
      }(s || (s = {})), function(t2) {
        t2[t2.UNSPECIFIED = 0] = "UNSPECIFIED", t2[t2.SRGB = 1] = "SRGB";
      }(a || (a = {})), function(t2) {
        t2[t2.UNSPECIFIED = 0] = "UNSPECIFIED", t2[t2.LINEAR = 1] = "LINEAR", t2[t2.SRGB = 2] = "SRGB", t2[t2.ITU = 3] = "ITU", t2[t2.NTSC = 4] = "NTSC", t2[t2.SLOG = 5] = "SLOG", t2[t2.SLOG2 = 6] = "SLOG2";
      }(r || (r = {})), function(t2) {
        t2[t2.ALPHA_STRAIGHT = 0] = "ALPHA_STRAIGHT", t2[t2.ALPHA_PREMULTIPLIED = 1] = "ALPHA_PREMULTIPLIED";
      }(o || (o = {})), function(t2) {
        t2[t2.RGB = 0] = "RGB", t2[t2.RRR = 3] = "RRR", t2[t2.GGG = 4] = "GGG", t2[t2.AAA = 15] = "AAA";
      }(l || (l = {})), function(t2) {
        t2[t2.RGB = 0] = "RGB", t2[t2.RGBA = 3] = "RGBA", t2[t2.RRR = 4] = "RRR", t2[t2.RRRG = 5] = "RRRG";
      }(f || (f = {}));
    }
  });

  // ../textures/src/lib/parsers/parse-ktx.ts
  function isKTX(data) {
    const id = new Uint8Array(data);
    const notKTX = id.byteLength < KTX2_ID.length || id[0] !== KTX2_ID[0] || id[1] !== KTX2_ID[1] || id[2] !== KTX2_ID[2] || id[3] !== KTX2_ID[3] || id[4] !== KTX2_ID[4] || id[5] !== KTX2_ID[5] || id[6] !== KTX2_ID[6] || id[7] !== KTX2_ID[7] || id[8] !== KTX2_ID[8] || id[9] !== KTX2_ID[9] || id[10] !== KTX2_ID[10] || id[11] !== KTX2_ID[11];
    return !notKTX;
  }
  var KTX2_ID;
  var init_parse_ktx = __esm({
    "../textures/src/lib/parsers/parse-ktx.ts"() {
      init_ktx_parse_modern();
      KTX2_ID = [
        171,
        75,
        84,
        88,
        32,
        50,
        48,
        187,
        13,
        10,
        26,
        10
      ];
    }
  });

  // ../textures/src/lib/parsers/parse-basis.ts
  async function parseBasis(data, options) {
    if (options.basis.containerFormat === "auto") {
      if (isKTX(data)) {
        const fileConstructors = await loadBasisEncoderModule(options);
        return parseKTX2File(fileConstructors.KTX2File, data, options);
      }
      const { BasisFile } = await loadBasisTrascoderModule(options);
      return parseBasisFile(BasisFile, data, options);
    }
    switch (options.basis.module) {
      case "encoder":
        const fileConstructors = await loadBasisEncoderModule(options);
        switch (options.basis.containerFormat) {
          case "ktx2":
            return parseKTX2File(fileConstructors.KTX2File, data, options);
          case "basis":
          default:
            return parseBasisFile(fileConstructors.BasisFile, data, options);
        }
      case "transcoder":
      default:
        const { BasisFile } = await loadBasisTrascoderModule(options);
        return parseBasisFile(BasisFile, data, options);
    }
  }
  function parseBasisFile(BasisFile, data, options) {
    const basisFile = new BasisFile(new Uint8Array(data));
    try {
      if (!basisFile.startTranscoding()) {
        throw new Error("Failed to start basis transcoding");
      }
      const imageCount = basisFile.getNumImages();
      const images = [];
      for (let imageIndex = 0; imageIndex < imageCount; imageIndex++) {
        const levelsCount = basisFile.getNumLevels(imageIndex);
        const levels = [];
        for (let levelIndex = 0; levelIndex < levelsCount; levelIndex++) {
          levels.push(transcodeImage(basisFile, imageIndex, levelIndex, options));
        }
        images.push(levels);
      }
      return images;
    } finally {
      basisFile.close();
      basisFile.delete();
    }
  }
  function transcodeImage(basisFile, imageIndex, levelIndex, options) {
    const width = basisFile.getImageWidth(imageIndex, levelIndex);
    const height = basisFile.getImageHeight(imageIndex, levelIndex);
    const hasAlpha = basisFile.getHasAlpha();
    const { compressed, format, basisFormat } = getBasisOptions(options, hasAlpha);
    const decodedSize = basisFile.getImageTranscodedSizeInBytes(imageIndex, levelIndex, basisFormat);
    const decodedData = new Uint8Array(decodedSize);
    if (!basisFile.transcodeImage(decodedData, imageIndex, levelIndex, basisFormat, 0, 0)) {
      throw new Error("failed to start Basis transcoding");
    }
    return {
      width,
      height,
      data: decodedData,
      compressed,
      format,
      hasAlpha
    };
  }
  function parseKTX2File(KTX2File, data, options) {
    const ktx2File = new KTX2File(new Uint8Array(data));
    try {
      if (!ktx2File.startTranscoding()) {
        throw new Error("failed to start KTX2 transcoding");
      }
      const levelsCount = ktx2File.getLevels();
      const levels = [];
      for (let levelIndex = 0; levelIndex < levelsCount; levelIndex++) {
        levels.push(transcodeKTX2Image(ktx2File, levelIndex, options));
        break;
      }
      return [levels];
    } finally {
      ktx2File.close();
      ktx2File.delete();
    }
  }
  function transcodeKTX2Image(ktx2File, levelIndex, options) {
    const { alphaFlag, height, width } = ktx2File.getImageLevelInfo(levelIndex, 0, 0);
    const { compressed, format, basisFormat } = getBasisOptions(options, alphaFlag);
    const decodedSize = ktx2File.getImageTranscodedSizeInBytes(levelIndex, 0, 0, basisFormat);
    const decodedData = new Uint8Array(decodedSize);
    if (!ktx2File.transcodeImage(decodedData, levelIndex, 0, 0, basisFormat, 0, -1, -1)) {
      throw new Error("Failed to transcode KTX2 image");
    }
    return {
      width,
      height,
      data: decodedData,
      compressed,
      levelSize: decodedSize,
      hasAlpha: alphaFlag,
      format
    };
  }
  function getBasisOptions(options, hasAlpha) {
    let format = options && options.basis && options.basis.format;
    if (format === "auto") {
      format = selectSupportedBasisFormat();
    }
    if (typeof format === "object") {
      format = hasAlpha ? format.alpha : format.noAlpha;
    }
    format = format.toLowerCase();
    return OutputFormat[format];
  }
  function selectSupportedBasisFormat() {
    const supportedFormats = getSupportedGPUTextureFormats();
    if (supportedFormats.has("astc")) {
      return "astc-4x4";
    } else if (supportedFormats.has("dxt")) {
      return {
        alpha: "bc3",
        noAlpha: "bc1"
      };
    } else if (supportedFormats.has("pvrtc")) {
      return {
        alpha: "pvrtc1-4-rgba",
        noAlpha: "pvrtc1-4-rgb"
      };
    } else if (supportedFormats.has("etc1")) {
      return "etc1";
    } else if (supportedFormats.has("etc2")) {
      return "etc2";
    }
    return "rgb565";
  }
  var OutputFormat;
  var init_parse_basis = __esm({
    "../textures/src/lib/parsers/parse-basis.ts"() {
      init_basis_module_loader();
      init_gl_extensions();
      init_texture_formats();
      init_parse_ktx();
      OutputFormat = {
        etc1: {
          basisFormat: 0,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_ETC1_WEBGL
        },
        etc2: { basisFormat: 1, compressed: true },
        bc1: {
          basisFormat: 2,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_S3TC_DXT1_EXT
        },
        bc3: {
          basisFormat: 3,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_S3TC_DXT5_EXT
        },
        bc4: { basisFormat: 4, compressed: true },
        bc5: { basisFormat: 5, compressed: true },
        "bc7-m6-opaque-only": { basisFormat: 6, compressed: true },
        "bc7-m5": { basisFormat: 7, compressed: true },
        "pvrtc1-4-rgb": {
          basisFormat: 8,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGB_PVRTC_4BPPV1_IMG
        },
        "pvrtc1-4-rgba": {
          basisFormat: 9,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG
        },
        "astc-4x4": {
          basisFormat: 10,
          compressed: true,
          format: GL_EXTENSIONS_CONSTANTS.COMPRESSED_RGBA_ASTC_4X4_KHR
        },
        "atc-rgb": { basisFormat: 11, compressed: true },
        "atc-rgba-interpolated-alpha": { basisFormat: 12, compressed: true },
        rgba32: { basisFormat: 13, compressed: false },
        rgb565: { basisFormat: 14, compressed: false },
        bgr565: { basisFormat: 15, compressed: false },
        rgba4444: { basisFormat: 16, compressed: false }
      };
    }
  });

  // ../textures/src/basis-loader.ts
  var BasisWorkerLoader, BasisLoader;
  var init_basis_loader = __esm({
    "../textures/src/basis-loader.ts"() {
      init_src();
      init_version5();
      init_parse_basis();
      BasisWorkerLoader = {
        name: "Basis",
        id: isBrowser2 ? "basis" : "basis-nodejs",
        module: "textures",
        version: VERSION7,
        worker: true,
        extensions: ["basis", "ktx2"],
        mimeTypes: ["application/octet-stream", "image/ktx2"],
        tests: ["sB"],
        binary: true,
        options: {
          basis: {
            format: "auto",
            libraryPath: "libs/",
            containerFormat: "auto",
            module: "transcoder"
          }
        }
      };
      BasisLoader = {
        ...BasisWorkerLoader,
        parse: parseBasis
      };
    }
  });

  // ../images/src/lib/utils/version.ts
  var VERSION9;
  var init_version6 = __esm({
    "../images/src/lib/utils/version.ts"() {
      VERSION9 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
    }
  });

  // ../images/src/lib/category-api/image-type.ts
  function isImageTypeSupported(type) {
    switch (type) {
      case "auto":
        return IMAGE_BITMAP_SUPPORTED || IMAGE_SUPPORTED || DATA_SUPPORTED;
      case "imagebitmap":
        return IMAGE_BITMAP_SUPPORTED;
      case "image":
        return IMAGE_SUPPORTED;
      case "data":
        return DATA_SUPPORTED;
      default:
        throw new Error(`@loaders.gl/images: image ${type} not supported in this environment`);
    }
  }
  function getDefaultImageType() {
    if (IMAGE_BITMAP_SUPPORTED) {
      return "imagebitmap";
    }
    if (IMAGE_SUPPORTED) {
      return "image";
    }
    if (DATA_SUPPORTED) {
      return "data";
    }
    throw new Error("Install '@loaders.gl/polyfills' to parse images under Node.js");
  }
  var _parseImageNode, IMAGE_SUPPORTED, IMAGE_BITMAP_SUPPORTED, NODE_IMAGE_SUPPORTED, DATA_SUPPORTED;
  var init_image_type = __esm({
    "../images/src/lib/category-api/image-type.ts"() {
      init_src2();
      ({ _parseImageNode } = globalThis);
      IMAGE_SUPPORTED = typeof Image !== "undefined";
      IMAGE_BITMAP_SUPPORTED = typeof ImageBitmap !== "undefined";
      NODE_IMAGE_SUPPORTED = Boolean(_parseImageNode);
      DATA_SUPPORTED = isBrowser ? true : NODE_IMAGE_SUPPORTED;
    }
  });

  // ../images/src/lib/category-api/parsed-image-api.ts
  function getImageType(image) {
    const format = getImageTypeOrNull(image);
    if (!format) {
      throw new Error("Not an image");
    }
    return format;
  }
  function getImageData(image) {
    switch (getImageType(image)) {
      case "data":
        return image;
      case "image":
      case "imagebitmap":
        const canvas = document.createElement("canvas");
        const context = canvas.getContext("2d");
        if (!context) {
          throw new Error("getImageData");
        }
        canvas.width = image.width;
        canvas.height = image.height;
        context.drawImage(image, 0, 0);
        return context.getImageData(0, 0, image.width, image.height);
      default:
        throw new Error("getImageData");
    }
  }
  function getImageTypeOrNull(image) {
    if (typeof ImageBitmap !== "undefined" && image instanceof ImageBitmap) {
      return "imagebitmap";
    }
    if (typeof Image !== "undefined" && image instanceof Image) {
      return "image";
    }
    if (image && typeof image === "object" && image.data && image.width && image.height) {
      return "data";
    }
    return null;
  }
  var init_parsed_image_api = __esm({
    "../images/src/lib/category-api/parsed-image-api.ts"() {
    }
  });

  // ../images/src/lib/parsers/svg-utils.ts
  function isSVG(url) {
    return url && (SVG_DATA_URL_PATTERN.test(url) || SVG_URL_PATTERN.test(url));
  }
  function getBlobOrSVGDataUrl(arrayBuffer, url) {
    if (isSVG(url)) {
      const textDecoder = new TextDecoder();
      let xmlText = textDecoder.decode(arrayBuffer);
      try {
        if (typeof unescape === "function" && typeof encodeURIComponent === "function") {
          xmlText = unescape(encodeURIComponent(xmlText));
        }
      } catch (error) {
        throw new Error(error.message);
      }
      const src = `data:image/svg+xml;base64,${btoa(xmlText)}`;
      return src;
    }
    return getBlob(arrayBuffer, url);
  }
  function getBlob(arrayBuffer, url) {
    if (isSVG(url)) {
      throw new Error("SVG cannot be parsed directly to imagebitmap");
    }
    return new Blob([new Uint8Array(arrayBuffer)]);
  }
  var SVG_DATA_URL_PATTERN, SVG_URL_PATTERN;
  var init_svg_utils = __esm({
    "../images/src/lib/parsers/svg-utils.ts"() {
      SVG_DATA_URL_PATTERN = /^data:image\/svg\+xml/;
      SVG_URL_PATTERN = /\.svg((\?|#).*)?$/;
    }
  });

  // ../images/src/lib/parsers/parse-to-image.ts
  async function parseToImage(arrayBuffer, options, url) {
    const blobOrDataUrl = getBlobOrSVGDataUrl(arrayBuffer, url);
    const URL2 = self.URL || self.webkitURL;
    const objectUrl = typeof blobOrDataUrl !== "string" && URL2.createObjectURL(blobOrDataUrl);
    try {
      return await loadToImage(objectUrl || blobOrDataUrl, options);
    } finally {
      if (objectUrl) {
        URL2.revokeObjectURL(objectUrl);
      }
    }
  }
  async function loadToImage(url, options) {
    const image = new Image();
    image.src = url;
    if (options.image && options.image.decode && image.decode) {
      await image.decode();
      return image;
    }
    return await new Promise((resolve2, reject) => {
      try {
        image.onload = () => resolve2(image);
        image.onerror = (err) => reject(new Error(`Could not load image ${url}: ${err}`));
      } catch (error) {
        reject(error);
      }
    });
  }
  var init_parse_to_image = __esm({
    "../images/src/lib/parsers/parse-to-image.ts"() {
      init_svg_utils();
    }
  });

  // ../images/src/lib/parsers/parse-to-image-bitmap.ts
  async function parseToImageBitmap(arrayBuffer, options, url) {
    let blob;
    if (isSVG(url)) {
      const image = await parseToImage(arrayBuffer, options, url);
      blob = image;
    } else {
      blob = getBlob(arrayBuffer, url);
    }
    const imagebitmapOptions = options && options.imagebitmap;
    return await safeCreateImageBitmap(blob, imagebitmapOptions);
  }
  async function safeCreateImageBitmap(blob, imagebitmapOptions = null) {
    if (isEmptyObject(imagebitmapOptions) || !imagebitmapOptionsSupported) {
      imagebitmapOptions = null;
    }
    if (imagebitmapOptions) {
      try {
        return await createImageBitmap(blob, imagebitmapOptions);
      } catch (error) {
        console.warn(error);
        imagebitmapOptionsSupported = false;
      }
    }
    return await createImageBitmap(blob);
  }
  function isEmptyObject(object) {
    for (const key in object || EMPTY_OBJECT) {
      return false;
    }
    return true;
  }
  var EMPTY_OBJECT, imagebitmapOptionsSupported;
  var init_parse_to_image_bitmap = __esm({
    "../images/src/lib/parsers/parse-to-image-bitmap.ts"() {
      init_svg_utils();
      init_parse_to_image();
      EMPTY_OBJECT = {};
      imagebitmapOptionsSupported = true;
    }
  });

  // ../images/src/lib/category-api/parse-isobmff-binary.ts
  function getISOBMFFMediaType(buffer) {
    if (!checkString(buffer, "ftyp", 4)) {
      return null;
    }
    if ((buffer[8] & 96) === 0) {
      return null;
    }
    return decodeMajorBrand(buffer);
  }
  function decodeMajorBrand(buffer) {
    const brandMajor = getUTF8String(buffer, 8, 12).replace("\0", " ").trim();
    switch (brandMajor) {
      case "avif":
      case "avis":
        return { extension: "avif", mimeType: "image/avif" };
      default:
        return null;
    }
  }
  function getUTF8String(array, start, end) {
    return String.fromCharCode(...array.slice(start, end));
  }
  function stringToBytes(string) {
    return [...string].map((character) => character.charCodeAt(0));
  }
  function checkString(buffer, header, offset = 0) {
    const headerBytes = stringToBytes(header);
    for (let i2 = 0; i2 < headerBytes.length; ++i2) {
      if (headerBytes[i2] !== buffer[i2 + offset]) {
        return false;
      }
    }
    return true;
  }
  var init_parse_isobmff_binary = __esm({
    "../images/src/lib/category-api/parse-isobmff-binary.ts"() {
    }
  });

  // ../images/src/lib/category-api/binary-image-api.ts
  function getBinaryImageMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    return getPngMetadata(dataView) || getJpegMetadata(dataView) || getGifMetadata(dataView) || getBmpMetadata(dataView) || getISOBMFFMetadata(dataView);
  }
  function getISOBMFFMetadata(binaryData) {
    const buffer = new Uint8Array(binaryData instanceof DataView ? binaryData.buffer : binaryData);
    const mediaType = getISOBMFFMediaType(buffer);
    if (!mediaType) {
      return null;
    }
    return {
      mimeType: mediaType.mimeType,
      width: 0,
      height: 0
    };
  }
  function getPngMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isPng = dataView.byteLength >= 24 && dataView.getUint32(0, BIG_ENDIAN) === 2303741511;
    if (!isPng) {
      return null;
    }
    return {
      mimeType: "image/png",
      width: dataView.getUint32(16, BIG_ENDIAN),
      height: dataView.getUint32(20, BIG_ENDIAN)
    };
  }
  function getGifMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isGif = dataView.byteLength >= 10 && dataView.getUint32(0, BIG_ENDIAN) === 1195984440;
    if (!isGif) {
      return null;
    }
    return {
      mimeType: "image/gif",
      width: dataView.getUint16(6, LITTLE_ENDIAN),
      height: dataView.getUint16(8, LITTLE_ENDIAN)
    };
  }
  function getBmpMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isBmp = dataView.byteLength >= 14 && dataView.getUint16(0, BIG_ENDIAN) === 16973 && dataView.getUint32(2, LITTLE_ENDIAN) === dataView.byteLength;
    if (!isBmp) {
      return null;
    }
    return {
      mimeType: "image/bmp",
      width: dataView.getUint32(18, LITTLE_ENDIAN),
      height: dataView.getUint32(22, LITTLE_ENDIAN)
    };
  }
  function getJpegMetadata(binaryData) {
    const dataView = toDataView(binaryData);
    const isJpeg = dataView.byteLength >= 3 && dataView.getUint16(0, BIG_ENDIAN) === 65496 && dataView.getUint8(2) === 255;
    if (!isJpeg) {
      return null;
    }
    const { tableMarkers, sofMarkers } = getJpegMarkers();
    let i2 = 2;
    while (i2 + 9 < dataView.byteLength) {
      const marker2 = dataView.getUint16(i2, BIG_ENDIAN);
      if (sofMarkers.has(marker2)) {
        return {
          mimeType: "image/jpeg",
          height: dataView.getUint16(i2 + 5, BIG_ENDIAN),
          width: dataView.getUint16(i2 + 7, BIG_ENDIAN)
        };
      }
      if (!tableMarkers.has(marker2)) {
        return null;
      }
      i2 += 2;
      i2 += dataView.getUint16(i2, BIG_ENDIAN);
    }
    return null;
  }
  function getJpegMarkers() {
    const tableMarkers = new Set([65499, 65476, 65484, 65501, 65534]);
    for (let i2 = 65504; i2 < 65520; ++i2) {
      tableMarkers.add(i2);
    }
    const sofMarkers = new Set([
      65472,
      65473,
      65474,
      65475,
      65477,
      65478,
      65479,
      65481,
      65482,
      65483,
      65485,
      65486,
      65487,
      65502
    ]);
    return { tableMarkers, sofMarkers };
  }
  function toDataView(data) {
    if (data instanceof DataView) {
      return data;
    }
    if (ArrayBuffer.isView(data)) {
      return new DataView(data.buffer);
    }
    if (data instanceof ArrayBuffer) {
      return new DataView(data);
    }
    throw new Error("toDataView");
  }
  var BIG_ENDIAN, LITTLE_ENDIAN;
  var init_binary_image_api = __esm({
    "../images/src/lib/category-api/binary-image-api.ts"() {
      init_parse_isobmff_binary();
      BIG_ENDIAN = false;
      LITTLE_ENDIAN = true;
    }
  });

  // ../images/src/lib/parsers/parse-to-node-image.ts
  async function parseToNodeImage(arrayBuffer, options) {
    const { mimeType } = getBinaryImageMetadata(arrayBuffer) || {};
    const _parseImageNode2 = globalThis._parseImageNode;
    assert2(_parseImageNode2);
    return await _parseImageNode2(arrayBuffer, mimeType);
  }
  var init_parse_to_node_image = __esm({
    "../images/src/lib/parsers/parse-to-node-image.ts"() {
      init_src2();
      init_binary_image_api();
    }
  });

  // ../images/src/lib/parsers/parse-image.ts
  async function parseImage(arrayBuffer, options, context) {
    options = options || {};
    const imageOptions = options.image || {};
    const imageType = imageOptions.type || "auto";
    const { url } = context || {};
    const loadType = getLoadableImageType(imageType);
    let image;
    switch (loadType) {
      case "imagebitmap":
        image = await parseToImageBitmap(arrayBuffer, options, url);
        break;
      case "image":
        image = await parseToImage(arrayBuffer, options, url);
        break;
      case "data":
        image = await parseToNodeImage(arrayBuffer, options);
        break;
      default:
        assert2(false);
    }
    if (imageType === "data") {
      image = getImageData(image);
    }
    return image;
  }
  function getLoadableImageType(type) {
    switch (type) {
      case "auto":
      case "data":
        return getDefaultImageType();
      default:
        isImageTypeSupported(type);
        return type;
    }
  }
  var init_parse_image = __esm({
    "../images/src/lib/parsers/parse-image.ts"() {
      init_src2();
      init_image_type();
      init_parsed_image_api();
      init_parse_to_image();
      init_parse_to_image_bitmap();
      init_parse_to_node_image();
    }
  });

  // ../images/src/image-loader.ts
  var EXTENSIONS, MIME_TYPES, DEFAULT_IMAGE_LOADER_OPTIONS, ImageLoader;
  var init_image_loader = __esm({
    "../images/src/image-loader.ts"() {
      init_version6();
      init_parse_image();
      init_binary_image_api();
      EXTENSIONS = ["png", "jpg", "jpeg", "gif", "webp", "bmp", "ico", "svg", "avif"];
      MIME_TYPES = [
        "image/png",
        "image/jpeg",
        "image/gif",
        "image/webp",
        "image/avif",
        "image/bmp",
        "image/vnd.microsoft.icon",
        "image/svg+xml"
      ];
      DEFAULT_IMAGE_LOADER_OPTIONS = {
        image: {
          type: "auto",
          decode: true
        }
      };
      ImageLoader = {
        id: "image",
        module: "images",
        name: "Images",
        version: VERSION9,
        mimeTypes: MIME_TYPES,
        extensions: EXTENSIONS,
        parse: parseImage,
        tests: [(arrayBuffer) => Boolean(getBinaryImageMetadata(new DataView(arrayBuffer)))],
        options: DEFAULT_IMAGE_LOADER_OPTIONS
      };
    }
  });

  // ../images/src/lib/category-api/image-format.ts
  function isImageFormatSupported(mimeType) {
    if (mimeTypeSupportedSync[mimeType] === void 0) {
      const supported = isBrowser ? checkBrowserImageFormatSupport(mimeType) : checkNodeImageFormatSupport(mimeType);
      mimeTypeSupportedSync[mimeType] = supported;
    }
    return mimeTypeSupportedSync[mimeType];
  }
  function checkNodeImageFormatSupport(mimeType) {
    const NODE_FORMAT_SUPPORT = ["image/png", "image/jpeg", "image/gif"];
    const { _parseImageNode: _parseImageNode2, _imageFormatsNode = NODE_FORMAT_SUPPORT } = globalThis;
    return Boolean(_parseImageNode2) && _imageFormatsNode.includes(mimeType);
  }
  function checkBrowserImageFormatSupport(mimeType) {
    switch (mimeType) {
      case "image/avif":
      case "image/webp":
        return testBrowserImageFormatSupport(mimeType);
      default:
        return true;
    }
  }
  function testBrowserImageFormatSupport(mimeType) {
    try {
      const element = document.createElement("canvas");
      const dataURL = element.toDataURL(mimeType);
      return dataURL.indexOf(`data:${mimeType}`) === 0;
    } catch {
      return false;
    }
  }
  var mimeTypeSupportedSync;
  var init_image_format = __esm({
    "../images/src/lib/category-api/image-format.ts"() {
      init_src2();
      mimeTypeSupportedSync = {};
    }
  });

  // ../images/src/index.ts
  var init_src8 = __esm({
    "../images/src/index.ts"() {
      init_image_loader();
      init_binary_image_api();
      init_image_format();
    }
  });

  // ../textures/src/index.ts
  var init_src9 = __esm({
    "../textures/src/index.ts"() {
      init_basis_loader();
      init_parse_basis();
    }
  });

  // ../gltf/src/lib/utils/assert.ts
  function assert8(condition, message) {
    if (!condition) {
      throw new Error(message || "assert failed: gltf");
    }
  }
  var init_assert7 = __esm({
    "../gltf/src/lib/utils/assert.ts"() {
    }
  });

  // ../gltf/src/lib/gltf-utils/resolve-url.ts
  function resolveUrl(url, options) {
    const absolute = url.startsWith("data:") || url.startsWith("http:") || url.startsWith("https:");
    if (absolute) {
      return url;
    }
    const baseUrl = options.baseUri || options.uri;
    if (!baseUrl) {
      throw new Error(`'baseUri' must be provided to resolve relative url ${url}`);
    }
    return baseUrl.substr(0, baseUrl.lastIndexOf("/") + 1) + url;
  }
  var init_resolve_url = __esm({
    "../gltf/src/lib/gltf-utils/resolve-url.ts"() {
    }
  });

  // ../gltf/src/lib/gltf-utils/get-typed-array.ts
  function getTypedArrayForBufferView(json, buffers, bufferViewIndex) {
    const bufferView = json.bufferViews[bufferViewIndex];
    assert8(bufferView);
    const bufferIndex = bufferView.buffer;
    const binChunk = buffers[bufferIndex];
    assert8(binChunk);
    const byteOffset = (bufferView.byteOffset || 0) + binChunk.byteOffset;
    return new Uint8Array(binChunk.arrayBuffer, byteOffset, bufferView.byteLength);
  }
  var init_get_typed_array = __esm({
    "../gltf/src/lib/gltf-utils/get-typed-array.ts"() {
      init_assert7();
    }
  });

  // ../gltf/src/lib/gltf-utils/gltf-utils.ts
  function getAccessorTypeFromSize(size) {
    const type = TYPES[size - 1];
    return type || TYPES[0];
  }
  function getComponentTypeFromArray(typedArray) {
    const componentType = ARRAY_TO_COMPONENT_TYPE.get(typedArray.constructor);
    if (!componentType) {
      throw new Error("Illegal typed array");
    }
    return componentType;
  }
  function getAccessorArrayTypeAndLength(accessor, bufferView) {
    const ArrayType = ATTRIBUTE_COMPONENT_TYPE_TO_ARRAY[accessor.componentType];
    const components = ATTRIBUTE_TYPE_TO_COMPONENTS[accessor.type];
    const bytesPerComponent = ATTRIBUTE_COMPONENT_TYPE_TO_BYTE_SIZE[accessor.componentType];
    const length4 = accessor.count * components;
    const byteLength = accessor.count * components * bytesPerComponent;
    assert8(byteLength >= 0 && byteLength <= bufferView.byteLength);
    return { ArrayType, length: length4, byteLength };
  }
  function getMemoryUsageGLTF(gltf) {
    let { images, bufferViews } = gltf;
    images = images || [];
    bufferViews = bufferViews || [];
    const imageBufferViews = images.map((i2) => i2.bufferView);
    bufferViews = bufferViews.filter((view) => !imageBufferViews.includes(view));
    const bufferMemory = bufferViews.reduce((acc, view) => acc + view.byteLength, 0);
    const pixelCount = images.reduce((acc, image) => {
      const { width, height } = image.image;
      return acc + width * height;
    }, 0);
    return bufferMemory + Math.ceil(4 * pixelCount * 1.33);
  }
  var TYPES, ARRAY_CONSTRUCTOR_TO_WEBGL_CONSTANT, ARRAY_TO_COMPONENT_TYPE, ATTRIBUTE_TYPE_TO_COMPONENTS, ATTRIBUTE_COMPONENT_TYPE_TO_BYTE_SIZE, ATTRIBUTE_COMPONENT_TYPE_TO_ARRAY;
  var init_gltf_utils = __esm({
    "../gltf/src/lib/gltf-utils/gltf-utils.ts"() {
      init_assert7();
      TYPES = ["SCALAR", "VEC2", "VEC3", "VEC4"];
      ARRAY_CONSTRUCTOR_TO_WEBGL_CONSTANT = [
        [Int8Array, 5120],
        [Uint8Array, 5121],
        [Int16Array, 5122],
        [Uint16Array, 5123],
        [Uint32Array, 5125],
        [Float32Array, 5126],
        [Float64Array, 5130]
      ];
      ARRAY_TO_COMPONENT_TYPE = new Map(ARRAY_CONSTRUCTOR_TO_WEBGL_CONSTANT);
      ATTRIBUTE_TYPE_TO_COMPONENTS = {
        SCALAR: 1,
        VEC2: 2,
        VEC3: 3,
        VEC4: 4,
        MAT2: 4,
        MAT3: 9,
        MAT4: 16
      };
      ATTRIBUTE_COMPONENT_TYPE_TO_BYTE_SIZE = {
        5120: 1,
        5121: 1,
        5122: 2,
        5123: 2,
        5125: 4,
        5126: 4
      };
      ATTRIBUTE_COMPONENT_TYPE_TO_ARRAY = {
        5120: Int8Array,
        5121: Uint8Array,
        5122: Int16Array,
        5123: Uint16Array,
        5125: Uint32Array,
        5126: Float32Array
      };
    }
  });

  // ../gltf/src/lib/api/gltf-scenegraph.ts
  var DEFAULT_GLTF_JSON, GLTFScenegraph;
  var init_gltf_scenegraph = __esm({
    "../gltf/src/lib/api/gltf-scenegraph.ts"() {
      init_src8();
      init_src2();
      init_assert7();
      init_gltf_utils();
      DEFAULT_GLTF_JSON = {
        asset: {
          version: "2.0",
          generator: "loaders.gl"
        },
        buffers: []
      };
      GLTFScenegraph = class {
        constructor(gltf) {
          this.gltf = gltf || {
            json: { ...DEFAULT_GLTF_JSON },
            buffers: []
          };
          this.sourceBuffers = [];
          this.byteLength = 0;
          if (this.gltf.buffers && this.gltf.buffers[0]) {
            this.byteLength = this.gltf.buffers[0].byteLength;
            this.sourceBuffers = [this.gltf.buffers[0]];
          }
        }
        get json() {
          return this.gltf.json;
        }
        getApplicationData(key) {
          const data = this.json[key];
          return data;
        }
        getExtraData(key) {
          const extras = this.json.extras || {};
          return extras[key];
        }
        getExtension(extensionName) {
          const isExtension = this.getUsedExtensions().find((name10) => name10 === extensionName);
          const extensions = this.json.extensions || {};
          return isExtension ? extensions[extensionName] || true : null;
        }
        getRequiredExtension(extensionName) {
          const isRequired = this.getRequiredExtensions().find((name10) => name10 === extensionName);
          return isRequired ? this.getExtension(extensionName) : null;
        }
        getRequiredExtensions() {
          return this.json.extensionsRequired || [];
        }
        getUsedExtensions() {
          return this.json.extensionsUsed || [];
        }
        getRemovedExtensions() {
          return this.json.extensionsRemoved || [];
        }
        getObjectExtension(object, extensionName) {
          const extensions = object.extensions || {};
          return extensions[extensionName];
        }
        getScene(index) {
          return this.getObject("scenes", index);
        }
        getNode(index) {
          return this.getObject("nodes", index);
        }
        getSkin(index) {
          return this.getObject("skins", index);
        }
        getMesh(index) {
          return this.getObject("meshes", index);
        }
        getMaterial(index) {
          return this.getObject("materials", index);
        }
        getAccessor(index) {
          return this.getObject("accessors", index);
        }
        getTexture(index) {
          return this.getObject("textures", index);
        }
        getSampler(index) {
          return this.getObject("samplers", index);
        }
        getImage(index) {
          return this.getObject("images", index);
        }
        getBufferView(index) {
          return this.getObject("bufferViews", index);
        }
        getBuffer(index) {
          return this.getObject("buffers", index);
        }
        getObject(array, index) {
          if (typeof index === "object") {
            return index;
          }
          const object = this.json[array] && this.json[array][index];
          if (!object) {
            throw new Error(`glTF file error: Could not find ${array}[${index}]`);
          }
          return object;
        }
        getTypedArrayForBufferView(bufferView) {
          bufferView = this.getBufferView(bufferView);
          const bufferIndex = bufferView.buffer;
          const binChunk = this.gltf.buffers[bufferIndex];
          assert8(binChunk);
          const byteOffset = (bufferView.byteOffset || 0) + binChunk.byteOffset;
          return new Uint8Array(binChunk.arrayBuffer, byteOffset, bufferView.byteLength);
        }
        getTypedArrayForAccessor(accessor) {
          accessor = this.getAccessor(accessor);
          const bufferView = this.getBufferView(accessor.bufferView);
          const buffer = this.getBuffer(bufferView.buffer);
          const arrayBuffer = buffer.data;
          const { ArrayType, length: length4 } = getAccessorArrayTypeAndLength(accessor, bufferView);
          const byteOffset = bufferView.byteOffset + accessor.byteOffset;
          return new ArrayType(arrayBuffer, byteOffset, length4);
        }
        getTypedArrayForImageData(image) {
          image = this.getAccessor(image);
          const bufferView = this.getBufferView(image.bufferView);
          const buffer = this.getBuffer(bufferView.buffer);
          const arrayBuffer = buffer.data;
          const byteOffset = bufferView.byteOffset || 0;
          return new Uint8Array(arrayBuffer, byteOffset, bufferView.byteLength);
        }
        addApplicationData(key, data) {
          this.json[key] = data;
          return this;
        }
        addExtraData(key, data) {
          this.json.extras = this.json.extras || {};
          this.json.extras[key] = data;
          return this;
        }
        addObjectExtension(object, extensionName, data) {
          object.extensions = object.extensions || {};
          object.extensions[extensionName] = data;
          this.registerUsedExtension(extensionName);
          return this;
        }
        setObjectExtension(object, extensionName, data) {
          const extensions = object.extensions || {};
          extensions[extensionName] = data;
        }
        removeObjectExtension(object, extensionName) {
          const extensions = object.extensions || {};
          const extension = extensions[extensionName];
          delete extensions[extensionName];
          return extension;
        }
        addExtension(extensionName, extensionData = {}) {
          assert8(extensionData);
          this.json.extensions = this.json.extensions || {};
          this.json.extensions[extensionName] = extensionData;
          this.registerUsedExtension(extensionName);
          return extensionData;
        }
        addRequiredExtension(extensionName, extensionData = {}) {
          assert8(extensionData);
          this.addExtension(extensionName, extensionData);
          this.registerRequiredExtension(extensionName);
          return extensionData;
        }
        registerUsedExtension(extensionName) {
          this.json.extensionsUsed = this.json.extensionsUsed || [];
          if (!this.json.extensionsUsed.find((ext) => ext === extensionName)) {
            this.json.extensionsUsed.push(extensionName);
          }
        }
        registerRequiredExtension(extensionName) {
          this.registerUsedExtension(extensionName);
          this.json.extensionsRequired = this.json.extensionsRequired || [];
          if (!this.json.extensionsRequired.find((ext) => ext === extensionName)) {
            this.json.extensionsRequired.push(extensionName);
          }
        }
        removeExtension(extensionName) {
          if (!this.getExtension(extensionName)) {
            return;
          }
          if (this.json.extensionsRequired) {
            this._removeStringFromArray(this.json.extensionsRequired, extensionName);
          }
          if (this.json.extensionsUsed) {
            this._removeStringFromArray(this.json.extensionsUsed, extensionName);
          }
          if (this.json.extensions) {
            delete this.json.extensions[extensionName];
          }
          if (!Array.isArray(this.json.extensionsRemoved)) {
            this.json.extensionsRemoved = [];
          }
          const extensionsRemoved = this.json.extensionsRemoved;
          if (!extensionsRemoved.includes(extensionName)) {
            extensionsRemoved.push(extensionName);
          }
        }
        setDefaultScene(sceneIndex) {
          this.json.scene = sceneIndex;
        }
        addScene(scene) {
          const { nodeIndices } = scene;
          this.json.scenes = this.json.scenes || [];
          this.json.scenes.push({ nodes: nodeIndices });
          return this.json.scenes.length - 1;
        }
        addNode(node2) {
          const { meshIndex, matrix } = node2;
          this.json.nodes = this.json.nodes || [];
          const nodeData = { mesh: meshIndex };
          if (matrix) {
            nodeData.matrix = matrix;
          }
          this.json.nodes.push(nodeData);
          return this.json.nodes.length - 1;
        }
        addMesh(mesh) {
          const { attributes, indices, material, mode = 4 } = mesh;
          const accessors = this._addAttributes(attributes);
          const glTFMesh = {
            primitives: [
              {
                attributes: accessors,
                mode
              }
            ]
          };
          if (indices) {
            const indicesAccessor = this._addIndices(indices);
            glTFMesh.primitives[0].indices = indicesAccessor;
          }
          if (Number.isFinite(material)) {
            glTFMesh.primitives[0].material = material;
          }
          this.json.meshes = this.json.meshes || [];
          this.json.meshes.push(glTFMesh);
          return this.json.meshes.length - 1;
        }
        addPointCloud(attributes) {
          const accessorIndices = this._addAttributes(attributes);
          const glTFMesh = {
            primitives: [
              {
                attributes: accessorIndices,
                mode: 0
              }
            ]
          };
          this.json.meshes = this.json.meshes || [];
          this.json.meshes.push(glTFMesh);
          return this.json.meshes.length - 1;
        }
        addImage(imageData, mimeTypeOpt) {
          const metadata = getBinaryImageMetadata(imageData);
          const mimeType = mimeTypeOpt || metadata?.mimeType;
          const bufferViewIndex = this.addBufferView(imageData);
          const glTFImage = {
            bufferView: bufferViewIndex,
            mimeType
          };
          this.json.images = this.json.images || [];
          this.json.images.push(glTFImage);
          return this.json.images.length - 1;
        }
        addBufferView(buffer) {
          const byteLength = buffer.byteLength;
          assert8(Number.isFinite(byteLength));
          this.sourceBuffers = this.sourceBuffers || [];
          this.sourceBuffers.push(buffer);
          const glTFBufferView = {
            buffer: 0,
            byteOffset: this.byteLength,
            byteLength
          };
          this.byteLength += padToNBytes(byteLength, 4);
          this.json.bufferViews = this.json.bufferViews || [];
          this.json.bufferViews.push(glTFBufferView);
          return this.json.bufferViews.length - 1;
        }
        addAccessor(bufferViewIndex, accessor) {
          const glTFAccessor = {
            bufferView: bufferViewIndex,
            type: getAccessorTypeFromSize(accessor.size),
            componentType: accessor.componentType,
            count: accessor.count,
            max: accessor.max,
            min: accessor.min
          };
          this.json.accessors = this.json.accessors || [];
          this.json.accessors.push(glTFAccessor);
          return this.json.accessors.length - 1;
        }
        addBinaryBuffer(sourceBuffer, accessor = { size: 3 }) {
          const bufferViewIndex = this.addBufferView(sourceBuffer);
          let minMax = { min: accessor.min, max: accessor.max };
          if (!minMax.min || !minMax.max) {
            minMax = this._getAccessorMinMax(sourceBuffer, accessor.size);
          }
          const accessorDefaults = {
            size: accessor.size,
            componentType: getComponentTypeFromArray(sourceBuffer),
            count: Math.round(sourceBuffer.length / accessor.size),
            min: minMax.min,
            max: minMax.max
          };
          return this.addAccessor(bufferViewIndex, Object.assign(accessorDefaults, accessor));
        }
        addTexture(texture) {
          const { imageIndex } = texture;
          const glTFTexture = {
            source: imageIndex
          };
          this.json.textures = this.json.textures || [];
          this.json.textures.push(glTFTexture);
          return this.json.textures.length - 1;
        }
        addMaterial(pbrMaterialInfo) {
          this.json.materials = this.json.materials || [];
          this.json.materials.push(pbrMaterialInfo);
          return this.json.materials.length - 1;
        }
        createBinaryChunk() {
          this.gltf.buffers = [];
          const totalByteLength = this.byteLength;
          const arrayBuffer = new ArrayBuffer(totalByteLength);
          const targetArray = new Uint8Array(arrayBuffer);
          let dstByteOffset = 0;
          for (const sourceBuffer of this.sourceBuffers || []) {
            dstByteOffset = copyToArray(sourceBuffer, targetArray, dstByteOffset);
          }
          if (this.json?.buffers?.[0]) {
            this.json.buffers[0].byteLength = totalByteLength;
          } else {
            this.json.buffers = [{ byteLength: totalByteLength }];
          }
          this.gltf.binary = arrayBuffer;
          this.sourceBuffers = [arrayBuffer];
        }
        _removeStringFromArray(array, string) {
          let found = true;
          while (found) {
            const index = array.indexOf(string);
            if (index > -1) {
              array.splice(index, 1);
            } else {
              found = false;
            }
          }
        }
        _addAttributes(attributes = {}) {
          const result = {};
          for (const attributeKey in attributes) {
            const attributeData = attributes[attributeKey];
            const attrName = this._getGltfAttributeName(attributeKey);
            const accessor = this.addBinaryBuffer(attributeData.value, attributeData);
            result[attrName] = accessor;
          }
          return result;
        }
        _addIndices(indices) {
          return this.addBinaryBuffer(indices, { size: 1 });
        }
        _getGltfAttributeName(attributeName) {
          switch (attributeName.toLowerCase()) {
            case "position":
            case "positions":
            case "vertices":
              return "POSITION";
            case "normal":
            case "normals":
              return "NORMAL";
            case "color":
            case "colors":
              return "COLOR_0";
            case "texcoord":
            case "texcoords":
              return "TEXCOORD_0";
            default:
              return attributeName;
          }
        }
        _getAccessorMinMax(buffer, size) {
          const result = { min: null, max: null };
          if (buffer.length < size) {
            return result;
          }
          result.min = [];
          result.max = [];
          const initValues = buffer.subarray(0, size);
          for (const value of initValues) {
            result.min.push(value);
            result.max.push(value);
          }
          for (let index = size; index < buffer.length; index += size) {
            for (let componentIndex = 0; componentIndex < size; componentIndex++) {
              result.min[0 + componentIndex] = Math.min(result.min[0 + componentIndex], buffer[index + componentIndex]);
              result.max[0 + componentIndex] = Math.max(result.max[0 + componentIndex], buffer[index + componentIndex]);
            }
          }
          return result;
        }
      };
    }
  });

  // ../gltf/src/meshopt/meshopt-decoder.ts
  async function meshoptDecodeGltfBuffer(target, count, size, source, mode, filter = "NONE") {
    const instance = await loadWasmInstance();
    decode(instance, instance.exports[DECODERS[mode]], target, count, size, source, instance.exports[FILTERS[filter || "NONE"]]);
  }
  async function loadWasmInstance() {
    if (!wasmPromise) {
      wasmPromise = loadWasmModule();
    }
    return wasmPromise;
  }
  async function loadWasmModule() {
    let wasm2 = wasm_base;
    if (WebAssembly.validate(detector)) {
      wasm2 = wasm_simd;
      console.log("Warning: meshopt_decoder is using experimental SIMD support");
    }
    const result = await WebAssembly.instantiate(unpack(wasm2), {});
    await result.instance.exports.__wasm_call_ctors();
    return result.instance;
  }
  function unpack(data) {
    const result = new Uint8Array(data.length);
    for (let i2 = 0; i2 < data.length; ++i2) {
      const ch = data.charCodeAt(i2);
      result[i2] = ch > 96 ? ch - 71 : ch > 64 ? ch - 65 : ch > 47 ? ch + 4 : ch > 46 ? 63 : 62;
    }
    let write = 0;
    for (let i2 = 0; i2 < data.length; ++i2) {
      result[write++] = result[i2] < 60 ? wasmpack[result[i2]] : (result[i2] - 60) * 64 + result[++i2];
    }
    return result.buffer.slice(0, write);
  }
  function decode(instance, fun, target, count, size, source, filter) {
    const sbrk = instance.exports.sbrk;
    const count4 = count + 3 & ~3;
    const tp = sbrk(count4 * size);
    const sp = sbrk(source.length);
    const heap = new Uint8Array(instance.exports.memory.buffer);
    heap.set(source, sp);
    const res = fun(tp, count, size, sp, source.length);
    if (res === 0 && filter) {
      filter(tp, count4, size);
    }
    target.set(heap.subarray(tp, tp + count * size));
    sbrk(tp - sbrk(0));
    if (res !== 0) {
      throw new Error(`Malformed buffer data: ${res}`);
    }
  }
  var wasm_base, wasm_simd, detector, wasmpack, FILTERS, DECODERS, wasmPromise;
  var init_meshopt_decoder = __esm({
    "../gltf/src/meshopt/meshopt-decoder.ts"() {
      wasm_base = "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";
      wasm_simd = "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";
      detector = new Uint8Array([
        0,
        97,
        115,
        109,
        1,
        0,
        0,
        0,
        1,
        4,
        1,
        96,
        0,
        0,
        3,
        3,
        2,
        0,
        0,
        5,
        3,
        1,
        0,
        1,
        12,
        1,
        0,
        10,
        22,
        2,
        12,
        0,
        65,
        0,
        65,
        0,
        65,
        0,
        252,
        10,
        0,
        0,
        11,
        7,
        0,
        65,
        0,
        253,
        15,
        26,
        11
      ]);
      wasmpack = new Uint8Array([
        32,
        0,
        65,
        253,
        3,
        1,
        2,
        34,
        4,
        106,
        6,
        5,
        11,
        8,
        7,
        20,
        13,
        33,
        12,
        16,
        128,
        9,
        116,
        64,
        19,
        113,
        127,
        15,
        10,
        21,
        22,
        14,
        255,
        66,
        24,
        54,
        136,
        107,
        18,
        23,
        192,
        26,
        114,
        118,
        132,
        17,
        77,
        101,
        130,
        144,
        27,
        87,
        131,
        44,
        45,
        74,
        156,
        154,
        70,
        167
      ]);
      FILTERS = {
        0: "",
        1: "meshopt_decodeFilterOct",
        2: "meshopt_decodeFilterQuat",
        3: "meshopt_decodeFilterExp",
        NONE: "",
        OCTAHEDRAL: "meshopt_decodeFilterOct",
        QUATERNION: "meshopt_decodeFilterQuat",
        EXPONENTIAL: "meshopt_decodeFilterExp"
      };
      DECODERS = {
        0: "meshopt_decodeVertexBuffer",
        1: "meshopt_decodeIndexBuffer",
        2: "meshopt_decodeIndexSequence",
        ATTRIBUTES: "meshopt_decodeVertexBuffer",
        TRIANGLES: "meshopt_decodeIndexBuffer",
        INDICES: "meshopt_decodeIndexSequence"
      };
    }
  });

  // ../gltf/src/lib/extensions/EXT_meshopt_compression.ts
  var EXT_meshopt_compression_exports = {};
  __export(EXT_meshopt_compression_exports, {
    decode: () => decode2,
    name: () => name
  });
  async function decode2(gltfData, options) {
    const scenegraph = new GLTFScenegraph(gltfData);
    if (!options?.gltf?.decompressMeshes) {
      return;
    }
    const promises = [];
    for (const bufferViewIndex of gltfData.json.bufferViews || []) {
      promises.push(decodeMeshoptBufferView(scenegraph, bufferViewIndex));
    }
    await Promise.all(promises);
    scenegraph.removeExtension(EXT_MESHOPT_COMPRESSION);
  }
  async function decodeMeshoptBufferView(scenegraph, bufferView) {
    const meshoptExtension = scenegraph.getObjectExtension(bufferView, EXT_MESHOPT_COMPRESSION);
    if (meshoptExtension) {
      const {
        byteOffset = 0,
        byteLength = 0,
        byteStride,
        count,
        mode,
        filter = "NONE",
        buffer: bufferIndex
      } = meshoptExtension;
      const buffer = scenegraph.gltf.buffers[bufferIndex];
      const source = new Uint8Array(buffer.arrayBuffer, buffer.byteOffset + byteOffset, byteLength);
      const result = new Uint8Array(scenegraph.gltf.buffers[bufferView.buffer].arrayBuffer, bufferView.byteOffset, bufferView.byteLength);
      await meshoptDecodeGltfBuffer(result, count, byteStride, source, mode, filter);
      return result;
    }
    return null;
  }
  var EXT_MESHOPT_COMPRESSION, name;
  var init_EXT_meshopt_compression = __esm({
    "../gltf/src/lib/extensions/EXT_meshopt_compression.ts"() {
      init_gltf_scenegraph();
      init_meshopt_decoder();
      EXT_MESHOPT_COMPRESSION = "EXT_meshopt_compression";
      name = EXT_MESHOPT_COMPRESSION;
    }
  });

  // ../gltf/src/lib/extensions/EXT_texture_webp.ts
  var EXT_texture_webp_exports = {};
  __export(EXT_texture_webp_exports, {
    name: () => name2,
    preprocess: () => preprocess
  });
  function preprocess(gltfData, options) {
    const scenegraph = new GLTFScenegraph(gltfData);
    if (!isImageFormatSupported("image/webp")) {
      if (scenegraph.getRequiredExtensions().includes(EXT_TEXTURE_WEBP)) {
        throw new Error(`gltf: Required extension ${EXT_TEXTURE_WEBP} not supported by browser`);
      }
      return;
    }
    const { json } = scenegraph;
    for (const texture of json.textures || []) {
      const extension = scenegraph.getObjectExtension(texture, EXT_TEXTURE_WEBP);
      if (extension) {
        texture.source = extension.source;
      }
      scenegraph.removeObjectExtension(texture, EXT_TEXTURE_WEBP);
    }
    scenegraph.removeExtension(EXT_TEXTURE_WEBP);
  }
  var EXT_TEXTURE_WEBP, name2;
  var init_EXT_texture_webp = __esm({
    "../gltf/src/lib/extensions/EXT_texture_webp.ts"() {
      init_src8();
      init_gltf_scenegraph();
      EXT_TEXTURE_WEBP = "EXT_texture_webp";
      name2 = EXT_TEXTURE_WEBP;
    }
  });

  // ../gltf/src/lib/extensions/KHR_texture_basisu.ts
  var KHR_texture_basisu_exports = {};
  __export(KHR_texture_basisu_exports, {
    name: () => name3,
    preprocess: () => preprocess2
  });
  function preprocess2(gltfData, options) {
    const scene = new GLTFScenegraph(gltfData);
    const { json } = scene;
    for (const texture of json.textures || []) {
      const extension = scene.getObjectExtension(texture, KHR_TEXTURE_BASISU);
      if (extension) {
        texture.source = extension.source;
      }
      scene.removeObjectExtension(texture, KHR_TEXTURE_BASISU);
    }
    scene.removeExtension(KHR_TEXTURE_BASISU);
  }
  var KHR_TEXTURE_BASISU, name3;
  var init_KHR_texture_basisu = __esm({
    "../gltf/src/lib/extensions/KHR_texture_basisu.ts"() {
      init_gltf_scenegraph();
      KHR_TEXTURE_BASISU = "KHR_texture_basisu";
      name3 = KHR_TEXTURE_BASISU;
    }
  });

  // ../gltf/src/lib/gltf-utils/gltf-attribute-utils.ts
  function getGLTFAccessors(attributes) {
    const accessors = {};
    for (const name10 in attributes) {
      const attribute = attributes[name10];
      if (name10 !== "indices") {
        const glTFAccessor = getGLTFAccessor(attribute);
        accessors[name10] = glTFAccessor;
      }
    }
    return accessors;
  }
  function getGLTFAccessor(attribute) {
    const { buffer, size, count } = getAccessorData(attribute);
    const glTFAccessor = {
      value: buffer,
      size,
      byteOffset: 0,
      count,
      type: getAccessorTypeFromSize(size),
      componentType: getComponentTypeFromArray(buffer)
    };
    return glTFAccessor;
  }
  function getAccessorData(attribute) {
    let buffer = attribute;
    let size = 1;
    let count = 0;
    if (attribute && attribute.value) {
      buffer = attribute.value;
      size = attribute.size || 1;
    }
    if (buffer) {
      if (!ArrayBuffer.isView(buffer)) {
        buffer = toTypedArray(buffer, Float32Array);
      }
      count = buffer.length / size;
    }
    return { buffer, size, count };
  }
  function toTypedArray(array, ArrayType, convertTypedArrays = false) {
    if (!array) {
      return null;
    }
    if (Array.isArray(array)) {
      return new ArrayType(array);
    }
    if (convertTypedArrays && !(array instanceof ArrayType)) {
      return new ArrayType(array);
    }
    return array;
  }
  var init_gltf_attribute_utils = __esm({
    "../gltf/src/lib/gltf-utils/gltf-attribute-utils.ts"() {
      init_gltf_utils();
    }
  });

  // ../gltf/src/lib/extensions/KHR_draco_mesh_compression.ts
  var KHR_draco_mesh_compression_exports = {};
  __export(KHR_draco_mesh_compression_exports, {
    decode: () => decode3,
    encode: () => encode,
    name: () => name4,
    preprocess: () => preprocess3
  });
  function preprocess3(gltfData, options, context) {
    const scenegraph = new GLTFScenegraph(gltfData);
    for (const primitive of makeMeshPrimitiveIterator(scenegraph)) {
      if (scenegraph.getObjectExtension(primitive, KHR_DRACO_MESH_COMPRESSION)) {
      }
    }
  }
  async function decode3(gltfData, options, context) {
    if (!options?.gltf?.decompressMeshes) {
      return;
    }
    const scenegraph = new GLTFScenegraph(gltfData);
    const promises = [];
    for (const primitive of makeMeshPrimitiveIterator(scenegraph)) {
      if (scenegraph.getObjectExtension(primitive, KHR_DRACO_MESH_COMPRESSION)) {
        promises.push(decompressPrimitive(scenegraph, primitive, options, context));
      }
    }
    await Promise.all(promises);
    scenegraph.removeExtension(KHR_DRACO_MESH_COMPRESSION);
  }
  function encode(gltfData, options = {}) {
    const scenegraph = new GLTFScenegraph(gltfData);
    for (const mesh of scenegraph.json.meshes || []) {
      compressMesh(mesh, options);
      scenegraph.addRequiredExtension(KHR_DRACO_MESH_COMPRESSION);
    }
  }
  async function decompressPrimitive(scenegraph, primitive, options, context) {
    const dracoExtension = scenegraph.getObjectExtension(primitive, KHR_DRACO_MESH_COMPRESSION);
    if (!dracoExtension) {
      return;
    }
    const buffer = scenegraph.getTypedArrayForBufferView(dracoExtension.bufferView);
    const bufferCopy = sliceArrayBuffer(buffer.buffer, buffer.byteOffset);
    const { parse: parse5 } = context;
    const dracoOptions = { ...options };
    delete dracoOptions["3d-tiles"];
    const decodedData = await parse5(bufferCopy, DracoLoader2, dracoOptions, context);
    const decodedAttributes = getGLTFAccessors(decodedData.attributes);
    for (const [attributeName, decodedAttribute] of Object.entries(decodedAttributes)) {
      if (attributeName in primitive.attributes) {
        const accessorIndex = primitive.attributes[attributeName];
        const accessor = scenegraph.getAccessor(accessorIndex);
        if (accessor?.min && accessor?.max) {
          decodedAttribute.min = accessor.min;
          decodedAttribute.max = accessor.max;
        }
      }
    }
    primitive.attributes = decodedAttributes;
    if (decodedData.indices) {
      primitive.indices = getGLTFAccessor(decodedData.indices);
    }
    checkPrimitive(primitive);
  }
  function compressMesh(attributes, indices, mode = 4, options, context) {
    if (!options.DracoWriter) {
      throw new Error("options.gltf.DracoWriter not provided");
    }
    const compressedData = options.DracoWriter.encodeSync({ attributes });
    const decodedData = context?.parseSync?.({ attributes });
    const fauxAccessors = options._addFauxAttributes(decodedData.attributes);
    const bufferViewIndex = options.addBufferView(compressedData);
    const glTFMesh = {
      primitives: [
        {
          attributes: fauxAccessors,
          mode,
          extensions: {
            [KHR_DRACO_MESH_COMPRESSION]: {
              bufferView: bufferViewIndex,
              attributes: fauxAccessors
            }
          }
        }
      ]
    };
    return glTFMesh;
  }
  function checkPrimitive(primitive) {
    if (!primitive.attributes && Object.keys(primitive.attributes).length > 0) {
      throw new Error("glTF: Empty primitive detected: Draco decompression failure?");
    }
  }
  function* makeMeshPrimitiveIterator(scenegraph) {
    for (const mesh of scenegraph.json.meshes || []) {
      for (const primitive of mesh.primitives) {
        yield primitive;
      }
    }
  }
  var KHR_DRACO_MESH_COMPRESSION, name4;
  var init_KHR_draco_mesh_compression = __esm({
    "../gltf/src/lib/extensions/KHR_draco_mesh_compression.ts"() {
      init_src6();
      init_src2();
      init_gltf_scenegraph();
      init_gltf_attribute_utils();
      KHR_DRACO_MESH_COMPRESSION = "KHR_draco_mesh_compression";
      name4 = KHR_DRACO_MESH_COMPRESSION;
    }
  });

  // ../gltf/src/lib/gltf-utils/gltf-constants.ts
  var COMPONENTS, BYTES;
  var init_gltf_constants = __esm({
    "../gltf/src/lib/gltf-utils/gltf-constants.ts"() {
      COMPONENTS = {
        SCALAR: 1,
        VEC2: 2,
        VEC3: 3,
        VEC4: 4,
        MAT2: 4,
        MAT3: 9,
        MAT4: 16
      };
      BYTES = {
        5120: 1,
        5121: 1,
        5122: 2,
        5123: 2,
        5125: 4,
        5126: 4
      };
    }
  });

  // ../gltf/src/lib/extensions/KHR_texture_transform.ts
  var KHR_texture_transform_exports = {};
  __export(KHR_texture_transform_exports, {
    decode: () => decode4,
    name: () => name5
  });
  async function decode4(gltfData, options) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const extension = gltfScenegraph.getExtension(EXT_MESHOPT_TRANSFORM);
    if (!extension) {
      return;
    }
    const materials = gltfData.json.materials || [];
    for (let i2 = 0; i2 < materials.length; i2++) {
      transformTexCoords(i2, gltfData);
    }
  }
  function transformTexCoords(materialIndex, gltfData) {
    const processedTexCoords = [];
    const material = gltfData.json.materials?.[materialIndex];
    const baseColorTexture = material?.pbrMetallicRoughness?.baseColorTexture;
    if (baseColorTexture) {
      transformPrimitives(gltfData, materialIndex, baseColorTexture, processedTexCoords);
    }
    const emisiveTexture = material?.emissiveTexture;
    if (emisiveTexture) {
      transformPrimitives(gltfData, materialIndex, emisiveTexture, processedTexCoords);
    }
    const normalTexture = material?.normalTexture;
    if (normalTexture) {
      transformPrimitives(gltfData, materialIndex, normalTexture, processedTexCoords);
    }
    const occlusionTexture = material?.occlusionTexture;
    if (occlusionTexture) {
      transformPrimitives(gltfData, materialIndex, occlusionTexture, processedTexCoords);
    }
    const metallicRoughnessTexture = material?.pbrMetallicRoughness?.metallicRoughnessTexture;
    if (metallicRoughnessTexture) {
      transformPrimitives(gltfData, materialIndex, metallicRoughnessTexture, processedTexCoords);
    }
  }
  function transformPrimitives(gltfData, materialIndex, texture, processedTexCoords) {
    const transformParameters = getTransformParameters(texture, processedTexCoords);
    if (!transformParameters) {
      return;
    }
    const meshes = gltfData.json.meshes || [];
    for (const mesh of meshes) {
      for (const primitive of mesh.primitives) {
        const material = primitive.material;
        if (Number.isFinite(material) && materialIndex === material) {
          transformPrimitive(gltfData, primitive, transformParameters);
        }
      }
    }
  }
  function getTransformParameters(texture, processedTexCoords) {
    const textureInfo = texture.extensions?.[EXT_MESHOPT_TRANSFORM];
    const { texCoord: originalTexCoord = 0 } = texture;
    const { texCoord = originalTexCoord } = textureInfo;
    const isProcessed = processedTexCoords.findIndex(([original, newTexCoord]) => original === originalTexCoord && newTexCoord === texCoord) !== -1;
    if (!isProcessed) {
      const matrix = makeTransformationMatrix(textureInfo);
      if (originalTexCoord !== texCoord) {
        texture.texCoord = texCoord;
      }
      processedTexCoords.push([originalTexCoord, texCoord]);
      return { originalTexCoord, texCoord, matrix };
    }
    return null;
  }
  function transformPrimitive(gltfData, primitive, transformParameters) {
    const { originalTexCoord, texCoord, matrix } = transformParameters;
    const texCoordAccessor = primitive.attributes[`TEXCOORD_${originalTexCoord}`];
    if (Number.isFinite(texCoordAccessor)) {
      const accessor = gltfData.json.accessors?.[texCoordAccessor];
      if (accessor && accessor.bufferView) {
        const bufferView = gltfData.json.bufferViews?.[accessor.bufferView];
        if (bufferView) {
          const { arrayBuffer, byteOffset: bufferByteOffset } = gltfData.buffers[bufferView.buffer];
          const byteOffset = (bufferByteOffset || 0) + (accessor.byteOffset || 0) + (bufferView.byteOffset || 0);
          const { ArrayType, length: length4 } = getAccessorArrayTypeAndLength(accessor, bufferView);
          const bytes = BYTES[accessor.componentType];
          const components = COMPONENTS[accessor.type];
          const elementAddressScale = bufferView.byteStride || bytes * components;
          const result = new Float32Array(length4);
          for (let i2 = 0; i2 < accessor.count; i2++) {
            const uv = new ArrayType(arrayBuffer, byteOffset + i2 * elementAddressScale, 2);
            scratchVector7.set(uv[0], uv[1], 1);
            scratchVector7.transformByMatrix3(matrix);
            result.set([scratchVector7[0], scratchVector7[1]], i2 * components);
          }
          if (originalTexCoord === texCoord) {
            updateGltf(accessor, bufferView, gltfData.buffers, result);
          } else {
            createAttribute(texCoord, accessor, primitive, gltfData, result);
          }
        }
      }
    }
  }
  function updateGltf(accessor, bufferView, buffers, newTexCoordArray) {
    accessor.componentType = 5126;
    buffers.push({
      arrayBuffer: newTexCoordArray.buffer,
      byteOffset: 0,
      byteLength: newTexCoordArray.buffer.byteLength
    });
    bufferView.buffer = buffers.length - 1;
    bufferView.byteLength = newTexCoordArray.buffer.byteLength;
    bufferView.byteOffset = 0;
    delete bufferView.byteStride;
  }
  function createAttribute(newTexCoord, originalAccessor, primitive, gltfData, newTexCoordArray) {
    gltfData.buffers.push({
      arrayBuffer: newTexCoordArray.buffer,
      byteOffset: 0,
      byteLength: newTexCoordArray.buffer.byteLength
    });
    const bufferViews = gltfData.json.bufferViews;
    if (!bufferViews) {
      return;
    }
    bufferViews.push({
      buffer: gltfData.buffers.length - 1,
      byteLength: newTexCoordArray.buffer.byteLength,
      byteOffset: 0
    });
    const accessors = gltfData.json.accessors;
    if (!accessors) {
      return;
    }
    accessors.push({
      bufferView: bufferViews?.length - 1,
      byteOffset: 0,
      componentType: 5126,
      count: originalAccessor.count,
      type: "VEC2"
    });
    primitive.attributes[`TEXCOORD_${newTexCoord}`] = accessors.length - 1;
  }
  function makeTransformationMatrix(extensionData) {
    const { offset = [0, 0], rotation = 0, scale: scale5 = [1, 1] } = extensionData;
    const translationMatirx = new Matrix3().set(1, 0, 0, 0, 1, 0, offset[0], offset[1], 1);
    const rotationMatirx = scratchRotationMatrix.set(Math.cos(rotation), Math.sin(rotation), 0, -Math.sin(rotation), Math.cos(rotation), 0, 0, 0, 1);
    const scaleMatrix = scratchScaleMatrix.set(scale5[0], 0, 0, 0, scale5[1], 0, 0, 0, 1);
    return translationMatirx.multiplyRight(rotationMatirx).multiplyRight(scaleMatrix);
  }
  var EXT_MESHOPT_TRANSFORM, name5, scratchVector7, scratchRotationMatrix, scratchScaleMatrix;
  var init_KHR_texture_transform = __esm({
    "../gltf/src/lib/extensions/KHR_texture_transform.ts"() {
      init_esm();
      init_gltf_utils();
      init_gltf_constants();
      init_gltf_scenegraph();
      EXT_MESHOPT_TRANSFORM = "KHR_texture_transform";
      name5 = EXT_MESHOPT_TRANSFORM;
      scratchVector7 = new Vector3();
      scratchRotationMatrix = new Matrix3();
      scratchScaleMatrix = new Matrix3();
    }
  });

  // ../gltf/src/lib/extensions/deprecated/KHR_lights_punctual.ts
  var KHR_lights_punctual_exports = {};
  __export(KHR_lights_punctual_exports, {
    decode: () => decode5,
    encode: () => encode2,
    name: () => name6
  });
  async function decode5(gltfData) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const { json } = gltfScenegraph;
    const extension = gltfScenegraph.getExtension(KHR_LIGHTS_PUNCTUAL);
    if (extension) {
      gltfScenegraph.json.lights = extension.lights;
      gltfScenegraph.removeExtension(KHR_LIGHTS_PUNCTUAL);
    }
    for (const node2 of json.nodes || []) {
      const nodeExtension = gltfScenegraph.getObjectExtension(node2, KHR_LIGHTS_PUNCTUAL);
      if (nodeExtension) {
        node2.light = nodeExtension.light;
      }
      gltfScenegraph.removeObjectExtension(node2, KHR_LIGHTS_PUNCTUAL);
    }
  }
  async function encode2(gltfData) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const { json } = gltfScenegraph;
    if (json.lights) {
      const extension = gltfScenegraph.addExtension(KHR_LIGHTS_PUNCTUAL);
      assert8(!extension.lights);
      extension.lights = json.lights;
      delete json.lights;
    }
    if (gltfScenegraph.json.lights) {
      for (const light of gltfScenegraph.json.lights) {
        const node2 = light.node;
        gltfScenegraph.addObjectExtension(node2, KHR_LIGHTS_PUNCTUAL, light);
      }
      delete gltfScenegraph.json.lights;
    }
  }
  var KHR_LIGHTS_PUNCTUAL, name6;
  var init_KHR_lights_punctual = __esm({
    "../gltf/src/lib/extensions/deprecated/KHR_lights_punctual.ts"() {
      init_assert7();
      init_gltf_scenegraph();
      KHR_LIGHTS_PUNCTUAL = "KHR_lights_punctual";
      name6 = KHR_LIGHTS_PUNCTUAL;
    }
  });

  // ../gltf/src/lib/extensions/deprecated/KHR_materials_unlit.ts
  var KHR_materials_unlit_exports = {};
  __export(KHR_materials_unlit_exports, {
    decode: () => decode6,
    encode: () => encode3,
    name: () => name7
  });
  async function decode6(gltfData) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const { json } = gltfScenegraph;
    for (const material of json.materials || []) {
      const extension = material.extensions && material.extensions.KHR_materials_unlit;
      if (extension) {
        material.unlit = true;
      }
      gltfScenegraph.removeObjectExtension(material, KHR_MATERIALS_UNLIT);
    }
    gltfScenegraph.removeExtension(KHR_MATERIALS_UNLIT);
  }
  function encode3(gltfData) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const { json } = gltfScenegraph;
    if (gltfScenegraph.materials) {
      for (const material of json.materials || []) {
        if (material.unlit) {
          delete material.unlit;
          gltfScenegraph.addObjectExtension(material, KHR_MATERIALS_UNLIT, {});
          gltfScenegraph.addExtension(KHR_MATERIALS_UNLIT);
        }
      }
    }
  }
  var KHR_MATERIALS_UNLIT, name7;
  var init_KHR_materials_unlit = __esm({
    "../gltf/src/lib/extensions/deprecated/KHR_materials_unlit.ts"() {
      init_gltf_scenegraph();
      KHR_MATERIALS_UNLIT = "KHR_materials_unlit";
      name7 = KHR_MATERIALS_UNLIT;
    }
  });

  // ../gltf/src/lib/extensions/deprecated/KHR_techniques_webgl.ts
  var KHR_techniques_webgl_exports = {};
  __export(KHR_techniques_webgl_exports, {
    decode: () => decode7,
    encode: () => encode4,
    name: () => name8
  });
  async function decode7(gltfData) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const { json } = gltfScenegraph;
    const extension = gltfScenegraph.getExtension(KHR_TECHNIQUES_WEBGL);
    if (extension) {
      const techniques = resolveTechniques(extension, gltfScenegraph);
      for (const material of json.materials || []) {
        const materialExtension = gltfScenegraph.getObjectExtension(material, KHR_TECHNIQUES_WEBGL);
        if (materialExtension) {
          material.technique = Object.assign({}, materialExtension, techniques[materialExtension.technique]);
          material.technique.values = resolveValues(material.technique, gltfScenegraph);
        }
        gltfScenegraph.removeObjectExtension(material, KHR_TECHNIQUES_WEBGL);
      }
      gltfScenegraph.removeExtension(KHR_TECHNIQUES_WEBGL);
    }
  }
  async function encode4(gltfData, options) {
  }
  function resolveTechniques(techniquesExtension, gltfScenegraph) {
    const { programs = [], shaders = [], techniques = [] } = techniquesExtension;
    const textDecoder = new TextDecoder();
    shaders.forEach((shader) => {
      if (Number.isFinite(shader.bufferView)) {
        shader.code = textDecoder.decode(gltfScenegraph.getTypedArrayForBufferView(shader.bufferView));
      } else {
        throw new Error("KHR_techniques_webgl: no shader code");
      }
    });
    programs.forEach((program) => {
      program.fragmentShader = shaders[program.fragmentShader];
      program.vertexShader = shaders[program.vertexShader];
    });
    techniques.forEach((technique) => {
      technique.program = programs[technique.program];
    });
    return techniques;
  }
  function resolveValues(technique, gltfScenegraph) {
    const values = Object.assign({}, technique.values);
    Object.keys(technique.uniforms || {}).forEach((uniform) => {
      if (technique.uniforms[uniform].value && !(uniform in values)) {
        values[uniform] = technique.uniforms[uniform].value;
      }
    });
    Object.keys(values).forEach((uniform) => {
      if (typeof values[uniform] === "object" && values[uniform].index !== void 0) {
        values[uniform].texture = gltfScenegraph.getTexture(values[uniform].index);
      }
    });
    return values;
  }
  var KHR_TECHNIQUES_WEBGL, name8;
  var init_KHR_techniques_webgl = __esm({
    "../gltf/src/lib/extensions/deprecated/KHR_techniques_webgl.ts"() {
      init_gltf_scenegraph();
      KHR_TECHNIQUES_WEBGL = "KHR_techniques_webgl";
      name8 = KHR_TECHNIQUES_WEBGL;
    }
  });

  // ../gltf/src/lib/extensions/deprecated/EXT_feature_metadata.ts
  var EXT_feature_metadata_exports = {};
  __export(EXT_feature_metadata_exports, {
    decode: () => decode8,
    name: () => name9
  });
  async function decode8(gltfData) {
    const scenegraph = new GLTFScenegraph(gltfData);
    decodeExtFeatureMetadata(scenegraph);
  }
  function decodeExtFeatureMetadata(scenegraph) {
    const extension = scenegraph.getExtension(EXT_FEATURE_METADATA);
    const schemaClasses = extension?.schema?.classes;
    const featureTables = extension?.featureTables;
    const featureTextures = extension?.featureTextures;
    if (featureTextures) {
      console.warn('featureTextures is not yet supported in the "EXT_feature_metadata" extension.');
    }
    if (schemaClasses && featureTables) {
      for (const schemaName in schemaClasses) {
        const schemaClass = schemaClasses[schemaName];
        const featureTable = findFeatureTableByName(featureTables, schemaName);
        if (featureTable) {
          handleFeatureTableProperties(scenegraph, featureTable, schemaClass);
        }
      }
    }
  }
  function handleFeatureTableProperties(scenegraph, featureTable, schemaClass) {
    for (const propertyName in schemaClass.properties) {
      const schemaProperty = schemaClass.properties[propertyName];
      const featureTableProperty = featureTable?.properties?.[propertyName];
      const numberOfFeatures = featureTable.count;
      if (featureTableProperty) {
        const data = getPropertyDataFromBinarySource(scenegraph, schemaProperty, numberOfFeatures, featureTableProperty);
        featureTableProperty.data = data;
      }
    }
  }
  function getPropertyDataFromBinarySource(scenegraph, schemaProperty, numberOfFeatures, featureTableProperty) {
    const bufferView = featureTableProperty.bufferView;
    let data = scenegraph.getTypedArrayForBufferView(bufferView);
    switch (schemaProperty.type) {
      case "STRING": {
        const stringOffsetBufferView = featureTableProperty.stringOffsetBufferView;
        const offsetsData = scenegraph.getTypedArrayForBufferView(stringOffsetBufferView);
        data = getStringAttributes(data, offsetsData, numberOfFeatures);
        break;
      }
      default:
    }
    return data;
  }
  function findFeatureTableByName(featureTables, schemaClassName) {
    for (const featureTableName in featureTables) {
      const featureTable = featureTables[featureTableName];
      if (featureTable.class === schemaClassName) {
        return featureTable;
      }
    }
    return null;
  }
  function getStringAttributes(data, offsetsData, stringsCount) {
    const stringsArray = [];
    const textDecoder = new TextDecoder("utf8");
    let stringOffset = 0;
    const bytesPerStringSize = 4;
    for (let index = 0; index < stringsCount; index++) {
      const stringByteSize = offsetsData[(index + 1) * bytesPerStringSize] - offsetsData[index * bytesPerStringSize];
      const stringData = data.subarray(stringOffset, stringByteSize + stringOffset);
      const stringAttribute = textDecoder.decode(stringData);
      stringsArray.push(stringAttribute);
      stringOffset += stringByteSize;
    }
    return stringsArray;
  }
  var EXT_FEATURE_METADATA, name9;
  var init_EXT_feature_metadata = __esm({
    "../gltf/src/lib/extensions/deprecated/EXT_feature_metadata.ts"() {
      init_gltf_scenegraph();
      EXT_FEATURE_METADATA = "EXT_feature_metadata";
      name9 = EXT_FEATURE_METADATA;
    }
  });

  // ../gltf/src/lib/api/gltf-extensions.ts
  function preprocessExtensions(gltf, options = {}, context) {
    const extensions = EXTENSIONS2.filter((extension) => useExtension(extension.name, options));
    for (const extension of extensions) {
      extension.preprocess?.(gltf, options, context);
    }
  }
  async function decodeExtensions(gltf, options = {}, context) {
    const extensions = EXTENSIONS2.filter((extension) => useExtension(extension.name, options));
    for (const extension of extensions) {
      await extension.decode?.(gltf, options, context);
    }
  }
  function useExtension(extensionName, options) {
    const excludes = options?.gltf?.excludeExtensions || {};
    const exclude = extensionName in excludes && !excludes[extensionName];
    return !exclude;
  }
  var EXTENSIONS2;
  var init_gltf_extensions = __esm({
    "../gltf/src/lib/api/gltf-extensions.ts"() {
      init_EXT_meshopt_compression();
      init_EXT_texture_webp();
      init_KHR_texture_basisu();
      init_KHR_draco_mesh_compression();
      init_KHR_texture_transform();
      init_KHR_lights_punctual();
      init_KHR_materials_unlit();
      init_KHR_techniques_webgl();
      init_EXT_feature_metadata();
      EXTENSIONS2 = [
        EXT_meshopt_compression_exports,
        EXT_texture_webp_exports,
        KHR_texture_basisu_exports,
        KHR_draco_mesh_compression_exports,
        KHR_lights_punctual_exports,
        KHR_materials_unlit_exports,
        KHR_techniques_webgl_exports,
        KHR_texture_transform_exports,
        EXT_feature_metadata_exports
      ];
    }
  });

  // ../gltf/src/lib/extensions/KHR_binary_gltf.ts
  function preprocess4(gltfData) {
    const gltfScenegraph = new GLTFScenegraph(gltfData);
    const { json } = gltfScenegraph;
    for (const image of json.images || []) {
      const extension = gltfScenegraph.getObjectExtension(image, KHR_BINARY_GLTF);
      if (extension) {
        Object.assign(image, extension);
      }
      gltfScenegraph.removeObjectExtension(image, KHR_BINARY_GLTF);
    }
    if (json.buffers && json.buffers[0]) {
      delete json.buffers[0].uri;
    }
    gltfScenegraph.removeExtension(KHR_BINARY_GLTF);
  }
  var KHR_BINARY_GLTF;
  var init_KHR_binary_gltf = __esm({
    "../gltf/src/lib/extensions/KHR_binary_gltf.ts"() {
      init_gltf_scenegraph();
      KHR_BINARY_GLTF = "KHR_binary_glTF";
    }
  });

  // ../gltf/src/lib/api/normalize-gltf-v1.ts
  function normalizeGLTFV1(gltf, options = {}) {
    return new GLTFV1Normalizer().normalize(gltf, options);
  }
  var GLTF_ARRAYS, GLTF_KEYS, GLTFV1Normalizer;
  var init_normalize_gltf_v1 = __esm({
    "../gltf/src/lib/api/normalize-gltf-v1.ts"() {
      init_KHR_binary_gltf();
      GLTF_ARRAYS = {
        accessors: "accessor",
        animations: "animation",
        buffers: "buffer",
        bufferViews: "bufferView",
        images: "image",
        materials: "material",
        meshes: "mesh",
        nodes: "node",
        samplers: "sampler",
        scenes: "scene",
        skins: "skin",
        textures: "texture"
      };
      GLTF_KEYS = {
        accessor: "accessors",
        animations: "animation",
        buffer: "buffers",
        bufferView: "bufferViews",
        image: "images",
        material: "materials",
        mesh: "meshes",
        node: "nodes",
        sampler: "samplers",
        scene: "scenes",
        skin: "skins",
        texture: "textures"
      };
      GLTFV1Normalizer = class {
        constructor() {
          this.idToIndexMap = {
            animations: {},
            accessors: {},
            buffers: {},
            bufferViews: {},
            images: {},
            materials: {},
            meshes: {},
            nodes: {},
            samplers: {},
            scenes: {},
            skins: {},
            textures: {}
          };
        }
        normalize(gltf, options) {
          this.json = gltf.json;
          const json = gltf.json;
          switch (json.asset && json.asset.version) {
            case "2.0":
              return;
            case void 0:
            case "1.0":
              break;
            default:
              console.warn(`glTF: Unknown version ${json.asset.version}`);
              return;
          }
          if (!options.normalize) {
            throw new Error("glTF v1 is not supported.");
          }
          console.warn("Converting glTF v1 to glTF v2 format. This is experimental and may fail.");
          this._addAsset(json);
          this._convertTopLevelObjectsToArrays(json);
          preprocess4(gltf);
          this._convertObjectIdsToArrayIndices(json);
          this._updateObjects(json);
          this._updateMaterial(json);
        }
        _addAsset(json) {
          json.asset = json.asset || {};
          json.asset.version = "2.0";
          json.asset.generator = json.asset.generator || "Normalized to glTF 2.0 by loaders.gl";
        }
        _convertTopLevelObjectsToArrays(json) {
          for (const arrayName in GLTF_ARRAYS) {
            this._convertTopLevelObjectToArray(json, arrayName);
          }
        }
        _convertTopLevelObjectToArray(json, mapName) {
          const objectMap = json[mapName];
          if (!objectMap || Array.isArray(objectMap)) {
            return;
          }
          json[mapName] = [];
          for (const id in objectMap) {
            const object = objectMap[id];
            object.id = object.id || id;
            const index = json[mapName].length;
            json[mapName].push(object);
            this.idToIndexMap[mapName][id] = index;
          }
        }
        _convertObjectIdsToArrayIndices(json) {
          for (const arrayName in GLTF_ARRAYS) {
            this._convertIdsToIndices(json, arrayName);
          }
          if ("scene" in json) {
            json.scene = this._convertIdToIndex(json.scene, "scene");
          }
          for (const texture of json.textures) {
            this._convertTextureIds(texture);
          }
          for (const mesh of json.meshes) {
            this._convertMeshIds(mesh);
          }
          for (const node2 of json.nodes) {
            this._convertNodeIds(node2);
          }
          for (const node2 of json.scenes) {
            this._convertSceneIds(node2);
          }
        }
        _convertTextureIds(texture) {
          if (texture.source) {
            texture.source = this._convertIdToIndex(texture.source, "image");
          }
        }
        _convertMeshIds(mesh) {
          for (const primitive of mesh.primitives) {
            const { attributes, indices, material } = primitive;
            for (const attributeName in attributes) {
              attributes[attributeName] = this._convertIdToIndex(attributes[attributeName], "accessor");
            }
            if (indices) {
              primitive.indices = this._convertIdToIndex(indices, "accessor");
            }
            if (material) {
              primitive.material = this._convertIdToIndex(material, "material");
            }
          }
        }
        _convertNodeIds(node2) {
          if (node2.children) {
            node2.children = node2.children.map((child) => this._convertIdToIndex(child, "node"));
          }
          if (node2.meshes) {
            node2.meshes = node2.meshes.map((mesh) => this._convertIdToIndex(mesh, "mesh"));
          }
        }
        _convertSceneIds(scene) {
          if (scene.nodes) {
            scene.nodes = scene.nodes.map((node2) => this._convertIdToIndex(node2, "node"));
          }
        }
        _convertIdsToIndices(json, topLevelArrayName) {
          if (!json[topLevelArrayName]) {
            console.warn(`gltf v1: json doesn't contain attribute ${topLevelArrayName}`);
            json[topLevelArrayName] = [];
          }
          for (const object of json[topLevelArrayName]) {
            for (const key in object) {
              const id = object[key];
              const index = this._convertIdToIndex(id, key);
              object[key] = index;
            }
          }
        }
        _convertIdToIndex(id, key) {
          const arrayName = GLTF_KEYS[key];
          if (arrayName in this.idToIndexMap) {
            const index = this.idToIndexMap[arrayName][id];
            if (!Number.isFinite(index)) {
              throw new Error(`gltf v1: failed to resolve ${key} with id ${id}`);
            }
            return index;
          }
          return id;
        }
        _updateObjects(json) {
          for (const buffer of this.json.buffers) {
            delete buffer.type;
          }
        }
        _updateMaterial(json) {
          for (const material of json.materials) {
            material.pbrMetallicRoughness = {
              baseColorFactor: [1, 1, 1, 1],
              metallicFactor: 1,
              roughnessFactor: 1
            };
            const textureId = material.values?.tex || material.values?.texture2d_0 || material.values?.diffuseTex;
            const textureIndex = json.textures.findIndex((texture) => texture.id === textureId);
            if (textureIndex !== -1) {
              material.pbrMetallicRoughness.baseColorTexture = { index: textureIndex };
            }
          }
        }
      };
    }
  });

  // ../gltf/src/lib/api/post-process-gltf.ts
  function getBytesFromComponentType(componentType) {
    return BYTES2[componentType];
  }
  function getSizeFromAccessorType(type) {
    return COMPONENTS2[type];
  }
  function postProcessGLTF(gltf, options) {
    return new GLTFPostProcessor().postProcess(gltf, options);
  }
  var COMPONENTS2, BYTES2, GL_SAMPLER, SAMPLER_PARAMETER_GLTF_TO_GL, DEFAULT_SAMPLER, GLTFPostProcessor;
  var init_post_process_gltf = __esm({
    "../gltf/src/lib/api/post-process-gltf.ts"() {
      init_assert7();
      init_gltf_utils();
      COMPONENTS2 = {
        SCALAR: 1,
        VEC2: 2,
        VEC3: 3,
        VEC4: 4,
        MAT2: 4,
        MAT3: 9,
        MAT4: 16
      };
      BYTES2 = {
        5120: 1,
        5121: 1,
        5122: 2,
        5123: 2,
        5125: 4,
        5126: 4
      };
      GL_SAMPLER = {
        TEXTURE_MAG_FILTER: 10240,
        TEXTURE_MIN_FILTER: 10241,
        TEXTURE_WRAP_S: 10242,
        TEXTURE_WRAP_T: 10243,
        REPEAT: 10497,
        LINEAR: 9729,
        NEAREST_MIPMAP_LINEAR: 9986
      };
      SAMPLER_PARAMETER_GLTF_TO_GL = {
        magFilter: GL_SAMPLER.TEXTURE_MAG_FILTER,
        minFilter: GL_SAMPLER.TEXTURE_MIN_FILTER,
        wrapS: GL_SAMPLER.TEXTURE_WRAP_S,
        wrapT: GL_SAMPLER.TEXTURE_WRAP_T
      };
      DEFAULT_SAMPLER = {
        [GL_SAMPLER.TEXTURE_MAG_FILTER]: GL_SAMPLER.LINEAR,
        [GL_SAMPLER.TEXTURE_MIN_FILTER]: GL_SAMPLER.NEAREST_MIPMAP_LINEAR,
        [GL_SAMPLER.TEXTURE_WRAP_S]: GL_SAMPLER.REPEAT,
        [GL_SAMPLER.TEXTURE_WRAP_T]: GL_SAMPLER.REPEAT
      };
      GLTFPostProcessor = class {
        constructor() {
          this.baseUri = "";
          this.json = {};
          this.buffers = [];
          this.images = [];
        }
        postProcess(gltf, options = {}) {
          const { json, buffers = [], images = [], baseUri = "" } = gltf;
          assert8(json);
          this.baseUri = baseUri;
          this.json = json;
          this.buffers = buffers;
          this.images = images;
          this._resolveTree(this.json, options);
          return this.json;
        }
        _resolveTree(json, options = {}) {
          if (json.bufferViews) {
            json.bufferViews = json.bufferViews.map((bufView, i2) => this._resolveBufferView(bufView, i2));
          }
          if (json.images) {
            json.images = json.images.map((image, i2) => this._resolveImage(image, i2));
          }
          if (json.samplers) {
            json.samplers = json.samplers.map((sampler, i2) => this._resolveSampler(sampler, i2));
          }
          if (json.textures) {
            json.textures = json.textures.map((texture, i2) => this._resolveTexture(texture, i2));
          }
          if (json.accessors) {
            json.accessors = json.accessors.map((accessor, i2) => this._resolveAccessor(accessor, i2));
          }
          if (json.materials) {
            json.materials = json.materials.map((material, i2) => this._resolveMaterial(material, i2));
          }
          if (json.meshes) {
            json.meshes = json.meshes.map((mesh, i2) => this._resolveMesh(mesh, i2));
          }
          if (json.nodes) {
            json.nodes = json.nodes.map((node2, i2) => this._resolveNode(node2, i2));
          }
          if (json.skins) {
            json.skins = json.skins.map((skin, i2) => this._resolveSkin(skin, i2));
          }
          if (json.scenes) {
            json.scenes = json.scenes.map((scene, i2) => this._resolveScene(scene, i2));
          }
          if (json.scene !== void 0) {
            json.scene = json.scenes[this.json.scene];
          }
        }
        getScene(index) {
          return this._get("scenes", index);
        }
        getNode(index) {
          return this._get("nodes", index);
        }
        getSkin(index) {
          return this._get("skins", index);
        }
        getMesh(index) {
          return this._get("meshes", index);
        }
        getMaterial(index) {
          return this._get("materials", index);
        }
        getAccessor(index) {
          return this._get("accessors", index);
        }
        getCamera(index) {
          return null;
        }
        getTexture(index) {
          return this._get("textures", index);
        }
        getSampler(index) {
          return this._get("samplers", index);
        }
        getImage(index) {
          return this._get("images", index);
        }
        getBufferView(index) {
          return this._get("bufferViews", index);
        }
        getBuffer(index) {
          return this._get("buffers", index);
        }
        _get(array, index) {
          if (typeof index === "object") {
            return index;
          }
          const object = this.json[array] && this.json[array][index];
          if (!object) {
            console.warn(`glTF file error: Could not find ${array}[${index}]`);
          }
          return object;
        }
        _resolveScene(scene, index) {
          scene.id = scene.id || `scene-${index}`;
          scene.nodes = (scene.nodes || []).map((node2) => this.getNode(node2));
          return scene;
        }
        _resolveNode(node2, index) {
          node2.id = node2.id || `node-${index}`;
          if (node2.children) {
            node2.children = node2.children.map((child) => this.getNode(child));
          }
          if (node2.mesh !== void 0) {
            node2.mesh = this.getMesh(node2.mesh);
          } else if (node2.meshes !== void 0 && node2.meshes.length) {
            node2.mesh = node2.meshes.reduce((accum, meshIndex) => {
              const mesh = this.getMesh(meshIndex);
              accum.id = mesh.id;
              accum.primitives = accum.primitives.concat(mesh.primitives);
              return accum;
            }, { primitives: [] });
          }
          if (node2.camera !== void 0) {
            node2.camera = this.getCamera(node2.camera);
          }
          if (node2.skin !== void 0) {
            node2.skin = this.getSkin(node2.skin);
          }
          return node2;
        }
        _resolveSkin(skin, index) {
          skin.id = skin.id || `skin-${index}`;
          skin.inverseBindMatrices = this.getAccessor(skin.inverseBindMatrices);
          return skin;
        }
        _resolveMesh(mesh, index) {
          mesh.id = mesh.id || `mesh-${index}`;
          if (mesh.primitives) {
            mesh.primitives = mesh.primitives.map((primitive) => {
              primitive = { ...primitive };
              const attributes = primitive.attributes;
              primitive.attributes = {};
              for (const attribute in attributes) {
                primitive.attributes[attribute] = this.getAccessor(attributes[attribute]);
              }
              if (primitive.indices !== void 0) {
                primitive.indices = this.getAccessor(primitive.indices);
              }
              if (primitive.material !== void 0) {
                primitive.material = this.getMaterial(primitive.material);
              }
              return primitive;
            });
          }
          return mesh;
        }
        _resolveMaterial(material, index) {
          material.id = material.id || `material-${index}`;
          if (material.normalTexture) {
            material.normalTexture = { ...material.normalTexture };
            material.normalTexture.texture = this.getTexture(material.normalTexture.index);
          }
          if (material.occlusionTexture) {
            material.occlustionTexture = { ...material.occlustionTexture };
            material.occlusionTexture.texture = this.getTexture(material.occlusionTexture.index);
          }
          if (material.emissiveTexture) {
            material.emmisiveTexture = { ...material.emmisiveTexture };
            material.emissiveTexture.texture = this.getTexture(material.emissiveTexture.index);
          }
          if (!material.emissiveFactor) {
            material.emissiveFactor = material.emmisiveTexture ? [1, 1, 1] : [0, 0, 0];
          }
          if (material.pbrMetallicRoughness) {
            material.pbrMetallicRoughness = { ...material.pbrMetallicRoughness };
            const mr = material.pbrMetallicRoughness;
            if (mr.baseColorTexture) {
              mr.baseColorTexture = { ...mr.baseColorTexture };
              mr.baseColorTexture.texture = this.getTexture(mr.baseColorTexture.index);
            }
            if (mr.metallicRoughnessTexture) {
              mr.metallicRoughnessTexture = { ...mr.metallicRoughnessTexture };
              mr.metallicRoughnessTexture.texture = this.getTexture(mr.metallicRoughnessTexture.index);
            }
          }
          return material;
        }
        _resolveAccessor(accessor, index) {
          accessor.id = accessor.id || `accessor-${index}`;
          if (accessor.bufferView !== void 0) {
            accessor.bufferView = this.getBufferView(accessor.bufferView);
          }
          accessor.bytesPerComponent = getBytesFromComponentType(accessor.componentType);
          accessor.components = getSizeFromAccessorType(accessor.type);
          accessor.bytesPerElement = accessor.bytesPerComponent * accessor.components;
          if (accessor.bufferView) {
            const buffer = accessor.bufferView.buffer;
            const { ArrayType, byteLength } = getAccessorArrayTypeAndLength(accessor, accessor.bufferView);
            const byteOffset = (accessor.bufferView.byteOffset || 0) + (accessor.byteOffset || 0) + buffer.byteOffset;
            let cutBuffer = buffer.arrayBuffer.slice(byteOffset, byteOffset + byteLength);
            if (accessor.bufferView.byteStride) {
              cutBuffer = this._getValueFromInterleavedBuffer(buffer, byteOffset, accessor.bufferView.byteStride, accessor.bytesPerElement, accessor.count);
            }
            accessor.value = new ArrayType(cutBuffer);
          }
          return accessor;
        }
        _getValueFromInterleavedBuffer(buffer, byteOffset, byteStride, bytesPerElement, count) {
          const result = new Uint8Array(count * bytesPerElement);
          for (let i2 = 0; i2 < count; i2++) {
            const elementOffset = byteOffset + i2 * byteStride;
            result.set(new Uint8Array(buffer.arrayBuffer.slice(elementOffset, elementOffset + bytesPerElement)), i2 * bytesPerElement);
          }
          return result.buffer;
        }
        _resolveTexture(texture, index) {
          texture.id = texture.id || `texture-${index}`;
          texture.sampler = "sampler" in texture ? this.getSampler(texture.sampler) : DEFAULT_SAMPLER;
          texture.source = this.getImage(texture.source);
          return texture;
        }
        _resolveSampler(sampler, index) {
          sampler.id = sampler.id || `sampler-${index}`;
          sampler.parameters = {};
          for (const key in sampler) {
            const glEnum = this._enumSamplerParameter(key);
            if (glEnum !== void 0) {
              sampler.parameters[glEnum] = sampler[key];
            }
          }
          return sampler;
        }
        _enumSamplerParameter(key) {
          return SAMPLER_PARAMETER_GLTF_TO_GL[key];
        }
        _resolveImage(image, index) {
          image.id = image.id || `image-${index}`;
          if (image.bufferView !== void 0) {
            image.bufferView = this.getBufferView(image.bufferView);
          }
          const preloadedImage = this.images[index];
          if (preloadedImage) {
            image.image = preloadedImage;
          }
          return image;
        }
        _resolveBufferView(bufferView, index) {
          const bufferIndex = bufferView.buffer;
          const result = {
            id: `bufferView-${index}`,
            ...bufferView,
            buffer: this.buffers[bufferIndex]
          };
          const arrayBuffer = this.buffers[bufferIndex].arrayBuffer;
          let byteOffset = this.buffers[bufferIndex].byteOffset || 0;
          if ("byteOffset" in bufferView) {
            byteOffset += bufferView.byteOffset;
          }
          result.data = new Uint8Array(arrayBuffer, byteOffset, bufferView.byteLength);
          return result;
        }
        _resolveCamera(camera, index) {
          camera.id = camera.id || `camera-${index}`;
          if (camera.perspective) {
          }
          if (camera.orthographic) {
          }
          return camera;
        }
      };
    }
  });

  // ../gltf/src/lib/parsers/parse-glb.ts
  function getMagicString4(dataView, byteOffset = 0) {
    return `${String.fromCharCode(dataView.getUint8(byteOffset + 0))}${String.fromCharCode(dataView.getUint8(byteOffset + 1))}${String.fromCharCode(dataView.getUint8(byteOffset + 2))}${String.fromCharCode(dataView.getUint8(byteOffset + 3))}`;
  }
  function isGLB(arrayBuffer, byteOffset = 0, options = {}) {
    const dataView = new DataView(arrayBuffer);
    const { magic = MAGIC_glTF } = options;
    const magic1 = dataView.getUint32(byteOffset, false);
    return magic1 === magic || magic1 === MAGIC_glTF;
  }
  function parseGLBSync(glb, arrayBuffer, byteOffset = 0, options = {}) {
    const dataView = new DataView(arrayBuffer);
    const type = getMagicString4(dataView, byteOffset + 0);
    const version = dataView.getUint32(byteOffset + 4, LE);
    const byteLength = dataView.getUint32(byteOffset + 8, LE);
    Object.assign(glb, {
      header: {
        byteOffset,
        byteLength,
        hasBinChunk: false
      },
      type,
      version,
      json: {},
      binChunks: []
    });
    byteOffset += GLB_FILE_HEADER_SIZE;
    switch (glb.version) {
      case 1:
        return parseGLBV1(glb, dataView, byteOffset);
      case 2:
        return parseGLBV2(glb, dataView, byteOffset, options = {});
      default:
        throw new Error(`Invalid GLB version ${glb.version}. Only supports v1 and v2.`);
    }
  }
  function parseGLBV1(glb, dataView, byteOffset) {
    assert2(glb.header.byteLength > GLB_FILE_HEADER_SIZE + GLB_CHUNK_HEADER_SIZE);
    const contentLength = dataView.getUint32(byteOffset + 0, LE);
    const contentFormat = dataView.getUint32(byteOffset + 4, LE);
    byteOffset += GLB_CHUNK_HEADER_SIZE;
    assert2(contentFormat === GLB_V1_CONTENT_FORMAT_JSON);
    parseJSONChunk(glb, dataView, byteOffset, contentLength);
    byteOffset += contentLength;
    byteOffset += parseBINChunk(glb, dataView, byteOffset, glb.header.byteLength);
    return byteOffset;
  }
  function parseGLBV2(glb, dataView, byteOffset, options) {
    assert2(glb.header.byteLength > GLB_FILE_HEADER_SIZE + GLB_CHUNK_HEADER_SIZE);
    parseGLBChunksSync(glb, dataView, byteOffset, options);
    return byteOffset + glb.header.byteLength;
  }
  function parseGLBChunksSync(glb, dataView, byteOffset, options) {
    while (byteOffset + 8 <= glb.header.byteLength) {
      const chunkLength = dataView.getUint32(byteOffset + 0, LE);
      const chunkFormat = dataView.getUint32(byteOffset + 4, LE);
      byteOffset += GLB_CHUNK_HEADER_SIZE;
      switch (chunkFormat) {
        case GLB_CHUNK_TYPE_JSON:
          parseJSONChunk(glb, dataView, byteOffset, chunkLength);
          break;
        case GLB_CHUNK_TYPE_BIN:
          parseBINChunk(glb, dataView, byteOffset, chunkLength);
          break;
        case GLB_CHUNK_TYPE_JSON_XVIZ_DEPRECATED:
          if (!options.strict) {
            parseJSONChunk(glb, dataView, byteOffset, chunkLength);
          }
          break;
        case GLB_CHUNK_TYPE_BIX_XVIZ_DEPRECATED:
          if (!options.strict) {
            parseBINChunk(glb, dataView, byteOffset, chunkLength);
          }
          break;
        default:
          break;
      }
      byteOffset += padToNBytes(chunkLength, 4);
    }
    return byteOffset;
  }
  function parseJSONChunk(glb, dataView, byteOffset, chunkLength) {
    const jsonChunk = new Uint8Array(dataView.buffer, byteOffset, chunkLength);
    const textDecoder = new TextDecoder("utf8");
    const jsonText = textDecoder.decode(jsonChunk);
    glb.json = JSON.parse(jsonText);
    return padToNBytes(chunkLength, 4);
  }
  function parseBINChunk(glb, dataView, byteOffset, chunkLength) {
    glb.header.hasBinChunk = true;
    glb.binChunks.push({
      byteOffset,
      byteLength: chunkLength,
      arrayBuffer: dataView.buffer
    });
    return padToNBytes(chunkLength, 4);
  }
  var MAGIC_glTF, GLB_FILE_HEADER_SIZE, GLB_CHUNK_HEADER_SIZE, GLB_CHUNK_TYPE_JSON, GLB_CHUNK_TYPE_BIN, GLB_CHUNK_TYPE_JSON_XVIZ_DEPRECATED, GLB_CHUNK_TYPE_BIX_XVIZ_DEPRECATED, GLB_V1_CONTENT_FORMAT_JSON, LE;
  var init_parse_glb = __esm({
    "../gltf/src/lib/parsers/parse-glb.ts"() {
      init_src2();
      MAGIC_glTF = 1735152710;
      GLB_FILE_HEADER_SIZE = 12;
      GLB_CHUNK_HEADER_SIZE = 8;
      GLB_CHUNK_TYPE_JSON = 1313821514;
      GLB_CHUNK_TYPE_BIN = 5130562;
      GLB_CHUNK_TYPE_JSON_XVIZ_DEPRECATED = 0;
      GLB_CHUNK_TYPE_BIX_XVIZ_DEPRECATED = 1;
      GLB_V1_CONTENT_FORMAT_JSON = 0;
      LE = true;
    }
  });

  // ../gltf/src/lib/parsers/parse-gltf.ts
  async function parseGLTF(gltf, arrayBufferOrString, byteOffset = 0, options, context) {
    parseGLTFContainerSync(gltf, arrayBufferOrString, byteOffset, options);
    normalizeGLTFV1(gltf, { normalize: options?.gltf?.normalize });
    preprocessExtensions(gltf, options, context);
    const promises = [];
    if (options?.gltf?.loadBuffers && gltf.json.buffers) {
      await loadBuffers(gltf, options, context);
    }
    if (options?.gltf?.loadImages) {
      const promise2 = loadImages(gltf, options, context);
      promises.push(promise2);
    }
    const promise = decodeExtensions(gltf, options, context);
    promises.push(promise);
    await Promise.all(promises);
    return options?.gltf?.postProcess ? postProcessGLTF(gltf, options) : gltf;
  }
  function parseGLTFContainerSync(gltf, data, byteOffset, options) {
    if (options.uri) {
      gltf.baseUri = options.uri;
    }
    if (data instanceof ArrayBuffer && !isGLB(data, byteOffset, options)) {
      const textDecoder = new TextDecoder();
      data = textDecoder.decode(data);
    }
    if (typeof data === "string") {
      gltf.json = parseJSON(data);
    } else if (data instanceof ArrayBuffer) {
      const glb = {};
      byteOffset = parseGLBSync(glb, data, byteOffset, options.glb);
      assert8(glb.type === "glTF", `Invalid GLB magic string ${glb.type}`);
      gltf._glb = glb;
      gltf.json = glb.json;
    } else {
      assert8(false, "GLTF: must be ArrayBuffer or string");
    }
    const buffers = gltf.json.buffers || [];
    gltf.buffers = new Array(buffers.length).fill(null);
    if (gltf._glb && gltf._glb.header.hasBinChunk) {
      const { binChunks } = gltf._glb;
      gltf.buffers[0] = {
        arrayBuffer: binChunks[0].arrayBuffer,
        byteOffset: binChunks[0].byteOffset,
        byteLength: binChunks[0].byteLength
      };
    }
    const images = gltf.json.images || [];
    gltf.images = new Array(images.length).fill({});
  }
  async function loadBuffers(gltf, options, context) {
    const buffers = gltf.json.buffers || [];
    for (let i2 = 0; i2 < buffers.length; ++i2) {
      const buffer = buffers[i2];
      if (buffer.uri) {
        const { fetch: fetch2 } = context;
        assert8(fetch2);
        const uri = resolveUrl(buffer.uri, options);
        const response = await context?.fetch?.(uri);
        const arrayBuffer = await response?.arrayBuffer?.();
        gltf.buffers[i2] = {
          arrayBuffer,
          byteOffset: 0,
          byteLength: arrayBuffer.byteLength
        };
        delete buffer.uri;
      } else if (gltf.buffers[i2] === null) {
        gltf.buffers[i2] = {
          arrayBuffer: new ArrayBuffer(buffer.byteLength),
          byteOffset: 0,
          byteLength: buffer.byteLength
        };
      }
    }
  }
  async function loadImages(gltf, options, context) {
    const imageIndices = getReferencesImageIndices(gltf);
    const images = gltf.json.images || [];
    const promises = [];
    for (const imageIndex of imageIndices) {
      promises.push(loadImage(gltf, images[imageIndex], imageIndex, options, context));
    }
    return await Promise.all(promises);
  }
  function getReferencesImageIndices(gltf) {
    const imageIndices = new Set();
    const textures = gltf.json.textures || [];
    for (const texture of textures) {
      if (texture.source !== void 0) {
        imageIndices.add(texture.source);
      }
    }
    return Array.from(imageIndices).sort();
  }
  async function loadImage(gltf, image, index, options, context) {
    const { fetch: fetch2, parse: parse5 } = context;
    let arrayBuffer;
    if (image.uri && !image.hasOwnProperty("bufferView")) {
      const uri = resolveUrl(image.uri, options);
      const response = await fetch2(uri);
      arrayBuffer = await response.arrayBuffer();
      image.bufferView = {
        data: arrayBuffer
      };
    }
    if (Number.isFinite(image.bufferView)) {
      const array = getTypedArrayForBufferView(gltf.json, gltf.buffers, image.bufferView);
      arrayBuffer = sliceArrayBuffer(array.buffer, array.byteOffset, array.byteLength);
    }
    assert8(arrayBuffer, "glTF image has no data");
    let parsedImage = await parse5(arrayBuffer, [ImageLoader, BasisLoader], { mimeType: image.mimeType, basis: options.basis || { format: selectSupportedBasisFormat() } }, context);
    if (parsedImage && parsedImage[0]) {
      parsedImage = {
        compressed: true,
        mipmaps: false,
        width: parsedImage[0].width,
        height: parsedImage[0].height,
        data: parsedImage[0]
      };
    }
    gltf.images = gltf.images || [];
    gltf.images[index] = parsedImage;
  }
  var init_parse_gltf = __esm({
    "../gltf/src/lib/parsers/parse-gltf.ts"() {
      init_src9();
      init_src8();
      init_src2();
      init_assert7();
      init_resolve_url();
      init_get_typed_array();
      init_gltf_extensions();
      init_normalize_gltf_v1();
      init_post_process_gltf();
      init_parse_glb();
    }
  });

  // ../gltf/src/gltf-loader.ts
  async function parse3(arrayBuffer, options = {}, context) {
    options = { ...GLTFLoader.options, ...options };
    options.gltf = { ...GLTFLoader.options.gltf, ...options.gltf };
    const { byteOffset = 0 } = options;
    const gltf = {};
    return await parseGLTF(gltf, arrayBuffer, byteOffset, options, context);
  }
  var GLTFLoader;
  var init_gltf_loader = __esm({
    "../gltf/src/gltf-loader.ts"() {
      init_version4();
      init_parse_gltf();
      GLTFLoader = {
        name: "glTF",
        id: "gltf",
        module: "gltf",
        version: VERSION6,
        extensions: ["gltf", "glb"],
        mimeTypes: ["model/gltf+json", "model/gltf-binary"],
        text: true,
        binary: true,
        tests: ["glTF"],
        parse: parse3,
        options: {
          gltf: {
            normalize: true,
            loadBuffers: true,
            loadImages: true,
            decompressMeshes: true,
            postProcess: true
          },
          log: console
        },
        deprecatedOptions: {
          fetchImages: "gltf.loadImages",
          createImages: "gltf.loadImages",
          decompress: "gltf.decompressMeshes",
          postProcess: "gltf.postProcess",
          gltf: {
            decompress: "gltf.decompressMeshes"
          }
        }
      };
    }
  });

  // ../gltf/src/index.ts
  var init_src10 = __esm({
    "../gltf/src/index.ts"() {
      init_gltf_loader();
      init_gltf_utils();
    }
  });

  // src/lib/parsers/helpers/parse-3d-tile-gltf-view.ts
  function parse3DTileGLTFViewSync(tile, arrayBuffer, byteOffset, options) {
    tile.rotateYtoZ = true;
    const gltfByteLength = tile.byteOffset + tile.byteLength - byteOffset;
    if (gltfByteLength === 0) {
      throw new Error("glTF byte length must be greater than 0.");
    }
    tile.gltfUpAxis = options["3d-tiles"] && options["3d-tiles"].assetGltfUpAxis ? options["3d-tiles"].assetGltfUpAxis : "Y";
    tile.gltfArrayBuffer = sliceArrayBuffer(arrayBuffer, byteOffset, gltfByteLength);
    tile.gltfByteOffset = 0;
    tile.gltfByteLength = gltfByteLength;
    if (byteOffset % 4 === 0) {
    } else {
      console.warn(`${tile.type}: embedded glb is not aligned to a 4-byte boundary.`);
    }
    return tile.byteOffset + tile.byteLength;
  }
  async function extractGLTF(tile, gltfFormat, options, context) {
    const tile3DOptions = options["3d-tiles"] || {};
    extractGLTFBufferOrURL(tile, gltfFormat, options);
    if (tile3DOptions.loadGLTF) {
      const { parse: parse5, fetch: fetch2 } = context;
      if (tile.gltfUrl) {
        tile.gltfArrayBuffer = await fetch2(tile.gltfUrl, options);
        tile.gltfByteOffset = 0;
      }
      if (tile.gltfArrayBuffer) {
        tile.gltf = await parse5(tile.gltfArrayBuffer, GLTFLoader, options, context);
        tile.gpuMemoryUsageInBytes = getMemoryUsageGLTF(tile.gltf);
        delete tile.gltfArrayBuffer;
        delete tile.gltfByteOffset;
        delete tile.gltfByteLength;
      }
    }
  }
  function extractGLTFBufferOrURL(tile, gltfFormat, options) {
    switch (gltfFormat) {
      case GLTF_FORMAT.URI:
        const gltfUrlBytes = new Uint8Array(tile.gltfArrayBuffer, tile.gltfByteOffset);
        const textDecoder = new TextDecoder();
        const gltfUrl = textDecoder.decode(gltfUrlBytes);
        tile.gltfUrl = gltfUrl.replace(/[\s\0]+$/, "");
        delete tile.gltfArrayBuffer;
        delete tile.gltfByteOffset;
        delete tile.gltfByteLength;
        break;
      case GLTF_FORMAT.EMBEDDED:
        break;
      default:
        throw new Error("b3dm: Illegal glTF format field");
    }
  }
  var GLTF_FORMAT;
  var init_parse_3d_tile_gltf_view = __esm({
    "src/lib/parsers/helpers/parse-3d-tile-gltf-view.ts"() {
      init_src10();
      init_src2();
      GLTF_FORMAT = {
        URI: 0,
        EMBEDDED: 1
      };
    }
  });

  // src/lib/parsers/parse-3d-tile-batched-model.ts
  async function parseBatchedModel3DTile(tile, arrayBuffer, byteOffset, options, context) {
    byteOffset = parseBatchedModel(tile, arrayBuffer, byteOffset, options, context);
    await extractGLTF(tile, GLTF_FORMAT.EMBEDDED, options, context);
    const extensions = tile?.gltf?.extensions;
    if (extensions && extensions.CESIUM_RTC) {
      tile.rtcCenter = extensions.CESIUM_RTC.center;
    }
    return byteOffset;
  }
  function parseBatchedModel(tile, arrayBuffer, byteOffset, options, context) {
    byteOffset = parse3DTileHeaderSync(tile, arrayBuffer, byteOffset);
    byteOffset = parse3DTileTablesHeaderSync(tile, arrayBuffer, byteOffset);
    byteOffset = parse3DTileTablesSync(tile, arrayBuffer, byteOffset, options);
    byteOffset = parse3DTileGLTFViewSync(tile, arrayBuffer, byteOffset, options);
    const featureTable = new Tile3DFeatureTable(tile.featureTableJson, tile.featureTableBinary);
    tile.rtcCenter = featureTable.getGlobalProperty("RTC_CENTER", GL2.FLOAT, 3);
    return byteOffset;
  }
  var init_parse_3d_tile_batched_model = __esm({
    "src/lib/parsers/parse-3d-tile-batched-model.ts"() {
      init_src7();
      init_tile_3d_feature_table();
      init_parse_3d_tile_header();
      init_parse_3d_tile_tables();
      init_parse_3d_tile_gltf_view();
    }
  });

  // src/lib/parsers/parse-3d-tile-instanced-model.ts
  async function parseInstancedModel3DTile(tile, arrayBuffer, byteOffset, options, context) {
    byteOffset = parseInstancedModel(tile, arrayBuffer, byteOffset, options, context);
    await extractGLTF(tile, tile.gltfFormat, options, context);
    return byteOffset;
  }
  function parseInstancedModel(tile, arrayBuffer, byteOffset, options, context) {
    byteOffset = parse3DTileHeaderSync(tile, arrayBuffer, byteOffset);
    if (tile.version !== 1) {
      throw new Error(`Instanced 3D Model version ${tile.version} is not supported`);
    }
    byteOffset = parse3DTileTablesHeaderSync(tile, arrayBuffer, byteOffset);
    const view = new DataView(arrayBuffer);
    tile.gltfFormat = view.getUint32(byteOffset, true);
    byteOffset += 4;
    byteOffset = parse3DTileTablesSync(tile, arrayBuffer, byteOffset, options);
    byteOffset = parse3DTileGLTFViewSync(tile, arrayBuffer, byteOffset, options);
    if (tile.featureTableJsonByteLength === 0) {
      throw new Error("i3dm parser: featureTableJsonByteLength is zero.");
    }
    const featureTable = new Tile3DFeatureTable(tile.featureTableJson, tile.featureTableBinary);
    const instancesLength = featureTable.getGlobalProperty("INSTANCES_LENGTH");
    featureTable.featuresLength = instancesLength;
    if (!Number.isFinite(instancesLength)) {
      throw new Error("i3dm parser: INSTANCES_LENGTH must be defined");
    }
    tile.eastNorthUp = featureTable.getGlobalProperty("EAST_NORTH_UP");
    tile.rtcCenter = featureTable.getGlobalProperty("RTC_CENTER", GL2.FLOAT, 3);
    const batchTable = new Tile3DBatchTableParser(tile.batchTableJson, tile.batchTableBinary, instancesLength);
    extractInstancedAttributes(tile, featureTable, batchTable, instancesLength);
    return byteOffset;
  }
  function extractInstancedAttributes(tile, featureTable, batchTable, instancesLength) {
    const collectionOptions = {
      instances: new Array(instancesLength),
      batchTable: tile._batchTable,
      cull: false,
      url: void 0,
      gltf: void 0,
      basePath: void 0,
      incrementallyLoadTextures: false,
      forwardAxis: [1, 0, 0]
    };
    const instances = collectionOptions.instances;
    const instancePosition = new Vector3();
    const instanceNormalRight = new Vector3();
    const instanceNormalUp = new Vector3();
    const instanceNormalForward = new Vector3();
    const instanceRotation = new Matrix3();
    const instanceQuaternion = new Quaternion();
    const instanceScale = new Vector3();
    const instanceTranslationRotationScale = {};
    const instanceTransform = new Matrix4();
    const scratch1 = [];
    const scratch2 = [];
    const scratchVector12 = new Vector3();
    const scratchVector26 = new Vector3();
    for (let i2 = 0; i2 < instancesLength; i2++) {
      let position;
      if (featureTable.hasProperty("POSITION")) {
        position = featureTable.getProperty("POSITION", GL2.FLOAT, 3, i2, instancePosition);
      } else if (featureTable.hasProperty("POSITION_QUANTIZED")) {
        position = featureTable.getProperty("POSITION_QUANTIZED", GL2.UNSIGNED_SHORT, 3, i2, instancePosition);
        const quantizedVolumeOffset = featureTable.getGlobalProperty("QUANTIZED_VOLUME_OFFSET", GL2.FLOAT, 3, scratchVector12);
        if (!quantizedVolumeOffset) {
          throw new Error("i3dm parser: QUANTIZED_VOLUME_OFFSET must be defined for quantized positions.");
        }
        const quantizedVolumeScale = featureTable.getGlobalProperty("QUANTIZED_VOLUME_SCALE", GL2.FLOAT, 3, scratchVector26);
        if (!quantizedVolumeScale) {
          throw new Error("i3dm parser: QUANTIZED_VOLUME_SCALE must be defined for quantized positions.");
        }
        const MAX_UNSIGNED_SHORT = 65535;
        for (let j = 0; j < 3; j++) {
          position[j] = position[j] / MAX_UNSIGNED_SHORT * quantizedVolumeScale[j] + quantizedVolumeOffset[j];
        }
      }
      if (!position) {
        throw new Error("i3dm: POSITION or POSITION_QUANTIZED must be defined for each instance.");
      }
      instancePosition.copy(position);
      instanceTranslationRotationScale.translation = instancePosition;
      tile.normalUp = featureTable.getProperty("NORMAL_UP", GL2.FLOAT, 3, i2, scratch1);
      tile.normalRight = featureTable.getProperty("NORMAL_RIGHT", GL2.FLOAT, 3, i2, scratch2);
      const hasCustomOrientation = false;
      if (tile.normalUp) {
        if (!tile.normalRight) {
          throw new Error("i3dm: Custom orientation requires both NORMAL_UP and NORMAL_RIGHT.");
        }
        tile.hasCustomOrientation = true;
      } else {
        tile.octNormalUp = featureTable.getProperty("NORMAL_UP_OCT32P", GL2.UNSIGNED_SHORT, 2, scratch1);
        tile.octNormalRight = featureTable.getProperty("NORMAL_RIGHT_OCT32P", GL2.UNSIGNED_SHORT, 2, scratch2);
        if (tile.octNormalUp) {
          if (!tile.octNormalRight) {
            throw new Error("i3dm: oct-encoded orientation requires NORMAL_UP_OCT32P and NORMAL_RIGHT_OCT32P");
          }
          throw new Error("i3dm: oct-encoded orientation not implemented");
        } else if (tile.eastNorthUp) {
          Ellipsoid.WGS84.eastNorthUpToFixedFrame(instancePosition, instanceTransform);
          instanceTransform.getRotationMatrix3(instanceRotation);
        } else {
          instanceRotation.identity();
        }
      }
      if (hasCustomOrientation) {
        instanceNormalForward.copy(instanceNormalRight).cross(instanceNormalUp).normalize();
        instanceRotation.setColumn(0, instanceNormalRight);
        instanceRotation.setColumn(1, instanceNormalUp);
        instanceRotation.setColumn(2, instanceNormalForward);
      }
      instanceQuaternion.fromMatrix3(instanceRotation);
      instanceTranslationRotationScale.rotation = instanceQuaternion;
      instanceScale.set(1, 1, 1);
      const scale5 = featureTable.getProperty("SCALE", GL2.FLOAT, 1, i2);
      if (Number.isFinite(scale5)) {
        instanceScale.multiplyByScalar(scale5);
      }
      const nonUniformScale = featureTable.getProperty("SCALE_NON_UNIFORM", GL2.FLOAT, 3, i2, scratch1);
      if (nonUniformScale) {
        instanceScale.scale(nonUniformScale);
      }
      instanceTranslationRotationScale.scale = instanceScale;
      let batchId = featureTable.getProperty("BATCH_ID", GL2.UNSIGNED_SHORT, 1, i2);
      if (batchId === void 0) {
        batchId = i2;
      }
      const rotationMatrix = new Matrix4().fromQuaternion(instanceTranslationRotationScale.rotation);
      instanceTransform.identity();
      instanceTransform.translate(instanceTranslationRotationScale.translation);
      instanceTransform.multiplyRight(rotationMatrix);
      instanceTransform.scale(instanceTranslationRotationScale.scale);
      const modelMatrix = instanceTransform.clone();
      instances[i2] = {
        modelMatrix,
        batchId
      };
    }
    tile.instances = instances;
  }
  var init_parse_3d_tile_instanced_model = __esm({
    "src/lib/parsers/parse-3d-tile-instanced-model.ts"() {
      init_esm();
      init_esm2();
      init_src7();
      init_tile_3d_feature_table();
      init_tile_3d_batch_table();
      init_parse_3d_tile_header();
      init_parse_3d_tile_tables();
      init_parse_3d_tile_gltf_view();
    }
  });

  // src/lib/parsers/parse-3d-tile-composite.ts
  async function parseComposite3DTile(tile, arrayBuffer, byteOffset, options, context, parse3DTile2) {
    byteOffset = parse3DTileHeaderSync(tile, arrayBuffer, byteOffset);
    const view = new DataView(arrayBuffer);
    tile.tilesLength = view.getUint32(byteOffset, true);
    byteOffset += 4;
    tile.tiles = [];
    while (tile.tiles.length < tile.tilesLength && tile.byteLength - byteOffset > 12) {
      const subtile = {};
      tile.tiles.push(subtile);
      byteOffset = await parse3DTile2(arrayBuffer, byteOffset, options, context, subtile);
    }
    return byteOffset;
  }
  var init_parse_3d_tile_composite = __esm({
    "src/lib/parsers/parse-3d-tile-composite.ts"() {
      init_parse_3d_tile_header();
    }
  });

  // src/lib/parsers/parse-3d-tile-gltf.ts
  async function parseGltf3DTile(tile, arrayBuffer, options, context) {
    tile.rotateYtoZ = true;
    tile.gltfUpAxis = options["3d-tiles"] && options["3d-tiles"].assetGltfUpAxis ? options["3d-tiles"].assetGltfUpAxis : "Y";
    const { parse: parse5 } = context;
    tile.gltf = await parse5(arrayBuffer, GLTFLoader, options, context);
    tile.gpuMemoryUsageInBytes = getMemoryUsageGLTF(tile.gltf);
  }
  var init_parse_3d_tile_gltf = __esm({
    "src/lib/parsers/parse-3d-tile-gltf.ts"() {
      init_src10();
    }
  });

  // src/lib/parsers/parse-3d-tile.ts
  async function parse3DTile(arrayBuffer, byteOffset = 0, options, context, tile = {}) {
    tile.byteOffset = byteOffset;
    tile.type = getMagicString3(arrayBuffer, byteOffset);
    switch (tile.type) {
      case TILE3D_TYPE.COMPOSITE:
        return await parseComposite3DTile(tile, arrayBuffer, byteOffset, options, context, parse3DTile);
      case TILE3D_TYPE.BATCHED_3D_MODEL:
        return await parseBatchedModel3DTile(tile, arrayBuffer, byteOffset, options, context);
      case TILE3D_TYPE.GLTF:
        return await parseGltf3DTile(tile, arrayBuffer, options, context);
      case TILE3D_TYPE.INSTANCED_3D_MODEL:
        return await parseInstancedModel3DTile(tile, arrayBuffer, byteOffset, options, context);
      case TILE3D_TYPE.POINT_CLOUD:
        return await parsePointCloud3DTile(tile, arrayBuffer, byteOffset, options, context);
      default:
        throw new Error(`3DTileLoader: unknown type ${tile.type}`);
    }
  }
  var init_parse_3d_tile = __esm({
    "src/lib/parsers/parse-3d-tile.ts"() {
      init_constants4();
      init_parse_utils();
      init_parse_3d_tile_point_cloud();
      init_parse_3d_tile_batched_model();
      init_parse_3d_tile_instanced_model();
      init_parse_3d_tile_composite();
      init_parse_3d_tile_gltf();
    }
  });

  // src/lib/parsers/helpers/parse-3d-tile-subtree.ts
  async function parse3DTilesSubtree(data, options, context) {
    const magic = new Uint32Array(data.slice(0, 4));
    if (magic[0] !== SUBTREE_FILE_MAGIC) {
      throw new Error("Wrong subtree file magic number");
    }
    const version = new Uint32Array(data.slice(4, 8));
    if (version[0] !== SUBTREE_FILE_VERSION) {
      throw new Error("Wrong subtree file verson, must be 1");
    }
    const jsonByteLength = parseUint64Value(data.slice(8, 16));
    const stringAttribute = new Uint8Array(data, 24, jsonByteLength);
    const textDecoder = new TextDecoder("utf8");
    const string = textDecoder.decode(stringAttribute);
    const subtree = JSON.parse(string);
    const binaryByteLength = parseUint64Value(data.slice(16, 24));
    let internalBinaryBuffer = new ArrayBuffer(0);
    if (binaryByteLength) {
      internalBinaryBuffer = data.slice(24 + jsonByteLength);
    }
    if ("bufferView" in subtree.tileAvailability) {
      subtree.tileAvailability.explicitBitstream = await getExplicitBitstream(subtree, "tileAvailability", internalBinaryBuffer, context);
    }
    if ("bufferView" in subtree.contentAvailability) {
      subtree.contentAvailability.explicitBitstream = await getExplicitBitstream(subtree, "contentAvailability", internalBinaryBuffer, context);
    }
    if ("bufferView" in subtree.childSubtreeAvailability) {
      subtree.childSubtreeAvailability.explicitBitstream = await getExplicitBitstream(subtree, "childSubtreeAvailability", internalBinaryBuffer, context);
    }
    return subtree;
  }
  function resolveBufferUri(bitstreamRelativeUri, basePath) {
    const hasProtocol = basePath.startsWith("http");
    if (hasProtocol) {
      const resolvedUri2 = new URL(bitstreamRelativeUri, basePath);
      return decodeURI(resolvedUri2.toString());
    }
    const basePathWithProtocol = `http://${basePath}`;
    const resolvedUri = new URL(bitstreamRelativeUri, basePathWithProtocol);
    return `/${resolvedUri.host}${resolvedUri.pathname}`;
  }
  async function getExplicitBitstream(subtree, name10, internalBinaryBuffer, context) {
    const bufferViewIndex = subtree[name10].bufferView;
    const bufferView = subtree.bufferViews[bufferViewIndex];
    const buffer = subtree.buffers[bufferView.buffer];
    if (!context?.url || !context.fetch) {
      throw new Error("Url is not provided");
    }
    if (!context.fetch) {
      throw new Error("fetch is not provided");
    }
    if (buffer.uri) {
      const bufferUri = resolveBufferUri(buffer.uri, context?.url);
      const response = await context.fetch(bufferUri);
      const data = await response.arrayBuffer();
      return new Uint8Array(data, bufferView.byteOffset, bufferView.byteLength);
    }
    return new Uint8Array(internalBinaryBuffer, bufferView.byteOffset, bufferView.byteLength);
  }
  function parseUint64Value(buffer) {
    const dataView = new DataView(buffer);
    const left = dataView.getUint32(0, true);
    const right = dataView.getUint32(4, true);
    return left + 2 ** 32 * right;
  }
  var SUBTREE_FILE_MAGIC, SUBTREE_FILE_VERSION;
  var init_parse_3d_tile_subtree = __esm({
    "src/lib/parsers/helpers/parse-3d-tile-subtree.ts"() {
      SUBTREE_FILE_MAGIC = 1952609651;
      SUBTREE_FILE_VERSION = 1;
    }
  });

  // src/tile-3d-subtree-loader.ts
  var Tile3DSubtreeLoader;
  var init_tile_3d_subtree_loader = __esm({
    "src/tile-3d-subtree-loader.ts"() {
      init_parse_3d_tile_subtree();
      init_version2();
      Tile3DSubtreeLoader = {
        id: "3d-tiles-subtree",
        name: "3D Tiles Subtree",
        module: "3d-tiles",
        version: VERSION4,
        extensions: ["subtree"],
        mimeTypes: ["application/octet-stream"],
        tests: ["subtree"],
        parse: parse3DTilesSubtree,
        options: {}
      };
    }
  });

  // ../../node_modules/long/index.js
  function Long(low, high, unsigned) {
    this.low = low | 0;
    this.high = high | 0;
    this.unsigned = !!unsigned;
  }
  function isLong(obj) {
    return (obj && obj["__isLong__"]) === true;
  }
  function ctz32(value) {
    var c = Math.clz32(value & -value);
    return value ? 31 - c : c;
  }
  function fromInt(value, unsigned) {
    var obj, cachedObj, cache2;
    if (unsigned) {
      value >>>= 0;
      if (cache2 = 0 <= value && value < 256) {
        cachedObj = UINT_CACHE[value];
        if (cachedObj)
          return cachedObj;
      }
      obj = fromBits(value, 0, true);
      if (cache2)
        UINT_CACHE[value] = obj;
      return obj;
    } else {
      value |= 0;
      if (cache2 = -128 <= value && value < 128) {
        cachedObj = INT_CACHE[value];
        if (cachedObj)
          return cachedObj;
      }
      obj = fromBits(value, value < 0 ? -1 : 0, false);
      if (cache2)
        INT_CACHE[value] = obj;
      return obj;
    }
  }
  function fromNumber(value, unsigned) {
    if (isNaN(value))
      return unsigned ? UZERO : ZERO4;
    if (unsigned) {
      if (value < 0)
        return UZERO;
      if (value >= TWO_PWR_64_DBL)
        return MAX_UNSIGNED_VALUE;
    } else {
      if (value <= -TWO_PWR_63_DBL)
        return MIN_VALUE;
      if (value + 1 >= TWO_PWR_63_DBL)
        return MAX_VALUE;
    }
    if (value < 0)
      return fromNumber(-value, unsigned).neg();
    return fromBits(value % TWO_PWR_32_DBL | 0, value / TWO_PWR_32_DBL | 0, unsigned);
  }
  function fromBits(lowBits, highBits, unsigned) {
    return new Long(lowBits, highBits, unsigned);
  }
  function fromString(str, unsigned, radix) {
    if (str.length === 0)
      throw Error("empty string");
    if (typeof unsigned === "number") {
      radix = unsigned;
      unsigned = false;
    } else {
      unsigned = !!unsigned;
    }
    if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity")
      return unsigned ? UZERO : ZERO4;
    radix = radix || 10;
    if (radix < 2 || 36 < radix)
      throw RangeError("radix");
    var p2;
    if ((p2 = str.indexOf("-")) > 0)
      throw Error("interior hyphen");
    else if (p2 === 0) {
      return fromString(str.substring(1), unsigned, radix).neg();
    }
    var radixToPower = fromNumber(pow_dbl(radix, 8));
    var result = ZERO4;
    for (var i2 = 0; i2 < str.length; i2 += 8) {
      var size = Math.min(8, str.length - i2), value = parseInt(str.substring(i2, i2 + size), radix);
      if (size < 8) {
        var power = fromNumber(pow_dbl(radix, size));
        result = result.mul(power).add(fromNumber(value));
      } else {
        result = result.mul(radixToPower);
        result = result.add(fromNumber(value));
      }
    }
    result.unsigned = unsigned;
    return result;
  }
  function fromValue(val, unsigned) {
    if (typeof val === "number")
      return fromNumber(val, unsigned);
    if (typeof val === "string")
      return fromString(val, unsigned);
    return fromBits(val.low, val.high, typeof unsigned === "boolean" ? unsigned : val.unsigned);
  }
  var wasm, INT_CACHE, UINT_CACHE, pow_dbl, TWO_PWR_16_DBL, TWO_PWR_24_DBL, TWO_PWR_32_DBL, TWO_PWR_64_DBL, TWO_PWR_63_DBL, TWO_PWR_24, ZERO4, UZERO, ONE, UONE, NEG_ONE, MAX_VALUE, MAX_UNSIGNED_VALUE, MIN_VALUE, LongPrototype, long_default;
  var init_long = __esm({
    "../../node_modules/long/index.js"() {
      wasm = null;
      try {
        wasm = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([
          0,
          97,
          115,
          109,
          1,
          0,
          0,
          0,
          1,
          13,
          2,
          96,
          0,
          1,
          127,
          96,
          4,
          127,
          127,
          127,
          127,
          1,
          127,
          3,
          7,
          6,
          0,
          1,
          1,
          1,
          1,
          1,
          6,
          6,
          1,
          127,
          1,
          65,
          0,
          11,
          7,
          50,
          6,
          3,
          109,
          117,
          108,
          0,
          1,
          5,
          100,
          105,
          118,
          95,
          115,
          0,
          2,
          5,
          100,
          105,
          118,
          95,
          117,
          0,
          3,
          5,
          114,
          101,
          109,
          95,
          115,
          0,
          4,
          5,
          114,
          101,
          109,
          95,
          117,
          0,
          5,
          8,
          103,
          101,
          116,
          95,
          104,
          105,
          103,
          104,
          0,
          0,
          10,
          191,
          1,
          6,
          4,
          0,
          35,
          0,
          11,
          36,
          1,
          1,
          126,
          32,
          0,
          173,
          32,
          1,
          173,
          66,
          32,
          134,
          132,
          32,
          2,
          173,
          32,
          3,
          173,
          66,
          32,
          134,
          132,
          126,
          34,
          4,
          66,
          32,
          135,
          167,
          36,
          0,
          32,
          4,
          167,
          11,
          36,
          1,
          1,
          126,
          32,
          0,
          173,
          32,
          1,
          173,
          66,
          32,
          134,
          132,
          32,
          2,
          173,
          32,
          3,
          173,
          66,
          32,
          134,
          132,
          127,
          34,
          4,
          66,
          32,
          135,
          167,
          36,
          0,
          32,
          4,
          167,
          11,
          36,
          1,
          1,
          126,
          32,
          0,
          173,
          32,
          1,
          173,
          66,
          32,
          134,
          132,
          32,
          2,
          173,
          32,
          3,
          173,
          66,
          32,
          134,
          132,
          128,
          34,
          4,
          66,
          32,
          135,
          167,
          36,
          0,
          32,
          4,
          167,
          11,
          36,
          1,
          1,
          126,
          32,
          0,
          173,
          32,
          1,
          173,
          66,
          32,
          134,
          132,
          32,
          2,
          173,
          32,
          3,
          173,
          66,
          32,
          134,
          132,
          129,
          34,
          4,
          66,
          32,
          135,
          167,
          36,
          0,
          32,
          4,
          167,
          11,
          36,
          1,
          1,
          126,
          32,
          0,
          173,
          32,
          1,
          173,
          66,
          32,
          134,
          132,
          32,
          2,
          173,
          32,
          3,
          173,
          66,
          32,
          134,
          132,
          130,
          34,
          4,
          66,
          32,
          135,
          167,
          36,
          0,
          32,
          4,
          167,
          11
        ])), {}).exports;
      } catch (e) {
      }
      Long.prototype.__isLong__;
      Object.defineProperty(Long.prototype, "__isLong__", { value: true });
      Long.isLong = isLong;
      INT_CACHE = {};
      UINT_CACHE = {};
      Long.fromInt = fromInt;
      Long.fromNumber = fromNumber;
      Long.fromBits = fromBits;
      pow_dbl = Math.pow;
      Long.fromString = fromString;
      Long.fromValue = fromValue;
      TWO_PWR_16_DBL = 1 << 16;
      TWO_PWR_24_DBL = 1 << 24;
      TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;
      TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;
      TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;
      TWO_PWR_24 = fromInt(TWO_PWR_24_DBL);
      ZERO4 = fromInt(0);
      Long.ZERO = ZERO4;
      UZERO = fromInt(0, true);
      Long.UZERO = UZERO;
      ONE = fromInt(1);
      Long.ONE = ONE;
      UONE = fromInt(1, true);
      Long.UONE = UONE;
      NEG_ONE = fromInt(-1);
      Long.NEG_ONE = NEG_ONE;
      MAX_VALUE = fromBits(4294967295 | 0, 2147483647 | 0, false);
      Long.MAX_VALUE = MAX_VALUE;
      MAX_UNSIGNED_VALUE = fromBits(4294967295 | 0, 4294967295 | 0, true);
      Long.MAX_UNSIGNED_VALUE = MAX_UNSIGNED_VALUE;
      MIN_VALUE = fromBits(0, 2147483648 | 0, false);
      Long.MIN_VALUE = MIN_VALUE;
      LongPrototype = Long.prototype;
      LongPrototype.toInt = function toInt() {
        return this.unsigned ? this.low >>> 0 : this.low;
      };
      LongPrototype.toNumber = function toNumber() {
        if (this.unsigned)
          return (this.high >>> 0) * TWO_PWR_32_DBL + (this.low >>> 0);
        return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
      };
      LongPrototype.toString = function toString(radix) {
        radix = radix || 10;
        if (radix < 2 || 36 < radix)
          throw RangeError("radix");
        if (this.isZero())
          return "0";
        if (this.isNegative()) {
          if (this.eq(MIN_VALUE)) {
            var radixLong = fromNumber(radix), div = this.div(radixLong), rem1 = div.mul(radixLong).sub(this);
            return div.toString(radix) + rem1.toInt().toString(radix);
          } else
            return "-" + this.neg().toString(radix);
        }
        var radixToPower = fromNumber(pow_dbl(radix, 6), this.unsigned), rem = this;
        var result = "";
        while (true) {
          var remDiv = rem.div(radixToPower), intval = rem.sub(remDiv.mul(radixToPower)).toInt() >>> 0, digits = intval.toString(radix);
          rem = remDiv;
          if (rem.isZero())
            return digits + result;
          else {
            while (digits.length < 6)
              digits = "0" + digits;
            result = "" + digits + result;
          }
        }
      };
      LongPrototype.getHighBits = function getHighBits() {
        return this.high;
      };
      LongPrototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
        return this.high >>> 0;
      };
      LongPrototype.getLowBits = function getLowBits() {
        return this.low;
      };
      LongPrototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
        return this.low >>> 0;
      };
      LongPrototype.getNumBitsAbs = function getNumBitsAbs() {
        if (this.isNegative())
          return this.eq(MIN_VALUE) ? 64 : this.neg().getNumBitsAbs();
        var val = this.high != 0 ? this.high : this.low;
        for (var bit = 31; bit > 0; bit--)
          if ((val & 1 << bit) != 0)
            break;
        return this.high != 0 ? bit + 33 : bit + 1;
      };
      LongPrototype.isZero = function isZero() {
        return this.high === 0 && this.low === 0;
      };
      LongPrototype.eqz = LongPrototype.isZero;
      LongPrototype.isNegative = function isNegative() {
        return !this.unsigned && this.high < 0;
      };
      LongPrototype.isPositive = function isPositive() {
        return this.unsigned || this.high >= 0;
      };
      LongPrototype.isOdd = function isOdd() {
        return (this.low & 1) === 1;
      };
      LongPrototype.isEven = function isEven() {
        return (this.low & 1) === 0;
      };
      LongPrototype.equals = function equals3(other) {
        if (!isLong(other))
          other = fromValue(other);
        if (this.unsigned !== other.unsigned && this.high >>> 31 === 1 && other.high >>> 31 === 1)
          return false;
        return this.high === other.high && this.low === other.low;
      };
      LongPrototype.eq = LongPrototype.equals;
      LongPrototype.notEquals = function notEquals(other) {
        return !this.eq(other);
      };
      LongPrototype.neq = LongPrototype.notEquals;
      LongPrototype.ne = LongPrototype.notEquals;
      LongPrototype.lessThan = function lessThan(other) {
        return this.comp(other) < 0;
      };
      LongPrototype.lt = LongPrototype.lessThan;
      LongPrototype.lessThanOrEqual = function lessThanOrEqual(other) {
        return this.comp(other) <= 0;
      };
      LongPrototype.lte = LongPrototype.lessThanOrEqual;
      LongPrototype.le = LongPrototype.lessThanOrEqual;
      LongPrototype.greaterThan = function greaterThan(other) {
        return this.comp(other) > 0;
      };
      LongPrototype.gt = LongPrototype.greaterThan;
      LongPrototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
        return this.comp(other) >= 0;
      };
      LongPrototype.gte = LongPrototype.greaterThanOrEqual;
      LongPrototype.ge = LongPrototype.greaterThanOrEqual;
      LongPrototype.compare = function compare(other) {
        if (!isLong(other))
          other = fromValue(other);
        if (this.eq(other))
          return 0;
        var thisNeg = this.isNegative(), otherNeg = other.isNegative();
        if (thisNeg && !otherNeg)
          return -1;
        if (!thisNeg && otherNeg)
          return 1;
        if (!this.unsigned)
          return this.sub(other).isNegative() ? -1 : 1;
        return other.high >>> 0 > this.high >>> 0 || other.high === this.high && other.low >>> 0 > this.low >>> 0 ? -1 : 1;
      };
      LongPrototype.comp = LongPrototype.compare;
      LongPrototype.negate = function negate() {
        if (!this.unsigned && this.eq(MIN_VALUE))
          return MIN_VALUE;
        return this.not().add(ONE);
      };
      LongPrototype.neg = LongPrototype.negate;
      LongPrototype.add = function add3(addend) {
        if (!isLong(addend))
          addend = fromValue(addend);
        var a48 = this.high >>> 16;
        var a32 = this.high & 65535;
        var a16 = this.low >>> 16;
        var a00 = this.low & 65535;
        var b48 = addend.high >>> 16;
        var b32 = addend.high & 65535;
        var b16 = addend.low >>> 16;
        var b00 = addend.low & 65535;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 + b00;
        c16 += c00 >>> 16;
        c00 &= 65535;
        c16 += a16 + b16;
        c32 += c16 >>> 16;
        c16 &= 65535;
        c32 += a32 + b32;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c48 += a48 + b48;
        c48 &= 65535;
        return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
      };
      LongPrototype.subtract = function subtract(subtrahend) {
        if (!isLong(subtrahend))
          subtrahend = fromValue(subtrahend);
        return this.add(subtrahend.neg());
      };
      LongPrototype.sub = LongPrototype.subtract;
      LongPrototype.multiply = function multiply4(multiplier) {
        if (this.isZero())
          return this;
        if (!isLong(multiplier))
          multiplier = fromValue(multiplier);
        if (wasm) {
          var low = wasm["mul"](this.low, this.high, multiplier.low, multiplier.high);
          return fromBits(low, wasm["get_high"](), this.unsigned);
        }
        if (multiplier.isZero())
          return this.unsigned ? UZERO : ZERO4;
        if (this.eq(MIN_VALUE))
          return multiplier.isOdd() ? MIN_VALUE : ZERO4;
        if (multiplier.eq(MIN_VALUE))
          return this.isOdd() ? MIN_VALUE : ZERO4;
        if (this.isNegative()) {
          if (multiplier.isNegative())
            return this.neg().mul(multiplier.neg());
          else
            return this.neg().mul(multiplier).neg();
        } else if (multiplier.isNegative())
          return this.mul(multiplier.neg()).neg();
        if (this.lt(TWO_PWR_24) && multiplier.lt(TWO_PWR_24))
          return fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned);
        var a48 = this.high >>> 16;
        var a32 = this.high & 65535;
        var a16 = this.low >>> 16;
        var a00 = this.low & 65535;
        var b48 = multiplier.high >>> 16;
        var b32 = multiplier.high & 65535;
        var b16 = multiplier.low >>> 16;
        var b00 = multiplier.low & 65535;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 * b00;
        c16 += c00 >>> 16;
        c00 &= 65535;
        c16 += a16 * b00;
        c32 += c16 >>> 16;
        c16 &= 65535;
        c16 += a00 * b16;
        c32 += c16 >>> 16;
        c16 &= 65535;
        c32 += a32 * b00;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c32 += a16 * b16;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c32 += a00 * b32;
        c48 += c32 >>> 16;
        c32 &= 65535;
        c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
        c48 &= 65535;
        return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
      };
      LongPrototype.mul = LongPrototype.multiply;
      LongPrototype.divide = function divide(divisor) {
        if (!isLong(divisor))
          divisor = fromValue(divisor);
        if (divisor.isZero())
          throw Error("division by zero");
        if (wasm) {
          if (!this.unsigned && this.high === -2147483648 && divisor.low === -1 && divisor.high === -1) {
            return this;
          }
          var low = (this.unsigned ? wasm["div_u"] : wasm["div_s"])(this.low, this.high, divisor.low, divisor.high);
          return fromBits(low, wasm["get_high"](), this.unsigned);
        }
        if (this.isZero())
          return this.unsigned ? UZERO : ZERO4;
        var approx, rem, res;
        if (!this.unsigned) {
          if (this.eq(MIN_VALUE)) {
            if (divisor.eq(ONE) || divisor.eq(NEG_ONE))
              return MIN_VALUE;
            else if (divisor.eq(MIN_VALUE))
              return ONE;
            else {
              var halfThis = this.shr(1);
              approx = halfThis.div(divisor).shl(1);
              if (approx.eq(ZERO4)) {
                return divisor.isNegative() ? ONE : NEG_ONE;
              } else {
                rem = this.sub(divisor.mul(approx));
                res = approx.add(rem.div(divisor));
                return res;
              }
            }
          } else if (divisor.eq(MIN_VALUE))
            return this.unsigned ? UZERO : ZERO4;
          if (this.isNegative()) {
            if (divisor.isNegative())
              return this.neg().div(divisor.neg());
            return this.neg().div(divisor).neg();
          } else if (divisor.isNegative())
            return this.div(divisor.neg()).neg();
          res = ZERO4;
        } else {
          if (!divisor.unsigned)
            divisor = divisor.toUnsigned();
          if (divisor.gt(this))
            return UZERO;
          if (divisor.gt(this.shru(1)))
            return UONE;
          res = UZERO;
        }
        rem = this;
        while (rem.gte(divisor)) {
          approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber()));
          var log2 = Math.ceil(Math.log(approx) / Math.LN2), delta = log2 <= 48 ? 1 : pow_dbl(2, log2 - 48), approxRes = fromNumber(approx), approxRem = approxRes.mul(divisor);
          while (approxRem.isNegative() || approxRem.gt(rem)) {
            approx -= delta;
            approxRes = fromNumber(approx, this.unsigned);
            approxRem = approxRes.mul(divisor);
          }
          if (approxRes.isZero())
            approxRes = ONE;
          res = res.add(approxRes);
          rem = rem.sub(approxRem);
        }
        return res;
      };
      LongPrototype.div = LongPrototype.divide;
      LongPrototype.modulo = function modulo(divisor) {
        if (!isLong(divisor))
          divisor = fromValue(divisor);
        if (wasm) {
          var low = (this.unsigned ? wasm["rem_u"] : wasm["rem_s"])(this.low, this.high, divisor.low, divisor.high);
          return fromBits(low, wasm["get_high"](), this.unsigned);
        }
        return this.sub(this.div(divisor).mul(divisor));
      };
      LongPrototype.mod = LongPrototype.modulo;
      LongPrototype.rem = LongPrototype.modulo;
      LongPrototype.not = function not() {
        return fromBits(~this.low, ~this.high, this.unsigned);
      };
      LongPrototype.countLeadingZeros = function countLeadingZeros() {
        return this.high ? Math.clz32(this.high) : Math.clz32(this.low) + 32;
      };
      LongPrototype.clz = LongPrototype.countLeadingZeros;
      LongPrototype.countTrailingZeros = function countTrailingZeros() {
        return this.low ? ctz32(this.low) : ctz32(this.high) + 32;
      };
      LongPrototype.ctz = LongPrototype.countTrailingZeros;
      LongPrototype.and = function and(other) {
        if (!isLong(other))
          other = fromValue(other);
        return fromBits(this.low & other.low, this.high & other.high, this.unsigned);
      };
      LongPrototype.or = function or(other) {
        if (!isLong(other))
          other = fromValue(other);
        return fromBits(this.low | other.low, this.high | other.high, this.unsigned);
      };
      LongPrototype.xor = function xor(other) {
        if (!isLong(other))
          other = fromValue(other);
        return fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
      };
      LongPrototype.shiftLeft = function shiftLeft(numBits) {
        if (isLong(numBits))
          numBits = numBits.toInt();
        if ((numBits &= 63) === 0)
          return this;
        else if (numBits < 32)
          return fromBits(this.low << numBits, this.high << numBits | this.low >>> 32 - numBits, this.unsigned);
        else
          return fromBits(0, this.low << numBits - 32, this.unsigned);
      };
      LongPrototype.shl = LongPrototype.shiftLeft;
      LongPrototype.shiftRight = function shiftRight(numBits) {
        if (isLong(numBits))
          numBits = numBits.toInt();
        if ((numBits &= 63) === 0)
          return this;
        else if (numBits < 32)
          return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >> numBits, this.unsigned);
        else
          return fromBits(this.high >> numBits - 32, this.high >= 0 ? 0 : -1, this.unsigned);
      };
      LongPrototype.shr = LongPrototype.shiftRight;
      LongPrototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
        if (isLong(numBits))
          numBits = numBits.toInt();
        if ((numBits &= 63) === 0)
          return this;
        if (numBits < 32)
          return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >>> numBits, this.unsigned);
        if (numBits === 32)
          return fromBits(this.high, 0, this.unsigned);
        return fromBits(this.high >>> numBits - 32, 0, this.unsigned);
      };
      LongPrototype.shru = LongPrototype.shiftRightUnsigned;
      LongPrototype.shr_u = LongPrototype.shiftRightUnsigned;
      LongPrototype.rotateLeft = function rotateLeft(numBits) {
        var b;
        if (isLong(numBits))
          numBits = numBits.toInt();
        if ((numBits &= 63) === 0)
          return this;
        if (numBits === 32)
          return fromBits(this.high, this.low, this.unsigned);
        if (numBits < 32) {
          b = 32 - numBits;
          return fromBits(this.low << numBits | this.high >>> b, this.high << numBits | this.low >>> b, this.unsigned);
        }
        numBits -= 32;
        b = 32 - numBits;
        return fromBits(this.high << numBits | this.low >>> b, this.low << numBits | this.high >>> b, this.unsigned);
      };
      LongPrototype.rotl = LongPrototype.rotateLeft;
      LongPrototype.rotateRight = function rotateRight(numBits) {
        var b;
        if (isLong(numBits))
          numBits = numBits.toInt();
        if ((numBits &= 63) === 0)
          return this;
        if (numBits === 32)
          return fromBits(this.high, this.low, this.unsigned);
        if (numBits < 32) {
          b = 32 - numBits;
          return fromBits(this.high << b | this.low >>> numBits, this.low << b | this.high >>> numBits, this.unsigned);
        }
        numBits -= 32;
        b = 32 - numBits;
        return fromBits(this.low << b | this.high >>> numBits, this.high << b | this.low >>> numBits, this.unsigned);
      };
      LongPrototype.rotr = LongPrototype.rotateRight;
      LongPrototype.toSigned = function toSigned() {
        if (!this.unsigned)
          return this;
        return fromBits(this.low, this.high, false);
      };
      LongPrototype.toUnsigned = function toUnsigned() {
        if (this.unsigned)
          return this;
        return fromBits(this.low, this.high, true);
      };
      LongPrototype.toBytes = function toBytes(le) {
        return le ? this.toBytesLE() : this.toBytesBE();
      };
      LongPrototype.toBytesLE = function toBytesLE() {
        var hi = this.high, lo = this.low;
        return [
          lo & 255,
          lo >>> 8 & 255,
          lo >>> 16 & 255,
          lo >>> 24,
          hi & 255,
          hi >>> 8 & 255,
          hi >>> 16 & 255,
          hi >>> 24
        ];
      };
      LongPrototype.toBytesBE = function toBytesBE() {
        var hi = this.high, lo = this.low;
        return [
          hi >>> 24,
          hi >>> 16 & 255,
          hi >>> 8 & 255,
          hi & 255,
          lo >>> 24,
          lo >>> 16 & 255,
          lo >>> 8 & 255,
          lo & 255
        ];
      };
      Long.fromBytes = function fromBytes(bytes, unsigned, le) {
        return le ? Long.fromBytesLE(bytes, unsigned) : Long.fromBytesBE(bytes, unsigned);
      };
      Long.fromBytesLE = function fromBytesLE(bytes, unsigned) {
        return new Long(bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[3] << 24, bytes[4] | bytes[5] << 8 | bytes[6] << 16 | bytes[7] << 24, unsigned);
      };
      Long.fromBytesBE = function fromBytesBE(bytes, unsigned) {
        return new Long(bytes[4] << 24 | bytes[5] << 16 | bytes[6] << 8 | bytes[7], bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], unsigned);
      };
      long_default = Long;
    }
  });

  // src/lib/utils/s2/s2-token-functions.ts
  function getS2CellIdFromToken(token) {
    if (token === "X") {
      token = "";
    }
    const paddedToken = token.padEnd(MAXIMUM_TOKEN_LENGTH, "0");
    return long_default.fromString(paddedToken, true, 16);
  }
  function getS2TokenFromCellId(cellId) {
    if (cellId.isZero()) {
      return "X";
    }
    let numZeroDigits = cellId.countTrailingZeros();
    const remainder = numZeroDigits % 4;
    numZeroDigits = (numZeroDigits - remainder) / 4;
    const trailingZeroHexChars = numZeroDigits;
    numZeroDigits *= 4;
    const x = cellId.shiftRightUnsigned(numZeroDigits);
    const hexString = x.toString(16).replace(/0+$/, "");
    const zeroString = Array(17 - trailingZeroHexChars - hexString.length).join("0");
    return zeroString + hexString;
  }
  function getS2ChildCellId(cellId, index) {
    const newLsb = lsb(cellId).shiftRightUnsigned(2);
    const childCellId = cellId.add(long_default.fromNumber(2 * index + 1 - 4).multiply(newLsb));
    return childCellId;
  }
  function lsb(cellId) {
    return cellId.and(cellId.not().add(1));
  }
  var MAXIMUM_TOKEN_LENGTH;
  var init_s2_token_functions = __esm({
    "src/lib/utils/s2/s2-token-functions.ts"() {
      init_long();
      MAXIMUM_TOKEN_LENGTH = 16;
    }
  });

  // src/lib/utils/s2/s2geometry/s2-geometry.ts
  function getS2CellFromQuadKey(hilbertQuadkey) {
    if (hilbertQuadkey.length === 0) {
      throw new Error(`Invalid Hilbert quad key ${hilbertQuadkey}`);
    }
    const parts = hilbertQuadkey.split("/");
    const face = parseInt(parts[0], 10);
    const position = parts[1];
    const maxLevel = position.length;
    let level = 0;
    const point = [0, 0];
    for (let i2 = maxLevel - 1; i2 >= 0; i2--) {
      level = maxLevel - i2;
      const bit = position[i2];
      let rx = 0;
      let ry = 0;
      if (bit === "1") {
        ry = 1;
      } else if (bit === "2") {
        rx = 1;
        ry = 1;
      } else if (bit === "3") {
        rx = 1;
      }
      const val = Math.pow(2, level - 1);
      rotateAndFlipQuadrant(val, point, rx, ry);
      point[0] += val * rx;
      point[1] += val * ry;
    }
    if (face % 2 === 1) {
      const t2 = point[0];
      point[0] = point[1];
      point[1] = t2;
    }
    return { face, ij: point, level };
  }
  function getS2QuadkeyFromCellId(cellId) {
    if (cellId.isZero()) {
      return "";
    }
    let bin = cellId.toString(2);
    while (bin.length < FACE_BITS + POS_BITS) {
      bin = "0" + bin;
    }
    const lsbIndex = bin.lastIndexOf("1");
    const faceB = bin.substring(0, 3);
    const posB = bin.substring(3, lsbIndex);
    const levelN = posB.length / 2;
    const faceS = long_default.fromString(faceB, true, 2).toString(10);
    let posS = "";
    if (levelN !== 0) {
      posS = long_default.fromString(posB, true, 2).toString(4);
      while (posS.length < levelN) {
        posS = "0" + posS;
      }
    }
    return `${faceS}/${posS}`;
  }
  function IJToST(ij, level, offsets) {
    const maxSize = 1 << level;
    return [(ij[0] + offsets[0]) / maxSize, (ij[1] + offsets[1]) / maxSize];
  }
  function singleSTtoUV(st) {
    if (st >= 0.5) {
      return 1 / 3 * (4 * st * st - 1);
    }
    return 1 / 3 * (1 - 4 * (1 - st) * (1 - st));
  }
  function STToUV(st) {
    return [singleSTtoUV(st[0]), singleSTtoUV(st[1])];
  }
  function FaceUVToXYZ(face, [u, v]) {
    switch (face) {
      case 0:
        return [1, u, v];
      case 1:
        return [-u, 1, v];
      case 2:
        return [-u, -v, 1];
      case 3:
        return [-1, -v, -u];
      case 4:
        return [v, -1, -u];
      case 5:
        return [v, u, -1];
      default:
        throw new Error("Invalid face");
    }
  }
  function XYZToLngLat([x, y, z]) {
    const lat = Math.atan2(z, Math.sqrt(x * x + y * y));
    const lng = Math.atan2(y, x);
    return [lng * RADIAN_TO_DEGREE, lat * RADIAN_TO_DEGREE];
  }
  function rotateAndFlipQuadrant(n2, point, rx, ry) {
    if (ry === 0) {
      if (rx === 1) {
        point[0] = n2 - 1 - point[0];
        point[1] = n2 - 1 - point[1];
      }
      const x = point[0];
      point[0] = point[1];
      point[1] = x;
    }
  }
  function getS2LngLatFromS2Cell(s2Cell) {
    const st = IJToST(s2Cell.ij, s2Cell.level, [0.5, 0.5]);
    const uv = STToUV(st);
    const xyz = FaceUVToXYZ(s2Cell.face, uv);
    return XYZToLngLat(xyz);
  }
  var FACE_BITS, MAX_LEVEL, POS_BITS, RADIAN_TO_DEGREE;
  var init_s2_geometry = __esm({
    "src/lib/utils/s2/s2geometry/s2-geometry.ts"() {
      init_long();
      FACE_BITS = 3;
      MAX_LEVEL = 30;
      POS_BITS = 2 * MAX_LEVEL + 1;
      RADIAN_TO_DEGREE = 180 / Math.PI;
    }
  });

  // src/lib/utils/s2/converters/s2-to-boundary.ts
  function getS2BoundaryFlatFromS2Cell(s2cell) {
    const { face, ij, level } = s2cell;
    const offsets = [
      [0, 0],
      [0, 1],
      [1, 1],
      [1, 0],
      [0, 0]
    ];
    const resolution = Math.max(1, Math.ceil(MAX_RESOLUTION * Math.pow(2, -level)));
    const result = new Float64Array(4 * resolution * 2 + 2);
    let ptIndex = 0;
    let prevLng = 0;
    for (let i2 = 0; i2 < 4; i2++) {
      const offset = offsets[i2].slice(0);
      const nextOffset = offsets[i2 + 1];
      const stepI = (nextOffset[0] - offset[0]) / resolution;
      const stepJ = (nextOffset[1] - offset[1]) / resolution;
      for (let j = 0; j < resolution; j++) {
        offset[0] += stepI;
        offset[1] += stepJ;
        const st = IJToST(ij, level, offset);
        const uv = STToUV(st);
        const xyz = FaceUVToXYZ(face, uv);
        const lngLat = XYZToLngLat(xyz);
        if (Math.abs(lngLat[1]) > 89.999) {
          lngLat[0] = prevLng;
        }
        const deltaLng = lngLat[0] - prevLng;
        lngLat[0] += deltaLng > 180 ? -360 : deltaLng < -180 ? 360 : 0;
        result[ptIndex++] = lngLat[0];
        result[ptIndex++] = lngLat[1];
        prevLng = lngLat[0];
      }
    }
    result[ptIndex++] = result[0];
    result[ptIndex++] = result[1];
    return result;
  }
  var MAX_RESOLUTION;
  var init_s2_to_boundary = __esm({
    "src/lib/utils/s2/converters/s2-to-boundary.ts"() {
      init_s2_geometry();
      MAX_RESOLUTION = 100;
    }
  });

  // src/lib/utils/s2/s2geometry/s2-cell-utils.ts
  function getS2Cell(tokenOrKey) {
    const key = getS2QuadKey(tokenOrKey);
    const s2cell = getS2CellFromQuadKey(key);
    return s2cell;
  }
  function getS2QuadKey(tokenOrKey) {
    if (tokenOrKey.indexOf("/") > 0) {
      return tokenOrKey;
    }
    const id = getS2CellIdFromToken(tokenOrKey);
    return getS2QuadkeyFromCellId(id);
  }
  var init_s2_cell_utils = __esm({
    "src/lib/utils/s2/s2geometry/s2-cell-utils.ts"() {
      init_s2_geometry();
      init_s2_token_functions();
    }
  });

  // src/lib/utils/s2/s2-geometry-functions.ts
  function getS2LngLat(s2Token) {
    const s2cell = getS2Cell(s2Token);
    return getS2LngLatFromS2Cell(s2cell);
  }
  var init_s2_geometry_functions = __esm({
    "src/lib/utils/s2/s2-geometry-functions.ts"() {
      init_s2_geometry();
      init_s2_cell_utils();
    }
  });

  // src/lib/utils/s2/converters/s2-to-region.ts
  function getS2Region(s2cell) {
    let region;
    if (s2cell.face === 2 || s2cell.face === 5) {
      let corners = null;
      let len2 = 0;
      for (let i2 = 0; i2 < 4; i2++) {
        const key = `${s2cell.face}/${i2}`;
        const cell = getS2Cell(key);
        const corns = getS2BoundaryFlatFromS2Cell(cell);
        if (typeof corners === "undefined" || corners === null)
          corners = new Float64Array(4 * corns.length);
        corners.set(corns, len2);
        len2 += corns.length;
      }
      region = get2DRegionFromS2Corners(corners);
    } else {
      const corners = getS2BoundaryFlatFromS2Cell(s2cell);
      region = get2DRegionFromS2Corners(corners);
    }
    return region;
  }
  function get2DRegionFromS2Corners(corners) {
    if (corners.length % 2 !== 0) {
      throw new Error("Invalid corners");
    }
    const longitudes = [];
    const latitudes = [];
    for (let i2 = 0; i2 < corners.length; i2 += 2) {
      longitudes.push(corners[i2]);
      latitudes.push(corners[i2 + 1]);
    }
    longitudes.sort((a2, b) => a2 - b);
    latitudes.sort((a2, b) => a2 - b);
    return {
      west: longitudes[0],
      east: longitudes[longitudes.length - 1],
      north: latitudes[latitudes.length - 1],
      south: latitudes[0]
    };
  }
  var init_s2_to_region = __esm({
    "src/lib/utils/s2/converters/s2-to-region.ts"() {
      init_s2_to_boundary();
      init_s2_cell_utils();
    }
  });

  // src/lib/utils/s2/converters/s2-to-obb-points.ts
  function getS2OrientedBoundingBoxCornerPoints(tokenOrKey, heightInfo) {
    const min = heightInfo?.minimumHeight || 0;
    const max = heightInfo?.maximumHeight || 0;
    const s2cell = getS2Cell(tokenOrKey);
    const region = getS2Region(s2cell);
    const W = region.west;
    const S = region.south;
    const E = region.east;
    const N = region.north;
    const points = [];
    points.push(new Vector3(W, N, min));
    points.push(new Vector3(E, N, min));
    points.push(new Vector3(E, S, min));
    points.push(new Vector3(W, S, min));
    points.push(new Vector3(W, N, max));
    points.push(new Vector3(E, N, max));
    points.push(new Vector3(E, S, max));
    points.push(new Vector3(W, S, max));
    return points;
  }
  var init_s2_to_obb_points = __esm({
    "src/lib/utils/s2/converters/s2-to-obb-points.ts"() {
      init_s2_cell_utils();
      init_s2_to_region();
      init_esm();
    }
  });

  // src/lib/utils/s2/index.ts
  var init_s2 = __esm({
    "src/lib/utils/s2/index.ts"() {
      init_s2_token_functions();
      init_s2_geometry_functions();
      init_s2_to_obb_points();
    }
  });

  // src/lib/utils/obb/s2-corners-to-obb.ts
  function convertS2BoundingVolumetoOBB(s2VolumeInfo) {
    const token = s2VolumeInfo.token;
    const heightInfo = {
      minimumHeight: s2VolumeInfo.minimumHeight,
      maximumHeight: s2VolumeInfo.maximumHeight
    };
    const corners = getS2OrientedBoundingBoxCornerPoints(token, heightInfo);
    const center = getS2LngLat(token);
    const centerLng = center[0];
    const centerLat = center[1];
    const point = Ellipsoid.WGS84.cartographicToCartesian([
      centerLng,
      centerLat,
      heightInfo.maximumHeight
    ]);
    const centerPointAdditional = new Vector3(point[0], point[1], point[2]);
    corners.push(centerPointAdditional);
    const obb = makeOrientedBoundingBoxFromPoints(corners);
    const box = [...obb.center, ...obb.halfAxes];
    return box;
  }
  var init_s2_corners_to_obb = __esm({
    "src/lib/utils/obb/s2-corners-to-obb.ts"() {
      init_esm();
      init_esm3();
      init_s2();
      init_s2();
      init_esm2();
    }
  });

  // src/lib/parsers/helpers/parse-3d-implicit-tiles.ts
  function getChildS2VolumeBox(s2VolumeBox, index, subdivisionScheme) {
    if (s2VolumeBox?.box) {
      const cellId = getS2CellIdFromToken(s2VolumeBox.s2VolumeInfo.token);
      const childCellId = getS2ChildCellId(cellId, index);
      const childToken = getS2TokenFromCellId(childCellId);
      const s2ChildVolumeInfo = { ...s2VolumeBox.s2VolumeInfo };
      s2ChildVolumeInfo.token = childToken;
      switch (subdivisionScheme) {
        case "OCTREE":
          const s2VolumeInfo = s2VolumeBox.s2VolumeInfo;
          const delta = s2VolumeInfo.maximumHeight - s2VolumeInfo.minimumHeight;
          const sizeZ = delta / 2;
          const midZ = s2VolumeInfo.minimumHeight + delta / 2;
          s2VolumeInfo.minimumHeight = midZ - sizeZ;
          s2VolumeInfo.maximumHeight = midZ + sizeZ;
          break;
        default:
          break;
      }
      const box = convertS2BoundingVolumetoOBB(s2ChildVolumeInfo);
      const childS2VolumeBox = {
        box,
        s2VolumeInfo: s2ChildVolumeInfo
      };
      return childS2VolumeBox;
    }
    return void 0;
  }
  async function parseImplicitTiles(params) {
    const {
      options,
      parentData = {
        mortonIndex: 0,
        x: 0,
        y: 0,
        z: 0
      },
      childIndex = 0,
      globalData = {
        level: 0,
        mortonIndex: 0,
        x: 0,
        y: 0,
        z: 0
      },
      s2VolumeBox
    } = params;
    let { subtree, level = 0 } = params;
    const {
      subdivisionScheme,
      subtreeLevels,
      maximumLevel,
      contentUrlTemplate,
      subtreesUriTemplate,
      basePath
    } = options;
    const tile = { children: [], lodMetricValue: 0, contentUrl: "" };
    const childrenPerTile = SUBDIVISION_COUNT_MAP[subdivisionScheme];
    const childX = childIndex & 1;
    const childY = childIndex >> 1 & 1;
    const childZ = childIndex >> 2 & 1;
    const levelOffset = (childrenPerTile ** level - 1) / (childrenPerTile - 1);
    let childTileMortonIndex = concatBits(parentData.mortonIndex, childIndex);
    let tileAvailabilityIndex = levelOffset + childTileMortonIndex;
    let childTileX = concatBits(parentData.x, childX);
    let childTileY = concatBits(parentData.y, childY);
    let childTileZ = concatBits(parentData.z, childZ);
    let isChildSubtreeAvailable = false;
    if (level + 1 > subtreeLevels) {
      isChildSubtreeAvailable = getAvailabilityResult(subtree.childSubtreeAvailability, childTileMortonIndex);
    }
    const x = concatBits(globalData.x, childTileX);
    const y = concatBits(globalData.y, childTileY);
    const z = concatBits(globalData.z, childTileZ);
    const lev = level + globalData.level;
    if (isChildSubtreeAvailable) {
      const subtreePath = `${basePath}/${subtreesUriTemplate}`;
      const childSubtreeUrl = replaceContentUrlTemplate(subtreePath, lev, x, y, z);
      const childSubtree = await load(childSubtreeUrl, Tile3DSubtreeLoader);
      subtree = childSubtree;
      globalData.mortonIndex = childTileMortonIndex;
      globalData.x = childTileX;
      globalData.y = childTileY;
      globalData.z = childTileZ;
      globalData.level = level;
      childTileMortonIndex = 0;
      tileAvailabilityIndex = 0;
      childTileX = 0;
      childTileY = 0;
      childTileZ = 0;
      level = 0;
    }
    const isTileAvailable = getAvailabilityResult(subtree.tileAvailability, tileAvailabilityIndex);
    if (!isTileAvailable || level > maximumLevel) {
      return tile;
    }
    const isContentAvailable = getAvailabilityResult(subtree.contentAvailability, tileAvailabilityIndex);
    if (isContentAvailable) {
      tile.contentUrl = replaceContentUrlTemplate(contentUrlTemplate, lev, x, y, z);
    }
    const childTileLevel = level + 1;
    const pData = { mortonIndex: childTileMortonIndex, x: childTileX, y: childTileY, z: childTileZ };
    for (let index = 0; index < childrenPerTile; index++) {
      const childS2VolumeBox = getChildS2VolumeBox(s2VolumeBox, index, subdivisionScheme);
      const childTileParsed = await parseImplicitTiles({
        subtree,
        options,
        parentData: pData,
        childIndex: index,
        level: childTileLevel,
        globalData,
        s2VolumeBox: childS2VolumeBox
      });
      if (childTileParsed.contentUrl || childTileParsed.children.length) {
        const globalLevel = lev + 1;
        const childCoordinates = { childTileX, childTileY, childTileZ };
        const formattedTile = formatTileData(childTileParsed, globalLevel, childCoordinates, options, s2VolumeBox);
        tile.children.push(formattedTile);
      }
    }
    return tile;
  }
  function getAvailabilityResult(availabilityData, index) {
    if ("constant" in availabilityData) {
      return Boolean(availabilityData.constant);
    }
    if (availabilityData.explicitBitstream) {
      return getBooleanValueFromBitstream(index, availabilityData.explicitBitstream);
    }
    return false;
  }
  function formatTileData(tile, level, childCoordinates, options, s2VolumeBox) {
    const {
      basePath,
      refine,
      getRefine: getRefine2,
      lodMetricType,
      getTileType: getTileType2,
      rootLodMetricValue,
      rootBoundingVolume
    } = options;
    const uri = tile.contentUrl && tile.contentUrl.replace(`${basePath}/`, "");
    const lodMetricValue = rootLodMetricValue / 2 ** level;
    const boundingVolume = s2VolumeBox?.box ? { box: s2VolumeBox.box } : rootBoundingVolume;
    const boundingVolumeForChildTile = calculateBoundingVolumeForChildTile(level, boundingVolume, childCoordinates);
    return {
      children: tile.children,
      contentUrl: tile.contentUrl,
      content: { uri },
      id: tile.contentUrl,
      refine: getRefine2(refine),
      type: getTileType2(tile),
      lodMetricType,
      lodMetricValue,
      geometricError: lodMetricValue,
      transform: tile.transform,
      boundingVolume: boundingVolumeForChildTile
    };
  }
  function calculateBoundingVolumeForChildTile(level, rootBoundingVolume, childCoordinates) {
    if (rootBoundingVolume.region) {
      const { childTileX, childTileY, childTileZ } = childCoordinates;
      const [west, south, east, north, minimumHeight, maximumHeight] = rootBoundingVolume.region;
      const boundingVolumesCount = 2 ** level;
      const sizeX = (east - west) / boundingVolumesCount;
      const sizeY = (north - south) / boundingVolumesCount;
      const sizeZ = (maximumHeight - minimumHeight) / boundingVolumesCount;
      const [childWest, childEast] = [west + sizeX * childTileX, west + sizeX * (childTileX + 1)];
      const [childSouth, childNorth] = [south + sizeY * childTileY, south + sizeY * (childTileY + 1)];
      const [childMinimumHeight, childMaximumHeight] = [
        minimumHeight + sizeZ * childTileZ,
        minimumHeight + sizeZ * (childTileZ + 1)
      ];
      return {
        region: [childWest, childSouth, childEast, childNorth, childMinimumHeight, childMaximumHeight]
      };
    }
    if (rootBoundingVolume.box) {
      return rootBoundingVolume;
    }
    throw new Error(`Unsupported bounding volume type ${rootBoundingVolume}`);
  }
  function concatBits(first, second) {
    return parseInt(first.toString(2) + second.toString(2), 2);
  }
  function replaceContentUrlTemplate(templateUrl, level, x, y, z) {
    const mapUrl = generateMapUrl({ level, x, y, z });
    return templateUrl.replace(/{level}|{x}|{y}|{z}/gi, (matched) => mapUrl[matched]);
  }
  function generateMapUrl(items) {
    const mapUrl = {};
    for (const key in items) {
      mapUrl[`{${key}}`] = items[key];
    }
    return mapUrl;
  }
  function getBooleanValueFromBitstream(availabilityIndex, availabilityBuffer) {
    const byteIndex = Math.floor(availabilityIndex / 8);
    const bitIndex = availabilityIndex % 8;
    const bitValue = availabilityBuffer[byteIndex] >> bitIndex & 1;
    return bitValue === 1;
  }
  var QUADTREE_DEVISION_COUNT, OCTREE_DEVISION_COUNT, SUBDIVISION_COUNT_MAP;
  var init_parse_3d_implicit_tiles = __esm({
    "src/lib/parsers/helpers/parse-3d-implicit-tiles.ts"() {
      init_tile_3d_subtree_loader();
      init_src3();
      init_s2();
      init_s2_corners_to_obb();
      QUADTREE_DEVISION_COUNT = 4;
      OCTREE_DEVISION_COUNT = 8;
      SUBDIVISION_COUNT_MAP = {
        QUADTREE: QUADTREE_DEVISION_COUNT,
        OCTREE: OCTREE_DEVISION_COUNT
      };
    }
  });

  // src/lib/parsers/parse-3d-tile-header.ts
  function getTileType(tile) {
    if (!tile.contentUrl) {
      return TILE_TYPE.EMPTY;
    }
    const contentUrl = tile.contentUrl.split("?")[0];
    const fileExtension = contentUrl.split(".").pop();
    switch (fileExtension) {
      case "pnts":
        return TILE_TYPE.POINTCLOUD;
      case "i3dm":
      case "b3dm":
      case "glb":
      case "gltf":
        return TILE_TYPE.SCENEGRAPH;
      default:
        return fileExtension;
    }
  }
  function getRefine(refine) {
    switch (refine) {
      case "REPLACE":
      case "replace":
        return TILE_REFINEMENT.REPLACE;
      case "ADD":
      case "add":
        return TILE_REFINEMENT.ADD;
      default:
        return refine;
    }
  }
  function resolveUri(uri, basePath) {
    const urlSchemeRegex = /^[a-z][0-9a-z+.-]*:/i;
    if (urlSchemeRegex.test(basePath)) {
      const url = new URL(uri, `${basePath}/`);
      return decodeURI(url.toString());
    } else if (uri.startsWith("/")) {
      return uri;
    }
    return `${basePath}/${uri}`;
  }
  function normalizeTileData(tile, options) {
    if (!tile) {
      return null;
    }
    if (tile.content) {
      const contentUri = tile.content.uri || tile.content.url;
      tile.contentUrl = resolveUri(contentUri, options.basePath);
    }
    tile.id = tile.contentUrl;
    tile.lodMetricType = LOD_METRIC_TYPE.GEOMETRIC_ERROR;
    tile.lodMetricValue = tile.geometricError;
    tile.transformMatrix = tile.transform;
    tile.type = getTileType(tile);
    tile.refine = getRefine(tile.refine);
    return tile;
  }
  async function normalizeTileHeaders(tileset, options) {
    const basePath = tileset.basePath;
    let root;
    const rootImplicitTilingExtension = getImplicitTilingExtensionData(tileset?.root);
    if (rootImplicitTilingExtension && tileset.root) {
      root = await normalizeImplicitTileHeaders(tileset.root, tileset, rootImplicitTilingExtension, options);
    } else {
      root = normalizeTileData(tileset.root, tileset);
    }
    const stack2 = [];
    stack2.push(root);
    while (stack2.length > 0) {
      const tile = stack2.pop() || {};
      const children = tile.children || [];
      for (let childHeader of children) {
        const childImplicitTilingExtension = getImplicitTilingExtensionData(childHeader);
        if (childImplicitTilingExtension) {
          childHeader = await normalizeImplicitTileHeaders(childHeader, tileset, childImplicitTilingExtension, options);
        } else {
          normalizeTileData(childHeader, { basePath });
        }
        stack2.push(childHeader);
      }
    }
    return root;
  }
  async function normalizeImplicitTileHeaders(tile, tileset, implicitTilingExtension, options) {
    const basePath = tileset.basePath;
    const {
      subdivisionScheme,
      maximumLevel,
      subtreeLevels,
      subtrees: { uri: subtreesUriTemplate }
    } = implicitTilingExtension;
    const replacedUrlTemplate = replaceContentUrlTemplate(subtreesUriTemplate, 0, 0, 0, 0);
    const subtreeUrl = resolveUri(replacedUrlTemplate, basePath);
    const subtree = await load(subtreeUrl, Tile3DSubtreeLoader, options);
    const contentUrlTemplate = resolveUri(tile.content.uri, basePath);
    const refine = tileset?.root?.refine;
    const rootLodMetricValue = tile.geometricError;
    const s2VolumeInfo = tile.boundingVolume.extensions?.["3DTILES_bounding_volume_S2"];
    if (s2VolumeInfo) {
      const box = convertS2BoundingVolumetoOBB(s2VolumeInfo);
      const s2VolumeBox = { box, s2VolumeInfo };
      tile.boundingVolume = s2VolumeBox;
    }
    const rootBoundingVolume = tile.boundingVolume;
    const implicitOptions = {
      contentUrlTemplate,
      subtreesUriTemplate,
      subdivisionScheme,
      subtreeLevels,
      maximumLevel,
      refine,
      basePath,
      lodMetricType: LOD_METRIC_TYPE.GEOMETRIC_ERROR,
      rootLodMetricValue,
      rootBoundingVolume,
      getTileType,
      getRefine
    };
    return await normalizeImplicitTileData(tile, subtree, implicitOptions);
  }
  async function normalizeImplicitTileData(tile, rootSubtree, options) {
    if (!tile) {
      return null;
    }
    tile.lodMetricType = LOD_METRIC_TYPE.GEOMETRIC_ERROR;
    tile.lodMetricValue = tile.geometricError;
    tile.transformMatrix = tile.transform;
    const { children, contentUrl } = await parseImplicitTiles({
      subtree: rootSubtree,
      options,
      s2VolumeBox: tile
    });
    if (contentUrl) {
      tile.contentUrl = contentUrl;
      tile.content = { uri: contentUrl.replace(`${options.basePath}/`, "") };
    }
    tile.refine = getRefine(tile.refine);
    tile.type = getTileType(tile);
    tile.children = children;
    tile.id = tile.contentUrl;
    return tile;
  }
  function getImplicitTilingExtensionData(tile) {
    return tile?.extensions?.["3DTILES_implicit_tiling"] || tile?.implicitTiling;
  }
  var init_parse_3d_tile_header2 = __esm({
    "src/lib/parsers/parse-3d-tile-header.ts"() {
      init_tile_3d_subtree_loader();
      init_src3();
      init_src4();
      init_parse_3d_implicit_tiles();
      init_s2_corners_to_obb();
    }
  });

  // src/tiles-3d-loader.ts
  function getBaseUri(tileset) {
    return path_exports.dirname(tileset.url);
  }
  async function parseTile(arrayBuffer, options, context) {
    const tile = {
      content: {
        featureIds: null
      }
    };
    const byteOffset = 0;
    await parse3DTile(arrayBuffer, byteOffset, options, context, tile.content);
    return tile.content;
  }
  async function parseTileset(data, options, context) {
    const tilesetJson = JSON.parse(new TextDecoder().decode(data));
    tilesetJson.loader = options.loader || Tiles3DLoader;
    tilesetJson.url = context.url;
    tilesetJson.queryString = context.queryString;
    tilesetJson.basePath = getBaseUri(tilesetJson);
    tilesetJson.root = await normalizeTileHeaders(tilesetJson, options);
    tilesetJson.type = TILESET_TYPE.TILES3D;
    tilesetJson.lodMetricType = LOD_METRIC_TYPE.GEOMETRIC_ERROR;
    tilesetJson.lodMetricValue = tilesetJson.root?.lodMetricValue || 0;
    return tilesetJson;
  }
  async function parse4(data, options, context) {
    const loaderOptions = options["3d-tiles"] || {};
    let isTileset;
    if (loaderOptions.isTileset === "auto") {
      isTileset = context.url && context.url.indexOf(".json") !== -1;
    } else {
      isTileset = loaderOptions.isTileset;
    }
    if (isTileset) {
      data = await parseTileset(data, options, context);
    } else {
      data = await parseTile(data, options, context);
    }
    return data;
  }
  var Tiles3DLoader;
  var init_tiles_3d_loader = __esm({
    "src/tiles-3d-loader.ts"() {
      init_src2();
      init_src4();
      init_version2();
      init_parse_3d_tile();
      init_parse_3d_tile_header2();
      Tiles3DLoader = {
        id: "3d-tiles",
        name: "3D Tiles",
        module: "3d-tiles",
        version: VERSION4,
        extensions: ["cmpt", "pnts", "b3dm", "i3dm"],
        mimeTypes: ["application/octet-stream"],
        tests: ["cmpt", "pnts", "b3dm", "i3dm"],
        parse: parse4,
        options: {
          "3d-tiles": {
            loadGLTF: true,
            decodeQuantizedPositions: false,
            isTileset: "auto",
            assetGltfUpAxis: null
          }
        }
      };
    }
  });

  // src/lib/ion/ion.ts
  async function getIonTilesetMetadata(accessToken, assetId) {
    if (!assetId) {
      const assets = await getIonAssets(accessToken);
      for (const item of assets.items) {
        if (item.type === "3DTILES") {
          assetId = item.id;
        }
      }
    }
    const ionAssetMetadata = await getIonAssetMetadata(accessToken, assetId);
    const { type, url } = ionAssetMetadata;
    assert2(type === "3DTILES" && url);
    ionAssetMetadata.headers = {
      Authorization: `Bearer ${ionAssetMetadata.accessToken}`
    };
    return ionAssetMetadata;
  }
  async function getIonAssets(accessToken) {
    assert2(accessToken);
    const url = CESIUM_ION_URL;
    const headers = { Authorization: `Bearer ${accessToken}` };
    const response = await fetchFile(url, { fetch: { headers } });
    if (!response.ok) {
      throw new Error(response.statusText);
    }
    return await response.json();
  }
  async function getIonAssetMetadata(accessToken, assetId) {
    assert2(accessToken, assetId);
    const headers = { Authorization: `Bearer ${accessToken}` };
    const url = `${CESIUM_ION_URL}/${assetId}`;
    let response = await fetchFile(`${url}`, { fetch: { headers } });
    if (!response.ok) {
      throw new Error(response.statusText);
    }
    let metadata = await response.json();
    response = await fetchFile(`${url}/endpoint`, { fetch: { headers } });
    if (!response.ok) {
      throw new Error(response.statusText);
    }
    const tilesetInfo = await response.json();
    metadata = {
      ...metadata,
      ...tilesetInfo
    };
    return metadata;
  }
  var CESIUM_ION_URL;
  var init_ion = __esm({
    "src/lib/ion/ion.ts"() {
      init_src3();
      init_src2();
      CESIUM_ION_URL = "https://api.cesium.com/v1/assets";
    }
  });

  // src/cesium-ion-loader.ts
  async function preload(url, options = {}) {
    options = options["cesium-ion"] || {};
    const { accessToken } = options;
    let assetId = options.assetId;
    if (!Number.isFinite(assetId)) {
      const matched = url.match(/\/([0-9]+)\/tileset.json/);
      assetId = matched && matched[1];
    }
    return getIonTilesetMetadata(accessToken, assetId);
  }
  var CesiumIonLoader;
  var init_cesium_ion_loader = __esm({
    "src/cesium-ion-loader.ts"() {
      init_tiles_3d_loader();
      init_ion();
      CesiumIonLoader = {
        ...Tiles3DLoader,
        id: "cesium-ion",
        name: "Cesium Ion",
        preload,
        parse: async (data, options, context) => {
          options = { ...options };
          options["3d-tiles"] = options["cesium-ion"];
          options.loader = CesiumIonLoader;
          return Tiles3DLoader.parse(data, options, context);
        },
        options: {
          "cesium-ion": {
            ...Tiles3DLoader.options["3d-tiles"],
            accessToken: null
          }
        }
      };
    }
  });

  // src/lib/encoders/helpers/encode-3d-tile-header.ts
  function encode3DTileHeader(tile, dataView, byteOffset) {
    const HEADER_SIZE = 12;
    if (!dataView) {
      return byteOffset + HEADER_SIZE;
    }
    const { magic, version = 1, byteLength = 12 } = tile;
    assert2(Array.isArray(magic) && Number.isFinite(version) && Number.isFinite(byteLength));
    dataView.setUint8(byteOffset + 0, magic[0]);
    dataView.setUint8(byteOffset + 1, magic[1]);
    dataView.setUint8(byteOffset + 2, magic[2]);
    dataView.setUint8(byteOffset + 3, magic[3]);
    dataView.setUint32(byteOffset + 4, version, true);
    dataView.setUint32(byteOffset + 8, byteLength, true);
    byteOffset += HEADER_SIZE;
    return byteOffset;
  }
  function encode3DTileByteLength(dataView, byteOffsetTileStart, byteLength) {
    if (!dataView) {
      return;
    }
    dataView.setUint32(byteOffsetTileStart + 8, byteLength, true);
  }
  var init_encode_3d_tile_header = __esm({
    "src/lib/encoders/helpers/encode-3d-tile-header.ts"() {
      init_src2();
    }
  });

  // src/lib/encoders/encode-3d-tile-composite.ts
  function encodeComposite3DTile(tile, dataView, byteOffset, options, encode3DTile2) {
    tile = { magic: MAGIC_ARRAY.COMPOSITE, tiles: [], ...tile };
    const byteOffsetStart = byteOffset;
    byteOffset += encode3DTileHeader(tile, dataView, byteOffset);
    if (dataView) {
      dataView.setUint32(byteOffset, tile.tiles.length, true);
    }
    byteOffset += 4;
    for (let i2 = 0; i2 < tile.tiles.length; ++i2) {
      byteOffset += encode3DTile2(tile.tiles[i2], dataView, byteOffset, options);
    }
    encode3DTileByteLength(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
    return byteOffset;
  }
  var init_encode_3d_tile_composite = __esm({
    "src/lib/encoders/encode-3d-tile-composite.ts"() {
      init_constants4();
      init_encode_3d_tile_header();
    }
  });

  // src/lib/encoders/encode-3d-tile-batched-model.ts
  function encodeBatchedModel3DTile(tile, dataView, byteOffset, options) {
    const { featuresLength = 0, batchTable } = tile;
    const featureTableJson = {
      BATCH_LENGTH: featuresLength
    };
    const featureTableJsonString = JSON.stringify(featureTableJson);
    const batchTableJsonString = batchTable ? JSON.stringify(batchTable) : "";
    const featureTableJsonByteLength = padToNBytes(featureTableJsonString.length, 8);
    const batchTableJsonByteLength = batchTableJsonString ? padToNBytes(batchTableJsonString.length, 8) : 0;
    tile = { magic: MAGIC_ARRAY.BATCHED_MODEL, ...tile };
    const byteOffsetStart = byteOffset;
    byteOffset = encode3DTileHeader(tile, dataView, byteOffset);
    if (dataView) {
      dataView.setUint32(12, featureTableJsonByteLength, true);
      dataView.setUint32(16, 0, true);
      dataView.setUint32(20, batchTableJsonByteLength, true);
      dataView.setUint32(24, 0, true);
    }
    byteOffset += 16;
    byteOffset = copyPaddedStringToDataView(dataView, byteOffset, featureTableJsonString, 8);
    if (batchTable) {
      byteOffset = copyPaddedStringToDataView(dataView, byteOffset, batchTableJsonString, 8);
    }
    const gltfEncoded = tile.gltfEncoded;
    if (gltfEncoded) {
      byteOffset = copyBinaryToDataView(dataView, byteOffset, gltfEncoded, gltfEncoded.byteLength);
    }
    encode3DTileByteLength(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
    return byteOffset;
  }
  var init_encode_3d_tile_batched_model = __esm({
    "src/lib/encoders/encode-3d-tile-batched-model.ts"() {
      init_src2();
      init_constants4();
      init_encode_3d_tile_header();
    }
  });

  // src/lib/encoders/encode-3d-tile-instanced-model.ts
  function encodeInstancedModel3DTile(tile, dataView, byteOffset, options) {
    const { featuresLength = 1, gltfFormat = 1, gltfUri = "" } = tile;
    const gltfUriByteLength = gltfUri.length;
    const featureTableJson = {
      INSTANCES_LENGTH: featuresLength,
      POSITION: new Array(featuresLength * 3).fill(0)
    };
    const featureTableJsonString = JSON.stringify(featureTableJson);
    const featureTableJsonByteLength = featureTableJsonString.length;
    tile = { magic: MAGIC_ARRAY.INSTANCED_MODEL, ...tile };
    const byteOffsetStart = byteOffset;
    byteOffset = encode3DTileHeader(tile, dataView, 0);
    if (dataView) {
      dataView.setUint32(12, featureTableJsonByteLength, true);
      dataView.setUint32(16, 0, true);
      dataView.setUint32(20, 0, true);
      dataView.setUint32(24, 0, true);
      dataView.setUint32(28, gltfFormat, true);
    }
    byteOffset += 20;
    byteOffset += copyStringToDataView(dataView, byteOffset, featureTableJsonString, featureTableJsonByteLength);
    byteOffset += copyStringToDataView(dataView, byteOffset, gltfUri, gltfUriByteLength);
    encode3DTileByteLength(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
    return byteOffset;
  }
  var init_encode_3d_tile_instanced_model = __esm({
    "src/lib/encoders/encode-3d-tile-instanced-model.ts"() {
      init_src2();
      init_constants4();
      init_encode_3d_tile_header();
    }
  });

  // src/lib/encoders/encode-3d-tile-point-cloud.ts
  function encodePointCloud3DTile(tile, dataView, byteOffset, options) {
    const { featureTableJson = DEFAULT_FEATURE_TABLE_JSON } = tile;
    let featureTableJsonString = JSON.stringify(featureTableJson);
    featureTableJsonString = padStringToByteAlignment(featureTableJsonString, 4);
    const { featureTableJsonByteLength = featureTableJsonString.length } = tile;
    const featureTableBinary = new ArrayBuffer(12);
    const featureTableBinaryByteLength = featureTableBinary.byteLength;
    tile = { magic: MAGIC_ARRAY.POINT_CLOUD, ...tile };
    const byteOffsetStart = byteOffset;
    byteOffset += encode3DTileHeader(tile, dataView, 0);
    if (dataView) {
      dataView.setUint32(byteOffset + 0, featureTableJsonByteLength, true);
      dataView.setUint32(byteOffset + 4, featureTableBinaryByteLength, true);
      dataView.setUint32(byteOffset + 8, 0, true);
      dataView.setUint32(byteOffset + 12, 0, true);
    }
    byteOffset += 16;
    byteOffset += copyStringToDataView(dataView, byteOffset, featureTableJsonString, featureTableJsonByteLength);
    byteOffset += copyBinaryToDataView(dataView, byteOffset, featureTableBinary, featureTableBinaryByteLength);
    encode3DTileByteLength(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
    return byteOffset;
  }
  var DEFAULT_FEATURE_TABLE_JSON;
  var init_encode_3d_tile_point_cloud = __esm({
    "src/lib/encoders/encode-3d-tile-point-cloud.ts"() {
      init_constants4();
      init_encode_3d_tile_header();
      init_src2();
      DEFAULT_FEATURE_TABLE_JSON = {
        POINTS_LENGTH: 1,
        POSITIONS: {
          byteOffset: 0
        }
      };
    }
  });

  // src/lib/encoders/encode-3d-tile.ts
  function encode3DTile(tile, options) {
    const byteLength = encode3DTileToDataView(tile, null, 0, options);
    const arrayBuffer = new ArrayBuffer(byteLength);
    const dataView = new DataView(arrayBuffer);
    encode3DTileToDataView(tile, dataView, 0, options);
    return arrayBuffer;
  }
  function encode3DTileToDataView(tile, dataView, byteOffset, options) {
    assert2(typeof tile.type === "string");
    switch (tile.type) {
      case TILE3D_TYPE.COMPOSITE:
        return encodeComposite3DTile(tile, dataView, byteOffset, options, encode3DTileToDataView);
      case TILE3D_TYPE.POINT_CLOUD:
        return encodePointCloud3DTile(tile, dataView, byteOffset, options);
      case TILE3D_TYPE.BATCHED_3D_MODEL:
        return encodeBatchedModel3DTile(tile, dataView, byteOffset, options);
      case TILE3D_TYPE.INSTANCED_3D_MODEL:
        return encodeInstancedModel3DTile(tile, dataView, byteOffset, options);
      default:
        throw new Error("3D Tiles: unknown tile type");
    }
  }
  var init_encode_3d_tile = __esm({
    "src/lib/encoders/encode-3d-tile.ts"() {
      init_constants4();
      init_src2();
      init_encode_3d_tile_composite();
      init_encode_3d_tile_batched_model();
      init_encode_3d_tile_instanced_model();
      init_encode_3d_tile_point_cloud();
    }
  });

  // src/tile-3d-writer.ts
  function encodeSync(tile, options) {
    return encode3DTile(tile, options);
  }
  var Tile3DWriter;
  var init_tile_3d_writer = __esm({
    "src/tile-3d-writer.ts"() {
      init_version2();
      init_encode_3d_tile();
      Tile3DWriter = {
        name: "3D Tile",
        id: "3d-tiles",
        module: "3d-tiles",
        version: VERSION4,
        extensions: ["cmpt", "pnts", "b3dm", "i3dm"],
        mimeTypes: ["application/octet-stream"],
        encodeSync,
        binary: true,
        options: {
          ["3d-tiles"]: {}
        }
      };
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    CesiumIonLoader: () => CesiumIonLoader,
    TILE3D_TYPE: () => TILE3D_TYPE,
    Tile3DBatchTable: () => Tile3DBatchTableParser,
    Tile3DFeatureTable: () => Tile3DFeatureTable,
    Tile3DSubtreeLoader: () => Tile3DSubtreeLoader,
    Tile3DWriter: () => Tile3DWriter,
    Tiles3DLoader: () => Tiles3DLoader,
    _getIonTilesetMetadata: () => getIonTilesetMetadata
  });
  var init_src11 = __esm({
    "src/index.ts"() {
      init_tiles_3d_loader();
      init_cesium_ion_loader();
      init_tile_3d_subtree_loader();
      init_tile_3d_writer();
      init_tile_3d_feature_table();
      init_tile_3d_batch_table();
      init_constants4();
      init_ion();
    }
  });

  // src/bundle.ts
  var require_bundle = __commonJS({
    "src/bundle.ts"(exports, module) {
      var moduleExports = (init_src11(), src_exports);
      globalThis.loaders = globalThis.loaders || {};
      module.exports = Object.assign(globalThis.loaders, moduleExports);
    }
  });
  require_bundle();
})();
/**
 * @license
 * Copyright 2009 The Closure Library Authors
 * Copyright 2020 Daniel Wirtz / The long.js Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
