"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CesiumIonLoader = void 0;
var _tiles3dLoader = require("./tiles-3d-loader");
var _ion = require("./lib/ion/ion");
async function preload(url) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  options = options['cesium-ion'] || {};
  const {
    accessToken
  } = options;
  let assetId = options.assetId;
  if (!Number.isFinite(assetId)) {
    const matched = url.match(/\/([0-9]+)\/tileset.json/);
    assetId = matched && matched[1];
  }
  return (0, _ion.getIonTilesetMetadata)(accessToken, assetId);
}
const CesiumIonLoader = {
  ..._tiles3dLoader.Tiles3DLoader,
  id: 'cesium-ion',
  name: 'Cesium Ion',
  preload,
  parse: async (data, options, context) => {
    options = {
      ...options
    };
    options['3d-tiles'] = options['cesium-ion'];
    options.loader = CesiumIonLoader;
    return _tiles3dLoader.Tiles3DLoader.parse(data, options, context);
  },
  options: {
    'cesium-ion': {
      ..._tiles3dLoader.Tiles3DLoader.options['3d-tiles'],
      accessToken: null
    }
  }
};
exports.CesiumIonLoader = CesiumIonLoader;
//# sourceMappingURL=cesium-ion-loader.js.map