"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeBatchedModel3DTile = encodeBatchedModel3DTile;
var _loaderUtils = require("@loaders.gl/loader-utils");
var _constants = require("../constants");
var _encode3dTileHeader = require("./helpers/encode-3d-tile-header");
function encodeBatchedModel3DTile(tile, dataView, byteOffset, options) {
  const {
    featuresLength = 0,
    batchTable
  } = tile;
  const featureTableJson = {
    BATCH_LENGTH: featuresLength
  };
  const featureTableJsonString = JSON.stringify(featureTableJson);
  const batchTableJsonString = batchTable ? JSON.stringify(batchTable) : '';
  const featureTableJsonByteLength = (0, _loaderUtils.padToNBytes)(featureTableJsonString.length, 8);
  const batchTableJsonByteLength = batchTableJsonString ? (0, _loaderUtils.padToNBytes)(batchTableJsonString.length, 8) : 0;
  tile = {
    magic: _constants.MAGIC_ARRAY.BATCHED_MODEL,
    ...tile
  };
  const byteOffsetStart = byteOffset;
  byteOffset = (0, _encode3dTileHeader.encode3DTileHeader)(tile, dataView, byteOffset);
  if (dataView) {
    dataView.setUint32(12, featureTableJsonByteLength, true);
    dataView.setUint32(16, 0, true);
    dataView.setUint32(20, batchTableJsonByteLength, true);
    dataView.setUint32(24, 0, true);
  }
  byteOffset += 16;
  byteOffset = (0, _loaderUtils.copyPaddedStringToDataView)(dataView, byteOffset, featureTableJsonString, 8);
  if (batchTable) {
    byteOffset = (0, _loaderUtils.copyPaddedStringToDataView)(dataView, byteOffset, batchTableJsonString, 8);
  }
  const gltfEncoded = tile.gltfEncoded;
  if (gltfEncoded) {
    byteOffset = (0, _loaderUtils.copyBinaryToDataView)(dataView, byteOffset, gltfEncoded, gltfEncoded.byteLength);
  }
  (0, _encode3dTileHeader.encode3DTileByteLength)(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
  return byteOffset;
}
//# sourceMappingURL=encode-3d-tile-batched-model.js.map