"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeComposite3DTile = encodeComposite3DTile;
var _constants = require("../constants");
var _encode3dTileHeader = require("./helpers/encode-3d-tile-header");
function encodeComposite3DTile(tile, dataView, byteOffset, options, encode3DTile) {
  tile = {
    magic: _constants.MAGIC_ARRAY.COMPOSITE,
    tiles: [],
    ...tile
  };
  const byteOffsetStart = byteOffset;
  byteOffset += (0, _encode3dTileHeader.encode3DTileHeader)(tile, dataView, byteOffset);
  if (dataView) {
    dataView.setUint32(byteOffset, tile.tiles.length, true);
  }
  byteOffset += 4;
  for (let i = 0; i < tile.tiles.length; ++i) {
    byteOffset += encode3DTile(tile.tiles[i], dataView, byteOffset, options);
  }
  (0, _encode3dTileHeader.encode3DTileByteLength)(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
  return byteOffset;
}
//# sourceMappingURL=encode-3d-tile-composite.js.map