"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodeInstancedModel3DTile = encodeInstancedModel3DTile;
var _loaderUtils = require("@loaders.gl/loader-utils");
var _constants = require("../constants");
var _encode3dTileHeader = require("./helpers/encode-3d-tile-header");
function encodeInstancedModel3DTile(tile, dataView, byteOffset, options) {
  const {
    featuresLength = 1,
    gltfFormat = 1,
    gltfUri = ''
  } = tile;
  const gltfUriByteLength = gltfUri.length;
  const featureTableJson = {
    INSTANCES_LENGTH: featuresLength,
    POSITION: new Array(featuresLength * 3).fill(0)
  };
  const featureTableJsonString = JSON.stringify(featureTableJson);
  const featureTableJsonByteLength = featureTableJsonString.length;
  tile = {
    magic: _constants.MAGIC_ARRAY.INSTANCED_MODEL,
    ...tile
  };
  const byteOffsetStart = byteOffset;
  byteOffset = (0, _encode3dTileHeader.encode3DTileHeader)(tile, dataView, 0);
  if (dataView) {
    dataView.setUint32(12, featureTableJsonByteLength, true);
    dataView.setUint32(16, 0, true);
    dataView.setUint32(20, 0, true);
    dataView.setUint32(24, 0, true);
    dataView.setUint32(28, gltfFormat, true);
  }
  byteOffset += 20;
  byteOffset += (0, _loaderUtils.copyStringToDataView)(dataView, byteOffset, featureTableJsonString, featureTableJsonByteLength);
  byteOffset += (0, _loaderUtils.copyStringToDataView)(dataView, byteOffset, gltfUri, gltfUriByteLength);
  (0, _encode3dTileHeader.encode3DTileByteLength)(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
  return byteOffset;
}
//# sourceMappingURL=encode-3d-tile-instanced-model.js.map