"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encodePointCloud3DTile = encodePointCloud3DTile;
var _constants = require("../constants");
var _encode3dTileHeader = require("./helpers/encode-3d-tile-header");
var _loaderUtils = require("@loaders.gl/loader-utils");
const DEFAULT_FEATURE_TABLE_JSON = {
  POINTS_LENGTH: 1,
  POSITIONS: {
    byteOffset: 0
  }
};
function encodePointCloud3DTile(tile, dataView, byteOffset, options) {
  const {
    featureTableJson = DEFAULT_FEATURE_TABLE_JSON
  } = tile;
  let featureTableJsonString = JSON.stringify(featureTableJson);
  featureTableJsonString = (0, _loaderUtils.padStringToByteAlignment)(featureTableJsonString, 4);
  const {
    featureTableJsonByteLength = featureTableJsonString.length
  } = tile;
  const featureTableBinary = new ArrayBuffer(12);
  const featureTableBinaryByteLength = featureTableBinary.byteLength;
  tile = {
    magic: _constants.MAGIC_ARRAY.POINT_CLOUD,
    ...tile
  };
  const byteOffsetStart = byteOffset;
  byteOffset += (0, _encode3dTileHeader.encode3DTileHeader)(tile, dataView, 0);
  if (dataView) {
    dataView.setUint32(byteOffset + 0, featureTableJsonByteLength, true);
    dataView.setUint32(byteOffset + 4, featureTableBinaryByteLength, true);
    dataView.setUint32(byteOffset + 8, 0, true);
    dataView.setUint32(byteOffset + 12, 0, true);
  }
  byteOffset += 16;
  byteOffset += (0, _loaderUtils.copyStringToDataView)(dataView, byteOffset, featureTableJsonString, featureTableJsonByteLength);
  byteOffset += (0, _loaderUtils.copyBinaryToDataView)(dataView, byteOffset, featureTableBinary, featureTableBinaryByteLength);
  (0, _encode3dTileHeader.encode3DTileByteLength)(dataView, byteOffsetStart, byteOffset - byteOffsetStart);
  return byteOffset;
}
//# sourceMappingURL=encode-3d-tile-point-cloud.js.map