"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIonAssetMetadata = getIonAssetMetadata;
exports.getIonAssets = getIonAssets;
exports.getIonTilesetMetadata = getIonTilesetMetadata;
var _core = require("@loaders.gl/core");
var _loaderUtils = require("@loaders.gl/loader-utils");
const CESIUM_ION_URL = 'https://api.cesium.com/v1/assets';
async function getIonTilesetMetadata(accessToken, assetId) {
  if (!assetId) {
    const assets = await getIonAssets(accessToken);
    for (const item of assets.items) {
      if (item.type === '3DTILES') {
        assetId = item.id;
      }
    }
  }
  const ionAssetMetadata = await getIonAssetMetadata(accessToken, assetId);
  const {
    type,
    url
  } = ionAssetMetadata;
  (0, _loaderUtils.assert)(type === '3DTILES' && url);
  ionAssetMetadata.headers = {
    Authorization: "Bearer ".concat(ionAssetMetadata.accessToken)
  };
  return ionAssetMetadata;
}
async function getIonAssets(accessToken) {
  (0, _loaderUtils.assert)(accessToken);
  const url = CESIUM_ION_URL;
  const headers = {
    Authorization: "Bearer ".concat(accessToken)
  };
  const response = await (0, _core.fetchFile)(url, {
    fetch: {
      headers
    }
  });
  if (!response.ok) {
    throw new Error(response.statusText);
  }
  return await response.json();
}
async function getIonAssetMetadata(accessToken, assetId) {
  (0, _loaderUtils.assert)(accessToken, assetId);
  const headers = {
    Authorization: "Bearer ".concat(accessToken)
  };
  const url = "".concat(CESIUM_ION_URL, "/").concat(assetId);
  let response = await (0, _core.fetchFile)("".concat(url), {
    fetch: {
      headers
    }
  });
  if (!response.ok) {
    throw new Error(response.statusText);
  }
  let metadata = await response.json();
  response = await (0, _core.fetchFile)("".concat(url, "/endpoint"), {
    fetch: {
      headers
    }
  });
  if (!response.ok) {
    throw new Error(response.statusText);
  }
  const tilesetInfo = await response.json();
  metadata = {
    ...metadata,
    ...tilesetInfo
  };
  return metadata;
}
//# sourceMappingURL=ion.js.map