"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GLTF_FORMAT = void 0;
exports.extractGLTF = extractGLTF;
exports.parse3DTileGLTFViewSync = parse3DTileGLTFViewSync;
var _gltf = require("@loaders.gl/gltf");
var _loaderUtils = require("@loaders.gl/loader-utils");
const GLTF_FORMAT = {
  URI: 0,
  EMBEDDED: 1
};
exports.GLTF_FORMAT = GLTF_FORMAT;
function parse3DTileGLTFViewSync(tile, arrayBuffer, byteOffset, options) {
  tile.rotateYtoZ = true;
  const gltfByteLength = tile.byteOffset + tile.byteLength - byteOffset;
  if (gltfByteLength === 0) {
    throw new Error('glTF byte length must be greater than 0.');
  }
  tile.gltfUpAxis = options['3d-tiles'] && options['3d-tiles'].assetGltfUpAxis ? options['3d-tiles'].assetGltfUpAxis : 'Y';
  tile.gltfArrayBuffer = (0, _loaderUtils.sliceArrayBuffer)(arrayBuffer, byteOffset, gltfByteLength);
  tile.gltfByteOffset = 0;
  tile.gltfByteLength = gltfByteLength;
  if (byteOffset % 4 === 0) {} else {
    console.warn("".concat(tile.type, ": embedded glb is not aligned to a 4-byte boundary."));
  }
  return tile.byteOffset + tile.byteLength;
}
async function extractGLTF(tile, gltfFormat, options, context) {
  const tile3DOptions = options['3d-tiles'] || {};
  extractGLTFBufferOrURL(tile, gltfFormat, options);
  if (tile3DOptions.loadGLTF) {
    const {
      parse,
      fetch
    } = context;
    if (tile.gltfUrl) {
      tile.gltfArrayBuffer = await fetch(tile.gltfUrl, options);
      tile.gltfByteOffset = 0;
    }
    if (tile.gltfArrayBuffer) {
      tile.gltf = await parse(tile.gltfArrayBuffer, _gltf.GLTFLoader, options, context);
      tile.gpuMemoryUsageInBytes = (0, _gltf._getMemoryUsageGLTF)(tile.gltf);
      delete tile.gltfArrayBuffer;
      delete tile.gltfByteOffset;
      delete tile.gltfByteLength;
    }
  }
}
function extractGLTFBufferOrURL(tile, gltfFormat, options) {
  switch (gltfFormat) {
    case GLTF_FORMAT.URI:
      const gltfUrlBytes = new Uint8Array(tile.gltfArrayBuffer, tile.gltfByteOffset);
      const textDecoder = new TextDecoder();
      const gltfUrl = textDecoder.decode(gltfUrlBytes);
      tile.gltfUrl = gltfUrl.replace(/[\s\0]+$/, '');
      delete tile.gltfArrayBuffer;
      delete tile.gltfByteOffset;
      delete tile.gltfByteLength;
      break;
    case GLTF_FORMAT.EMBEDDED:
      break;
    default:
      throw new Error('b3dm: Illegal glTF format field');
  }
}
//# sourceMappingURL=parse-3d-tile-gltf-view.js.map