"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseBatchedModel3DTile = parseBatchedModel3DTile;
var _math = require("@loaders.gl/math");
var _tile3dFeatureTable = _interopRequireDefault(require("../classes/tile-3d-feature-table"));
var _parse3dTileHeader = require("./helpers/parse-3d-tile-header");
var _parse3dTileTables = require("./helpers/parse-3d-tile-tables");
var _parse3dTileGltfView = require("./helpers/parse-3d-tile-gltf-view");
async function parseBatchedModel3DTile(tile, arrayBuffer, byteOffset, options, context) {
  var _tile$gltf;
  byteOffset = parseBatchedModel(tile, arrayBuffer, byteOffset, options, context);
  await (0, _parse3dTileGltfView.extractGLTF)(tile, _parse3dTileGltfView.GLTF_FORMAT.EMBEDDED, options, context);
  const extensions = tile === null || tile === void 0 ? void 0 : (_tile$gltf = tile.gltf) === null || _tile$gltf === void 0 ? void 0 : _tile$gltf.extensions;
  if (extensions && extensions.CESIUM_RTC) {
    tile.rtcCenter = extensions.CESIUM_RTC.center;
  }
  return byteOffset;
}
function parseBatchedModel(tile, arrayBuffer, byteOffset, options, context) {
  byteOffset = (0, _parse3dTileHeader.parse3DTileHeaderSync)(tile, arrayBuffer, byteOffset);
  byteOffset = (0, _parse3dTileTables.parse3DTileTablesHeaderSync)(tile, arrayBuffer, byteOffset);
  byteOffset = (0, _parse3dTileTables.parse3DTileTablesSync)(tile, arrayBuffer, byteOffset, options);
  byteOffset = (0, _parse3dTileGltfView.parse3DTileGLTFViewSync)(tile, arrayBuffer, byteOffset, options);
  const featureTable = new _tile3dFeatureTable.default(tile.featureTableJson, tile.featureTableBinary);
  tile.rtcCenter = featureTable.getGlobalProperty('RTC_CENTER', _math.GL.FLOAT, 3);
  return byteOffset;
}
//# sourceMappingURL=parse-3d-tile-batched-model.js.map