"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseGltf3DTile = parseGltf3DTile;
var _gltf = require("@loaders.gl/gltf");
async function parseGltf3DTile(tile, arrayBuffer, options, context) {
  tile.rotateYtoZ = true;
  tile.gltfUpAxis = options['3d-tiles'] && options['3d-tiles'].assetGltfUpAxis ? options['3d-tiles'].assetGltfUpAxis : 'Y';
  const {
    parse
  } = context;
  tile.gltf = await parse(arrayBuffer, _gltf.GLTFLoader, options, context);
  tile.gpuMemoryUsageInBytes = (0, _gltf._getMemoryUsageGLTF)(tile.gltf);
}
//# sourceMappingURL=parse-3d-tile-gltf.js.map