"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parse3DTile = parse3DTile;
var _constants = require("../constants");
var _parseUtils = require("./helpers/parse-utils");
var _parse3dTilePointCloud = require("./parse-3d-tile-point-cloud");
var _parse3dTileBatchedModel = require("./parse-3d-tile-batched-model");
var _parse3dTileInstancedModel = require("./parse-3d-tile-instanced-model");
var _parse3dTileComposite = require("./parse-3d-tile-composite");
var _parse3dTileGltf = require("./parse-3d-tile-gltf");
async function parse3DTile(arrayBuffer) {
  let byteOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  let options = arguments.length > 2 ? arguments[2] : undefined;
  let context = arguments.length > 3 ? arguments[3] : undefined;
  let tile = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};
  tile.byteOffset = byteOffset;
  tile.type = (0, _parseUtils.getMagicString)(arrayBuffer, byteOffset);
  switch (tile.type) {
    case _constants.TILE3D_TYPE.COMPOSITE:
      return await (0, _parse3dTileComposite.parseComposite3DTile)(tile, arrayBuffer, byteOffset, options, context, parse3DTile);
    case _constants.TILE3D_TYPE.BATCHED_3D_MODEL:
      return await (0, _parse3dTileBatchedModel.parseBatchedModel3DTile)(tile, arrayBuffer, byteOffset, options, context);
    case _constants.TILE3D_TYPE.GLTF:
      return await (0, _parse3dTileGltf.parseGltf3DTile)(tile, arrayBuffer, options, context);
    case _constants.TILE3D_TYPE.INSTANCED_3D_MODEL:
      return await (0, _parse3dTileInstancedModel.parseInstancedModel3DTile)(tile, arrayBuffer, byteOffset, options, context);
    case _constants.TILE3D_TYPE.POINT_CLOUD:
      return await (0, _parse3dTilePointCloud.parsePointCloud3DTile)(tile, arrayBuffer, byteOffset, options, context);
    default:
      throw new Error("3DTileLoader: unknown type ".concat(tile.type));
  }
}
//# sourceMappingURL=parse-3d-tile.js.map