"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertS2BoundingVolumetoOBB = convertS2BoundingVolumetoOBB;
var _core = require("@math.gl/core");
var _culling = require("@math.gl/culling");
var _index = require("../../utils/s2/index");
var _geospatial = require("@math.gl/geospatial");
function convertS2BoundingVolumetoOBB(s2VolumeInfo) {
  const token = s2VolumeInfo.token;
  const heightInfo = {
    minimumHeight: s2VolumeInfo.minimumHeight,
    maximumHeight: s2VolumeInfo.maximumHeight
  };
  const corners = (0, _index.getS2OrientedBoundingBoxCornerPoints)(token, heightInfo);
  const center = (0, _index.getS2LngLat)(token);
  const centerLng = center[0];
  const centerLat = center[1];
  const point = _geospatial.Ellipsoid.WGS84.cartographicToCartesian([centerLng, centerLat, heightInfo.maximumHeight]);
  const centerPointAdditional = new _core.Vector3(point[0], point[1], point[2]);
  corners.push(centerPointAdditional);
  const obb = (0, _culling.makeOrientedBoundingBoxFromPoints)(corners);
  const box = [...obb.center, ...obb.halfAxes];
  return box;
}
//# sourceMappingURL=s2-corners-to-obb.js.map