"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tiles3DLoader = void 0;
var _loaderUtils = require("@loaders.gl/loader-utils");
var _tiles = require("@loaders.gl/tiles");
var _version = require("./lib/utils/version");
var _parse3dTile = require("./lib/parsers/parse-3d-tile");
var _parse3dTileHeader = require("./lib/parsers/parse-3d-tile-header");
const Tiles3DLoader = {
  id: '3d-tiles',
  name: '3D Tiles',
  module: '3d-tiles',
  version: _version.VERSION,
  extensions: ['cmpt', 'pnts', 'b3dm', 'i3dm'],
  mimeTypes: ['application/octet-stream'],
  tests: ['cmpt', 'pnts', 'b3dm', 'i3dm'],
  parse,
  options: {
    '3d-tiles': {
      loadGLTF: true,
      decodeQuantizedPositions: false,
      isTileset: 'auto',
      assetGltfUpAxis: null
    }
  }
};
exports.Tiles3DLoader = Tiles3DLoader;
function getBaseUri(tileset) {
  return _loaderUtils.path.dirname(tileset.url);
}
async function parseTile(arrayBuffer, options, context) {
  const tile = {
    content: {
      featureIds: null
    }
  };
  const byteOffset = 0;
  await (0, _parse3dTile.parse3DTile)(arrayBuffer, byteOffset, options, context, tile.content);
  return tile.content;
}
async function parseTileset(data, options, context) {
  var _tilesetJson$root;
  const tilesetJson = JSON.parse(new TextDecoder().decode(data));
  tilesetJson.loader = options.loader || Tiles3DLoader;
  tilesetJson.url = context.url;
  tilesetJson.queryString = context.queryString;
  tilesetJson.basePath = getBaseUri(tilesetJson);
  tilesetJson.root = await (0, _parse3dTileHeader.normalizeTileHeaders)(tilesetJson, options);
  tilesetJson.type = _tiles.TILESET_TYPE.TILES3D;
  tilesetJson.lodMetricType = _tiles.LOD_METRIC_TYPE.GEOMETRIC_ERROR;
  tilesetJson.lodMetricValue = ((_tilesetJson$root = tilesetJson.root) === null || _tilesetJson$root === void 0 ? void 0 : _tilesetJson$root.lodMetricValue) || 0;
  return tilesetJson;
}
async function parse(data, options, context) {
  const loaderOptions = options['3d-tiles'] || {};
  let isTileset;
  if (loaderOptions.isTileset === 'auto') {
    isTileset = context.url && context.url.indexOf('.json') !== -1;
  } else {
    isTileset = loaderOptions.isTileset;
  }
  if (isTileset) {
    data = await parseTileset(data, options, context);
  } else {
    data = await parseTile(data, options, context);
  }
  return data;
}
//# sourceMappingURL=tiles-3d-loader.js.map