import type { LoaderOptions } from '@loaders.gl/loader-utils';
import { Tileset3D, Tile3D } from '@loaders.gl/tiles';
import { ImplicitTilingExtension, Subtree } from '../../types';
export declare function normalizeTileData(tile: any, options: any): any;
export declare function normalizeTileHeaders(tileset: Tileset3D, options: LoaderOptions): Promise<Tileset3D>;
/**
 * Do normalisation of implicit tile headers
 * TODO Check if Tile3D class can be a return type here.
 * @param tileset
 */
export declare function normalizeImplicitTileHeaders(tile: Tile3D, tileset: Tileset3D, implicitTilingExtension: ImplicitTilingExtension, options: LoaderOptions): Promise<any>;
/**
 * Do implicit data normalisation to create hierarchical tile structure
 * @param tile
 * @param rootSubtree
 * @param options
 * @returns
 */
export declare function normalizeImplicitTileData(tile: any, rootSubtree: Subtree, options: any): Promise<any>;
//# sourceMappingURL=parse-3d-tile-header.d.ts.map