function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

export function binaryToGeoJson(data, type, format) {
  if (format === 'geometry') {
    return parseGeometry(data);
  }

  var dataArray = normalizeInput(data, type);

  switch (deduceReturnType(dataArray)) {
    case 'Geometry':
      return parseGeometry(dataArray[0]);

    case 'FeatureCollection':
      return parseFeatureCollection(dataArray);

    default:
      break;
  }

  return null;
}

function normalizeInput(data, type) {
  var isHeterogeneousType = Boolean(data.points || data.lines || data.polygons);

  if (!isHeterogeneousType) {
    data.type = type || parseType(data);
    return [data];
  }

  var features = [];

  if (data.points) {
    data.points.type = 'Point';
    features.push(data.points);
  }

  if (data.lines) {
    data.lines.type = 'LineString';
    features.push(data.lines);
  }

  if (data.polygons) {
    data.polygons.type = 'Polygon';
    features.push(data.polygons);
  }

  return features;
}

function deduceReturnType(dataArray) {
  if (dataArray.length > 1) {
    return 'FeatureCollection';
  }

  var data = dataArray[0];

  if (!(data.featureIds || data.globalFeatureIds || data.numericProps || data.properties)) {
    return 'Geometry';
  }

  return 'FeatureCollection';
}

function parseFeatureCollection(dataArray) {
  var features = [];

  var _iterator = _createForOfIteratorHelper(dataArray),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var data = _step.value;

      if (data.featureIds.value.length === 0) {
        continue;
      }

      var lastIndex = 0;
      var lastValue = data.featureIds.value[0];

      for (var i = 0; i < data.featureIds.value.length; i++) {
        var currValue = data.featureIds.value[i];

        if (currValue === lastValue) {
          continue;
        }

        features.push(parseFeature(data, lastIndex, i));
        lastIndex = i;
        lastValue = currValue;
      }

      features.push(parseFeature(data, lastIndex, data.featureIds.value.length));
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return features;
}

function parseFeature(data, startIndex, endIndex) {
  var geometry = parseGeometry(data, startIndex, endIndex);
  var properties = parseProperties(data, startIndex, endIndex);
  return {
    type: 'Feature',
    geometry: geometry,
    properties: properties
  };
}

function parseProperties(data, startIndex, endIndex) {
  var properties = Object.assign(data.properties[data.featureIds.value[startIndex]]);

  for (var key in data.numericProps) {
    properties[key] = data.numericProps[key].value[startIndex];
  }

  return properties;
}

function parseGeometry(data, startIndex, endIndex) {
  switch (data.type) {
    case 'Point':
      return pointToGeoJson(data, startIndex, endIndex);

    case 'LineString':
      return lineStringToGeoJson(data, startIndex, endIndex);

    case 'Polygon':
      return polygonToGeoJson(data, startIndex, endIndex);

    default:
      throw new Error("Unsupported geometry type: ".concat(data.type));
  }
}

function polygonToGeoJson(data) {
  var startIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -Infinity;
  var endIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Infinity;
  var positions = data.positions;
  var polygonIndices = data.polygonIndices.value.filter(function (x) {
    return x >= startIndex && x <= endIndex;
  });
  var primitivePolygonIndices = data.primitivePolygonIndices.value.filter(function (x) {
    return x >= startIndex && x <= endIndex;
  });
  var multi = polygonIndices.length > 2;
  var coordinates = [];

  if (!multi) {
    for (var i = 0; i < primitivePolygonIndices.length - 1; i++) {
      var startRingIndex = primitivePolygonIndices[i];
      var endRingIndex = primitivePolygonIndices[i + 1];
      var ringCoordinates = ringToGeoJson(positions, startRingIndex, endRingIndex);
      coordinates.push(ringCoordinates);
    }

    return {
      type: 'Polygon',
      coordinates: coordinates
    };
  }

  for (var _i = 0; _i < polygonIndices.length - 1; _i++) {
    var startPolygonIndex = polygonIndices[_i];
    var endPolygonIndex = polygonIndices[_i + 1];
    var polygonCoordinates = polygonToGeoJson(data, startPolygonIndex, endPolygonIndex).coordinates;
    coordinates.push(polygonCoordinates);
  }

  return {
    type: 'MultiPolygon',
    coordinates: coordinates
  };
}

function lineStringToGeoJson(data) {
  var startIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : -Infinity;
  var endIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Infinity;
  var positions = data.positions;
  var pathIndices = data.pathIndices.value.filter(function (x) {
    return x >= startIndex && x <= endIndex;
  });
  var multi = pathIndices.length > 2;

  if (!multi) {
    var _coordinates = ringToGeoJson(positions, pathIndices[0], pathIndices[1]);

    return {
      type: 'LineString',
      coordinates: _coordinates
    };
  }

  var coordinates = [];

  for (var i = 0; i < pathIndices.length - 1; i++) {
    var ringCoordinates = ringToGeoJson(positions, pathIndices[i], pathIndices[i + 1]);
    coordinates.push(ringCoordinates);
  }

  return {
    type: 'MultiLineString',
    coordinates: coordinates
  };
}

function pointToGeoJson(data, startIndex, endIndex) {
  var positions = data.positions;
  var coordinates = ringToGeoJson(positions, startIndex, endIndex);
  var multi = coordinates.length > 1;

  if (multi) {
    return {
      type: 'MultiPoint',
      coordinates: coordinates
    };
  }

  return {
    type: 'Point',
    coordinates: coordinates[0]
  };
}

function ringToGeoJson(positions, startIndex, endIndex) {
  startIndex = startIndex || 0;
  endIndex = endIndex || positions.value.length / positions.size;
  var ringCoordinates = [];

  for (var j = startIndex; j < endIndex; j++) {
    ringCoordinates.push(Array.from(positions.value.subarray(j * positions.size, (j + 1) * positions.size)));
  }

  return ringCoordinates;
}

function parseType(data) {
  if (data.pathIndices) {
    return 'LineString';
  }

  if (data.polygonIndices) {
    return 'Polygon';
  }

  return 'Point';
}
//# sourceMappingURL=binary-to-geojson.js.map