import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

export function geojsonToBinary(features) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var firstPassData = firstPass(features);
  return secondPass(features, firstPassData, {
    coordLength: options.coordLength || firstPassData.coordLength || 2,
    numericPropKeys: options.numericPropKeys || firstPassData.numericPropKeys,
    PositionDataType: options.PositionDataType || Float32Array
  });
}
export var TEST_EXPORTS = {
  firstPass: firstPass,
  secondPass: secondPass
};

function firstPass(features) {
  var pointPositionsCount = 0;
  var pointFeaturesCount = 0;
  var linePositionsCount = 0;
  var linePathsCount = 0;
  var lineFeaturesCount = 0;
  var polygonPositionsCount = 0;
  var polygonObjectsCount = 0;
  var polygonRingsCount = 0;
  var polygonFeaturesCount = 0;
  var coordLengths = new Set();
  var numericPropKeys = {};

  var _iterator = _createForOfIteratorHelper(features),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var feature = _step.value;
      var geometry = feature.geometry;

      switch (geometry.type) {
        case 'Point':
          pointFeaturesCount++;
          pointPositionsCount++;
          coordLengths.add(geometry.coordinates.length);
          break;

        case 'MultiPoint':
          pointFeaturesCount++;
          pointPositionsCount += geometry.coordinates.length;

          var _iterator2 = _createForOfIteratorHelper(geometry.coordinates),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var point = _step2.value;
              coordLengths.add(point.length);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }

          break;

        case 'LineString':
          lineFeaturesCount++;
          linePositionsCount += geometry.coordinates.length;
          linePathsCount++;

          var _iterator3 = _createForOfIteratorHelper(geometry.coordinates),
              _step3;

          try {
            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
              var coord = _step3.value;
              coordLengths.add(coord.length);
            }
          } catch (err) {
            _iterator3.e(err);
          } finally {
            _iterator3.f();
          }

          break;

        case 'MultiLineString':
          lineFeaturesCount++;

          var _iterator4 = _createForOfIteratorHelper(geometry.coordinates),
              _step4;

          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var line = _step4.value;
              linePositionsCount += line.length;
              linePathsCount++;

              var _iterator5 = _createForOfIteratorHelper(line),
                  _step5;

              try {
                for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                  var _coord = _step5.value;
                  coordLengths.add(_coord.length);
                }
              } catch (err) {
                _iterator5.e(err);
              } finally {
                _iterator5.f();
              }
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }

          break;

        case 'Polygon':
          polygonFeaturesCount++;
          polygonObjectsCount++;
          polygonRingsCount += geometry.coordinates.length;
          polygonPositionsCount += flatten(geometry.coordinates).length;

          var _iterator6 = _createForOfIteratorHelper(flatten(geometry.coordinates)),
              _step6;

          try {
            for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
              var _coord2 = _step6.value;
              coordLengths.add(_coord2.length);
            }
          } catch (err) {
            _iterator6.e(err);
          } finally {
            _iterator6.f();
          }

          break;

        case 'MultiPolygon':
          polygonFeaturesCount++;

          var _iterator7 = _createForOfIteratorHelper(geometry.coordinates),
              _step7;

          try {
            for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
              var polygon = _step7.value;
              polygonObjectsCount++;
              polygonRingsCount += polygon.length;
              polygonPositionsCount += flatten(polygon).length;

              var _iterator8 = _createForOfIteratorHelper(flatten(polygon)),
                  _step8;

              try {
                for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                  var _coord3 = _step8.value;
                  coordLengths.add(_coord3.length);
                }
              } catch (err) {
                _iterator8.e(err);
              } finally {
                _iterator8.f();
              }
            }
          } catch (err) {
            _iterator7.e(err);
          } finally {
            _iterator7.f();
          }

          break;

        default:
          throw new Error("Unsupported geometry type: ".concat(geometry.type));
      }

      if (feature.properties) {
        for (var key in feature.properties) {
          var val = feature.properties[key];
          numericPropKeys[key] = numericPropKeys[key] || numericPropKeys[key] === undefined ? isNumeric(val) : numericPropKeys[key];
        }
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return {
    pointPositionsCount: pointPositionsCount,
    pointFeaturesCount: pointFeaturesCount,
    linePositionsCount: linePositionsCount,
    linePathsCount: linePathsCount,
    lineFeaturesCount: lineFeaturesCount,
    coordLength: coordLengths.size > 0 && Math.max.apply(Math, _toConsumableArray(coordLengths)),
    polygonPositionsCount: polygonPositionsCount,
    polygonObjectsCount: polygonObjectsCount,
    polygonRingsCount: polygonRingsCount,
    polygonFeaturesCount: polygonFeaturesCount,
    numericPropKeys: Object.keys(numericPropKeys).filter(function (k) {
      return numericPropKeys[k];
    })
  };
}

function secondPass(features) {
  var firstPassData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var pointPositionsCount = firstPassData.pointPositionsCount,
      pointFeaturesCount = firstPassData.pointFeaturesCount,
      linePositionsCount = firstPassData.linePositionsCount,
      linePathsCount = firstPassData.linePathsCount,
      lineFeaturesCount = firstPassData.lineFeaturesCount,
      polygonPositionsCount = firstPassData.polygonPositionsCount,
      polygonObjectsCount = firstPassData.polygonObjectsCount,
      polygonRingsCount = firstPassData.polygonRingsCount,
      polygonFeaturesCount = firstPassData.polygonFeaturesCount;
  var coordLength = options.coordLength,
      numericPropKeys = options.numericPropKeys,
      _options$PositionData = options.PositionDataType,
      PositionDataType = _options$PositionData === void 0 ? Float32Array : _options$PositionData;
  var GlobalFeatureIdsDataType = features.length > 65535 ? Uint32Array : Uint16Array;
  var points = {
    positions: new PositionDataType(pointPositionsCount * coordLength),
    globalFeatureIds: new GlobalFeatureIdsDataType(pointPositionsCount),
    featureIds: pointFeaturesCount > 65535 ? new Uint32Array(pointPositionsCount) : new Uint16Array(pointPositionsCount),
    numericProps: {},
    properties: []
  };
  var lines = {
    pathIndices: linePositionsCount > 65535 ? new Uint32Array(linePathsCount + 1) : new Uint16Array(linePathsCount + 1),
    positions: new PositionDataType(linePositionsCount * coordLength),
    globalFeatureIds: new GlobalFeatureIdsDataType(linePositionsCount),
    featureIds: lineFeaturesCount > 65535 ? new Uint32Array(linePositionsCount) : new Uint16Array(linePositionsCount),
    numericProps: {},
    properties: []
  };
  var polygons = {
    polygonIndices: polygonPositionsCount > 65535 ? new Uint32Array(polygonObjectsCount + 1) : new Uint16Array(polygonObjectsCount + 1),
    primitivePolygonIndices: polygonPositionsCount > 65535 ? new Uint32Array(polygonRingsCount + 1) : new Uint16Array(polygonRingsCount + 1),
    positions: new PositionDataType(polygonPositionsCount * coordLength),
    globalFeatureIds: new GlobalFeatureIdsDataType(polygonPositionsCount),
    featureIds: polygonFeaturesCount > 65535 ? new Uint32Array(polygonPositionsCount) : new Uint16Array(polygonPositionsCount),
    numericProps: {},
    properties: []
  };

  for (var _i = 0, _arr = [points, lines, polygons]; _i < _arr.length; _i++) {
    var object = _arr[_i];

    var _iterator9 = _createForOfIteratorHelper(numericPropKeys),
        _step9;

    try {
      for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
        var propName = _step9.value;
        object.numericProps[propName] = new Float32Array(object.positions.length / coordLength);
      }
    } catch (err) {
      _iterator9.e(err);
    } finally {
      _iterator9.f();
    }
  }

  lines.pathIndices[linePathsCount] = linePositionsCount;
  polygons.polygonIndices[polygonObjectsCount] = polygonPositionsCount;
  polygons.primitivePolygonIndices[polygonRingsCount] = polygonPositionsCount;
  var indexMap = {
    pointPosition: 0,
    pointFeature: 0,
    linePosition: 0,
    linePath: 0,
    lineFeature: 0,
    polygonPosition: 0,
    polygonObject: 0,
    polygonRing: 0,
    polygonFeature: 0,
    feature: 0
  };

  var _iterator10 = _createForOfIteratorHelper(features),
      _step10;

  try {
    for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
      var feature = _step10.value;
      var geometry = feature.geometry;
      var properties = feature.properties || {};

      switch (geometry.type) {
        case 'Point':
          handlePoint(geometry.coordinates, points, indexMap, coordLength, properties);
          points.properties.push(keepStringProperties(properties, numericPropKeys));
          indexMap.pointFeature++;
          break;

        case 'MultiPoint':
          handleMultiPoint(geometry.coordinates, points, indexMap, coordLength, properties);
          points.properties.push(keepStringProperties(properties, numericPropKeys));
          indexMap.pointFeature++;
          break;

        case 'LineString':
          handleLineString(geometry.coordinates, lines, indexMap, coordLength, properties);
          lines.properties.push(keepStringProperties(properties, numericPropKeys));
          indexMap.lineFeature++;
          break;

        case 'MultiLineString':
          handleMultiLineString(geometry.coordinates, lines, indexMap, coordLength, properties);
          lines.properties.push(keepStringProperties(properties, numericPropKeys));
          indexMap.lineFeature++;
          break;

        case 'Polygon':
          handlePolygon(geometry.coordinates, polygons, indexMap, coordLength, properties);
          polygons.properties.push(keepStringProperties(properties, numericPropKeys));
          indexMap.polygonFeature++;
          break;

        case 'MultiPolygon':
          handleMultiPolygon(geometry.coordinates, polygons, indexMap, coordLength, properties);
          polygons.properties.push(keepStringProperties(properties, numericPropKeys));
          indexMap.polygonFeature++;
          break;

        default:
          throw new Error('Invalid geometry type');
      }

      indexMap.feature++;
    }
  } catch (err) {
    _iterator10.e(err);
  } finally {
    _iterator10.f();
  }

  return makeAccessorObjects(points, lines, polygons, coordLength);
}

function handlePoint(coords, points, indexMap, coordLength, properties) {
  points.positions.set(coords, indexMap.pointPosition * coordLength);
  points.globalFeatureIds[indexMap.pointPosition] = indexMap.feature;
  points.featureIds[indexMap.pointPosition] = indexMap.pointFeature;
  fillNumericProperties(points, properties, indexMap.pointPosition, 1);
  indexMap.pointPosition++;
}

function handleMultiPoint(coords, points, indexMap, coordLength, properties) {
  var _iterator11 = _createForOfIteratorHelper(coords),
      _step11;

  try {
    for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
      var point = _step11.value;
      handlePoint(point, points, indexMap, coordLength, properties);
    }
  } catch (err) {
    _iterator11.e(err);
  } finally {
    _iterator11.f();
  }
}

function handleLineString(coords, lines, indexMap, coordLength, properties) {
  lines.pathIndices[indexMap.linePath] = indexMap.linePosition;
  indexMap.linePath++;
  fillCoords(lines.positions, coords, indexMap.linePosition, coordLength);
  var nPositions = coords.length;
  fillNumericProperties(lines, properties, indexMap.linePosition, nPositions);
  lines.globalFeatureIds.set(new Uint32Array(nPositions).fill(indexMap.feature), indexMap.linePosition);
  lines.featureIds.set(new Uint32Array(nPositions).fill(indexMap.lineFeature), indexMap.linePosition);
  indexMap.linePosition += nPositions;
}

function handleMultiLineString(coords, lines, indexMap, coordLength, properties) {
  var _iterator12 = _createForOfIteratorHelper(coords),
      _step12;

  try {
    for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
      var line = _step12.value;
      handleLineString(line, lines, indexMap, coordLength, properties);
    }
  } catch (err) {
    _iterator12.e(err);
  } finally {
    _iterator12.f();
  }
}

function handlePolygon(coords, polygons, indexMap, coordLength, properties) {
  polygons.polygonIndices[indexMap.polygonObject] = indexMap.polygonPosition;
  indexMap.polygonObject++;

  var _iterator13 = _createForOfIteratorHelper(coords),
      _step13;

  try {
    for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
      var ring = _step13.value;
      polygons.primitivePolygonIndices[indexMap.polygonRing] = indexMap.polygonPosition;
      indexMap.polygonRing++;
      fillCoords(polygons.positions, ring, indexMap.polygonPosition, coordLength);
      var nPositions = ring.length;
      fillNumericProperties(polygons, properties, indexMap.polygonPosition, nPositions);
      polygons.globalFeatureIds.set(new Uint32Array(nPositions).fill(indexMap.feature), indexMap.polygonPosition);
      polygons.featureIds.set(new Uint32Array(nPositions).fill(indexMap.polygonFeature), indexMap.polygonPosition);
      indexMap.polygonPosition += nPositions;
    }
  } catch (err) {
    _iterator13.e(err);
  } finally {
    _iterator13.f();
  }
}

function handleMultiPolygon(coords, polygons, indexMap, coordLength, properties) {
  var _iterator14 = _createForOfIteratorHelper(coords),
      _step14;

  try {
    for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
      var polygon = _step14.value;
      handlePolygon(polygon, polygons, indexMap, coordLength, properties);
    }
  } catch (err) {
    _iterator14.e(err);
  } finally {
    _iterator14.f();
  }
}

function makeAccessorObjects(points, lines, polygons, coordLength) {
  var returnObj = {
    points: {
      positions: {
        value: points.positions,
        size: coordLength
      },
      globalFeatureIds: {
        value: points.globalFeatureIds,
        size: 1
      },
      featureIds: {
        value: points.featureIds,
        size: 1
      },
      numericProps: points.numericProps,
      properties: points.properties
    },
    lines: {
      pathIndices: {
        value: lines.pathIndices,
        size: 1
      },
      positions: {
        value: lines.positions,
        size: coordLength
      },
      globalFeatureIds: {
        value: lines.globalFeatureIds,
        size: 1
      },
      featureIds: {
        value: lines.featureIds,
        size: 1
      },
      numericProps: lines.numericProps,
      properties: lines.properties
    },
    polygons: {
      polygonIndices: {
        value: polygons.polygonIndices,
        size: 1
      },
      primitivePolygonIndices: {
        value: polygons.primitivePolygonIndices,
        size: 1
      },
      positions: {
        value: polygons.positions,
        size: coordLength
      },
      globalFeatureIds: {
        value: polygons.globalFeatureIds,
        size: 1
      },
      featureIds: {
        value: polygons.featureIds,
        size: 1
      },
      numericProps: polygons.numericProps,
      properties: polygons.properties
    }
  };

  for (var geomType in returnObj) {
    for (var numericProp in returnObj[geomType].numericProps) {
      returnObj[geomType].numericProps[numericProp] = {
        value: returnObj[geomType].numericProps[numericProp],
        size: 1
      };
    }
  }

  return returnObj;
}

function fillNumericProperties(object, properties, index, length) {
  for (var numericPropName in object.numericProps) {
    if (numericPropName in properties) {
      object.numericProps[numericPropName].set(new Array(length).fill(properties[numericPropName]), index);
    }
  }
}

function keepStringProperties(properties, numericKeys) {
  var props = {};

  for (var key in properties) {
    if (!numericKeys.includes(key)) {
      props[key] = properties[key];
    }
  }

  return props;
}

function fillCoords(array, coords, startVertex, coordLength) {
  var index = startVertex * coordLength;

  var _iterator15 = _createForOfIteratorHelper(coords),
      _step15;

  try {
    for (_iterator15.s(); !(_step15 = _iterator15.n()).done;) {
      var coord = _step15.value;
      array.set(coord, index);
      index += coordLength;
    }
  } catch (err) {
    _iterator15.e(err);
  } finally {
    _iterator15.f();
  }
}

function flatten(arrays) {
  var _ref;

  return (_ref = []).concat.apply(_ref, _toConsumableArray(arrays));
}

function isNumeric(x) {
  return Number.isFinite(x);
}
//# sourceMappingURL=geojson-to-binary.js.map