"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geojsonToBinary = geojsonToBinary;
var _extractGeometryInfo = require("./extract-geometry-info");
var _geojsonToFlatGeojson = require("./geojson-to-flat-geojson");
var _flatGeojsonToBinary = require("./flat-geojson-to-binary");
function geojsonToBinary(features) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    fixRingWinding: true,
    triangulate: true
  };
  const geometryInfo = (0, _extractGeometryInfo.extractGeometryInfo)(features);
  const coordLength = geometryInfo.coordLength;
  const {
    fixRingWinding
  } = options;
  const flatFeatures = (0, _geojsonToFlatGeojson.geojsonToFlatGeojson)(features, {
    coordLength,
    fixRingWinding
  });
  return (0, _flatGeojsonToBinary.flatGeojsonToBinary)(flatFeatures, geometryInfo, {
    numericPropKeys: options.numericPropKeys,
    PositionDataType: options.PositionDataType || Float32Array,
    triangulate: options.triangulate
  });
}
//# sourceMappingURL=geojson-to-binary.js.map