"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoJSONLoader = exports.GeoJSONWorkerLoader = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _awaitAsyncGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/awaitAsyncGenerator"));

var _wrapAsyncGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapAsyncGenerator"));

var _asyncIterator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncIterator"));

var _tables = require("@loaders.gl/tables");

var _gis = require("@loaders.gl/gis");

var _parseJson = _interopRequireDefault(require("./lib/parse-json"));

var _parseJsonInBatches = _interopRequireDefault(require("./lib/parse-json-in-batches"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var VERSION = typeof "2.3.13" !== 'undefined' ? "2.3.13" : 'latest';
var GeoJSONLoaderOptions = {
  geojson: {
    TableBatch: _tables.RowTableBatch,
    batchSize: 'auto',
    workerUrl: "https://unpkg.com/@loaders.gl/json@".concat(VERSION, "/dist/geojson-loader.worker.js")
  },
  json: {
    jsonpaths: ['$', '$.features']
  },
  gis: {
    format: 'geojson'
  }
};
var GeoJSONWorkerLoader = {
  id: 'geojson',
  name: 'GeoJSON',
  version: VERSION,
  extensions: ['geojson'],
  mimeTypes: ['application/geo+json'],
  category: 'geometry',
  text: true,
  options: GeoJSONLoaderOptions
};
exports.GeoJSONWorkerLoader = GeoJSONWorkerLoader;

var GeoJSONLoader = _objectSpread(_objectSpread({}, GeoJSONWorkerLoader), {}, {
  parse: parse,
  parseTextSync: parseTextSync,
  parseInBatches: parseInBatches
});

exports.GeoJSONLoader = GeoJSONLoader;

function parse(_x2, _x3) {
  return _parse.apply(this, arguments);
}

function _parse() {
  _parse = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2(arrayBuffer, options) {
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            return _context2.abrupt("return", parseTextSync(new TextDecoder().decode(arrayBuffer), options));

          case 1:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _parse.apply(this, arguments);
}

function parseTextSync(text, options) {
  options = _objectSpread(_objectSpread({}, GeoJSONLoaderOptions), options);
  options.json = _objectSpread(_objectSpread({}, GeoJSONLoaderOptions.geojson), options.geojson);
  options.gis = options.gis || {};
  var json = (0, _parseJson["default"])(text, options);

  switch (options.gis.format) {
    case 'binary':
      return (0, _gis.geojsonToBinary)(json);

    default:
      return json;
  }
}

function parseInBatches(_x4, _x5) {
  return _parseInBatches.apply(this, arguments);
}

function _parseInBatches() {
  _parseInBatches = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee3(asyncIterator, options) {
    var geojsonIterator;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            options = _objectSpread(_objectSpread({}, GeoJSONLoaderOptions), options);
            options.json = _objectSpread(_objectSpread({}, GeoJSONLoaderOptions.geojson), options.geojson);
            geojsonIterator = (0, _parseJsonInBatches["default"])(asyncIterator, options);
            _context3.t0 = options.gis.format;
            _context3.next = _context3.t0 === 'binary' ? 6 : 7;
            break;

          case 6:
            return _context3.abrupt("return", makeBinaryGeometryIterator(geojsonIterator));

          case 7:
            return _context3.abrupt("return", geojsonIterator);

          case 8:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _parseInBatches.apply(this, arguments);
}

function makeBinaryGeometryIterator(_x) {
  return _makeBinaryGeometryIterator.apply(this, arguments);
}

function _makeBinaryGeometryIterator() {
  _makeBinaryGeometryIterator = (0, _wrapAsyncGenerator2["default"])(_regenerator["default"].mark(function _callee(geojsonIterator) {
    var _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, _value, batch;

    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _context.prev = 2;
            _iterator = (0, _asyncIterator2["default"])(geojsonIterator);

          case 4:
            _context.next = 6;
            return (0, _awaitAsyncGenerator2["default"])(_iterator.next());

          case 6:
            _step = _context.sent;
            _iteratorNormalCompletion = _step.done;
            _context.next = 10;
            return (0, _awaitAsyncGenerator2["default"])(_step.value);

          case 10:
            _value = _context.sent;

            if (_iteratorNormalCompletion) {
              _context.next = 19;
              break;
            }

            batch = _value;
            batch.data = (0, _gis.geojsonToBinary)(batch.data);
            _context.next = 16;
            return batch;

          case 16:
            _iteratorNormalCompletion = true;
            _context.next = 4;
            break;

          case 19:
            _context.next = 25;
            break;

          case 21:
            _context.prev = 21;
            _context.t0 = _context["catch"](2);
            _didIteratorError = true;
            _iteratorError = _context.t0;

          case 25:
            _context.prev = 25;
            _context.prev = 26;

            if (!(!_iteratorNormalCompletion && _iterator["return"] != null)) {
              _context.next = 30;
              break;
            }

            _context.next = 30;
            return (0, _awaitAsyncGenerator2["default"])(_iterator["return"]());

          case 30:
            _context.prev = 30;

            if (!_didIteratorError) {
              _context.next = 33;
              break;
            }

            throw _iteratorError;

          case 33:
            return _context.finish(30);

          case 34:
            return _context.finish(25);

          case 35:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[2, 21, 25, 35], [26,, 30, 34]]);
  }));
  return _makeBinaryGeometryIterator.apply(this, arguments);
}
//# sourceMappingURL=geojson-loader.js.map