"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JSONLoader = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _tables = require("@loaders.gl/tables");

var _parseJson = _interopRequireDefault(require("./lib/parse-json"));

var _parseJsonInBatches = _interopRequireDefault(require("./lib/parse-json-in-batches"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var VERSION = typeof "2.3.13" !== 'undefined' ? "2.3.13" : 'latest';
var JSONLoaderOptions = {
  json: {
    TableBatch: _tables.RowTableBatch,
    batchSize: 'auto',
    _rootObjectBatches: false,
    table: false,
    jsonpaths: []
  }
};
var JSONLoader = {
  id: 'json',
  name: 'JSON',
  version: VERSION,
  extensions: ['json', 'geojson'],
  mimeTypes: ['application/json'],
  category: 'table',
  text: true,
  parse: parse,
  parseTextSync: parseTextSync,
  parseInBatches: parseInBatches,
  options: JSONLoaderOptions,
  deprecatedOptions: {
    json: {
      _rootObjectBatches: 'metadata'
    }
  }
};
exports.JSONLoader = JSONLoader;

function parse(_x, _x2) {
  return _parse.apply(this, arguments);
}

function _parse() {
  _parse = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(arrayBuffer, options) {
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", parseTextSync(new TextDecoder().decode(arrayBuffer), options));

          case 1:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _parse.apply(this, arguments);
}

function parseTextSync(text, options) {
  options = _objectSpread(_objectSpread({}, JSONLoaderOptions), options);
  options.json = _objectSpread(_objectSpread({}, JSONLoaderOptions.json), options.json);
  return (0, _parseJson["default"])(text, options);
}

function parseInBatches(_x3, _x4) {
  return _parseInBatches.apply(this, arguments);
}

function _parseInBatches() {
  _parseInBatches = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2(asyncIterator, options) {
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            options = _objectSpread(_objectSpread({}, JSONLoaderOptions), options);
            options.json = _objectSpread(_objectSpread({}, JSONLoaderOptions.json), options.json);
            return _context2.abrupt("return", (0, _parseJsonInBatches["default"])(asyncIterator, options));

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _parseInBatches.apply(this, arguments);
}
//# sourceMappingURL=json-loader.js.map