"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var JSONPath = function () {
  function JSONPath() {
    var path = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    (0, _classCallCheck2["default"])(this, JSONPath);
    this.path = ['$'];

    if (path instanceof JSONPath) {
      this.path = (0, _toConsumableArray2["default"])(path.path);
      return;
    }

    if (Array.isArray(path)) {
      var _this$path;

      (_this$path = this.path).push.apply(_this$path, (0, _toConsumableArray2["default"])(path));

      return;
    }

    if (typeof path === 'string') {
      this.path = path.split('.');

      if (this.path[0] !== '$') {
        throw new Error('JSONPaths must start with $');
      }
    }
  }

  (0, _createClass2["default"])(JSONPath, [{
    key: "clone",
    value: function clone() {
      return new JSONPath(this);
    }
  }, {
    key: "toString",
    value: function toString() {
      return this.path.join('.');
    }
  }, {
    key: "push",
    value: function push(name) {
      this.path.push(name);
    }
  }, {
    key: "pop",
    value: function pop() {
      return this.path.pop();
    }
  }, {
    key: "set",
    value: function set(name) {
      this.path[this.path.length - 1] = name;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (!this || !other || this.path.length !== other.path.length) {
        return false;
      }

      for (var i = 0; i < this.path.length; ++i) {
        if (this.path[i] !== other.path[i]) {
          return false;
        }
      }

      return true;
    }
  }, {
    key: "setFieldAtPath",
    value: function setFieldAtPath(object, value) {
      var path = (0, _toConsumableArray2["default"])(this.path);
      path.shift();
      var field = path.pop();

      var _iterator = _createForOfIteratorHelper(path),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var component = _step.value;
          object = object[component];
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      object[field] = value;
    }
  }, {
    key: "getFieldAtPath",
    value: function getFieldAtPath(object) {
      var path = (0, _toConsumableArray2["default"])(this.path);
      path.shift();
      var field = path.pop();

      var _iterator2 = _createForOfIteratorHelper(path),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var component = _step2.value;
          object = object[component];
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return object[field];
    }
  }]);
  return JSONPath;
}();

exports["default"] = JSONPath;
//# sourceMappingURL=jsonpath.js.map