"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _jsonParser = _interopRequireDefault(require("./json-parser"));

var _jsonpath = _interopRequireDefault(require("../jsonpath/jsonpath"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var StreamingJSONParser = function (_JSONParser) {
  (0, _inherits2["default"])(StreamingJSONParser, _JSONParser);

  var _super = _createSuper(StreamingJSONParser);

  function StreamingJSONParser() {
    var _this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    (0, _classCallCheck2["default"])(this, StreamingJSONParser);
    _this = _super.call(this);
    var jsonpaths = options.jsonpaths || [];
    _this.jsonPaths = jsonpaths.map(function (jsonpath) {
      return new _jsonpath["default"](jsonpath);
    });
    _this.streamingJsonPath = null;
    _this.streamingArray = null;
    _this.topLevelObject = null;

    _this._extendParser();

    return _this;
  }

  (0, _createClass2["default"])(StreamingJSONParser, [{
    key: "write",
    value: function write(chunk) {
      (0, _get2["default"])((0, _getPrototypeOf2["default"])(StreamingJSONParser.prototype), "write", this).call(this, chunk);
      var array = [];

      if (this.streamingArray) {
        array = (0, _toConsumableArray2["default"])(this.streamingArray);
        this.streamingArray.length = 0;
      }

      return array;
    }
  }, {
    key: "getPartialResult",
    value: function getPartialResult() {
      return this.topLevelObject;
    }
  }, {
    key: "getStreamingJsonPath",
    value: function getStreamingJsonPath() {
      return this.streamingJsonPath;
    }
  }, {
    key: "getStreamingJsonPathAsString",
    value: function getStreamingJsonPathAsString() {
      return this.streamingJsonPath && this.streamingJsonPath.toString();
    }
  }, {
    key: "getJsonPath",
    value: function getJsonPath() {
      return this.jsonpath;
    }
  }, {
    key: "_matchJSONPath",
    value: function _matchJSONPath() {
      var currentPath = this.getJsonPath();

      if (this.jsonPaths.length === 0) {
        return true;
      }

      var _iterator = _createForOfIteratorHelper(this.jsonPaths),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var jsonPath = _step.value;

          if (jsonPath.equals(currentPath)) {
            return true;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return false;
    }
  }, {
    key: "_extendParser",
    value: function _extendParser() {
      var _this2 = this;

      this.parser.onopenarray = function () {
        if (!_this2.streamingArray) {
          if (_this2._matchJSONPath()) {
            _this2.streamingJsonPath = _this2.getJsonPath().clone();
            _this2.streamingArray = [];

            _this2._openArray(_this2.streamingArray);

            return;
          }
        }

        _this2._openArray();
      };

      this.parser.onopenobject = function (name) {
        if (!_this2.topLevelObject) {
          _this2.topLevelObject = {};

          _this2._openObject(_this2.topLevelObject);
        } else {
          _this2._openObject({});
        }

        if (typeof name !== 'undefined') {
          _this2.parser.onkey(name);
        }
      };
    }
  }]);
  return StreamingJSONParser;
}(_jsonParser["default"]);

exports["default"] = StreamingJSONParser;
//# sourceMappingURL=streaming-json-parser.js.map