import { RowTableBatch } from '@loaders.gl/tables';
import parseJSONSync from './lib/parse-json';
import parseJSONInBatches from './lib/parse-json-in-batches';
const VERSION = typeof "2.3.13" !== 'undefined' ? "2.3.13" : 'latest';
const JSONLoaderOptions = {
  json: {
    TableBatch: RowTableBatch,
    batchSize: 'auto',
    _rootObjectBatches: false,
    table: false,
    jsonpaths: []
  }
};
export const JSONLoader = {
  id: 'json',
  name: 'JSON',
  version: VERSION,
  extensions: ['json', 'geojson'],
  mimeTypes: ['application/json'],
  category: 'table',
  text: true,
  parse,
  parseTextSync,
  parseInBatches,
  options: JSONLoaderOptions,
  deprecatedOptions: {
    json: {
      _rootObjectBatches: 'metadata'
    }
  }
};

async function parse(arrayBuffer, options) {
  return parseTextSync(new TextDecoder().decode(arrayBuffer), options);
}

function parseTextSync(text, options) {
  options = { ...JSONLoaderOptions,
    ...options
  };
  options.json = { ...JSONLoaderOptions.json,
    ...options.json
  };
  return parseJSONSync(text, options);
}

async function parseInBatches(asyncIterator, options) {
  options = { ...JSONLoaderOptions,
    ...options
  };
  options.json = { ...JSONLoaderOptions.json,
    ...options.json
  };
  return parseJSONInBatches(asyncIterator, options);
}
//# sourceMappingURL=json-loader.js.map