import { default as JSONParser } from './json-parser';
import JSONPath from '../jsonpath/jsonpath';
export default class StreamingJSONParser extends JSONParser {
  constructor(options = {}) {
    super();
    const jsonpaths = options.jsonpaths || [];
    this.jsonPaths = jsonpaths.map(jsonpath => new JSONPath(jsonpath));
    this.streamingJsonPath = null;
    this.streamingArray = null;
    this.topLevelObject = null;

    this._extendParser();
  }

  write(chunk) {
    super.write(chunk);
    let array = [];

    if (this.streamingArray) {
      array = [...this.streamingArray];
      this.streamingArray.length = 0;
    }

    return array;
  }

  getPartialResult() {
    return this.topLevelObject;
  }

  getStreamingJsonPath() {
    return this.streamingJsonPath;
  }

  getStreamingJsonPathAsString() {
    return this.streamingJsonPath && this.streamingJsonPath.toString();
  }

  getJsonPath() {
    return this.jsonpath;
  }

  _matchJSONPath() {
    const currentPath = this.getJsonPath();

    if (this.jsonPaths.length === 0) {
      return true;
    }

    for (const jsonPath of this.jsonPaths) {
      if (jsonPath.equals(currentPath)) {
        return true;
      }
    }

    return false;
  }

  _extendParser() {
    this.parser.onopenarray = () => {
      if (!this.streamingArray) {
        if (this._matchJSONPath()) {
          this.streamingJsonPath = this.getJsonPath().clone();
          this.streamingArray = [];

          this._openArray(this.streamingArray);

          return;
        }
      }

      this._openArray();
    };

    this.parser.onopenobject = name => {
      if (!this.topLevelObject) {
        this.topLevelObject = {};

        this._openObject(this.topLevelObject);
      } else {
        this._openObject({});
      }

      if (typeof name !== 'undefined') {
        this.parser.onkey(name);
      }
    };
  }

}
//# sourceMappingURL=streaming-json-parser.js.map