import _typeof from "@babel/runtime/helpers/esm/typeof";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import _awaitAsyncGenerator from "@babel/runtime/helpers/esm/awaitAsyncGenerator";
import _wrapAsyncGenerator from "@babel/runtime/helpers/esm/wrapAsyncGenerator";
import _asyncIterator from "@babel/runtime/helpers/esm/asyncIterator";

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

import { makeTextDecoderIterator } from '@loaders.gl/loader-utils';
import { TableBatchBuilder } from '@loaders.gl/tables';
import StreamingJSONParser from './parser/streaming-json-parser';
export default function parseJSONInBatches(_x, _x2) {
  return _parseJSONInBatches.apply(this, arguments);
}

function _parseJSONInBatches() {
  _parseJSONInBatches = _wrapAsyncGenerator(_regeneratorRuntime.mark(function _callee(asyncIterator, options) {
    var metadata, _options$json, batchSize, _rootObjectBatches, jsonpaths, TableBatchType, isFirstChunk, tableBatchBuilder, schema, parser, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, _value, chunk, rows, _jsonpath, initialBatch, _initialBatch, _iterator2, _step2, row, jsonpath, batch, finalBatch, _finalBatch;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            asyncIterator = makeTextDecoderIterator(asyncIterator);
            metadata = options.metadata;
            _options$json = options.json, batchSize = _options$json.batchSize, _rootObjectBatches = _options$json._rootObjectBatches, jsonpaths = _options$json.jsonpaths;
            TableBatchType = options.json.TableBatch;
            isFirstChunk = true;
            tableBatchBuilder = null;
            schema = null;
            parser = new StreamingJSONParser({
              jsonpaths: jsonpaths
            });
            tableBatchBuilder = tableBatchBuilder || new TableBatchBuilder(TableBatchType, schema, {
              batchSize: batchSize
            });
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _context.prev = 11;
            _iterator = _asyncIterator(asyncIterator);

          case 13:
            _context.next = 15;
            return _awaitAsyncGenerator(_iterator.next());

          case 15:
            _step = _context.sent;
            _iteratorNormalCompletion = _step.done;
            _context.next = 19;
            return _awaitAsyncGenerator(_step.value);

          case 19:
            _value = _context.sent;

            if (_iteratorNormalCompletion) {
              _context.next = 61;
              break;
            }

            chunk = _value;
            rows = parser.write(chunk);
            _jsonpath = rows.length > 0 && parser.getStreamingJsonPathAsString();

            if (!(rows.length > 0 && isFirstChunk)) {
              _context.next = 35;
              break;
            }

            if (!metadata) {
              _context.next = 29;
              break;
            }

            initialBatch = {
              batchType: 'partial-result',
              container: parser.getPartialResult(),
              data: [],
              bytesUsed: 0,
              schema: null,
              jsonpath: _jsonpath
            };
            _context.next = 29;
            return initialBatch;

          case 29:
            if (!_rootObjectBatches) {
              _context.next = 33;
              break;
            }

            _initialBatch = {
              batchType: 'root-object-batch-partial',
              container: parser.getPartialResult(),
              data: [],
              schema: null
            };
            _context.next = 33;
            return _initialBatch;

          case 33:
            isFirstChunk = false;
            schema = deduceSchema(rows);

          case 35:
            _iterator2 = _createForOfIteratorHelper(rows);
            _context.prev = 36;

            _iterator2.s();

          case 38:
            if ((_step2 = _iterator2.n()).done) {
              _context.next = 46;
              break;
            }

            row = _step2.value;
            tableBatchBuilder.addRow(row);

            if (!tableBatchBuilder.isFull()) {
              _context.next = 44;
              break;
            }

            _context.next = 44;
            return tableBatchBuilder.getBatch({
              jsonpath: _jsonpath
            });

          case 44:
            _context.next = 38;
            break;

          case 46:
            _context.next = 51;
            break;

          case 48:
            _context.prev = 48;
            _context.t0 = _context["catch"](36);

            _iterator2.e(_context.t0);

          case 51:
            _context.prev = 51;

            _iterator2.f();

            return _context.finish(51);

          case 54:
            tableBatchBuilder.chunkComplete(chunk);

            if (!tableBatchBuilder.isFull()) {
              _context.next = 58;
              break;
            }

            _context.next = 58;
            return tableBatchBuilder.getBatch({
              jsonpath: _jsonpath
            });

          case 58:
            _iteratorNormalCompletion = true;
            _context.next = 13;
            break;

          case 61:
            _context.next = 67;
            break;

          case 63:
            _context.prev = 63;
            _context.t1 = _context["catch"](11);
            _didIteratorError = true;
            _iteratorError = _context.t1;

          case 67:
            _context.prev = 67;
            _context.prev = 68;

            if (!(!_iteratorNormalCompletion && _iterator["return"] != null)) {
              _context.next = 72;
              break;
            }

            _context.next = 72;
            return _awaitAsyncGenerator(_iterator["return"]());

          case 72:
            _context.prev = 72;

            if (!_didIteratorError) {
              _context.next = 75;
              break;
            }

            throw _iteratorError;

          case 75:
            return _context.finish(72);

          case 76:
            return _context.finish(67);

          case 77:
            jsonpath = parser.getStreamingJsonPathAsString();
            batch = tableBatchBuilder.getBatch({
              jsonpath: jsonpath
            });

            if (!batch) {
              _context.next = 82;
              break;
            }

            _context.next = 82;
            return batch;

          case 82:
            if (!metadata) {
              _context.next = 86;
              break;
            }

            finalBatch = {
              batchType: 'final-result',
              container: parser.getPartialResult(),
              jsonpath: parser.getStreamingJsonPathAsString(),
              data: [],
              schema: null
            };
            _context.next = 86;
            return finalBatch;

          case 86:
            if (!_rootObjectBatches) {
              _context.next = 90;
              break;
            }

            _finalBatch = {
              batchType: 'root-object-batch-complete',
              container: parser.getPartialResult(),
              data: [],
              schema: null
            };
            _context.next = 90;
            return _finalBatch;

          case 90:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, null, [[11, 63, 67, 77], [36, 48, 51, 54], [68,, 72, 76]]);
  }));
  return _parseJSONInBatches.apply(this, arguments);
}

function deduceSchema(rows) {
  var row = rows[0];
  var schema = {};
  var i = 0;

  for (var columnName in row) {
    var value = row[columnName];

    switch (_typeof(value)) {
      case 'number':
      case 'boolean':
        schema[columnName] = {
          name: String(columnName),
          index: i,
          type: Float32Array
        };
        break;

      case 'object':
        schema[columnName] = {
          name: String(columnName),
          index: i,
          type: Array
        };
        break;

      case 'string':
      default:
        schema[columnName] = {
          name: String(columnName),
          index: i,
          type: Array
        };
    }

    i++;
  }

  return schema;
}
//# sourceMappingURL=parse-json-in-batches.js.map