import _typeof from "@babel/runtime/helpers/esm/typeof";
export default function parseJSONSync(jsonText, options) {
  try {
    var json = JSON.parse(jsonText);

    if (options.json.table) {
      return getFirstArray(json) || json;
    }

    return json;
  } catch (error) {
    throw new Error('JSONLoader: failed to parse JSON');
  }
}

function getFirstArray(json) {
  if (Array.isArray(json)) {
    return json;
  }

  if (json && _typeof(json) === 'object') {
    for (var _i = 0, _Object$values = Object.values(json); _i < _Object$values.length; _i++) {
      var value = _Object$values[_i];
      var array = getFirstArray(value);

      if (array) {
        return array;
      }
    }
  }

  return null;
}
//# sourceMappingURL=parse-json.js.map