import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import ClarinetParser from '../clarinet/clarinet';
import JSONPath from '../jsonpath/jsonpath';

var JSONParser = function () {
  function JSONParser() {
    _classCallCheck(this, JSONParser);

    this.reset();

    this._initializeParser();
  }

  _createClass(JSONParser, [{
    key: "reset",
    value: function reset() {
      this.result = undefined;
      this.previousStates = [];
      this.currentState = Object.freeze({
        container: [],
        key: null
      });
      this.jsonpath = new JSONPath();
    }
  }, {
    key: "write",
    value: function write(chunk) {
      this.parser.write(chunk);
    }
  }, {
    key: "close",
    value: function close() {
      this.parser.close();
    }
  }, {
    key: "_pushOrSet",
    value: function _pushOrSet(value) {
      var _this$currentState = this.currentState,
          container = _this$currentState.container,
          key = _this$currentState.key;

      if (key !== null) {
        container[key] = value;
        this.currentState.key = null;
      } else {
        container.push(value);
      }
    }
  }, {
    key: "_openArray",
    value: function _openArray() {
      var newContainer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      this.jsonpath.push(null);

      this._pushOrSet(newContainer);

      this.previousStates.push(this.currentState);
      this.currentState = {
        container: newContainer,
        isArray: true,
        key: null
      };
    }
  }, {
    key: "_closeArray",
    value: function _closeArray() {
      this.jsonpath.pop();
      this.currentState = this.previousStates.pop();
    }
  }, {
    key: "_openObject",
    value: function _openObject() {
      var newContainer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      this.jsonpath.push(null);

      this._pushOrSet(newContainer);

      this.previousStates.push(this.currentState);
      this.currentState = {
        container: newContainer,
        isArray: false,
        key: null
      };
    }
  }, {
    key: "_closeObject",
    value: function _closeObject() {
      this.jsonpath.pop();
      this.currentState = this.previousStates.pop();
    }
  }, {
    key: "_initializeParser",
    value: function _initializeParser() {
      var _this = this;

      this.parser = new ClarinetParser({
        onready: function onready() {
          _this.jsonpath = new JSONPath();
          _this.previousStates.length = 0;
          _this.currentState.container.length = 0;
        },
        onopenobject: function onopenobject(name) {
          _this._openObject({});

          if (typeof name !== 'undefined') {
            _this.parser.onkey(name);
          }
        },
        onkey: function onkey(name) {
          _this.jsonpath.set(name);

          _this.currentState.key = name;
        },
        oncloseobject: function oncloseobject() {
          _this._closeObject();
        },
        onopenarray: function onopenarray() {
          _this._openArray();
        },
        onclosearray: function onclosearray() {
          _this._closeArray();
        },
        onvalue: function onvalue(value) {
          _this._pushOrSet(value);
        },
        onerror: function onerror(error) {
          throw error;
        },
        onend: function onend() {
          _this.result = _this.currentState.container.pop();
        }
      });
    }
  }]);

  return JSONParser;
}();

export { JSONParser as default };
//# sourceMappingURL=json-parser.js.map