import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _get from "@babel/runtime/helpers/esm/get";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/esm/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/esm/getPrototypeOf";

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

import { default as JSONParser } from './json-parser';
import JSONPath from '../jsonpath/jsonpath';

var StreamingJSONParser = function (_JSONParser) {
  _inherits(StreamingJSONParser, _JSONParser);

  var _super = _createSuper(StreamingJSONParser);

  function StreamingJSONParser() {
    var _this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    _classCallCheck(this, StreamingJSONParser);

    _this = _super.call(this);
    var jsonpaths = options.jsonpaths || [];
    _this.jsonPaths = jsonpaths.map(function (jsonpath) {
      return new JSONPath(jsonpath);
    });
    _this.streamingJsonPath = null;
    _this.streamingArray = null;
    _this.topLevelObject = null;

    _this._extendParser();

    return _this;
  }

  _createClass(StreamingJSONParser, [{
    key: "write",
    value: function write(chunk) {
      _get(_getPrototypeOf(StreamingJSONParser.prototype), "write", this).call(this, chunk);

      var array = [];

      if (this.streamingArray) {
        array = _toConsumableArray(this.streamingArray);
        this.streamingArray.length = 0;
      }

      return array;
    }
  }, {
    key: "getPartialResult",
    value: function getPartialResult() {
      return this.topLevelObject;
    }
  }, {
    key: "getStreamingJsonPath",
    value: function getStreamingJsonPath() {
      return this.streamingJsonPath;
    }
  }, {
    key: "getStreamingJsonPathAsString",
    value: function getStreamingJsonPathAsString() {
      return this.streamingJsonPath && this.streamingJsonPath.toString();
    }
  }, {
    key: "getJsonPath",
    value: function getJsonPath() {
      return this.jsonpath;
    }
  }, {
    key: "_matchJSONPath",
    value: function _matchJSONPath() {
      var currentPath = this.getJsonPath();

      if (this.jsonPaths.length === 0) {
        return true;
      }

      var _iterator = _createForOfIteratorHelper(this.jsonPaths),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var jsonPath = _step.value;

          if (jsonPath.equals(currentPath)) {
            return true;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return false;
    }
  }, {
    key: "_extendParser",
    value: function _extendParser() {
      var _this2 = this;

      this.parser.onopenarray = function () {
        if (!_this2.streamingArray) {
          if (_this2._matchJSONPath()) {
            _this2.streamingJsonPath = _this2.getJsonPath().clone();
            _this2.streamingArray = [];

            _this2._openArray(_this2.streamingArray);

            return;
          }
        }

        _this2._openArray();
      };

      this.parser.onopenobject = function (name) {
        if (!_this2.topLevelObject) {
          _this2.topLevelObject = {};

          _this2._openObject(_this2.topLevelObject);
        } else {
          _this2._openObject({});
        }

        if (typeof name !== 'undefined') {
          _this2.parser.onkey(name);
        }
      };
    }
  }]);

  return StreamingJSONParser;
}(JSONParser);

export { StreamingJSONParser as default };
//# sourceMappingURL=streaming-json-parser.js.map