"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toArrayBuffer = toArrayBuffer;
exports.toBuffer = toBuffer;

var _assert = _interopRequireDefault(require("../env-utils/assert"));

function toArrayBuffer(buffer) {
  if (Buffer.isBuffer(buffer)) {
    var typedArray = new Uint8Array(buffer);
    return typedArray.buffer;
  }

  return buffer;
}

function toBuffer(binaryData) {
  if (ArrayBuffer.isView(binaryData)) {
    binaryData = binaryData.buffer;
  }

  if (typeof Buffer !== 'undefined' && binaryData instanceof ArrayBuffer) {
    var buffer = new Buffer(binaryData.byteLength);
    var view = new Uint8Array(binaryData);

    for (var i = 0; i < buffer.length; ++i) {
      buffer[i] = view[i];
    }

    return buffer;
  }

  return (0, _assert["default"])(false);
}
//# sourceMappingURL=buffer-utils.node.js.map