"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _child_process = _interopRequireDefault(require("child_process"));

var _assert = _interopRequireDefault(require("../env-utils/assert"));

var _processUtils = require("./process-utils");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var DEFAULT_PROCESS_OPTIONS = {
  command: null,
  arguments: [],
  portArg: null,
  port: 'auto',
  basePort: 5000,
  wait: 2000,
  nodeSpawnOptions: {
    maxBuffer: 5000 * 1024
  },
  onSuccess: function onSuccess(processProxy) {
    console.log("Started ".concat(processProxy.options.command));
  }
};

var ChildProcessProxy = function () {
  function ChildProcessProxy() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$id = _ref.id,
        id = _ref$id === void 0 ? 'browser-driver' : _ref$id;

    (0, _classCallCheck2["default"])(this, ChildProcessProxy);
    this.id = id;
    this.childProcess = null;
    this.port = null;
  }

  (0, _createClass2["default"])(ChildProcessProxy, [{
    key: "start",
    value: function () {
      var _start = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee() {
        var _this = this;

        var options,
            args,
            _args = arguments;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                options = _args.length > 0 && _args[0] !== undefined ? _args[0] : {};
                options = _objectSpread(_objectSpread({}, DEFAULT_PROCESS_OPTIONS), options);
                (0, _assert["default"])(options.command && typeof options.command === 'string');
                this.options = options;
                args = (0, _toConsumableArray2["default"])(options.arguments);
                this.port = options.port;

                if (!options.portArg) {
                  _context.next = 12;
                  break;
                }

                if (!(this.port === 'auto')) {
                  _context.next = 11;
                  break;
                }

                _context.next = 10;
                return (0, _processUtils.getAvailablePort)(options.basePort);

              case 10:
                this.port = _context.sent;

              case 11:
                args.push(options.portArg, this.port);

              case 12:
                _context.next = 14;
                return new Promise(function (resolve, reject) {
                  try {
                    var successTimer = setTimeout(function () {
                      if (options.onSuccess) {
                        options.onSuccess(_this);
                      }

                      resolve({});
                    }, options.wait);
                    console.log("Spawning ".concat(options.command, " ").concat(options.arguments.join(' ')));
                    _this.childProcess = _child_process["default"].spawn(options.command, args, options.spawn);

                    _this.childProcess.stderr.on('data', function (data) {
                      console.log("Child process wrote to stderr: \"".concat(data, "\"."));
                      clearTimeout(successTimer);
                      reject(new Error(data));
                    });

                    _this.childProcess.on('error', function (error) {
                      console.log("Child process errored with ".concat(error));
                      clearTimeout(successTimer);
                      reject(error);
                    });

                    _this.childProcess.on('close', function (code) {
                      console.log("Child process exited with ".concat(code));
                      _this.childProcess = null;
                    });
                  } catch (error) {
                    reject(error);
                  }
                });

              case 14:
                return _context.abrupt("return", _context.sent);

              case 15:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function start() {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "stop",
    value: function () {
      var _stop = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee2() {
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (this.childProcess) {
                  this.childProcess.kill();
                  this.childProcess = null;
                }

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function stop() {
        return _stop.apply(this, arguments);
      }

      return stop;
    }()
  }, {
    key: "exit",
    value: function () {
      var _exit = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee3() {
        var statusCode,
            _args3 = arguments;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                statusCode = _args3.length > 0 && _args3[0] !== undefined ? _args3[0] : 0;
                _context3.prev = 1;
                _context3.next = 4;
                return this.stop();

              case 4:
                process.exit(statusCode);
                _context3.next = 11;
                break;

              case 7:
                _context3.prev = 7;
                _context3.t0 = _context3["catch"](1);
                console.error(_context3.t0.message || _context3.t0);
                process.exit(1);

              case 11:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[1, 7]]);
      }));

      function exit() {
        return _exit.apply(this, arguments);
      }

      return exit;
    }()
  }]);
  return ChildProcessProxy;
}();

exports["default"] = ChildProcessProxy;
//# sourceMappingURL=child-process-proxy.js.map