"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _workerPool = _interopRequireDefault(require("./worker-pool"));

var DEFAULT_MAX_CONCURRENCY = 5;

var WorkerFarm = function () {
  (0, _createClass2["default"])(WorkerFarm, null, [{
    key: "isSupported",
    value: function isSupported() {
      return typeof Worker !== 'undefined';
    }
  }]);

  function WorkerFarm(_ref) {
    var _ref$maxConcurrency = _ref.maxConcurrency,
        maxConcurrency = _ref$maxConcurrency === void 0 ? DEFAULT_MAX_CONCURRENCY : _ref$maxConcurrency,
        _ref$onMessage = _ref.onMessage,
        onMessage = _ref$onMessage === void 0 ? null : _ref$onMessage,
        _ref$onDebug = _ref.onDebug,
        onDebug = _ref$onDebug === void 0 ? function () {} : _ref$onDebug,
        _ref$reuseWorkers = _ref.reuseWorkers,
        reuseWorkers = _ref$reuseWorkers === void 0 ? true : _ref$reuseWorkers;
    (0, _classCallCheck2["default"])(this, WorkerFarm);
    this.maxConcurrency = maxConcurrency;
    this.onMessage = onMessage;
    this.onDebug = onDebug;
    this.workerPools = new Map();
    this.reuseWorkers = reuseWorkers;
  }

  (0, _createClass2["default"])(WorkerFarm, [{
    key: "setProps",
    value: function setProps(props) {
      if ('maxConcurrency' in props) {
        this.maxConcurrency = props.maxConcurrency;
      }

      if ('onDebug' in props) {
        this.onDebug = props.onDebug;
      }

      if ('reuseWorkers' in props) {
        this.reuseWorkers = props.reuseWorkers;
      }
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.workerPools.forEach(function (workerPool) {
        return workerPool.destroy();
      });
    }
  }, {
    key: "process",
    value: function () {
      var _process = (0, _asyncToGenerator2["default"])(_regenerator["default"].mark(function _callee(workerSource, workerName, data) {
        var workerPool;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                workerPool = this._getWorkerPool(workerSource, workerName);
                return _context.abrupt("return", workerPool.process(data));

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function process(_x, _x2, _x3) {
        return _process.apply(this, arguments);
      }

      return process;
    }()
  }, {
    key: "_getWorkerPool",
    value: function _getWorkerPool(workerSource, workerName) {
      var workerPool = this.workerPools.get(workerName);

      if (!workerPool) {
        workerPool = new _workerPool["default"]({
          source: workerSource,
          name: workerName,
          onMessage: onWorkerMessage.bind(null, this.onMessage),
          maxConcurrency: this.maxConcurrency,
          onDebug: this.onDebug,
          reuseWorkers: this.reuseWorkers
        });
        this.workerPools.set(workerName, workerPool);
      }

      return workerPool;
    }
  }]);
  return WorkerFarm;
}();

exports["default"] = WorkerFarm;

function onWorkerMessage(onMessage, _ref2) {
  var worker = _ref2.worker,
      data = _ref2.data,
      resolve = _ref2.resolve,
      reject = _ref2.reject;

  if (onMessage) {
    onMessage({
      worker: worker,
      data: data,
      resolve: resolve,
      reject: reject
    });
    return;
  }

  switch (data.type) {
    case 'done':
      resolve(data.result);
      break;

    case 'error':
      reject(data.message);
      break;

    default:
  }
}
//# sourceMappingURL=worker-farm.js.map