import { concatenateArrayBuffers } from '../binary-utils/array-buffer-utils';
import assert from '../env-utils/assert';
export async function forEach(iterator, visitor) {
  while (true) {
    const {
      done,
      value
    } = await iterator.next();

    if (done) {
      iterator.return();
      return;
    }

    const cancel = visitor(value);

    if (cancel) {
      return;
    }
  }
}
export async function concatenateChunksAsync(asyncIterator) {
  const arrayBuffers = [];
  const strings = [];

  for await (const chunk of asyncIterator) {
    if (typeof chunk === 'string') {
      strings.push(chunk);
    } else {
      arrayBuffers.push(chunk);
    }
  }

  if (strings.length > 0) {
    assert(arrayBuffers.length === 0);
    return strings.join('');
  }

  return concatenateArrayBuffers(...arrayBuffers);
}
//# sourceMappingURL=async-iteration.js.map