import Module from 'module';
import path from 'path';
export function requireFromFile(filename) {
  if (filename.startsWith('http')) {
    throw new Error("require from remote script not supported in Node.js: ".concat(filename));
  }

  if (!filename.startsWith('/')) {
    filename = "".concat(process.cwd(), "/").concat(filename);
  }

  return require(filename);
}
export function requireFromString(code, filename = '', options = {}) {
  if (typeof filename === 'object') {
    options = filename;
    filename = '';
  }

  options = {
    appendPaths: [],
    prependPaths: [],
    ...options
  };

  if (typeof code !== 'string') {
    throw new Error("code must be a string, not ".concat(typeof code));
  }

  const paths = Module._nodeModulePaths(path.dirname(filename));

  const parent = module.parent;
  const newModule = new Module(filename, parent);
  newModule.filename = filename;
  newModule.paths = [].concat(options.prependPaths).concat(paths).concat(options.appendPaths);

  newModule._compile(code, filename);

  if (parent && parent.children) {
    parent.children.splice(parent.children.indexOf(newModule), 1);
  }

  return newModule.exports;
}
//# sourceMappingURL=require-utils.node.js.map