import ChildProcess from 'child_process';
export function getAvailablePort(defaultPort = 3000) {
  return new Promise((resolve, reject) => {
    ChildProcess.exec('lsof -i -P -n | grep LISTEN', (error, stdout, stderr) => {
      if (error) {
        resolve(defaultPort);
        return;
      }

      const portsInUse = [];
      const regex = /:(\d+) \(LISTEN\)/;
      stdout.split('\n').forEach(line => {
        const match = line.match(regex);

        if (match) {
          portsInUse.push(Number(match[1]));
        }
      });
      let port = defaultPort;

      while (portsInUse.includes(port)) {
        port++;
      }

      resolve(port);
    });
  });
}
//# sourceMappingURL=process-utils.js.map