import _regeneratorRuntime from "@babel/runtime/regenerator";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import ChildProcess from 'child_process';
import assert from '../env-utils/assert';
import { getAvailablePort } from './process-utils';
var DEFAULT_PROCESS_OPTIONS = {
  command: null,
  arguments: [],
  portArg: null,
  port: 'auto',
  basePort: 5000,
  wait: 2000,
  nodeSpawnOptions: {
    maxBuffer: 5000 * 1024
  },
  onSuccess: function onSuccess(processProxy) {
    console.log("Started ".concat(processProxy.options.command));
  }
};

var ChildProcessProxy = function () {
  function ChildProcessProxy() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$id = _ref.id,
        id = _ref$id === void 0 ? 'browser-driver' : _ref$id;

    _classCallCheck(this, ChildProcessProxy);

    this.id = id;
    this.childProcess = null;
    this.port = null;
  }

  _createClass(ChildProcessProxy, [{
    key: "start",
    value: function () {
      var _start = _asyncToGenerator(_regeneratorRuntime.mark(function _callee() {
        var _this = this;

        var options,
            args,
            _args = arguments;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                options = _args.length > 0 && _args[0] !== undefined ? _args[0] : {};
                options = _objectSpread(_objectSpread({}, DEFAULT_PROCESS_OPTIONS), options);
                assert(options.command && typeof options.command === 'string');
                this.options = options;
                args = _toConsumableArray(options.arguments);
                this.port = options.port;

                if (!options.portArg) {
                  _context.next = 12;
                  break;
                }

                if (!(this.port === 'auto')) {
                  _context.next = 11;
                  break;
                }

                _context.next = 10;
                return getAvailablePort(options.basePort);

              case 10:
                this.port = _context.sent;

              case 11:
                args.push(options.portArg, this.port);

              case 12:
                _context.next = 14;
                return new Promise(function (resolve, reject) {
                  try {
                    var successTimer = setTimeout(function () {
                      if (options.onSuccess) {
                        options.onSuccess(_this);
                      }

                      resolve({});
                    }, options.wait);
                    console.log("Spawning ".concat(options.command, " ").concat(options.arguments.join(' ')));
                    _this.childProcess = ChildProcess.spawn(options.command, args, options.spawn);

                    _this.childProcess.stderr.on('data', function (data) {
                      console.log("Child process wrote to stderr: \"".concat(data, "\"."));
                      clearTimeout(successTimer);
                      reject(new Error(data));
                    });

                    _this.childProcess.on('error', function (error) {
                      console.log("Child process errored with ".concat(error));
                      clearTimeout(successTimer);
                      reject(error);
                    });

                    _this.childProcess.on('close', function (code) {
                      console.log("Child process exited with ".concat(code));
                      _this.childProcess = null;
                    });
                  } catch (error) {
                    reject(error);
                  }
                });

              case 14:
                return _context.abrupt("return", _context.sent);

              case 15:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function start() {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "stop",
    value: function () {
      var _stop = _asyncToGenerator(_regeneratorRuntime.mark(function _callee2() {
        return _regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                if (this.childProcess) {
                  this.childProcess.kill();
                  this.childProcess = null;
                }

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function stop() {
        return _stop.apply(this, arguments);
      }

      return stop;
    }()
  }, {
    key: "exit",
    value: function () {
      var _exit = _asyncToGenerator(_regeneratorRuntime.mark(function _callee3() {
        var statusCode,
            _args3 = arguments;
        return _regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                statusCode = _args3.length > 0 && _args3[0] !== undefined ? _args3[0] : 0;
                _context3.prev = 1;
                _context3.next = 4;
                return this.stop();

              case 4:
                process.exit(statusCode);
                _context3.next = 11;
                break;

              case 7:
                _context3.prev = 7;
                _context3.t0 = _context3["catch"](1);
                console.error(_context3.t0.message || _context3.t0);
                process.exit(1);

              case 11:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[1, 7]]);
      }));

      function exit() {
        return _exit.apply(this, arguments);
      }

      return exit;
    }()
  }]);

  return ChildProcessProxy;
}();

export { ChildProcessProxy as default };
//# sourceMappingURL=child-process-proxy.js.map