import _regeneratorRuntime from "@babel/runtime/regenerator";
import _asyncToGenerator from "@babel/runtime/helpers/esm/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import WorkerThread from './worker-thread';

var WorkerPool = function () {
  function WorkerPool(_ref) {
    var source = _ref.source,
        _ref$name = _ref.name,
        name = _ref$name === void 0 ? 'unnamed' : _ref$name,
        _ref$maxConcurrency = _ref.maxConcurrency,
        maxConcurrency = _ref$maxConcurrency === void 0 ? 1 : _ref$maxConcurrency,
        onMessage = _ref.onMessage,
        _ref$onDebug = _ref.onDebug,
        onDebug = _ref$onDebug === void 0 ? function () {} : _ref$onDebug,
        _ref$reuseWorkers = _ref.reuseWorkers,
        reuseWorkers = _ref$reuseWorkers === void 0 ? true : _ref$reuseWorkers;

    _classCallCheck(this, WorkerPool);

    this.source = source;
    this.name = name;
    this.maxConcurrency = maxConcurrency;
    this.onMessage = onMessage;
    this.onDebug = onDebug;
    this.jobQueue = [];
    this.idleQueue = [];
    this.count = 0;
    this.isDestroyed = false;
    this.reuseWorkers = reuseWorkers;
  }

  _createClass(WorkerPool, [{
    key: "destroy",
    value: function destroy() {
      this.idleQueue.forEach(function (worker) {
        return worker.destroy();
      });
      this.isDestroyed = true;
    }
  }, {
    key: "process",
    value: function process(data, jobName) {
      var _this = this;

      return new Promise(function (resolve, reject) {
        _this.jobQueue.push({
          data: data,
          jobName: jobName,
          resolve: resolve,
          reject: reject
        });

        _this._startQueuedJob();
      });
    }
  }, {
    key: "_startQueuedJob",
    value: function () {
      var _startQueuedJob2 = _asyncToGenerator(_regeneratorRuntime.mark(function _callee() {
        var worker, job;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (this.jobQueue.length) {
                  _context.next = 2;
                  break;
                }

                return _context.abrupt("return");

              case 2:
                worker = this._getAvailableWorker();

                if (worker) {
                  _context.next = 5;
                  break;
                }

                return _context.abrupt("return");

              case 5:
                job = this.jobQueue.shift();
                this.onDebug({
                  message: 'processing',
                  worker: worker.name,
                  job: job.jobName,
                  backlog: this.jobQueue.length
                });
                _context.prev = 7;
                _context.t0 = job;
                _context.next = 11;
                return worker.process(job.data);

              case 11:
                _context.t1 = _context.sent;

                _context.t0.resolve.call(_context.t0, _context.t1);

                _context.next = 18;
                break;

              case 15:
                _context.prev = 15;
                _context.t2 = _context["catch"](7);
                job.reject(_context.t2);

              case 18:
                _context.prev = 18;

                this._onWorkerDone(worker);

                return _context.finish(18);

              case 21:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[7, 15, 18, 21]]);
      }));

      function _startQueuedJob() {
        return _startQueuedJob2.apply(this, arguments);
      }

      return _startQueuedJob;
    }()
  }, {
    key: "_onWorkerDone",
    value: function _onWorkerDone(worker) {
      if (this.isDestroyed) {
        worker.destroy();
        return;
      }

      if (this.reuseWorkers) {
        this.idleQueue.push(worker);
      } else {
        worker.destroy();
        this.count--;
      }

      this._startQueuedJob();
    }
  }, {
    key: "_getAvailableWorker",
    value: function _getAvailableWorker() {
      if (this.idleQueue.length > 0) {
        return this.idleQueue.shift();
      }

      if (this.count < this.maxConcurrency) {
        this.count++;
        var name = "".concat(this.name.toLowerCase(), " (#").concat(this.count, " of ").concat(this.maxConcurrency, ")");
        return new WorkerThread({
          source: this.source,
          onMessage: this.onMessage,
          name: name
        });
      }

      return null;
    }
  }]);

  return WorkerPool;
}();

export { WorkerPool as default };
//# sourceMappingURL=worker-pool.js.map