"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeVertexNormals = computeVertexNormals;
var _core = require("@math.gl/core");
var _constants = require("../constants");
var _assert = require("../utils/assert");
var _primitiveIterator = require("../iterators/primitive-iterator");
var _modes = require("../primitives/modes");
var _getAttributeFromGeometry = require("./get-attribute-from-geometry");
function computeVertexNormals(geometry) {
  (0, _assert.assert)((0, _modes.getPrimitiveModeType)(geometry.mode) === _constants.GL.TRIANGLES, 'TRIANGLES required');
  const {
    values: positions
  } = (0, _getAttributeFromGeometry.getPositions)(geometry);
  const normals = new Float32Array(positions.length);
  const vectorA = new _core.Vector3();
  const vectorB = new _core.Vector3();
  const vectorC = new _core.Vector3();
  const vectorCB = new _core.Vector3();
  const vectorAB = new _core.Vector3();
  for (const primitive of (0, _primitiveIterator.makePrimitiveIterator)(geometry)) {
    vectorA.fromArray(positions, primitive.i1 * 3);
    vectorB.fromArray(positions, primitive.i2 * 3 + 3);
    vectorC.fromArray(positions, primitive.i3 * 3 + 6);
    vectorCB.subVectors(vectorC, vectorB);
    vectorAB.subVectors(vectorA, vectorB);
    const normal = vectorCB.cross(vectorAB);
    normal.normalize();
    const {
      primitiveIndex
    } = primitive;
    normals[primitiveIndex * 9 + 0] = normal.x;
    normals[primitiveIndex * 9 + 1] = normal.y;
    normals[primitiveIndex * 9 + 2] = normal.z;
    normals[primitiveIndex * 9 + 3] = normal.x;
    normals[primitiveIndex * 9 + 4] = normal.y;
    normals[primitiveIndex * 9 + 5] = normal.z;
    normals[primitiveIndex * 9 + 6] = normal.x;
    normals[primitiveIndex * 9 + 7] = normal.y;
    normals[primitiveIndex * 9 + 8] = normal.z;
  }
  return normals;
}
//# sourceMappingURL=compute-vertex-normals.js.map