(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[Object.keys(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __reExport = (target, module, desc) => {
    if (module && typeof module === "object" || typeof module === "function") {
      for (let key of __getOwnPropNames(module))
        if (!__hasOwnProp.call(target, key) && key !== "default")
          __defProp(target, key, { get: () => module[key], enumerable: !(desc = __getOwnPropDesc(module, key)) || desc.enumerable });
    }
    return target;
  };
  var __toModule = (module) => {
    return __reExport(__markAsModule(__defProp(module != null ? __create(__getProtoOf(module)) : {}, "default", module && module.__esModule && "default" in module ? { get: () => module.default, enumerable: true } : { value: module, enumerable: true })), module);
  };

  // ../../node_modules/@babel/runtime/helpers/esm/typeof.js
  var init_typeof = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/typeof.js"() {
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js
  var init_toPrimitive = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPrimitive.js"() {
      init_typeof();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
  var init_toPropertyKey = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/toPropertyKey.js"() {
      init_typeof();
      init_toPrimitive();
    }
  });

  // ../../node_modules/@babel/runtime/helpers/esm/defineProperty.js
  var init_defineProperty = __esm({
    "../../node_modules/@babel/runtime/helpers/esm/defineProperty.js"() {
      init_toPropertyKey();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/polygon-utils.js
  function getPolygonSignedArea(points, options = {}) {
    const {
      start = 0,
      end = points.length
    } = options;
    const dim = options.size || 2;
    let area2 = 0;
    for (let i2 = start, j = end - dim; i2 < end; i2 += dim) {
      area2 += (points[i2] - points[j]) * (points[i2 + 1] + points[j + 1]);
      j = i2;
    }
    return area2 / 2;
  }
  var init_polygon_utils = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/polygon-utils.js"() {
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/polygon.js
  var init_polygon = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/polygon.js"() {
      init_defineProperty();
      init_polygon_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/earcut.js
  function earcut(positions, holeIndices, dim = 2, areas) {
    const hasHoles = holeIndices && holeIndices.length;
    const outerLen = hasHoles ? holeIndices[0] * dim : positions.length;
    let outerNode = linkedList(positions, 0, outerLen, dim, true, areas && areas[0]);
    const triangles = [];
    if (!outerNode || outerNode.next === outerNode.prev)
      return triangles;
    let invSize;
    let maxX;
    let maxY;
    let minX;
    let minY;
    let x2;
    let y2;
    if (hasHoles)
      outerNode = eliminateHoles(positions, holeIndices, outerNode, dim, areas);
    if (positions.length > 80 * dim) {
      minX = maxX = positions[0];
      minY = maxY = positions[1];
      for (let i2 = dim; i2 < outerLen; i2 += dim) {
        x2 = positions[i2];
        y2 = positions[i2 + 1];
        if (x2 < minX)
          minX = x2;
        if (y2 < minY)
          minY = y2;
        if (x2 > maxX)
          maxX = x2;
        if (y2 > maxY)
          maxY = y2;
      }
      invSize = Math.max(maxX - minX, maxY - minY);
      invSize = invSize !== 0 ? 1 / invSize : 0;
    }
    earcutLinked(outerNode, triangles, dim, minX, minY, invSize);
    return triangles;
  }
  function linkedList(data, start, end, dim, clockwise, area2) {
    let i2;
    let last;
    if (area2 === void 0) {
      area2 = getPolygonSignedArea(data, {
        start,
        end,
        size: dim
      });
    }
    if (clockwise === area2 < 0) {
      for (i2 = start; i2 < end; i2 += dim)
        last = insertNode(i2, data[i2], data[i2 + 1], last);
    } else {
      for (i2 = end - dim; i2 >= start; i2 -= dim)
        last = insertNode(i2, data[i2], data[i2 + 1], last);
    }
    if (last && equals(last, last.next)) {
      removeNode(last);
      last = last.next;
    }
    return last;
  }
  function filterPoints(start, end) {
    if (!start)
      return start;
    if (!end)
      end = start;
    let p = start;
    let again;
    do {
      again = false;
      if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
        removeNode(p);
        p = end = p.prev;
        if (p === p.next)
          break;
        again = true;
      } else {
        p = p.next;
      }
    } while (again || p !== end);
    return end;
  }
  function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
    if (!ear)
      return;
    if (!pass && invSize)
      indexCurve(ear, minX, minY, invSize);
    let stop = ear;
    let prev;
    let next;
    while (ear.prev !== ear.next) {
      prev = ear.prev;
      next = ear.next;
      if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
        triangles.push(prev.i / dim);
        triangles.push(ear.i / dim);
        triangles.push(next.i / dim);
        removeNode(ear);
        ear = next.next;
        stop = next.next;
        continue;
      }
      ear = next;
      if (ear === stop) {
        if (!pass) {
          earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);
        } else if (pass === 1) {
          ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
          earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
        } else if (pass === 2) {
          splitEarcut(ear, triangles, dim, minX, minY, invSize);
        }
        break;
      }
    }
  }
  function isEar(ear) {
    const a = ear.prev;
    const b = ear;
    const c = ear.next;
    if (area(a, b, c) >= 0)
      return false;
    let p = ear.next.next;
    while (p !== ear.prev) {
      if (pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0)
        return false;
      p = p.next;
    }
    return true;
  }
  function isEarHashed(ear, minX, minY, invSize) {
    const a = ear.prev;
    const b = ear;
    const c = ear.next;
    if (area(a, b, c) >= 0)
      return false;
    const minTX = a.x < b.x ? a.x < c.x ? a.x : c.x : b.x < c.x ? b.x : c.x;
    const minTY = a.y < b.y ? a.y < c.y ? a.y : c.y : b.y < c.y ? b.y : c.y;
    const maxTX = a.x > b.x ? a.x > c.x ? a.x : c.x : b.x > c.x ? b.x : c.x;
    const maxTY = a.y > b.y ? a.y > c.y ? a.y : c.y : b.y > c.y ? b.y : c.y;
    const minZ = zOrder(minTX, minTY, minX, minY, invSize);
    const maxZ = zOrder(maxTX, maxTY, minX, minY, invSize);
    let p = ear.prevZ;
    let n = ear.nextZ;
    while (p && p.z >= minZ && n && n.z <= maxZ) {
      if (p !== ear.prev && p !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0)
        return false;
      p = p.prevZ;
      if (n !== ear.prev && n !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && area(n.prev, n, n.next) >= 0)
        return false;
      n = n.nextZ;
    }
    while (p && p.z >= minZ) {
      if (p !== ear.prev && p !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0)
        return false;
      p = p.prevZ;
    }
    while (n && n.z <= maxZ) {
      if (n !== ear.prev && n !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && area(n.prev, n, n.next) >= 0)
        return false;
      n = n.nextZ;
    }
    return true;
  }
  function cureLocalIntersections(start, triangles, dim) {
    let p = start;
    do {
      const a = p.prev;
      const b = p.next.next;
      if (!equals(a, b) && intersects(a, p, p.next, b) && locallyInside(a, b) && locallyInside(b, a)) {
        triangles.push(a.i / dim);
        triangles.push(p.i / dim);
        triangles.push(b.i / dim);
        removeNode(p);
        removeNode(p.next);
        p = start = b;
      }
      p = p.next;
    } while (p !== start);
    return filterPoints(p);
  }
  function splitEarcut(start, triangles, dim, minX, minY, invSize) {
    let a = start;
    do {
      let b = a.next.next;
      while (b !== a.prev) {
        if (a.i !== b.i && isValidDiagonal(a, b)) {
          let c = splitPolygon(a, b);
          a = filterPoints(a, a.next);
          c = filterPoints(c, c.next);
          earcutLinked(a, triangles, dim, minX, minY, invSize);
          earcutLinked(c, triangles, dim, minX, minY, invSize);
          return;
        }
        b = b.next;
      }
      a = a.next;
    } while (a !== start);
  }
  function eliminateHoles(data, holeIndices, outerNode, dim, areas) {
    const queue = [];
    let i2;
    let len;
    let start;
    let end;
    let list;
    for (i2 = 0, len = holeIndices.length; i2 < len; i2++) {
      start = holeIndices[i2] * dim;
      end = i2 < len - 1 ? holeIndices[i2 + 1] * dim : data.length;
      list = linkedList(data, start, end, dim, false, areas && areas[i2 + 1]);
      if (list === list.next)
        list.steiner = true;
      queue.push(getLeftmost(list));
    }
    queue.sort(compareX);
    for (i2 = 0; i2 < queue.length; i2++) {
      eliminateHole(queue[i2], outerNode);
      outerNode = filterPoints(outerNode, outerNode.next);
    }
    return outerNode;
  }
  function compareX(a, b) {
    return a.x - b.x;
  }
  function eliminateHole(hole, outerNode) {
    outerNode = findHoleBridge(hole, outerNode);
    if (outerNode) {
      const b = splitPolygon(outerNode, hole);
      filterPoints(outerNode, outerNode.next);
      filterPoints(b, b.next);
    }
  }
  function findHoleBridge(hole, outerNode) {
    let p = outerNode;
    const hx = hole.x;
    const hy = hole.y;
    let qx = -Infinity;
    let m;
    do {
      if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
        const x2 = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
        if (x2 <= hx && x2 > qx) {
          qx = x2;
          if (x2 === hx) {
            if (hy === p.y)
              return p;
            if (hy === p.next.y)
              return p.next;
          }
          m = p.x < p.next.x ? p : p.next;
        }
      }
      p = p.next;
    } while (p !== outerNode);
    if (!m)
      return null;
    if (hx === qx)
      return m;
    const stop = m;
    const mx = m.x;
    const my = m.y;
    let tanMin = Infinity;
    let tan;
    p = m;
    do {
      if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
        tan = Math.abs(hy - p.y) / (hx - p.x);
        if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {
          m = p;
          tanMin = tan;
        }
      }
      p = p.next;
    } while (p !== stop);
    return m;
  }
  function sectorContainsSector(m, p) {
    return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
  }
  function indexCurve(start, minX, minY, invSize) {
    let p = start;
    do {
      if (p.z === null)
        p.z = zOrder(p.x, p.y, minX, minY, invSize);
      p.prevZ = p.prev;
      p.nextZ = p.next;
      p = p.next;
    } while (p !== start);
    p.prevZ.nextZ = null;
    p.prevZ = null;
    sortLinked(p);
  }
  function sortLinked(list) {
    let e;
    let i2;
    let inSize = 1;
    let numMerges;
    let p;
    let pSize;
    let q;
    let qSize;
    let tail;
    do {
      p = list;
      list = null;
      tail = null;
      numMerges = 0;
      while (p) {
        numMerges++;
        q = p;
        pSize = 0;
        for (i2 = 0; i2 < inSize; i2++) {
          pSize++;
          q = q.nextZ;
          if (!q)
            break;
        }
        qSize = inSize;
        while (pSize > 0 || qSize > 0 && q) {
          if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
            e = p;
            p = p.nextZ;
            pSize--;
          } else {
            e = q;
            q = q.nextZ;
            qSize--;
          }
          if (tail)
            tail.nextZ = e;
          else
            list = e;
          e.prevZ = tail;
          tail = e;
        }
        p = q;
      }
      tail.nextZ = null;
      inSize *= 2;
    } while (numMerges > 1);
    return list;
  }
  function zOrder(x2, y2, minX, minY, invSize) {
    x2 = 32767 * (x2 - minX) * invSize;
    y2 = 32767 * (y2 - minY) * invSize;
    x2 = (x2 | x2 << 8) & 16711935;
    x2 = (x2 | x2 << 4) & 252645135;
    x2 = (x2 | x2 << 2) & 858993459;
    x2 = (x2 | x2 << 1) & 1431655765;
    y2 = (y2 | y2 << 8) & 16711935;
    y2 = (y2 | y2 << 4) & 252645135;
    y2 = (y2 | y2 << 2) & 858993459;
    y2 = (y2 | y2 << 1) & 1431655765;
    return x2 | y2 << 1;
  }
  function getLeftmost(start) {
    let p = start;
    let leftmost = start;
    do {
      if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y)
        leftmost = p;
      p = p.next;
    } while (p !== start);
    return leftmost;
  }
  function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
    return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0 && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0 && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0;
  }
  function isValidDiagonal(a, b) {
    return a.next.i !== b.i && a.prev.i !== b.i && !intersectsPolygon(a, b) && (locallyInside(a, b) && locallyInside(b, a) && middleInside(a, b) && (area(a.prev, a, b.prev) || area(a, b.prev, b)) || equals(a, b) && area(a.prev, a, a.next) > 0 && area(b.prev, b, b.next) > 0);
  }
  function area(p, q, r) {
    return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
  }
  function equals(p1, p2) {
    return p1.x === p2.x && p1.y === p2.y;
  }
  function intersects(p1, q1, p2, q2) {
    const o1 = sign(area(p1, q1, p2));
    const o2 = sign(area(p1, q1, q2));
    const o3 = sign(area(p2, q2, p1));
    const o4 = sign(area(p2, q2, q1));
    if (o1 !== o2 && o3 !== o4)
      return true;
    if (o1 === 0 && onSegment(p1, p2, q1))
      return true;
    if (o2 === 0 && onSegment(p1, q2, q1))
      return true;
    if (o3 === 0 && onSegment(p2, p1, q2))
      return true;
    if (o4 === 0 && onSegment(p2, q1, q2))
      return true;
    return false;
  }
  function onSegment(p, q, r) {
    return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
  }
  function sign(num) {
    return num > 0 ? 1 : num < 0 ? -1 : 0;
  }
  function intersectsPolygon(a, b) {
    let p = a;
    do {
      if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a, b))
        return true;
      p = p.next;
    } while (p !== a);
    return false;
  }
  function locallyInside(a, b) {
    return area(a.prev, a, a.next) < 0 ? area(a, b, a.next) >= 0 && area(a, a.prev, b) >= 0 : area(a, b, a.prev) < 0 || area(a, a.next, b) < 0;
  }
  function middleInside(a, b) {
    let p = a;
    let inside = false;
    const px = (a.x + b.x) / 2;
    const py = (a.y + b.y) / 2;
    do {
      if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)
        inside = !inside;
      p = p.next;
    } while (p !== a);
    return inside;
  }
  function splitPolygon(a, b) {
    const a2 = new Node(a.i, a.x, a.y);
    const b2 = new Node(b.i, b.x, b.y);
    const an = a.next;
    const bp = b.prev;
    a.next = b;
    b.prev = a;
    a2.next = an;
    an.prev = a2;
    b2.next = a2;
    a2.prev = b2;
    bp.next = b2;
    b2.prev = bp;
    return b2;
  }
  function insertNode(i2, x2, y2, last) {
    const p = new Node(i2, x2, y2);
    if (!last) {
      p.prev = p;
      p.next = p;
    } else {
      p.next = last.next;
      p.prev = last;
      last.next.prev = p;
      last.next = p;
    }
    return p;
  }
  function removeNode(p) {
    p.next.prev = p.prev;
    p.prev.next = p.next;
    if (p.prevZ)
      p.prevZ.nextZ = p.nextZ;
    if (p.nextZ)
      p.nextZ.prevZ = p.prevZ;
  }
  function Node(i2, x2, y2) {
    this.i = i2;
    this.x = x2;
    this.y = y2;
    this.prev = null;
    this.next = null;
    this.z = null;
    this.prevZ = null;
    this.nextZ = null;
    this.steiner = false;
  }
  var init_earcut = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/earcut.js"() {
      init_polygon_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/utils.js
  var init_utils = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/utils.js"() {
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/lineclip.js
  var init_lineclip = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/lineclip.js"() {
      init_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js
  var init_cut_by_grid = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js"() {
      init_lineclip();
      init_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js
  var init_cut_by_mercator_bounds = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js"() {
      init_cut_by_grid();
      init_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/index.js
  var init_esm = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/index.js"() {
      init_polygon();
      init_polygon_utils();
      init_earcut();
      init_lineclip();
      init_cut_by_grid();
      init_cut_by_mercator_bounds();
      init_polygon();
    }
  });

  // ../gis/src/lib/flat-geojson-to-binary.ts
  function flatGeojsonToBinary(features, geometryInfo, options) {
    const propArrayTypes = extractNumericPropTypes(features);
    const numericPropKeys = Object.keys(propArrayTypes).filter((k) => propArrayTypes[k] !== Array);
    return fillArrays(features, {
      propArrayTypes,
      ...geometryInfo
    }, {
      numericPropKeys: options && options.numericPropKeys || numericPropKeys,
      PositionDataType: options ? options.PositionDataType : Float32Array,
      triangulate: options ? options.triangulate : true
    });
  }
  function extractNumericPropTypes(features) {
    const propArrayTypes = {};
    for (const feature of features) {
      if (feature.properties) {
        for (const key in feature.properties) {
          const val = feature.properties[key];
          propArrayTypes[key] = deduceArrayType(val, propArrayTypes[key]);
        }
      }
    }
    return propArrayTypes;
  }
  function fillArrays(features, geometryInfo, options) {
    const {
      pointPositionsCount,
      pointFeaturesCount,
      linePositionsCount,
      linePathsCount,
      lineFeaturesCount,
      polygonPositionsCount,
      polygonObjectsCount,
      polygonRingsCount,
      polygonFeaturesCount,
      propArrayTypes,
      coordLength
    } = geometryInfo;
    const { numericPropKeys = [], PositionDataType = Float32Array, triangulate = true } = options;
    const hasGlobalId = features[0] && "id" in features[0];
    const GlobalFeatureIdsDataType = features.length > 65535 ? Uint32Array : Uint16Array;
    const points = {
      type: "Point",
      positions: new PositionDataType(pointPositionsCount * coordLength),
      globalFeatureIds: new GlobalFeatureIdsDataType(pointPositionsCount),
      featureIds: pointFeaturesCount > 65535 ? new Uint32Array(pointPositionsCount) : new Uint16Array(pointPositionsCount),
      numericProps: {},
      properties: [],
      fields: []
    };
    const lines = {
      type: "LineString",
      pathIndices: linePositionsCount > 65535 ? new Uint32Array(linePathsCount + 1) : new Uint16Array(linePathsCount + 1),
      positions: new PositionDataType(linePositionsCount * coordLength),
      globalFeatureIds: new GlobalFeatureIdsDataType(linePositionsCount),
      featureIds: lineFeaturesCount > 65535 ? new Uint32Array(linePositionsCount) : new Uint16Array(linePositionsCount),
      numericProps: {},
      properties: [],
      fields: []
    };
    const polygons = {
      type: "Polygon",
      polygonIndices: polygonPositionsCount > 65535 ? new Uint32Array(polygonObjectsCount + 1) : new Uint16Array(polygonObjectsCount + 1),
      primitivePolygonIndices: polygonPositionsCount > 65535 ? new Uint32Array(polygonRingsCount + 1) : new Uint16Array(polygonRingsCount + 1),
      positions: new PositionDataType(polygonPositionsCount * coordLength),
      globalFeatureIds: new GlobalFeatureIdsDataType(polygonPositionsCount),
      featureIds: polygonFeaturesCount > 65535 ? new Uint32Array(polygonPositionsCount) : new Uint16Array(polygonPositionsCount),
      numericProps: {},
      properties: [],
      fields: []
    };
    if (triangulate) {
      polygons.triangles = [];
    }
    for (const object of [points, lines, polygons]) {
      for (const propName of numericPropKeys) {
        const T = propArrayTypes[propName];
        object.numericProps[propName] = new T(object.positions.length / coordLength);
      }
    }
    lines.pathIndices[linePathsCount] = linePositionsCount;
    polygons.polygonIndices[polygonObjectsCount] = polygonPositionsCount;
    polygons.primitivePolygonIndices[polygonRingsCount] = polygonPositionsCount;
    const indexMap = {
      pointPosition: 0,
      pointFeature: 0,
      linePosition: 0,
      linePath: 0,
      lineFeature: 0,
      polygonPosition: 0,
      polygonObject: 0,
      polygonRing: 0,
      polygonFeature: 0,
      feature: 0
    };
    for (const feature of features) {
      const geometry = feature.geometry;
      const properties = feature.properties || {};
      switch (geometry.type) {
        case "Point":
          handlePoint(geometry, points, indexMap, coordLength, properties);
          points.properties.push(keepStringProperties(properties, numericPropKeys));
          if (hasGlobalId) {
            points.fields.push({ id: feature.id });
          }
          indexMap.pointFeature++;
          break;
        case "LineString":
          handleLineString(geometry, lines, indexMap, coordLength, properties);
          lines.properties.push(keepStringProperties(properties, numericPropKeys));
          if (hasGlobalId) {
            lines.fields.push({ id: feature.id });
          }
          indexMap.lineFeature++;
          break;
        case "Polygon":
          handlePolygon(geometry, polygons, indexMap, coordLength, properties);
          polygons.properties.push(keepStringProperties(properties, numericPropKeys));
          if (hasGlobalId) {
            polygons.fields.push({ id: feature.id });
          }
          indexMap.polygonFeature++;
          break;
        default:
          throw new Error("Invalid geometry type");
      }
      indexMap.feature++;
    }
    return makeAccessorObjects(points, lines, polygons, coordLength);
  }
  function handlePoint(geometry, points, indexMap, coordLength, properties) {
    points.positions.set(geometry.data, indexMap.pointPosition * coordLength);
    const nPositions = geometry.data.length / coordLength;
    fillNumericProperties(points, properties, indexMap.pointPosition, nPositions);
    points.globalFeatureIds.fill(indexMap.feature, indexMap.pointPosition, indexMap.pointPosition + nPositions);
    points.featureIds.fill(indexMap.pointFeature, indexMap.pointPosition, indexMap.pointPosition + nPositions);
    indexMap.pointPosition += nPositions;
  }
  function handleLineString(geometry, lines, indexMap, coordLength, properties) {
    lines.positions.set(geometry.data, indexMap.linePosition * coordLength);
    const nPositions = geometry.data.length / coordLength;
    fillNumericProperties(lines, properties, indexMap.linePosition, nPositions);
    lines.globalFeatureIds.fill(indexMap.feature, indexMap.linePosition, indexMap.linePosition + nPositions);
    lines.featureIds.fill(indexMap.lineFeature, indexMap.linePosition, indexMap.linePosition + nPositions);
    for (let i2 = 0, il = geometry.indices.length; i2 < il; ++i2) {
      const start = geometry.indices[i2];
      const end = i2 === il - 1 ? geometry.data.length : geometry.indices[i2 + 1];
      lines.pathIndices[indexMap.linePath++] = indexMap.linePosition;
      indexMap.linePosition += (end - start) / coordLength;
    }
  }
  function handlePolygon(geometry, polygons, indexMap, coordLength, properties) {
    polygons.positions.set(geometry.data, indexMap.polygonPosition * coordLength);
    const nPositions = geometry.data.length / coordLength;
    fillNumericProperties(polygons, properties, indexMap.polygonPosition, nPositions);
    polygons.globalFeatureIds.fill(indexMap.feature, indexMap.polygonPosition, indexMap.polygonPosition + nPositions);
    polygons.featureIds.fill(indexMap.polygonFeature, indexMap.polygonPosition, indexMap.polygonPosition + nPositions);
    for (let l = 0, ll = geometry.indices.length; l < ll; ++l) {
      const startPosition = indexMap.polygonPosition;
      polygons.polygonIndices[indexMap.polygonObject++] = startPosition;
      const areas = geometry.areas[l];
      const indices = geometry.indices[l];
      const nextIndices = geometry.indices[l + 1];
      for (let i2 = 0, il = indices.length; i2 < il; ++i2) {
        const start = indices[i2];
        const end = i2 === il - 1 ? nextIndices === void 0 ? geometry.data.length : nextIndices[0] : indices[i2 + 1];
        polygons.primitivePolygonIndices[indexMap.polygonRing++] = indexMap.polygonPosition;
        indexMap.polygonPosition += (end - start) / coordLength;
      }
      const endPosition = indexMap.polygonPosition;
      triangulatePolygon(polygons, areas, indices, { startPosition, endPosition, coordLength });
    }
  }
  function triangulatePolygon(polygons, areas, indices, {
    startPosition,
    endPosition,
    coordLength
  }) {
    if (!polygons.triangles) {
      return;
    }
    const start = startPosition * coordLength;
    const end = endPosition * coordLength;
    const polygonPositions = polygons.positions.subarray(start, end);
    const offset = indices[0];
    const holes = indices.slice(1).map((n) => (n - offset) / coordLength);
    const triangles = earcut(polygonPositions, holes, coordLength, areas);
    for (let t = 0, tl = triangles.length; t < tl; ++t) {
      polygons.triangles.push(startPosition + triangles[t]);
    }
  }
  function wrapProps(obj, size) {
    const returnObj = {};
    for (const key in obj) {
      returnObj[key] = { value: obj[key], size };
    }
    return returnObj;
  }
  function makeAccessorObjects(points, lines, polygons, coordLength) {
    const binaryFeatures = {
      points: {
        ...points,
        positions: { value: points.positions, size: coordLength },
        globalFeatureIds: { value: points.globalFeatureIds, size: 1 },
        featureIds: { value: points.featureIds, size: 1 },
        numericProps: wrapProps(points.numericProps, 1)
      },
      lines: {
        ...lines,
        positions: { value: lines.positions, size: coordLength },
        pathIndices: { value: lines.pathIndices, size: 1 },
        globalFeatureIds: { value: lines.globalFeatureIds, size: 1 },
        featureIds: { value: lines.featureIds, size: 1 },
        numericProps: wrapProps(lines.numericProps, 1)
      },
      polygons: {
        ...polygons,
        positions: { value: polygons.positions, size: coordLength },
        polygonIndices: { value: polygons.polygonIndices, size: 1 },
        primitivePolygonIndices: { value: polygons.primitivePolygonIndices, size: 1 },
        globalFeatureIds: { value: polygons.globalFeatureIds, size: 1 },
        featureIds: { value: polygons.featureIds, size: 1 },
        numericProps: wrapProps(polygons.numericProps, 1)
      }
    };
    if (polygons.triangles) {
      binaryFeatures.polygons.triangles = { value: new Uint32Array(polygons.triangles), size: 1 };
    }
    return binaryFeatures;
  }
  function fillNumericProperties(object, properties, index, length2) {
    for (const numericPropName in object.numericProps) {
      if (numericPropName in properties) {
        const value = properties[numericPropName];
        object.numericProps[numericPropName].fill(value, index, index + length2);
      }
    }
  }
  function keepStringProperties(properties, numericKeys) {
    const props = {};
    for (const key in properties) {
      if (!numericKeys.includes(key)) {
        props[key] = properties[key];
      }
    }
    return props;
  }
  function deduceArrayType(x2, constructor) {
    if (constructor === Array || !Number.isFinite(x2)) {
      return Array;
    }
    return constructor === Float64Array || Math.fround(x2) !== x2 ? Float64Array : Float32Array;
  }
  var init_flat_geojson_to_binary = __esm({
    "../gis/src/lib/flat-geojson-to-binary.ts"() {
      init_esm();
    }
  });

  // ../gis/src/index.ts
  var init_src = __esm({
    "../gis/src/index.ts"() {
      init_flat_geojson_to_binary();
    }
  });

  // ../../node_modules/ieee754/index.js
  var require_ieee754 = __commonJS({
    "../../node_modules/ieee754/index.js"(exports) {
      exports.read = function(buffer, offset, isLE, mLen, nBytes) {
        var e, m;
        var eLen = nBytes * 8 - mLen - 1;
        var eMax = (1 << eLen) - 1;
        var eBias = eMax >> 1;
        var nBits = -7;
        var i2 = isLE ? nBytes - 1 : 0;
        var d = isLE ? -1 : 1;
        var s = buffer[offset + i2];
        i2 += d;
        e = s & (1 << -nBits) - 1;
        s >>= -nBits;
        nBits += eLen;
        for (; nBits > 0; e = e * 256 + buffer[offset + i2], i2 += d, nBits -= 8) {
        }
        m = e & (1 << -nBits) - 1;
        e >>= -nBits;
        nBits += mLen;
        for (; nBits > 0; m = m * 256 + buffer[offset + i2], i2 += d, nBits -= 8) {
        }
        if (e === 0) {
          e = 1 - eBias;
        } else if (e === eMax) {
          return m ? NaN : (s ? -1 : 1) * Infinity;
        } else {
          m = m + Math.pow(2, mLen);
          e = e - eBias;
        }
        return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
      };
      exports.write = function(buffer, value, offset, isLE, mLen, nBytes) {
        var e, m, c;
        var eLen = nBytes * 8 - mLen - 1;
        var eMax = (1 << eLen) - 1;
        var eBias = eMax >> 1;
        var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
        var i2 = isLE ? 0 : nBytes - 1;
        var d = isLE ? 1 : -1;
        var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
        value = Math.abs(value);
        if (isNaN(value) || value === Infinity) {
          m = isNaN(value) ? 1 : 0;
          e = eMax;
        } else {
          e = Math.floor(Math.log(value) / Math.LN2);
          if (value * (c = Math.pow(2, -e)) < 1) {
            e--;
            c *= 2;
          }
          if (e + eBias >= 1) {
            value += rt / c;
          } else {
            value += rt * Math.pow(2, 1 - eBias);
          }
          if (value * c >= 2) {
            e++;
            c /= 2;
          }
          if (e + eBias >= eMax) {
            m = 0;
            e = eMax;
          } else if (e + eBias >= 1) {
            m = (value * c - 1) * Math.pow(2, mLen);
            e = e + eBias;
          } else {
            m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
            e = 0;
          }
        }
        for (; mLen >= 8; buffer[offset + i2] = m & 255, i2 += d, m /= 256, mLen -= 8) {
        }
        e = e << mLen | m;
        eLen += mLen;
        for (; eLen > 0; buffer[offset + i2] = e & 255, i2 += d, e /= 256, eLen -= 8) {
        }
        buffer[offset + i2 - d] |= s * 128;
      };
    }
  });

  // ../../node_modules/pbf/index.js
  var require_pbf = __commonJS({
    "../../node_modules/pbf/index.js"(exports, module) {
      "use strict";
      module.exports = Pbf;
      var ieee754 = require_ieee754();
      function Pbf(buf) {
        this.buf = ArrayBuffer.isView && ArrayBuffer.isView(buf) ? buf : new Uint8Array(buf || 0);
        this.pos = 0;
        this.type = 0;
        this.length = this.buf.length;
      }
      Pbf.Varint = 0;
      Pbf.Fixed64 = 1;
      Pbf.Bytes = 2;
      Pbf.Fixed32 = 5;
      var SHIFT_LEFT_32 = (1 << 16) * (1 << 16);
      var SHIFT_RIGHT_32 = 1 / SHIFT_LEFT_32;
      var TEXT_DECODER_MIN_LENGTH = 12;
      var utf8TextDecoder = typeof TextDecoder === "undefined" ? null : new TextDecoder("utf8");
      Pbf.prototype = {
        destroy: function() {
          this.buf = null;
        },
        readFields: function(readField, result, end) {
          end = end || this.length;
          while (this.pos < end) {
            var val = this.readVarint(), tag = val >> 3, startPos = this.pos;
            this.type = val & 7;
            readField(tag, result, this);
            if (this.pos === startPos)
              this.skip(val);
          }
          return result;
        },
        readMessage: function(readField, result) {
          return this.readFields(readField, result, this.readVarint() + this.pos);
        },
        readFixed32: function() {
          var val = readUInt32(this.buf, this.pos);
          this.pos += 4;
          return val;
        },
        readSFixed32: function() {
          var val = readInt32(this.buf, this.pos);
          this.pos += 4;
          return val;
        },
        readFixed64: function() {
          var val = readUInt32(this.buf, this.pos) + readUInt32(this.buf, this.pos + 4) * SHIFT_LEFT_32;
          this.pos += 8;
          return val;
        },
        readSFixed64: function() {
          var val = readUInt32(this.buf, this.pos) + readInt32(this.buf, this.pos + 4) * SHIFT_LEFT_32;
          this.pos += 8;
          return val;
        },
        readFloat: function() {
          var val = ieee754.read(this.buf, this.pos, true, 23, 4);
          this.pos += 4;
          return val;
        },
        readDouble: function() {
          var val = ieee754.read(this.buf, this.pos, true, 52, 8);
          this.pos += 8;
          return val;
        },
        readVarint: function(isSigned) {
          var buf = this.buf, val, b;
          b = buf[this.pos++];
          val = b & 127;
          if (b < 128)
            return val;
          b = buf[this.pos++];
          val |= (b & 127) << 7;
          if (b < 128)
            return val;
          b = buf[this.pos++];
          val |= (b & 127) << 14;
          if (b < 128)
            return val;
          b = buf[this.pos++];
          val |= (b & 127) << 21;
          if (b < 128)
            return val;
          b = buf[this.pos];
          val |= (b & 15) << 28;
          return readVarintRemainder(val, isSigned, this);
        },
        readVarint64: function() {
          return this.readVarint(true);
        },
        readSVarint: function() {
          var num = this.readVarint();
          return num % 2 === 1 ? (num + 1) / -2 : num / 2;
        },
        readBoolean: function() {
          return Boolean(this.readVarint());
        },
        readString: function() {
          var end = this.readVarint() + this.pos;
          var pos = this.pos;
          this.pos = end;
          if (end - pos >= TEXT_DECODER_MIN_LENGTH && utf8TextDecoder) {
            return readUtf8TextDecoder(this.buf, pos, end);
          }
          return readUtf8(this.buf, pos, end);
        },
        readBytes: function() {
          var end = this.readVarint() + this.pos, buffer = this.buf.subarray(this.pos, end);
          this.pos = end;
          return buffer;
        },
        readPackedVarint: function(arr, isSigned) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readVarint(isSigned));
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readVarint(isSigned));
          return arr;
        },
        readPackedSVarint: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readSVarint());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readSVarint());
          return arr;
        },
        readPackedBoolean: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readBoolean());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readBoolean());
          return arr;
        },
        readPackedFloat: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readFloat());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readFloat());
          return arr;
        },
        readPackedDouble: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readDouble());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readDouble());
          return arr;
        },
        readPackedFixed32: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readFixed32());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readFixed32());
          return arr;
        },
        readPackedSFixed32: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readSFixed32());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readSFixed32());
          return arr;
        },
        readPackedFixed64: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readFixed64());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readFixed64());
          return arr;
        },
        readPackedSFixed64: function(arr) {
          if (this.type !== Pbf.Bytes)
            return arr.push(this.readSFixed64());
          var end = readPackedEnd(this);
          arr = arr || [];
          while (this.pos < end)
            arr.push(this.readSFixed64());
          return arr;
        },
        skip: function(val) {
          var type = val & 7;
          if (type === Pbf.Varint)
            while (this.buf[this.pos++] > 127) {
            }
          else if (type === Pbf.Bytes)
            this.pos = this.readVarint() + this.pos;
          else if (type === Pbf.Fixed32)
            this.pos += 4;
          else if (type === Pbf.Fixed64)
            this.pos += 8;
          else
            throw new Error("Unimplemented type: " + type);
        },
        writeTag: function(tag, type) {
          this.writeVarint(tag << 3 | type);
        },
        realloc: function(min) {
          var length2 = this.length || 16;
          while (length2 < this.pos + min)
            length2 *= 2;
          if (length2 !== this.length) {
            var buf = new Uint8Array(length2);
            buf.set(this.buf);
            this.buf = buf;
            this.length = length2;
          }
        },
        finish: function() {
          this.length = this.pos;
          this.pos = 0;
          return this.buf.subarray(0, this.length);
        },
        writeFixed32: function(val) {
          this.realloc(4);
          writeInt32(this.buf, val, this.pos);
          this.pos += 4;
        },
        writeSFixed32: function(val) {
          this.realloc(4);
          writeInt32(this.buf, val, this.pos);
          this.pos += 4;
        },
        writeFixed64: function(val) {
          this.realloc(8);
          writeInt32(this.buf, val & -1, this.pos);
          writeInt32(this.buf, Math.floor(val * SHIFT_RIGHT_32), this.pos + 4);
          this.pos += 8;
        },
        writeSFixed64: function(val) {
          this.realloc(8);
          writeInt32(this.buf, val & -1, this.pos);
          writeInt32(this.buf, Math.floor(val * SHIFT_RIGHT_32), this.pos + 4);
          this.pos += 8;
        },
        writeVarint: function(val) {
          val = +val || 0;
          if (val > 268435455 || val < 0) {
            writeBigVarint(val, this);
            return;
          }
          this.realloc(4);
          this.buf[this.pos++] = val & 127 | (val > 127 ? 128 : 0);
          if (val <= 127)
            return;
          this.buf[this.pos++] = (val >>>= 7) & 127 | (val > 127 ? 128 : 0);
          if (val <= 127)
            return;
          this.buf[this.pos++] = (val >>>= 7) & 127 | (val > 127 ? 128 : 0);
          if (val <= 127)
            return;
          this.buf[this.pos++] = val >>> 7 & 127;
        },
        writeSVarint: function(val) {
          this.writeVarint(val < 0 ? -val * 2 - 1 : val * 2);
        },
        writeBoolean: function(val) {
          this.writeVarint(Boolean(val));
        },
        writeString: function(str) {
          str = String(str);
          this.realloc(str.length * 4);
          this.pos++;
          var startPos = this.pos;
          this.pos = writeUtf8(this.buf, str, this.pos);
          var len = this.pos - startPos;
          if (len >= 128)
            makeRoomForExtraLength(startPos, len, this);
          this.pos = startPos - 1;
          this.writeVarint(len);
          this.pos += len;
        },
        writeFloat: function(val) {
          this.realloc(4);
          ieee754.write(this.buf, val, this.pos, true, 23, 4);
          this.pos += 4;
        },
        writeDouble: function(val) {
          this.realloc(8);
          ieee754.write(this.buf, val, this.pos, true, 52, 8);
          this.pos += 8;
        },
        writeBytes: function(buffer) {
          var len = buffer.length;
          this.writeVarint(len);
          this.realloc(len);
          for (var i2 = 0; i2 < len; i2++)
            this.buf[this.pos++] = buffer[i2];
        },
        writeRawMessage: function(fn, obj) {
          this.pos++;
          var startPos = this.pos;
          fn(obj, this);
          var len = this.pos - startPos;
          if (len >= 128)
            makeRoomForExtraLength(startPos, len, this);
          this.pos = startPos - 1;
          this.writeVarint(len);
          this.pos += len;
        },
        writeMessage: function(tag, fn, obj) {
          this.writeTag(tag, Pbf.Bytes);
          this.writeRawMessage(fn, obj);
        },
        writePackedVarint: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedVarint, arr);
        },
        writePackedSVarint: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedSVarint, arr);
        },
        writePackedBoolean: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedBoolean, arr);
        },
        writePackedFloat: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedFloat, arr);
        },
        writePackedDouble: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedDouble, arr);
        },
        writePackedFixed32: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedFixed32, arr);
        },
        writePackedSFixed32: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedSFixed32, arr);
        },
        writePackedFixed64: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedFixed64, arr);
        },
        writePackedSFixed64: function(tag, arr) {
          if (arr.length)
            this.writeMessage(tag, writePackedSFixed64, arr);
        },
        writeBytesField: function(tag, buffer) {
          this.writeTag(tag, Pbf.Bytes);
          this.writeBytes(buffer);
        },
        writeFixed32Field: function(tag, val) {
          this.writeTag(tag, Pbf.Fixed32);
          this.writeFixed32(val);
        },
        writeSFixed32Field: function(tag, val) {
          this.writeTag(tag, Pbf.Fixed32);
          this.writeSFixed32(val);
        },
        writeFixed64Field: function(tag, val) {
          this.writeTag(tag, Pbf.Fixed64);
          this.writeFixed64(val);
        },
        writeSFixed64Field: function(tag, val) {
          this.writeTag(tag, Pbf.Fixed64);
          this.writeSFixed64(val);
        },
        writeVarintField: function(tag, val) {
          this.writeTag(tag, Pbf.Varint);
          this.writeVarint(val);
        },
        writeSVarintField: function(tag, val) {
          this.writeTag(tag, Pbf.Varint);
          this.writeSVarint(val);
        },
        writeStringField: function(tag, str) {
          this.writeTag(tag, Pbf.Bytes);
          this.writeString(str);
        },
        writeFloatField: function(tag, val) {
          this.writeTag(tag, Pbf.Fixed32);
          this.writeFloat(val);
        },
        writeDoubleField: function(tag, val) {
          this.writeTag(tag, Pbf.Fixed64);
          this.writeDouble(val);
        },
        writeBooleanField: function(tag, val) {
          this.writeVarintField(tag, Boolean(val));
        }
      };
      function readVarintRemainder(l, s, p) {
        var buf = p.buf, h, b;
        b = buf[p.pos++];
        h = (b & 112) >> 4;
        if (b < 128)
          return toNum(l, h, s);
        b = buf[p.pos++];
        h |= (b & 127) << 3;
        if (b < 128)
          return toNum(l, h, s);
        b = buf[p.pos++];
        h |= (b & 127) << 10;
        if (b < 128)
          return toNum(l, h, s);
        b = buf[p.pos++];
        h |= (b & 127) << 17;
        if (b < 128)
          return toNum(l, h, s);
        b = buf[p.pos++];
        h |= (b & 127) << 24;
        if (b < 128)
          return toNum(l, h, s);
        b = buf[p.pos++];
        h |= (b & 1) << 31;
        if (b < 128)
          return toNum(l, h, s);
        throw new Error("Expected varint not more than 10 bytes");
      }
      function readPackedEnd(pbf) {
        return pbf.type === Pbf.Bytes ? pbf.readVarint() + pbf.pos : pbf.pos + 1;
      }
      function toNum(low, high, isSigned) {
        if (isSigned) {
          return high * 4294967296 + (low >>> 0);
        }
        return (high >>> 0) * 4294967296 + (low >>> 0);
      }
      function writeBigVarint(val, pbf) {
        var low, high;
        if (val >= 0) {
          low = val % 4294967296 | 0;
          high = val / 4294967296 | 0;
        } else {
          low = ~(-val % 4294967296);
          high = ~(-val / 4294967296);
          if (low ^ 4294967295) {
            low = low + 1 | 0;
          } else {
            low = 0;
            high = high + 1 | 0;
          }
        }
        if (val >= 18446744073709552e3 || val < -18446744073709552e3) {
          throw new Error("Given varint doesn't fit into 10 bytes");
        }
        pbf.realloc(10);
        writeBigVarintLow(low, high, pbf);
        writeBigVarintHigh(high, pbf);
      }
      function writeBigVarintLow(low, high, pbf) {
        pbf.buf[pbf.pos++] = low & 127 | 128;
        low >>>= 7;
        pbf.buf[pbf.pos++] = low & 127 | 128;
        low >>>= 7;
        pbf.buf[pbf.pos++] = low & 127 | 128;
        low >>>= 7;
        pbf.buf[pbf.pos++] = low & 127 | 128;
        low >>>= 7;
        pbf.buf[pbf.pos] = low & 127;
      }
      function writeBigVarintHigh(high, pbf) {
        var lsb = (high & 7) << 4;
        pbf.buf[pbf.pos++] |= lsb | ((high >>>= 3) ? 128 : 0);
        if (!high)
          return;
        pbf.buf[pbf.pos++] = high & 127 | ((high >>>= 7) ? 128 : 0);
        if (!high)
          return;
        pbf.buf[pbf.pos++] = high & 127 | ((high >>>= 7) ? 128 : 0);
        if (!high)
          return;
        pbf.buf[pbf.pos++] = high & 127 | ((high >>>= 7) ? 128 : 0);
        if (!high)
          return;
        pbf.buf[pbf.pos++] = high & 127 | ((high >>>= 7) ? 128 : 0);
        if (!high)
          return;
        pbf.buf[pbf.pos++] = high & 127;
      }
      function makeRoomForExtraLength(startPos, len, pbf) {
        var extraLen = len <= 16383 ? 1 : len <= 2097151 ? 2 : len <= 268435455 ? 3 : Math.floor(Math.log(len) / (Math.LN2 * 7));
        pbf.realloc(extraLen);
        for (var i2 = pbf.pos - 1; i2 >= startPos; i2--)
          pbf.buf[i2 + extraLen] = pbf.buf[i2];
      }
      function writePackedVarint(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeVarint(arr[i2]);
      }
      function writePackedSVarint(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeSVarint(arr[i2]);
      }
      function writePackedFloat(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeFloat(arr[i2]);
      }
      function writePackedDouble(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeDouble(arr[i2]);
      }
      function writePackedBoolean(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeBoolean(arr[i2]);
      }
      function writePackedFixed32(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeFixed32(arr[i2]);
      }
      function writePackedSFixed32(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeSFixed32(arr[i2]);
      }
      function writePackedFixed64(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeFixed64(arr[i2]);
      }
      function writePackedSFixed64(arr, pbf) {
        for (var i2 = 0; i2 < arr.length; i2++)
          pbf.writeSFixed64(arr[i2]);
      }
      function readUInt32(buf, pos) {
        return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16) + buf[pos + 3] * 16777216;
      }
      function writeInt32(buf, val, pos) {
        buf[pos] = val;
        buf[pos + 1] = val >>> 8;
        buf[pos + 2] = val >>> 16;
        buf[pos + 3] = val >>> 24;
      }
      function readInt32(buf, pos) {
        return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16) + (buf[pos + 3] << 24);
      }
      function readUtf8(buf, pos, end) {
        var str = "";
        var i2 = pos;
        while (i2 < end) {
          var b0 = buf[i2];
          var c = null;
          var bytesPerSequence = b0 > 239 ? 4 : b0 > 223 ? 3 : b0 > 191 ? 2 : 1;
          if (i2 + bytesPerSequence > end)
            break;
          var b1, b2, b3;
          if (bytesPerSequence === 1) {
            if (b0 < 128) {
              c = b0;
            }
          } else if (bytesPerSequence === 2) {
            b1 = buf[i2 + 1];
            if ((b1 & 192) === 128) {
              c = (b0 & 31) << 6 | b1 & 63;
              if (c <= 127) {
                c = null;
              }
            }
          } else if (bytesPerSequence === 3) {
            b1 = buf[i2 + 1];
            b2 = buf[i2 + 2];
            if ((b1 & 192) === 128 && (b2 & 192) === 128) {
              c = (b0 & 15) << 12 | (b1 & 63) << 6 | b2 & 63;
              if (c <= 2047 || c >= 55296 && c <= 57343) {
                c = null;
              }
            }
          } else if (bytesPerSequence === 4) {
            b1 = buf[i2 + 1];
            b2 = buf[i2 + 2];
            b3 = buf[i2 + 3];
            if ((b1 & 192) === 128 && (b2 & 192) === 128 && (b3 & 192) === 128) {
              c = (b0 & 15) << 18 | (b1 & 63) << 12 | (b2 & 63) << 6 | b3 & 63;
              if (c <= 65535 || c >= 1114112) {
                c = null;
              }
            }
          }
          if (c === null) {
            c = 65533;
            bytesPerSequence = 1;
          } else if (c > 65535) {
            c -= 65536;
            str += String.fromCharCode(c >>> 10 & 1023 | 55296);
            c = 56320 | c & 1023;
          }
          str += String.fromCharCode(c);
          i2 += bytesPerSequence;
        }
        return str;
      }
      function readUtf8TextDecoder(buf, pos, end) {
        return utf8TextDecoder.decode(buf.subarray(pos, end));
      }
      function writeUtf8(buf, str, pos) {
        for (var i2 = 0, c, lead; i2 < str.length; i2++) {
          c = str.charCodeAt(i2);
          if (c > 55295 && c < 57344) {
            if (lead) {
              if (c < 56320) {
                buf[pos++] = 239;
                buf[pos++] = 191;
                buf[pos++] = 189;
                lead = c;
                continue;
              } else {
                c = lead - 55296 << 10 | c - 56320 | 65536;
                lead = null;
              }
            } else {
              if (c > 56319 || i2 + 1 === str.length) {
                buf[pos++] = 239;
                buf[pos++] = 191;
                buf[pos++] = 189;
              } else {
                lead = c;
              }
              continue;
            }
          } else if (lead) {
            buf[pos++] = 239;
            buf[pos++] = 191;
            buf[pos++] = 189;
            lead = null;
          }
          if (c < 128) {
            buf[pos++] = c;
          } else {
            if (c < 2048) {
              buf[pos++] = c >> 6 | 192;
            } else {
              if (c < 65536) {
                buf[pos++] = c >> 12 | 224;
              } else {
                buf[pos++] = c >> 18 | 240;
                buf[pos++] = c >> 12 & 63 | 128;
              }
              buf[pos++] = c >> 6 & 63 | 128;
            }
            buf[pos++] = c & 63 | 128;
          }
        }
        return pos;
      }
    }
  });

  // src/helpers/mapbox-util-functions.ts
  function classifyRings(rings) {
    const len = rings.length;
    if (len <= 1)
      return [rings];
    const polygons = [];
    let polygon;
    let ccw;
    for (let i2 = 0; i2 < len; i2++) {
      const area2 = signedArea(rings[i2]);
      if (area2 === 0)
        continue;
      if (ccw === void 0)
        ccw = area2 < 0;
      if (ccw === area2 < 0) {
        if (polygon)
          polygons.push(polygon);
        polygon = [rings[i2]];
      } else if (polygon)
        polygon.push(rings[i2]);
    }
    if (polygon)
      polygons.push(polygon);
    return polygons;
  }
  function signedArea(ring) {
    let sum = 0;
    for (let i2 = 0, j = ring.length - 1, p1, p2; i2 < ring.length; j = i2++) {
      p1 = ring[i2];
      p2 = ring[j];
      sum += (p2[0] - p1[0]) * (p1[1] + p2[1]);
    }
    return sum;
  }
  function readFeature(tag, feature, pbf) {
    if (feature && pbf) {
      if (tag === 1)
        feature.id = pbf.readVarint();
      else if (tag === 2)
        readTag(pbf, feature);
      else if (tag === 3)
        feature.type = pbf.readVarint();
      else if (tag === 4)
        feature._geometry = pbf.pos;
    }
  }
  function readTag(pbf, feature) {
    const end = pbf.readVarint() + pbf.pos;
    while (pbf.pos < end) {
      const key = feature._keys[pbf.readVarint()];
      const value = feature._values[pbf.readVarint()];
      feature.properties[key] = value;
    }
  }
  var init_mapbox_util_functions = __esm({
    "src/helpers/mapbox-util-functions.ts"() {
    }
  });

  // src/lib/mapbox-vector-tile/vector-tile-feature.ts
  var VectorTileFeature;
  var init_vector_tile_feature = __esm({
    "src/lib/mapbox-vector-tile/vector-tile-feature.ts"() {
      init_mapbox_util_functions();
      VectorTileFeature = class {
        static get types() {
          return ["Unknown", "Point", "LineString", "Polygon"];
        }
        constructor(pbf, end, extent, keys, values) {
          this.properties = {};
          this.extent = extent;
          this.type = 0;
          this.id = null;
          this._pbf = pbf;
          this._geometry = -1;
          this._keys = keys;
          this._values = values;
          pbf.readFields(readFeature, this, end);
        }
        loadGeometry() {
          const pbf = this._pbf;
          pbf.pos = this._geometry;
          const end = pbf.readVarint() + pbf.pos;
          let cmd2 = 1;
          let length2 = 0;
          let x2 = 0;
          let y2 = 0;
          const lines = [];
          let line;
          while (pbf.pos < end) {
            if (length2 <= 0) {
              const cmdLen2 = pbf.readVarint();
              cmd2 = cmdLen2 & 7;
              length2 = cmdLen2 >> 3;
            }
            length2--;
            if (cmd2 === 1 || cmd2 === 2) {
              x2 += pbf.readSVarint();
              y2 += pbf.readSVarint();
              if (cmd2 === 1) {
                if (line)
                  lines.push(line);
                line = [];
              }
              if (line)
                line.push([x2, y2]);
            } else if (cmd2 === 7) {
              if (line) {
                line.push(line[0].slice());
              }
            } else {
              throw new Error(`unknown command ${cmd2}`);
            }
          }
          if (line)
            lines.push(line);
          return lines;
        }
        bbox() {
          const pbf = this._pbf;
          pbf.pos = this._geometry;
          const end = pbf.readVarint() + pbf.pos;
          let cmd2 = 1;
          let length2 = 0;
          let x2 = 0;
          let y2 = 0;
          let x1 = Infinity;
          let x22 = -Infinity;
          let y1 = Infinity;
          let y22 = -Infinity;
          while (pbf.pos < end) {
            if (length2 <= 0) {
              const cmdLen2 = pbf.readVarint();
              cmd2 = cmdLen2 & 7;
              length2 = cmdLen2 >> 3;
            }
            length2--;
            if (cmd2 === 1 || cmd2 === 2) {
              x2 += pbf.readSVarint();
              y2 += pbf.readSVarint();
              if (x2 < x1)
                x1 = x2;
              if (x2 > x22)
                x22 = x2;
              if (y2 < y1)
                y1 = y2;
              if (y2 > y22)
                y22 = y2;
            } else if (cmd2 !== 7) {
              throw new Error(`unknown command ${cmd2}`);
            }
          }
          return [x1, y1, x22, y22];
        }
        _toGeoJSON(transform) {
          let coords = this.loadGeometry();
          let type = VectorTileFeature.types[this.type];
          let i2;
          let j;
          switch (this.type) {
            case 1:
              const points = [];
              for (i2 = 0; i2 < coords.length; i2++) {
                points[i2] = coords[i2][0];
              }
              coords = points;
              transform(coords, this);
              break;
            case 2:
              for (i2 = 0; i2 < coords.length; i2++) {
                transform(coords[i2], this);
              }
              break;
            case 3:
              coords = classifyRings(coords);
              for (i2 = 0; i2 < coords.length; i2++) {
                for (j = 0; j < coords[i2].length; j++) {
                  transform(coords[i2][j], this);
                }
              }
              break;
          }
          if (coords.length === 1) {
            coords = coords[0];
          } else {
            type = `Multi${type}`;
          }
          const result = {
            type: "Feature",
            geometry: {
              type,
              coordinates: coords
            },
            properties: this.properties
          };
          if (this.id !== null) {
            result.id = this.id;
          }
          return result;
        }
        toGeoJSON(options) {
          if (typeof options === "function") {
            return this._toGeoJSON(options);
          }
          const { x: x2, y: y2, z } = options;
          const size = this.extent * Math.pow(2, z);
          const x0 = this.extent * x2;
          const y0 = this.extent * y2;
          function project2(line) {
            for (let j = 0; j < line.length; j++) {
              const p = line[j];
              p[0] = (p[0] + x0) * 360 / size - 180;
              const y22 = 180 - (p[1] + y0) * 360 / size;
              p[1] = 360 / Math.PI * Math.atan(Math.exp(y22 * Math.PI / 180)) - 90;
            }
          }
          return this._toGeoJSON(project2);
        }
      };
    }
  });

  // src/lib/mapbox-vector-tile/vector-tile-layer.ts
  function readLayer(tag, layer, pbf) {
    if (layer && pbf) {
      if (tag === 15)
        layer.version = pbf.readVarint();
      else if (tag === 1)
        layer.name = pbf.readString();
      else if (tag === 5)
        layer.extent = pbf.readVarint();
      else if (tag === 2)
        layer._features.push(pbf.pos);
      else if (tag === 3)
        layer._keys.push(pbf.readString());
      else if (tag === 4)
        layer._values.push(readValueMessage(pbf));
    }
  }
  function readValueMessage(pbf) {
    let value = null;
    const end = pbf.readVarint() + pbf.pos;
    while (pbf.pos < end) {
      const tag = pbf.readVarint() >> 3;
      value = tag === 1 ? pbf.readString() : tag === 2 ? pbf.readFloat() : tag === 3 ? pbf.readDouble() : tag === 4 ? pbf.readVarint64() : tag === 5 ? pbf.readVarint() : tag === 6 ? pbf.readSVarint() : tag === 7 ? pbf.readBoolean() : null;
    }
    return value;
  }
  var VectorTileLayer;
  var init_vector_tile_layer = __esm({
    "src/lib/mapbox-vector-tile/vector-tile-layer.ts"() {
      init_vector_tile_feature();
      VectorTileLayer = class {
        constructor(pbf, end) {
          this.version = 1;
          this.name = "";
          this.extent = 4096;
          this.length = 0;
          this._pbf = pbf;
          this._keys = [];
          this._values = [];
          this._features = [];
          pbf.readFields(readLayer, this, end);
          this.length = this._features.length;
        }
        feature(i2) {
          if (i2 < 0 || i2 >= this._features.length) {
            throw new Error("feature index out of bounds");
          }
          this._pbf.pos = this._features[i2];
          const end = this._pbf.readVarint() + this._pbf.pos;
          return new VectorTileFeature(this._pbf, end, this.extent, this._keys, this._values);
        }
      };
    }
  });

  // src/lib/mapbox-vector-tile/vector-tile.ts
  function readTile(tag, layers, pbf) {
    if (tag === 3) {
      if (pbf) {
        const layer = new VectorTileLayer(pbf, pbf.readVarint() + pbf.pos);
        if (layer.length && layers) {
          layers[layer.name] = layer;
        }
      }
    }
  }
  var VectorTile;
  var init_vector_tile = __esm({
    "src/lib/mapbox-vector-tile/vector-tile.ts"() {
      init_vector_tile_layer();
      VectorTile = class {
        constructor(pbf, end) {
          this.layers = pbf.readFields(readTile, {}, end);
        }
      };
    }
  });

  // src/helpers/binary-util-functions.ts
  function classifyRings2(geom) {
    const len = geom.indices.length;
    const type = "Polygon";
    if (len <= 1) {
      return {
        type,
        data: geom.data,
        areas: [[getPolygonSignedArea(geom.data)]],
        indices: [geom.indices]
      };
    }
    const areas = [];
    const polygons = [];
    let ringAreas = [];
    let polygon = [];
    let ccw;
    let offset = 0;
    for (let endIndex, i2 = 0, startIndex; i2 < len; i2++) {
      startIndex = geom.indices[i2] - offset;
      endIndex = geom.indices[i2 + 1] - offset || geom.data.length;
      const shape = geom.data.slice(startIndex, endIndex);
      const area2 = getPolygonSignedArea(shape);
      if (area2 === 0) {
        const before = geom.data.slice(0, startIndex);
        const after = geom.data.slice(endIndex);
        geom.data = before.concat(after);
        offset += endIndex - startIndex;
        continue;
      }
      if (ccw === void 0)
        ccw = area2 < 0;
      if (ccw === area2 < 0) {
        if (polygon.length) {
          areas.push(ringAreas);
          polygons.push(polygon);
        }
        polygon = [startIndex];
        ringAreas = [area2];
      } else {
        ringAreas.push(area2);
        polygon.push(startIndex);
      }
    }
    if (ringAreas)
      areas.push(ringAreas);
    if (polygon.length)
      polygons.push(polygon);
    return { type, areas, indices: polygons, data: geom.data };
  }
  function project(data, x0, y0, size) {
    for (let j = 0, jl = data.length; j < jl; j += 2) {
      data[j] = (data[j] + x0) * 360 / size - 180;
      const y2 = 180 - (data[j + 1] + y0) * 360 / size;
      data[j + 1] = 360 / Math.PI * Math.atan(Math.exp(y2 * Math.PI / 180)) - 90;
    }
  }
  function readFeature2(tag, feature, pbf) {
    if (feature && pbf) {
      if (tag === 1)
        feature.id = pbf.readVarint();
      else if (tag === 2)
        readTag2(pbf, feature);
      else if (tag === 3)
        feature.type = pbf.readVarint();
      else if (tag === 4)
        feature._geometry = pbf.pos;
    }
  }
  function readTag2(pbf, feature) {
    const end = pbf.readVarint() + pbf.pos;
    while (pbf.pos < end) {
      const key = feature._keys[pbf.readVarint()];
      const value = feature._values[pbf.readVarint()];
      feature.properties[key] = value;
    }
  }
  var init_binary_util_functions = __esm({
    "src/helpers/binary-util-functions.ts"() {
      init_esm();
    }
  });

  // src/lib/binary-vector-tile/vector-tile-feature.ts
  var endPos, cmd, cmdLen, length, x, y, i, VectorTileFeature2;
  var init_vector_tile_feature2 = __esm({
    "src/lib/binary-vector-tile/vector-tile-feature.ts"() {
      init_binary_util_functions();
      VectorTileFeature2 = class {
        constructor(pbf, end, extent, keys, values, geometryInfo) {
          this.properties = {};
          this.extent = extent;
          this.type = 0;
          this.id = null;
          this._pbf = pbf;
          this._geometry = -1;
          this._keys = keys;
          this._values = values;
          this._geometryInfo = geometryInfo;
          pbf.readFields(readFeature2, this, end);
        }
        loadGeometry() {
          const pbf = this._pbf;
          pbf.pos = this._geometry;
          endPos = pbf.readVarint() + pbf.pos;
          cmd = 1;
          length = 0;
          x = 0;
          y = 0;
          i = 0;
          const indices = [];
          const data = [];
          while (pbf.pos < endPos) {
            if (length <= 0) {
              cmdLen = pbf.readVarint();
              cmd = cmdLen & 7;
              length = cmdLen >> 3;
            }
            length--;
            if (cmd === 1 || cmd === 2) {
              x += pbf.readSVarint();
              y += pbf.readSVarint();
              if (cmd === 1) {
                indices.push(i);
              }
              data.push(x, y);
              i += 2;
            } else if (cmd === 7) {
              if (i > 0) {
                const start = indices[indices.length - 1];
                data.push(data[start], data[start + 1]);
                i += 2;
              }
            } else {
              throw new Error(`unknown command ${cmd}`);
            }
          }
          return { data, indices };
        }
        _toBinaryCoordinates(transform) {
          const geom = this.loadGeometry();
          let geometry;
          transform(geom.data, this);
          const coordLength = 2;
          switch (this.type) {
            case 1:
              this._geometryInfo.pointFeaturesCount++;
              this._geometryInfo.pointPositionsCount += geom.indices.length;
              geometry = { type: "Point", ...geom };
              break;
            case 2:
              this._geometryInfo.lineFeaturesCount++;
              this._geometryInfo.linePathsCount += geom.indices.length;
              this._geometryInfo.linePositionsCount += geom.data.length / coordLength;
              geometry = { type: "LineString", ...geom };
              break;
            case 3:
              geometry = classifyRings2(geom);
              this._geometryInfo.polygonFeaturesCount++;
              this._geometryInfo.polygonObjectsCount += geometry.indices.length;
              for (const indices of geometry.indices) {
                this._geometryInfo.polygonRingsCount += indices.length;
              }
              this._geometryInfo.polygonPositionsCount += geometry.data.length / coordLength;
              break;
            default:
              throw new Error(`Invalid geometry type: ${this.type}`);
          }
          const result = { type: "Feature", geometry, properties: this.properties };
          if (this.id !== null) {
            result.id = this.id;
          }
          return result;
        }
        toBinaryCoordinates(options) {
          if (typeof options === "function") {
            return this._toBinaryCoordinates(options);
          }
          const { x: x2, y: y2, z } = options;
          const size = this.extent * Math.pow(2, z);
          const x0 = this.extent * x2;
          const y0 = this.extent * y2;
          return this._toBinaryCoordinates((data) => project(data, x0, y0, size));
        }
      };
    }
  });

  // src/lib/binary-vector-tile/vector-tile-layer.ts
  function readLayer2(tag, layer, pbf) {
    if (layer && pbf) {
      if (tag === 15)
        layer.version = pbf.readVarint();
      else if (tag === 1)
        layer.name = pbf.readString();
      else if (tag === 5)
        layer.extent = pbf.readVarint();
      else if (tag === 2)
        layer._features.push(pbf.pos);
      else if (tag === 3)
        layer._keys.push(pbf.readString());
      else if (tag === 4)
        layer._values.push(readValueMessage2(pbf));
    }
  }
  function readValueMessage2(pbf) {
    let value = null;
    const end = pbf.readVarint() + pbf.pos;
    while (pbf.pos < end) {
      const tag = pbf.readVarint() >> 3;
      value = tag === 1 ? pbf.readString() : tag === 2 ? pbf.readFloat() : tag === 3 ? pbf.readDouble() : tag === 4 ? pbf.readVarint64() : tag === 5 ? pbf.readVarint() : tag === 6 ? pbf.readSVarint() : tag === 7 ? pbf.readBoolean() : null;
    }
    return value;
  }
  var VectorTileLayer2;
  var init_vector_tile_layer2 = __esm({
    "src/lib/binary-vector-tile/vector-tile-layer.ts"() {
      init_vector_tile_feature2();
      VectorTileLayer2 = class {
        constructor(pbf, end) {
          this.version = 1;
          this.name = "";
          this.extent = 4096;
          this.length = 0;
          this._pbf = pbf;
          this._keys = [];
          this._values = [];
          this._features = [];
          pbf.readFields(readLayer2, this, end);
          this.length = this._features.length;
        }
        feature(i2, geometryInfo) {
          if (i2 < 0 || i2 >= this._features.length) {
            throw new Error("feature index out of bounds");
          }
          this._pbf.pos = this._features[i2];
          const end = this._pbf.readVarint() + this._pbf.pos;
          return new VectorTileFeature2(this._pbf, end, this.extent, this._keys, this._values, geometryInfo);
        }
      };
    }
  });

  // src/lib/binary-vector-tile/vector-tile.ts
  function readTile2(tag, layers, pbf) {
    if (tag === 3) {
      if (pbf) {
        const layer = new VectorTileLayer2(pbf, pbf.readVarint() + pbf.pos);
        if (layer.length && layers) {
          layers[layer.name] = layer;
        }
      }
    }
  }
  var VectorTile2;
  var init_vector_tile2 = __esm({
    "src/lib/binary-vector-tile/vector-tile.ts"() {
      init_vector_tile_layer2();
      VectorTile2 = class {
        constructor(pbf, end) {
          this.layers = pbf.readFields(readTile2, {}, end);
        }
      };
    }
  });

  // src/lib/parse-mvt.ts
  function parseMVT(arrayBuffer, options) {
    const mvtOptions = normalizeOptions(options);
    const shape = options?.gis?.format || options?.mvt?.shape;
    switch (shape) {
      case "columnar-table":
        return { shape: "columnar-table", data: parseToBinary(arrayBuffer, mvtOptions) };
      case "geojson-row-table": {
        const table = {
          shape: "geojson-row-table",
          data: parseToGeojson(arrayBuffer, mvtOptions)
        };
        return table;
      }
      case "geojson":
        return parseToGeojson(arrayBuffer, mvtOptions);
      case "binary-geometry":
        return parseToBinary(arrayBuffer, mvtOptions);
      case "binary":
        return parseToBinary(arrayBuffer, mvtOptions);
      default:
        throw new Error(shape);
    }
  }
  function parseToBinary(arrayBuffer, options) {
    const [flatGeoJsonFeatures, geometryInfo] = parseToFlatGeoJson(arrayBuffer, options);
    const binaryData = flatGeojsonToBinary(flatGeoJsonFeatures, geometryInfo);
    binaryData.byteLength = arrayBuffer.byteLength;
    return binaryData;
  }
  function parseToFlatGeoJson(arrayBuffer, options) {
    const features = [];
    const geometryInfo = {
      coordLength: 2,
      pointPositionsCount: 0,
      pointFeaturesCount: 0,
      linePositionsCount: 0,
      linePathsCount: 0,
      lineFeaturesCount: 0,
      polygonPositionsCount: 0,
      polygonObjectsCount: 0,
      polygonRingsCount: 0,
      polygonFeaturesCount: 0
    };
    if (arrayBuffer.byteLength <= 0) {
      return [features, geometryInfo];
    }
    const tile = new VectorTile2(new import_pbf.default(arrayBuffer));
    const selectedLayers = options && Array.isArray(options.layers) ? options.layers : Object.keys(tile.layers);
    selectedLayers.forEach((layerName) => {
      const vectorTileLayer = tile.layers[layerName];
      if (!vectorTileLayer) {
        return;
      }
      for (let i2 = 0; i2 < vectorTileLayer.length; i2++) {
        const vectorTileFeature = vectorTileLayer.feature(i2, geometryInfo);
        const decodedFeature = getDecodedFeatureBinary(vectorTileFeature, options, layerName);
        features.push(decodedFeature);
      }
    });
    return [features, geometryInfo];
  }
  function parseToGeojson(arrayBuffer, options) {
    if (arrayBuffer.byteLength <= 0) {
      return [];
    }
    const features = [];
    const tile = new VectorTile(new import_pbf.default(arrayBuffer));
    const selectedLayers = Array.isArray(options.layers) ? options.layers : Object.keys(tile.layers);
    selectedLayers.forEach((layerName) => {
      const vectorTileLayer = tile.layers[layerName];
      if (!vectorTileLayer) {
        return;
      }
      for (let i2 = 0; i2 < vectorTileLayer.length; i2++) {
        const vectorTileFeature = vectorTileLayer.feature(i2);
        const decodedFeature = getDecodedFeature(vectorTileFeature, options, layerName);
        features.push(decodedFeature);
      }
    });
    return features;
  }
  function normalizeOptions(options) {
    if (!options?.mvt) {
      throw new Error("mvt options required");
    }
    const wgs84Coordinates = options.mvt?.coordinates === "wgs84";
    const { tileIndex } = options.mvt;
    const hasTileIndex = tileIndex && Number.isFinite(tileIndex.x) && Number.isFinite(tileIndex.y) && Number.isFinite(tileIndex.z);
    if (wgs84Coordinates && !hasTileIndex) {
      throw new Error("MVT Loader: WGS84 coordinates need tileIndex property");
    }
    return options.mvt;
  }
  function getDecodedFeature(feature, options, layerName) {
    const decodedFeature = feature.toGeoJSON(options.coordinates === "wgs84" ? options.tileIndex : transformToLocalCoordinates);
    if (options.layerProperty) {
      decodedFeature.properties[options.layerProperty] = layerName;
    }
    return decodedFeature;
  }
  function getDecodedFeatureBinary(feature, options, layerName) {
    const decodedFeature = feature.toBinaryCoordinates(options.coordinates === "wgs84" ? options.tileIndex : transformToLocalCoordinatesBinary);
    if (options.layerProperty && decodedFeature.properties) {
      decodedFeature.properties[options.layerProperty] = layerName;
    }
    return decodedFeature;
  }
  function transformToLocalCoordinates(line, feature) {
    const { extent } = feature;
    for (let i2 = 0; i2 < line.length; i2++) {
      const p = line[i2];
      p[0] /= extent;
      p[1] /= extent;
    }
  }
  function transformToLocalCoordinatesBinary(data, feature) {
    const { extent } = feature;
    for (let i2 = 0, il = data.length; i2 < il; ++i2) {
      data[i2] /= extent;
    }
  }
  var import_pbf;
  var init_parse_mvt = __esm({
    "src/lib/parse-mvt.ts"() {
      init_src();
      import_pbf = __toModule(require_pbf());
      init_vector_tile();
      init_vector_tile2();
    }
  });

  // src/mvt-loader.ts
  var VERSION, DEFAULT_MVT_LOADER_OPTIONS, MVTWorkerLoader, MVTLoader;
  var init_mvt_loader = __esm({
    "src/mvt-loader.ts"() {
      init_parse_mvt();
      VERSION = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      DEFAULT_MVT_LOADER_OPTIONS = {
        mvt: {
          shape: "geojson",
          coordinates: "local",
          layerProperty: "layerName",
          layers: void 0,
          tileIndex: null
        }
      };
      MVTWorkerLoader = {
        name: "Mapbox Vector Tile",
        id: "mvt",
        module: "mvt",
        version: VERSION,
        extensions: ["mvt", "pbf"],
        mimeTypes: [
          "application/vnd.mapbox-vector-tile",
          "application/x-protobuf"
        ],
        worker: true,
        category: "geometry",
        options: DEFAULT_MVT_LOADER_OPTIONS
      };
      MVTLoader = {
        ...MVTWorkerLoader,
        parse: async (arrayBuffer, options) => parseMVT(arrayBuffer, options),
        parseSync: parseMVT,
        binary: true
      };
    }
  });

  // src/lib/geojson-tiler/simplify.ts
  function simplify(coords, first, last, sqTolerance) {
    let maxSqDist = sqTolerance;
    const mid = last - first >> 1;
    let minPosToMid = last - first;
    let index;
    const ax = coords[first];
    const ay = coords[first + 1];
    const bx = coords[last];
    const by = coords[last + 1];
    for (let i2 = first + 3; i2 < last; i2 += 3) {
      const d = getSqSegDist(coords[i2], coords[i2 + 1], ax, ay, bx, by);
      if (d > maxSqDist) {
        index = i2;
        maxSqDist = d;
      } else if (d === maxSqDist) {
        const posToMid = Math.abs(i2 - mid);
        if (posToMid < minPosToMid) {
          index = i2;
          minPosToMid = posToMid;
        }
      }
    }
    if (maxSqDist > sqTolerance) {
      if (index - first > 3)
        simplify(coords, first, index, sqTolerance);
      coords[index + 2] = maxSqDist;
      if (last - index > 3)
        simplify(coords, index, last, sqTolerance);
    }
  }
  function getSqSegDist(px, py, x2, y2, bx, by) {
    let dx = bx - x2;
    let dy = by - y2;
    if (dx !== 0 || dy !== 0) {
      const t = ((px - x2) * dx + (py - y2) * dy) / (dx * dx + dy * dy);
      if (t > 1) {
        x2 = bx;
        y2 = by;
      } else if (t > 0) {
        x2 += dx * t;
        y2 += dy * t;
      }
    }
    dx = px - x2;
    dy = py - y2;
    return dx * dx + dy * dy;
  }
  var init_simplify = __esm({
    "src/lib/geojson-tiler/simplify.ts"() {
    }
  });

  // src/lib/geojson-tiler/feature.ts
  function createFeature(id, type, geom, tags) {
    const feature = {
      id: id == null ? null : id,
      type,
      geometry: geom,
      tags,
      minX: Infinity,
      minY: Infinity,
      maxX: -Infinity,
      maxY: -Infinity
    };
    if (type === "Point" || type === "MultiPoint" || type === "LineString") {
      calcLineBBox(feature, geom);
    } else if (type === "Polygon") {
      calcLineBBox(feature, geom[0]);
    } else if (type === "MultiLineString") {
      for (const line of geom) {
        calcLineBBox(feature, line);
      }
    } else if (type === "MultiPolygon") {
      for (const polygon of geom) {
        calcLineBBox(feature, polygon[0]);
      }
    }
    return feature;
  }
  function calcLineBBox(feature, geom) {
    for (let i2 = 0; i2 < geom.length; i2 += 3) {
      feature.minX = Math.min(feature.minX, geom[i2]);
      feature.minY = Math.min(feature.minY, geom[i2 + 1]);
      feature.maxX = Math.max(feature.maxX, geom[i2]);
      feature.maxY = Math.max(feature.maxY, geom[i2 + 1]);
    }
  }
  var init_feature = __esm({
    "src/lib/geojson-tiler/feature.ts"() {
    }
  });

  // src/lib/geojson-tiler/convert.ts
  function convert(data, options) {
    const features = [];
    if (data.type === "FeatureCollection") {
      for (let i2 = 0; i2 < data.features.length; i2++) {
        convertFeature(features, data.features[i2], options, i2);
      }
    } else if (data.type === "Feature") {
      convertFeature(features, data, options);
    } else {
      convertFeature(features, { geometry: data }, options);
    }
    return features;
  }
  function convertFeature(features, geojson, options, index) {
    if (!geojson.geometry) {
      return;
    }
    const coords = geojson.geometry.coordinates;
    const type = geojson.geometry.type;
    const tolerance = Math.pow(options.tolerance / ((1 << options.maxZoom) * options.extent), 2);
    let geometry = [];
    let id = geojson.id;
    if (options.promoteId) {
      id = geojson.properties[options.promoteId];
    } else if (options.generateId) {
      id = index || 0;
    }
    if (type === "Point") {
      convertPoint(coords, geometry);
    } else if (type === "MultiPoint") {
      for (const p of coords) {
        convertPoint(p, geometry);
      }
    } else if (type === "LineString") {
      convertLine(coords, geometry, tolerance, false);
    } else if (type === "MultiLineString") {
      if (options.lineMetrics) {
        for (const line of coords) {
          geometry = [];
          convertLine(line, geometry, tolerance, false);
          features.push(createFeature(id, "LineString", geometry, geojson.properties));
        }
        return;
      } else {
        convertLines(coords, geometry, tolerance, false);
      }
    } else if (type === "Polygon") {
      convertLines(coords, geometry, tolerance, true);
    } else if (type === "MultiPolygon") {
      for (const polygon of coords) {
        const newPolygon = [];
        convertLines(polygon, newPolygon, tolerance, true);
        geometry.push(newPolygon);
      }
    } else if (type === "GeometryCollection") {
      for (const singleGeometry of geojson.geometry.geometries) {
        convertFeature(features, {
          id,
          geometry: singleGeometry,
          properties: geojson.properties
        }, options, index);
      }
      return;
    } else {
      throw new Error("Input data is not a valid GeoJSON object.");
    }
    features.push(createFeature(id, type, geometry, geojson.properties));
  }
  function convertPoint(coords, out) {
    out.push(projectX(coords[0]), projectY(coords[1]), 0);
  }
  function convertLine(ring, out, tolerance, isPolygon) {
    let x0, y0;
    let size = 0;
    for (let j = 0; j < ring.length; j++) {
      const x2 = projectX(ring[j][0]);
      const y2 = projectY(ring[j][1]);
      out.push(x2, y2, 0);
      if (j > 0) {
        if (isPolygon) {
          size += (x0 * y2 - x2 * y0) / 2;
        } else {
          size += Math.sqrt(Math.pow(x2 - x0, 2) + Math.pow(y2 - y0, 2));
        }
      }
      x0 = x2;
      y0 = y2;
    }
    const last = out.length - 3;
    out[2] = 1;
    simplify(out, 0, last, tolerance);
    out[last + 2] = 1;
    out.size = Math.abs(size);
    out.start = 0;
    out.end = out.size;
  }
  function convertLines(rings, out, tolerance, isPolygon) {
    for (let i2 = 0; i2 < rings.length; i2++) {
      const geom = [];
      convertLine(rings[i2], geom, tolerance, isPolygon);
      out.push(geom);
    }
  }
  function projectX(x2) {
    return x2 / 360 + 0.5;
  }
  function projectY(y2) {
    const sin = Math.sin(y2 * Math.PI / 180);
    const y22 = 0.5 - 0.25 * Math.log((1 + sin) / (1 - sin)) / Math.PI;
    return y22 < 0 ? 0 : y22 > 1 ? 1 : y22;
  }
  var init_convert = __esm({
    "src/lib/geojson-tiler/convert.ts"() {
      init_simplify();
      init_feature();
    }
  });

  // src/lib/geojson-tiler/clip.ts
  function clip(features, scale, k1, k2, axis, minAll, maxAll, options) {
    k1 /= scale;
    k2 /= scale;
    if (minAll >= k1 && maxAll < k2) {
      return features;
    } else if (maxAll < k1 || minAll >= k2) {
      return null;
    }
    const clipped = [];
    for (const feature of features) {
      const geometry = feature.geometry;
      let type = feature.type;
      const min = axis === 0 ? feature.minX : feature.minY;
      const max = axis === 0 ? feature.maxX : feature.maxY;
      if (min >= k1 && max < k2) {
        clipped.push(feature);
        continue;
      } else if (max < k1 || min >= k2) {
        continue;
      }
      let newGeometry = [];
      if (type === "Point" || type === "MultiPoint") {
        clipPoints(geometry, newGeometry, k1, k2, axis);
      } else if (type === "LineString") {
        clipLine(geometry, newGeometry, k1, k2, axis, false, options.lineMetrics);
      } else if (type === "MultiLineString") {
        clipLines(geometry, newGeometry, k1, k2, axis, false);
      } else if (type === "Polygon") {
        clipLines(geometry, newGeometry, k1, k2, axis, true);
      } else if (type === "MultiPolygon") {
        for (const polygon of geometry) {
          const newPolygon = [];
          clipLines(polygon, newPolygon, k1, k2, axis, true);
          if (newPolygon.length) {
            newGeometry.push(newPolygon);
          }
        }
      }
      if (newGeometry.length) {
        if (options.lineMetrics && type === "LineString") {
          for (const line of newGeometry) {
            clipped.push(createFeature(feature.id, type, line, feature.tags));
          }
          continue;
        }
        if (type === "LineString" || type === "MultiLineString") {
          if (newGeometry.length === 1) {
            type = "LineString";
            newGeometry = newGeometry[0];
          } else {
            type = "MultiLineString";
          }
        }
        if (type === "Point" || type === "MultiPoint") {
          type = newGeometry.length === 3 ? "Point" : "MultiPoint";
        }
        clipped.push(createFeature(feature.id, type, newGeometry, feature.tags));
      }
    }
    return clipped.length ? clipped : null;
  }
  function clipPoints(geom, newGeom, k1, k2, axis) {
    for (let i2 = 0; i2 < geom.length; i2 += 3) {
      const a = geom[i2 + axis];
      if (a >= k1 && a <= k2) {
        addPoint(newGeom, geom[i2], geom[i2 + 1], geom[i2 + 2]);
      }
    }
  }
  function clipLine(geom, newGeom, k1, k2, axis, isPolygon, trackMetrics) {
    let slice = newSlice(geom);
    const intersect2 = axis === 0 ? intersectX : intersectY;
    let len = geom.start;
    let segLen;
    let t;
    for (let i2 = 0; i2 < geom.length - 3; i2 += 3) {
      const ax2 = geom[i2];
      const ay2 = geom[i2 + 1];
      const az2 = geom[i2 + 2];
      const bx = geom[i2 + 3];
      const by = geom[i2 + 4];
      const a2 = axis === 0 ? ax2 : ay2;
      const b = axis === 0 ? bx : by;
      let exited = false;
      if (trackMetrics) {
        segLen = Math.sqrt(Math.pow(ax2 - bx, 2) + Math.pow(ay2 - by, 2));
      }
      if (a2 < k1) {
        if (b > k1) {
          t = intersect2(slice, ax2, ay2, bx, by, k1);
          if (trackMetrics) {
            slice.start = len + segLen * t;
          }
        }
      } else if (a2 > k2) {
        if (b < k2) {
          t = intersect2(slice, ax2, ay2, bx, by, k2);
          if (trackMetrics) {
            slice.start = len + segLen * t;
          }
        }
      } else {
        addPoint(slice, ax2, ay2, az2);
      }
      if (b < k1 && a2 >= k1) {
        t = intersect2(slice, ax2, ay2, bx, by, k1);
        exited = true;
      }
      if (b > k2 && a2 <= k2) {
        t = intersect2(slice, ax2, ay2, bx, by, k2);
        exited = true;
      }
      if (!isPolygon && exited) {
        if (trackMetrics) {
          slice.end = len + segLen * t;
        }
        newGeom.push(slice);
        slice = newSlice(geom);
      }
      if (trackMetrics) {
        len += segLen;
      }
    }
    let last = geom.length - 3;
    const ax = geom[last];
    const ay = geom[last + 1];
    const az = geom[last + 2];
    const a = axis === 0 ? ax : ay;
    if (a >= k1 && a <= k2)
      addPoint(slice, ax, ay, az);
    last = slice.length - 3;
    if (isPolygon && last >= 3 && (slice[last] !== slice[0] || slice[last + 1] !== slice[1])) {
      addPoint(slice, slice[0], slice[1], slice[2]);
    }
    if (slice.length) {
      newGeom.push(slice);
    }
  }
  function newSlice(line) {
    const slice = [];
    slice.size = line.size;
    slice.start = line.start;
    slice.end = line.end;
    return slice;
  }
  function clipLines(geom, newGeom, k1, k2, axis, isPolygon) {
    for (const line of geom) {
      clipLine(line, newGeom, k1, k2, axis, isPolygon, false);
    }
  }
  function addPoint(out, x2, y2, z) {
    out.push(x2, y2, z);
  }
  function intersectX(out, ax, ay, bx, by, x2) {
    const t = (x2 - ax) / (bx - ax);
    addPoint(out, x2, ay + (by - ay) * t, 1);
    return t;
  }
  function intersectY(out, ax, ay, bx, by, y2) {
    const t = (y2 - ay) / (by - ay);
    addPoint(out, ax + (bx - ax) * t, y2, 1);
    return t;
  }
  var init_clip = __esm({
    "src/lib/geojson-tiler/clip.ts"() {
      init_feature();
    }
  });

  // src/lib/geojson-tiler/wrap.ts
  function wrap(features, options) {
    const buffer = options.buffer / options.extent;
    let merged = features;
    const left = clip(features, 1, -1 - buffer, buffer, 0, -1, 2, options);
    const right = clip(features, 1, 1 - buffer, 2 + buffer, 0, -1, 2, options);
    if (left || right) {
      merged = clip(features, 1, -buffer, 1 + buffer, 0, -1, 2, options) || [];
      if (left) {
        merged = shiftFeatureCoords(left, 1).concat(merged);
      }
      if (right) {
        merged = merged.concat(shiftFeatureCoords(right, -1));
      }
    }
    return merged;
  }
  function shiftFeatureCoords(features, offset) {
    const newFeatures = [];
    for (let i2 = 0; i2 < features.length; i2++) {
      const feature = features[i2];
      const type = feature.type;
      let newGeometry;
      if (type === "Point" || type === "MultiPoint" || type === "LineString") {
        newGeometry = shiftCoords(feature.geometry, offset);
      } else if (type === "MultiLineString" || type === "Polygon") {
        newGeometry = [];
        for (const line of feature.geometry) {
          newGeometry.push(shiftCoords(line, offset));
        }
      } else if (type === "MultiPolygon") {
        newGeometry = [];
        for (const polygon of feature.geometry) {
          const newPolygon = [];
          for (const line of polygon) {
            newPolygon.push(shiftCoords(line, offset));
          }
          newGeometry.push(newPolygon);
        }
      }
      newFeatures.push(createFeature(feature.id, type, newGeometry, feature.tags));
    }
    return newFeatures;
  }
  function shiftCoords(points, offset) {
    const newPoints = [];
    newPoints.size = points.size;
    if (points.start !== void 0) {
      newPoints.start = points.start;
      newPoints.end = points.end;
    }
    for (let i2 = 0; i2 < points.length; i2 += 3) {
      newPoints.push(points[i2] + offset, points[i2 + 1], points[i2 + 2]);
    }
    return newPoints;
  }
  var init_wrap = __esm({
    "src/lib/geojson-tiler/wrap.ts"() {
      init_clip();
      init_feature();
    }
  });

  // src/lib/geojson-tiler/transform.ts
  function transformTile(tile, extent) {
    if (tile.transformed) {
      return tile;
    }
    const z2 = 1 << tile.z;
    const tx = tile.x;
    const ty = tile.y;
    for (const feature of tile.features) {
      const geom = feature.geometry;
      const type = feature.type;
      feature.geometry = [];
      if (type === 1) {
        for (let j = 0; j < geom.length; j += 2) {
          feature.geometry.push(transformPoint(geom[j], geom[j + 1], extent, z2, tx, ty));
        }
      } else {
        for (let j = 0; j < geom.length; j++) {
          const ring = [];
          for (let k = 0; k < geom[j].length; k += 2) {
            ring.push(transformPoint(geom[j][k], geom[j][k + 1], extent, z2, tx, ty));
          }
          feature.geometry.push(ring);
        }
      }
    }
    tile.transformed = true;
    return tile;
  }
  function transformPoint(x2, y2, extent, z2, tx, ty) {
    return [Math.round(extent * (x2 * z2 - tx)), Math.round(extent * (y2 * z2 - ty))];
  }
  var init_transform = __esm({
    "src/lib/geojson-tiler/transform.ts"() {
    }
  });

  // src/lib/geojson-tiler/tile.ts
  function createTile(features, z, tx, ty, options) {
    const tolerance = z === options.maxZoom ? 0 : options.tolerance / ((1 << z) * options.extent);
    const tile = {
      features: [],
      numPoints: 0,
      numSimplified: 0,
      numFeatures: features.length,
      source: null,
      x: tx,
      y: ty,
      z,
      transformed: false,
      minX: 2,
      minY: 1,
      maxX: -1,
      maxY: 0
    };
    for (const feature of features) {
      addFeature(tile, feature, tolerance, options);
    }
    return tile;
  }
  function addFeature(tile, feature, tolerance, options) {
    const geom = feature.geometry;
    const type = feature.type;
    const simplified = [];
    tile.minX = Math.min(tile.minX, feature.minX);
    tile.minY = Math.min(tile.minY, feature.minY);
    tile.maxX = Math.max(tile.maxX, feature.maxX);
    tile.maxY = Math.max(tile.maxY, feature.maxY);
    if (type === "Point" || type === "MultiPoint") {
      for (let i2 = 0; i2 < geom.length; i2 += 3) {
        simplified.push(geom[i2], geom[i2 + 1]);
        tile.numPoints++;
        tile.numSimplified++;
      }
    } else if (type === "LineString") {
      addLine(simplified, geom, tile, tolerance, false, false);
    } else if (type === "MultiLineString" || type === "Polygon") {
      for (let i2 = 0; i2 < geom.length; i2++) {
        addLine(simplified, geom[i2], tile, tolerance, type === "Polygon", i2 === 0);
      }
    } else if (type === "MultiPolygon") {
      for (let k = 0; k < geom.length; k++) {
        const polygon = geom[k];
        for (let i2 = 0; i2 < polygon.length; i2++) {
          addLine(simplified, polygon[i2], tile, tolerance, true, i2 === 0);
        }
      }
    }
    if (simplified.length) {
      let tags = feature.tags || null;
      if (type === "LineString" && options.lineMetrics) {
        tags = {};
        for (const key in feature.tags)
          tags[key] = feature.tags[key];
        tags.mapbox_clip_start = geom.start / geom.size;
        tags.mapbox_clip_end = geom.end / geom.size;
      }
      const tileFeature = {
        geometry: simplified,
        type: type === "Polygon" || type === "MultiPolygon" ? 3 : type === "LineString" || type === "MultiLineString" ? 2 : 1,
        tags
      };
      if (feature.id !== null) {
        tileFeature.id = feature.id;
      }
      tile.features.push(tileFeature);
    }
  }
  function addLine(result, geom, tile, tolerance, isPolygon, isOuter) {
    const sqTolerance = tolerance * tolerance;
    if (tolerance > 0 && geom.size < (isPolygon ? sqTolerance : tolerance)) {
      tile.numPoints += geom.length / 3;
      return;
    }
    const ring = [];
    for (let i2 = 0; i2 < geom.length; i2 += 3) {
      if (tolerance === 0 || geom[i2 + 2] > sqTolerance) {
        tile.numSimplified++;
        ring.push(geom[i2], geom[i2 + 1]);
      }
      tile.numPoints++;
    }
    if (isPolygon)
      rewind(ring, isOuter);
    result.push(ring);
  }
  function rewind(ring, clockwise) {
    let area2 = 0;
    for (let i2 = 0, j = ring.length - 2; i2 < ring.length; j = i2, i2 += 2) {
      area2 += (ring[i2] - ring[j]) * (ring[i2 + 1] + ring[j + 1]);
    }
    if (area2 > 0 === clockwise) {
      for (let i2 = 0, len = ring.length; i2 < len / 2; i2 += 2) {
        const x2 = ring[i2];
        const y2 = ring[i2 + 1];
        ring[i2] = ring[len - 2 - i2];
        ring[i2 + 1] = ring[len - 1 - i2];
        ring[len - 2 - i2] = x2;
        ring[len - 1 - i2] = y2;
      }
    }
  }
  var init_tile = __esm({
    "src/lib/geojson-tiler/tile.ts"() {
    }
  });

  // src/lib/geojson-tiler/geojson-tiler.ts
  function toID(z, x2, y2) {
    return ((1 << z) * y2 + x2) * 32 + z;
  }
  var DEFAULT_OPTIONS, GeoJSONTiler;
  var init_geojson_tiler = __esm({
    "src/lib/geojson-tiler/geojson-tiler.ts"() {
      init_convert();
      init_clip();
      init_wrap();
      init_transform();
      init_tile();
      DEFAULT_OPTIONS = {
        maxZoom: 14,
        indexMaxZoom: 5,
        indexMaxPoints: 1e5,
        tolerance: 3,
        extent: 4096,
        buffer: 64,
        lineMetrics: false,
        promoteId: void 0,
        generateId: false,
        debug: 0
      };
      GeoJSONTiler = class {
        constructor(data, options) {
          this.tiles = {};
          this.tileCoords = [];
          this.stats = {};
          this.total = 0;
          this.options = { ...DEFAULT_OPTIONS, ...options };
          options = this.options;
          const debug = options.debug;
          if (debug)
            console.time("preprocess data");
          if (this.options.maxZoom < 0 || this.options.maxZoom > 24) {
            throw new Error("maxZoom should be in the 0-24 range");
          }
          if (options.promoteId && this.options.generateId) {
            throw new Error("promoteId and generateId cannot be used together.");
          }
          let features = convert(data, options);
          if (debug) {
            console.timeEnd("preprocess data");
            console.log("index: maxZoom: %d, maxPoints: %d", options.indexMaxZoom, options.indexMaxPoints);
            console.time("generate tiles");
          }
          features = wrap(features, this.options);
          if (features.length) {
            this.splitTile(features, 0, 0, 0);
          }
          if (debug) {
            if (features.length) {
              console.log("features: %d, points: %d", this.tiles[0].numFeatures, this.tiles[0].numPoints);
            }
            console.timeEnd("generate tiles");
            console.log("tiles generated:", this.total, JSON.stringify(this.stats));
          }
        }
        getTile(z, x2, y2) {
          const { extent, debug } = this.options;
          if (z < 0 || z > 24) {
            return null;
          }
          const z2 = 1 << z;
          x2 = x2 + z2 & z2 - 1;
          const id = toID(z, x2, y2);
          if (this.tiles[id]) {
            return transformTile(this.tiles[id], extent);
          }
          if (debug > 1)
            console.log("drilling down to z%d-%d-%d", z, x2, y2);
          let z0 = z;
          let x0 = x2;
          let y0 = y2;
          let parent;
          while (!parent && z0 > 0) {
            z0--;
            x0 = x0 >> 1;
            y0 = y0 >> 1;
            parent = this.tiles[toID(z0, x0, y0)];
          }
          if (!parent || !parent.source) {
            return null;
          }
          if (debug > 1) {
            console.log("found parent tile z%d-%d-%d", z0, x0, y0);
            console.time("drilling down");
          }
          this.splitTile(parent.source, z0, x0, y0, z, x2, y2);
          if (debug > 1) {
            console.timeEnd("drilling down");
          }
          return this.tiles[id] ? transformTile(this.tiles[id], extent) : null;
        }
        splitTile(features, z, x2, y2, cz, cx, cy) {
          const stack = [features, z, x2, y2];
          const options = this.options;
          const debug = options.debug;
          while (stack.length) {
            y2 = stack.pop();
            x2 = stack.pop();
            z = stack.pop();
            features = stack.pop();
            const z2 = 1 << z;
            const id = toID(z, x2, y2);
            let tile = this.tiles[id];
            if (!tile) {
              if (debug > 1) {
                console.time("creation");
              }
              tile = this.tiles[id] = createTile(features, z, x2, y2, options);
              this.tileCoords.push({ z, x: x2, y: y2 });
              if (debug) {
                if (debug > 1) {
                  console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)", z, x2, y2, tile.numFeatures, tile.numPoints, tile.numSimplified);
                  console.timeEnd("creation");
                }
                const key = `z${z}`;
                this.stats[key] = (this.stats[key] || 0) + 1;
                this.total++;
              }
            }
            tile.source = features;
            if (cz === void 0) {
              if (z === options.indexMaxZoom || tile.numPoints <= options.indexMaxPoints)
                continue;
            } else if (z === options.maxZoom || z === cz) {
              continue;
            } else if (cz !== void 0) {
              const zoomSteps = cz - z;
              if (x2 !== cx >> zoomSteps || y2 !== cy >> zoomSteps)
                continue;
            }
            tile.source = null;
            if (features.length === 0)
              continue;
            if (debug > 1)
              console.time("clipping");
            const k1 = 0.5 * options.buffer / options.extent;
            const k2 = 0.5 - k1;
            const k3 = 0.5 + k1;
            const k4 = 1 + k1;
            let tl = null;
            let bl = null;
            let tr = null;
            let br = null;
            let left = clip(features, z2, x2 - k1, x2 + k3, 0, tile.minX, tile.maxX, options);
            let right = clip(features, z2, x2 + k2, x2 + k4, 0, tile.minX, tile.maxX, options);
            features = null;
            if (left) {
              tl = clip(left, z2, y2 - k1, y2 + k3, 1, tile.minY, tile.maxY, options);
              bl = clip(left, z2, y2 + k2, y2 + k4, 1, tile.minY, tile.maxY, options);
              left = null;
            }
            if (right) {
              tr = clip(right, z2, y2 - k1, y2 + k3, 1, tile.minY, tile.maxY, options);
              br = clip(right, z2, y2 + k2, y2 + k4, 1, tile.minY, tile.maxY, options);
              right = null;
            }
            if (debug > 1)
              console.timeEnd("clipping");
            stack.push(tl || [], z + 1, x2 * 2, y2 * 2);
            stack.push(bl || [], z + 1, x2 * 2, y2 * 2 + 1);
            stack.push(tr || [], z + 1, x2 * 2 + 1, y2 * 2);
            stack.push(br || [], z + 1, x2 * 2 + 1, y2 * 2 + 1);
          }
        }
      };
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    GeoJSONTiler: () => GeoJSONTiler,
    MVTLoader: () => MVTLoader,
    MVTWorkerLoader: () => MVTWorkerLoader
  });
  var init_src2 = __esm({
    "src/index.ts"() {
      init_mvt_loader();
      init_geojson_tiler();
    }
  });

  // src/bundle.ts
  var require_bundle = __commonJS({
    "src/bundle.ts"(exports, module) {
      var moduleExports = (init_src2(), src_exports);
      globalThis.loaders = globalThis.loaders || {};
      module.exports = Object.assign(globalThis.loaders, moduleExports);
    }
  });
  require_bundle();
})();
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
