"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrap = wrap;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _clip = require("./clip");
var _feature = require("./feature");
function wrap(features, options) {
  const buffer = options.buffer / options.extent;
  let merged = features;
  const left = (0, _clip.clip)(features, 1, -1 - buffer, buffer, 0, -1, 2, options);
  const right = (0, _clip.clip)(features, 1, 1 - buffer, 2 + buffer, 0, -1, 2, options);
  if (left || right) {
    merged = (0, _clip.clip)(features, 1, -buffer, 1 + buffer, 0, -1, 2, options) || [];
    if (left) {
      merged = shiftFeatureCoords(left, 1).concat(merged);
    }
    if (right) {
      merged = merged.concat(shiftFeatureCoords(right, -1));
    }
  }
  return merged;
}
function shiftFeatureCoords(features, offset) {
  const newFeatures = [];
  for (let i = 0; i < features.length; i++) {
    const feature = features[i];
    const type = feature.type;
    let newGeometry;
    if (type === 'Point' || type === 'MultiPoint' || type === 'LineString') {
      newGeometry = shiftCoords(feature.geometry, offset);
    } else if (type === 'MultiLineString' || type === 'Polygon') {
      newGeometry = [];
      for (const line of feature.geometry) {
        newGeometry.push(shiftCoords(line, offset));
      }
    } else if (type === 'MultiPolygon') {
      newGeometry = [];
      for (const polygon of feature.geometry) {
        const newPolygon = [];
        for (const line of polygon) {
          newPolygon.push(shiftCoords(line, offset));
        }
        newGeometry.push(newPolygon);
      }
    }
    newFeatures.push((0, _feature.createFeature)(feature.id, type, newGeometry, feature.tags));
  }
  return newFeatures;
}
class Points extends Array {
  constructor() {
    super(...arguments);
    (0, _defineProperty2.default)(this, "size", void 0);
    (0, _defineProperty2.default)(this, "start", void 0);
    (0, _defineProperty2.default)(this, "end", void 0);
  }
}
function shiftCoords(points, offset) {
  const newPoints = [];
  newPoints.size = points.size;
  if (points.start !== undefined) {
    newPoints.start = points.start;
    newPoints.end = points.end;
  }
  for (let i = 0; i < points.length; i += 3) {
    newPoints.push(points[i] + offset, points[i + 1], points[i + 2]);
  }
  return newPoints;
}
//# sourceMappingURL=wrap.js.map