"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTWorkerLoader = exports.MVTLoader = void 0;
var _parseMvt = _interopRequireDefault(require("./lib/parse-mvt"));
const VERSION = typeof "3.4.15" !== 'undefined' ? "3.4.15" : 'latest';
const DEFAULT_MVT_LOADER_OPTIONS = {
  mvt: {
    shape: 'geojson',
    coordinates: 'local',
    layerProperty: 'layerName',
    layers: undefined,
    tileIndex: null
  }
};
const MVTWorkerLoader = {
  name: 'Mapbox Vector Tile',
  id: 'mvt',
  module: 'mvt',
  version: VERSION,
  extensions: ['mvt', 'pbf'],
  mimeTypes: ['application/vnd.mapbox-vector-tile', 'application/x-protobuf'],
  worker: true,
  category: 'geometry',
  options: DEFAULT_MVT_LOADER_OPTIONS
};
exports.MVTWorkerLoader = MVTWorkerLoader;
const MVTLoader = {
  ...MVTWorkerLoader,
  parse: async (arrayBuffer, options) => (0, _parseMvt.default)(arrayBuffer, options),
  parseSync: _parseMvt.default,
  binary: true
};
exports.MVTLoader = MVTLoader;
//# sourceMappingURL=mvt-loader.js.map