import parseMVT from './lib/parse-mvt';
const VERSION = typeof "3.4.15" !== 'undefined' ? "3.4.15" : 'latest';
const DEFAULT_MVT_LOADER_OPTIONS = {
  mvt: {
    shape: 'geojson',
    coordinates: 'local',
    layerProperty: 'layerName',
    layers: undefined,
    tileIndex: null
  }
};
export const MVTWorkerLoader = {
  name: 'Mapbox Vector Tile',
  id: 'mvt',
  module: 'mvt',
  version: VERSION,
  extensions: ['mvt', 'pbf'],
  mimeTypes: ['application/vnd.mapbox-vector-tile', 'application/x-protobuf'],
  worker: true,
  category: 'geometry',
  options: DEFAULT_MVT_LOADER_OPTIONS
};
export const MVTLoader = {
  ...MVTWorkerLoader,
  parse: async (arrayBuffer, options) => parseMVT(arrayBuffer, options),
  parseSync: parseMVT,
  binary: true
};
//# sourceMappingURL=mvt-loader.js.map